/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.wan.loadbalancing.sla;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.F.OOoO;
import com.ubnt.model.api.wan.loadbalancing.sla.ImmutableWanMonitorDto;
import com.ubnt.model.api.wan.loadbalancing.sla.WanAlertThresholdDto;
import com.ubnt.service.config.ubios.wanfailover.sla.D;
import com.ubnt.service.config.ubios.wanfailover.sla.WanMonitorDocumentPart;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicInteger;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableWanMonitorDto.Builder.class)
@Value.Immutable
@OOoO
public interface WanMonitorDto {
    @JsonProperty(value="monitor_id")
    public OptionalInt id();

    @JsonProperty(value="type")
    public D type();

    @JsonProperty(value="target")
    public String target();

    @JsonProperty(value="domain")
    public String domain();

    @Min(value=1L)
    @Max(value=3600L)
    @JsonProperty(value="interval")
    public @Min(value=1L) @Max(value=3600L) int interval();

    @Min(value=1L)
    @Max(value=65535L)
    @JsonProperty(value="time_period")
    public @Min(value=1L) @Max(value=65535L) int timePeriod();

    @JsonProperty(value="alert")
    @NotNull
    public WanAlertThresholdDto alert();

    public static ImmutableWanMonitorDto.Builder builder() {
        return ImmutableWanMonitorDto.builder();
    }

    public static List<WanMonitorDto> fromDocument(List<WanMonitorDocumentPart> list) {
        return list.stream().map(WanMonitorDto::fromDocument).toList();
    }

    public static WanMonitorDto fromDocument(WanMonitorDocumentPart wanMonitorDocumentPart) {
        return ImmutableWanMonitorDto.builder().id(wanMonitorDocumentPart.getId()).type(wanMonitorDocumentPart.getType()).target(wanMonitorDocumentPart.getTarget()).domain(wanMonitorDocumentPart.getDomain()).interval(wanMonitorDocumentPart.getInterval()).timePeriod(wanMonitorDocumentPart.getTimePeriod()).alert(WanAlertThresholdDto.fromDocument(wanMonitorDocumentPart.getAlert())).build();
    }

    public static List<WanMonitorDocumentPart> toDocument(List<WanMonitorDto> list) {
        List<WanMonitorDocumentPart> list2 = list.stream().map(WanMonitorDto::toDocument).toList();
        AtomicInteger atomicInteger = new AtomicInteger(list2.stream().mapToInt(WanMonitorDocumentPart::getId).max().orElse(0));
        return list2.stream().map(wanMonitorDocumentPart -> wanMonitorDocumentPart.getId() == 0 ? wanMonitorDocumentPart.withId(atomicInteger.incrementAndGet()) : wanMonitorDocumentPart).toList();
    }

    default public WanMonitorDocumentPart toDocument() {
        return WanMonitorDocumentPart.builder().\u00d800000(this.id().orElse(0)).\u00d400000(this.type()).\u00d500000(this.target()).o00000(this.domain()).new(this.interval()).return(this.timePeriod()).\u00f400000(this.alert().toDocument()).\u00d300000();
    }
}

