/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.firewallzone;

import com.ubnt.data.Site;
import com.ubnt.model.api.firewall.policy.FirewallPolicyDto;
import com.ubnt.model.api.firewallzone.FirewallMatrixSourceZoneDto;
import com.ubnt.model.api.firewallzone.FirewallZoneDto;
import com.ubnt.model.api.firewallzone.FirewallZoneRequestDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.firewall.FirewallPolicyController;
import com.ubnt.service.firewallzone.B;
import com.ubnt.service.firewallzone.super;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Firewall zone")
public class FirewallZoneController {
    private final super o00000;
    private final FirewallPolicyController new;

    public FirewallZoneController(super super_, FirewallPolicyController firewallPolicyController) {
        this.o00000 = super_;
        this.new = firewallPolicyController;
    }

    @GetMapping(value={"/api/site/{siteName}/firewall/zone"})
    @Operation(summary="List Firewall Zones")
    public List<FirewallZoneDto> listFirewallZones(@PathVariable(value="siteName") Site site) {
        return this.o00000.\u00f4O0000(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/firewall/zone/defaults"})
    @Operation(summary="List Firewall Zone defaults")
    public List<FirewallZoneDto> listFirewallZoneDefaults(@PathVariable(value="siteName") Site site) {
        return this.o00000.o\u00d20000(site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/firewall/zone"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Create Firewall Zone")
    public FirewallZoneDto createFirewallZone(@PathVariable(value="siteName") Site site, @RequestBody @Valid FirewallZoneRequestDto firewallZoneRequestDto) {
        return FirewallZoneDto.from(this.o00000.\u00d8O0000(firewallZoneRequestDto, site.getId()), firewallZoneRequestDto.networkIds());
    }

    @PutMapping(value={"/api/site/{siteName}/firewall/zone/{zoneId}"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Update Firewall Zone")
    public FirewallZoneDto updateFirewallZone(@PathVariable(value="siteName") Site site, @PathVariable(value="zoneId") String string, @Valid @RequestBody FirewallZoneRequestDto firewallZoneRequestDto) {
        return FirewallZoneDto.from(this.o00000.\u00f4o0000(firewallZoneRequestDto, site.getId()), firewallZoneRequestDto.networkIds());
    }

    @DeleteMapping(value={"/api/site/{siteName}/firewall/zone/{zoneId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Delete Firewall Zone")
    public void deleteFirewallZone(@PathVariable(value="siteName") Site site, @PathVariable(value="zoneId") String string) {
        this.o00000.\u00d5O0000(string, site.getId());
    }

    @PostMapping(value={"/api/site/{siteName}/firewall/zone/batch-delete"})
    @Operation(summary="Batch delete Firewall Zone")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void batchDeleteFirewallZones(@PathVariable(value="siteName") Site site, @RequestBody @NotEmpty List<String> list) {
        this.o00000.\u00f800000(list, site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/firewall/zone-matrix"})
    @Operation(summary="Returns firewall zone matrix")
    public List<FirewallMatrixSourceZoneDto> getFirewallZoneMatrix(@PathVariable(value="siteName") Site site) {
        Map<Pair, List<FirewallPolicyDto>> map = this.new.listFirewallPolicies(site).stream().collect(Collectors.groupingBy(firewallPolicyDto -> Pair.of((Object)firewallPolicyDto.source().zoneId(), (Object)firewallPolicyDto.destination().zoneId())));
        List<B> list = this.o00000.\u00d400000(site.getId());
        return list.stream().map(b2 -> FirewallMatrixSourceZoneDto.getFirewallMatrixSourceZoneDto(map, list, b2)).toList();
    }
}

