/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.object.oriented.network;

import com.ubnt.ace.U;
import com.ubnt.data.NetworkConf;
import com.ubnt.model.api.IpVersion;
import com.ubnt.model.api.object.oriented.network.ObjectOrientedNetworkConfigDto;
import com.ubnt.model.api.object.oriented.network.ObjectOrientedNetworkSecureMode;
import com.ubnt.model.api.trafficroute.TrafficRouteMatchingTarget;
import com.ubnt.model.schedule.ScheduleDocumentPart;
import com.ubnt.model.schedule.ScheduleDto;
import com.ubnt.net.null.A;
import com.ubnt.net.v2.object.oriented.network.ObjectOrientedNetworkDocumentConverter;
import com.ubnt.net.v2.object.oriented.network.exception.InvalidObjectOrientedNetworkConfigField;
import com.ubnt.net.v2.object.oriented.network.exception.InvalidObjectOrientedNetworkConfigState;
import com.ubnt.service.firewall.E;
import com.ubnt.service.firewall.Object;
import com.ubnt.service.firewall.OoOO;
import com.ubnt.service.firewall.policy.for;
import com.ubnt.service.firewall.policy.ifsuper;
import com.ubnt.service.firewall.policy.thissuper;
import com.ubnt.service.firewall.policy.zone.super;
import com.ubnt.service.firewall.qos.A.J;
import com.ubnt.service.firewall.qos.A.OooO;
import com.ubnt.service.firewall.qos.B;
import com.ubnt.service.firewall.qos.G;
import com.ubnt.service.firewall.qos.I;
import com.ubnt.service.firewall.qos.destination.FirewallQosDestinationWebDocumentPart;
import com.ubnt.service.firewall.qos.oo0O;
import com.ubnt.service.network.configuration.ooOO;
import com.ubnt.service.object.oriented.network.D;
import com.ubnt.service.object.oriented.network.ObjectOrientedNetworkConfigDocument;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.switchacl.super.K;
import com.ubnt.service.switchacl.super.O;
import com.ubnt.service.system.jA;
import com.ubnt.service.traffic.TrafficDomainDocumentPart;
import com.ubnt.service.traffic.TrafficIpDocumentPart;
import com.ubnt.service.trafficroute.C;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectOrientedNetworkConfigValidator {
    private static final Logger OO0000 = jA.oo0000;
    public static final int IPSET_MAX_SIZE = 10000;
    public static final int APPS_MAX_SIZE = 100;
    private final com.ubnt.service.firewall.policy.ooOO return;
    private final Object \u00d300000;
    private final ifsuper oO0000;
    private final super \u00f500000;
    private final C if;
    private final com.ubnt.service.traffic.Object \u00d500000;
    private final G \u00f400000;
    private final B \u00d400000;
    private final com.ubnt.service.switchacl.thissuper o00000;
    private final D \u00f800000;
    private final E \u00d800000;
    private final ooOO new;

    public void validate(String string, ObjectOrientedNetworkConfigDto objectOrientedNetworkConfigDto) {
        this.Oo0000(objectOrientedNetworkConfigDto);
        this.\u00f4O0000(string, objectOrientedNetworkConfigDto.qos());
        this.\u00d2O0000(string, objectOrientedNetworkConfigDto.route());
        this.OO0000(string, objectOrientedNetworkConfigDto.secure());
        this.\u00d300000(ObjectOrientedNetworkDocumentConverter.toDocument(string, objectOrientedNetworkConfigDto));
    }

    private void Oo0000(ObjectOrientedNetworkConfigDto objectOrientedNetworkConfigDto) {
        List<String> list = objectOrientedNetworkConfigDto.targets();
        switch (objectOrientedNetworkConfigDto.targetType()) {
            case CLIENTS: {
                if (!list.stream().anyMatch(string -> !A.\u00d200000(string, false))) break;
                throw new InvalidObjectOrientedNetworkConfigField("Not all clients are valid mac in 'targets'", "targets");
            }
        }
    }

    private void \u00f4O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.QosDto qosDto) {
        if (qosDto == null || !qosDto.enabled().booleanValue()) {
            return;
        }
        if (BooleanUtils.isTrue((Boolean)qosDto.allTraffic())) {
            if (ObjectOrientedNetworkConfigValidator.class(qosDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.apps cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.Objectsuper(qosDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.domains cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.do(qosDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.ip_addresses cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.Objectsuper(qosDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.regions cannot be enabled together with all traffic");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.class(qosDto.apps()) || ObjectOrientedNetworkConfigValidator.Objectsuper(qosDto.domains()) || ObjectOrientedNetworkConfigValidator.do(qosDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.Objectsuper(qosDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for qos");
        }
        this.\u00d8O0000("qos.domains", string, qosDto.domains());
        this.\u00f800000(qosDto, string);
        this.super(qosDto);
        this.\u00d3O0000("qos.apps", qosDto.apps());
        this.\u00d2o0000("qos.regions", qosDto.regions());
        this.\u00f6O0000("qos.ip_addresses", qosDto.ipAddresses());
        ScheduleDocumentPart scheduleDocumentPart = ScheduleDto.toDocument(qosDto.schedule());
        if (scheduleDocumentPart != null) {
            try {
                this.\u00d800000.\u00d600000(scheduleDocumentPart);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid 'qos.schedule' field", "qos.schedule");
            }
        }
    }

    private void \u00d2O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        if (routeDto == null || !routeDto.enabled().booleanValue()) {
            return;
        }
        if (BooleanUtils.isTrue((Boolean)routeDto.allTraffic())) {
            if (ObjectOrientedNetworkConfigValidator.class(routeDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.apps cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.Objectsuper(routeDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.domains cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.do(routeDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.ip_addresses cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.Objectsuper(routeDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.regions cannot be enabled together with all traffic");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.class(routeDto.apps()) || ObjectOrientedNetworkConfigValidator.Objectsuper(routeDto.domains()) || ObjectOrientedNetworkConfigValidator.do(routeDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.Objectsuper(routeDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for route");
        }
        NetworkConf networkConf = this.\u00d800000(routeDto, string);
        this.\u00d4O0000("route.domains", string, routeDto.domains());
        this.interface("route.ip_addresses", networkConf, routeDto);
        this.\u00d2o0000("route.regions", routeDto.regions());
        ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList = routeDto.apps();
        if (integerValuesList != null && integerValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Route doesn't support applications", "route.apps");
        }
    }

    private void OO0000(String string, @Nullable ObjectOrientedNetworkConfigDto.SecureDto secureDto) {
        if (secureDto == null || !secureDto.enabled().booleanValue()) {
            return;
        }
        this.\u00d6O0000(secureDto.internet());
        this.\u00f400000(string, secureDto.local());
    }

    private void \u00d300000(ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument) {
        if (objectOrientedNetworkConfigDocument.isSecureEnabled()) {
            this.\u00d200000(objectOrientedNetworkConfigDocument);
        }
    }

    private void \u00d200000(ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument) {
        List<NetworkConf> list = this.new.\u00f500000(objectOrientedNetworkConfigDocument.siteId());
        List<AclRuleDocument> list2 = this.\u00f800000.o00000(objectOrientedNetworkConfigDocument, list);
        try {
            this.o00000.\u00d4O0000(objectOrientedNetworkConfigDocument.siteId(), objectOrientedNetworkConfigDocument, list2, list);
        }
        catch (K k2) {
            throw O.\u00d300000(k2);
        }
    }

    private void \u00d6O0000(@Nullable ObjectOrientedNetworkConfigDto.SecureDto.InternetSectionDto internetSectionDto) {
        if (internetSectionDto == null) {
            return;
        }
        switch (internetSectionDto.mode()) {
            case ALLOWLIST: 
            case BLOCKLIST: 
            case TURN_OFF_INTERNET: {
                break;
            }
            default: {
                String string = "secure.internet.mode";
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        }
        ObjectOrientedNetworkSecureMode objectOrientedNetworkSecureMode = internetSectionDto.mode();
        if (objectOrientedNetworkSecureMode == ObjectOrientedNetworkSecureMode.TURN_OFF_INTERNET) {
            if (BooleanUtils.isTrue((Boolean)internetSectionDto.everything()) || ObjectOrientedNetworkConfigValidator.class(internetSectionDto.apps()) || ObjectOrientedNetworkConfigValidator.Objectsuper(internetSectionDto.domains()) || ObjectOrientedNetworkConfigValidator.do(internetSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.Objectsuper(internetSectionDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("Nothing can be enabled with 'TURN_OFF_INTERNET' mode");
            }
            return;
        }
        if (BooleanUtils.isTrue((Boolean)internetSectionDto.everything())) {
            if (ObjectOrientedNetworkConfigValidator.class(internetSectionDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.apps cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.Objectsuper(internetSectionDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.domains cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.do(internetSectionDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.ip_addresses cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.Objectsuper(internetSectionDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.regions cannot be enabled together with everything");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.class(internetSectionDto.apps()) || ObjectOrientedNetworkConfigValidator.Objectsuper(internetSectionDto.domains()) || ObjectOrientedNetworkConfigValidator.do(internetSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.Objectsuper(internetSectionDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for secure.internet");
        }
        this.\u00d3O0000("secure.internet.apps", internetSectionDto.apps());
        this.\u00f600000("secure.internet.domains", internetSectionDto.domains());
        this.\u00f6O0000("secure.internet.ip_addresses", internetSectionDto.ipAddresses());
        this.\u00d2o0000("secure.internet.regions", internetSectionDto.regions());
        ScheduleDocumentPart scheduleDocumentPart = ScheduleDto.toDocument(internetSectionDto.schedule());
        if (scheduleDocumentPart != null) {
            try {
                this.\u00d800000.\u00d600000(scheduleDocumentPart);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid 'internet.schedule' field", "internet.schedule");
            }
        }
    }

    private void \u00f400000(String string, @Nullable ObjectOrientedNetworkConfigDto.SecureDto.LocalSectionDto localSectionDto) {
        if (localSectionDto == null) {
            return;
        }
        switch (localSectionDto.mode()) {
            case ALLOWLIST: 
            case BLOCKLIST: 
            case QUARANTINE: {
                break;
            }
            default: {
                String string2 = "secure.local.mode";
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
            }
        }
        ObjectOrientedNetworkSecureMode objectOrientedNetworkSecureMode = localSectionDto.mode();
        if (objectOrientedNetworkSecureMode == ObjectOrientedNetworkSecureMode.QUARANTINE) {
            if (BooleanUtils.isTrue((Boolean)localSectionDto.everything()) || ObjectOrientedNetworkConfigValidator.\u00d400000(localSectionDto.devices()) || ObjectOrientedNetworkConfigValidator.Objectsuper(localSectionDto.networks()) || ObjectOrientedNetworkConfigValidator.do(localSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00d400000(localSectionDto.macAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("Nothing can be enabled with 'QUARANTINE' mode");
            }
            return;
        }
        if (BooleanUtils.isTrue((Boolean)localSectionDto.everything())) {
            if (ObjectOrientedNetworkConfigValidator.\u00d400000(localSectionDto.devices())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.devices cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.Objectsuper(localSectionDto.networks())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.networks cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.do(localSectionDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.ip_addresses cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00d400000(localSectionDto.macAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.mac_addresses cannot be enabled together with everything");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.\u00d400000(localSectionDto.devices()) || ObjectOrientedNetworkConfigValidator.Objectsuper(localSectionDto.networks()) || ObjectOrientedNetworkConfigValidator.do(localSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00d400000(localSectionDto.macAddresses()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for secure.local");
        }
        this.\u00d600000("secure.local.devices", localSectionDto.devices());
        this.\u00d8o0000("secure.local.networks", string, localSectionDto.networks());
        this.\u00f6O0000("secure.local.ip_addresses", localSectionDto.ipAddresses());
    }

    private void \u00f6O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList) {
        if (ipAddressesValuesList == null) {
            return;
        }
        List<String> list = ipAddressesValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            try {
                this.\u00d300000.\u00d200000(list, OoOO.\u00d300000, thissuper.\u00d500000);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (ipAddressesValuesList.enabled().booleanValue()) {
            throw new IllegalStateException("'%s' should not be empty".formatted(string));
        }
    }

    private void interface(String string, NetworkConf networkConf, ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList = routeDto.ipAddresses();
        if (ipAddressesValuesList == null) {
            return;
        }
        List<String> list = ipAddressesValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            List<TrafficIpDocumentPart> list2 = ObjectOrientedNetworkConfigValidator.voidsuper(list);
            try {
                this.if.OO0000(networkConf, list2, List.of(), TrafficRouteMatchingTarget.IP);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (ipAddressesValuesList.enabled().booleanValue()) {
            throw new IllegalStateException("'%s' should not be empty".formatted(string));
        }
    }

    private void \u00d2o0000(String string, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            try {
                this.\u00d500000.\u00d8o0000(list);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d8O0000(String string, String string2, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            FirewallQosDestinationWebDocumentPart firewallQosDestinationWebDocumentPart = FirewallQosDestinationWebDocumentPart.builder().\u00d400000(list).OO0000(I.\u00d600000).Object(for.\u00d400000).\u00f400000();
            try {
                this.\u00d400000.\u00f800000(firewallQosDestinationWebDocumentPart, string2);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00f800000(ObjectOrientedNetworkConfigDto.QosDto qosDto, String string) {
        String string2 = qosDto.networkId();
        try {
            this.\u00f400000.\u00d3O0000(string2, string);
        }
        catch (OooO oooO2) {
            OO0000.warn(oooO2.getMessage(), (Throwable)oooO2);
            throw new InvalidObjectOrientedNetworkConfigField("Invalid 'qos.network_id'", "qos.network_id");
        }
    }

    private void super(ObjectOrientedNetworkConfigDto.QosDto qosDto) {
        oo0O oo0O2 = qosDto.mode().qosRuleObjective();
        Integer n2 = U.classsuper(qosDto.downloadLimit(), speedLimitDto -> speedLimitDto != null && speedLimitDto.enabled() != false, ObjectOrientedNetworkConfigDto.QosDto.SpeedLimitDto::limit);
        Integer n3 = U.classsuper(qosDto.uploadLimit(), speedLimitDto -> speedLimitDto != null && speedLimitDto.enabled() != false, ObjectOrientedNetworkConfigDto.QosDto.SpeedLimitDto::limit);
        try {
            this.\u00f400000.new(oo0O2, n2, n3);
        }
        catch (J j2) {
            OO0000.warn(j2.getMessage(), (Throwable)j2);
            throw new InvalidObjectOrientedNetworkConfigField(j2.getMessage(), "qos.download_limit|qos.upload_limit");
        }
    }

    private void \u00d4O0000(String string2, String string3, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string2), string2);
            }
            List<TrafficDomainDocumentPart> list2 = list.stream().map(string -> TrafficDomainDocumentPart.builder().for((String)string).\u00d600000()).toList();
            try {
                this.\u00d500000.\u00d4o0000(string3, list2);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string2), string2);
        }
    }

    private void \u00f600000(String string, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 10000) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many elements in '%s'".formatted(string), string);
            }
            try {
                this.\u00d300000.for(list);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d3O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList) {
        if (integerValuesList == null) {
            return;
        }
        List<Integer> list = integerValuesList.values();
        if (!list.isEmpty()) {
            if (list.size() >= 100) {
                throw new InvalidObjectOrientedNetworkConfigField("Too many apps in '%s'".formatted(string), string);
            }
            try {
                this.\u00d300000.newsuper(list);
            }
            catch (RuntimeException runtimeException) {
                OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (integerValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d8o0000(String string, String string2, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            List<com.ubnt.service.firewall.policy.zone.Object> list2 = this.\u00f500000.\u00d500000(this.return.\u00d3O0000(string2));
            if (list2.isEmpty()) {
                throw new InvalidObjectOrientedNetworkConfigState("No any available firewall zones to configure networks");
            }
            HashMap<com.ubnt.service.firewall.policy.zone.Object, Set> hashMap = new HashMap<com.ubnt.service.firewall.policy.zone.Object, Set>();
            for (String object2 : list) {
                com.ubnt.service.firewall.policy.zone.Object object3 = list2.stream().filter(object -> object.\u00d600000().contains(object2)).findFirst().orElseThrow(() -> new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string));
                hashMap.computeIfAbsent(object3, object -> new HashSet()).add(object2);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                try {
                    this.oO0000.null((Set)entry.getValue(), (com.ubnt.service.firewall.policy.zone.Object)entry.getKey());
                }
                catch (RuntimeException runtimeException) {
                    OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                    throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
                }
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d600000(String string, @Nullable ObjectOrientedNetworkConfigDto.MacAddressesValuesList macAddressesValuesList) {
        if (macAddressesValuesList == null) {
            return;
        }
        List<String> list = macAddressesValuesList.values();
        if (macAddressesValuesList.enabled().booleanValue() && list.isEmpty()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private NetworkConf \u00d800000(ObjectOrientedNetworkConfigDto.RouteDto routeDto, String string) {
        String string2 = "route.network_id";
        String string3 = routeDto.networkId();
        if (StringUtils.isBlank((CharSequence)string3)) {
            throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
        }
        Set<TrafficRouteMatchingTarget> set = ObjectOrientedNetworkConfigValidator.\u00d4o0000(routeDto);
        try {
            return this.if.\u00d600000(string, string3, set);
        }
        catch (RuntimeException runtimeException) {
            OO0000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
            throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
        }
    }

    private static boolean Objectsuper(@Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        return stringValuesList != null && stringValuesList.enabled() != false;
    }

    private static boolean do(@Nullable ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList) {
        return ipAddressesValuesList != null && ipAddressesValuesList.enabled() != false;
    }

    private static boolean \u00d400000(@Nullable ObjectOrientedNetworkConfigDto.MacAddressesValuesList macAddressesValuesList) {
        return macAddressesValuesList != null && macAddressesValuesList.enabled() != false;
    }

    private static boolean class(@Nullable ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList) {
        return integerValuesList != null && integerValuesList.enabled() != false;
    }

    private static Set<TrafficRouteMatchingTarget> \u00d4o0000(ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        HashSet<TrafficRouteMatchingTarget> hashSet = new HashSet<TrafficRouteMatchingTarget>();
        if (ObjectOrientedNetworkConfigValidator.Objectsuper(routeDto.domains())) {
            hashSet.add(TrafficRouteMatchingTarget.DOMAIN);
        }
        if (ObjectOrientedNetworkConfigValidator.do(routeDto.ipAddresses())) {
            hashSet.add(TrafficRouteMatchingTarget.IP);
        }
        if (ObjectOrientedNetworkConfigValidator.Objectsuper(routeDto.regions())) {
            hashSet.add(TrafficRouteMatchingTarget.REGION);
        }
        if (BooleanUtils.isTrue((Boolean)routeDto.allTraffic())) {
            hashSet.add(TrafficRouteMatchingTarget.INTERNET);
        }
        return hashSet;
    }

    private static List<TrafficIpDocumentPart> voidsuper(List<String> list) {
        return list.stream().map(string -> TrafficIpDocumentPart.builder().new(com.ubnt.ace.Object.\u00f8\u00d40000(string) || com.ubnt.ace.Object.\u00d500000(string) ? IpVersion.V6 : IpVersion.V4).\u00d300000((String)string).\u00d500000()).toList();
    }

    @ConstructorProperties(value={"firewallPolicyValidator", "firewallSourceDestinationValidationUtils", "firewallPolicySourceDestinationValidationUtils", "firewallZoneMatchingTargetUtils", "trafficRouteValidator", "trafficValidator", "qosRuleValidator", "destinationQosValidator", "aclRuleValidator", "objectOrientedNetworkAclRulesFactory", "firewallScheduleValidator", "networkConfigService"})
    @Generated
    public ObjectOrientedNetworkConfigValidator(com.ubnt.service.firewall.policy.ooOO ooOO2, Object object, ifsuper ifsuper2, super super_, C c2, com.ubnt.service.traffic.Object object2, G g2, B b2, com.ubnt.service.switchacl.thissuper thissuper2, D d2, E e2, ooOO ooOO3) {
        this.return = ooOO2;
        this.\u00d300000 = object;
        this.oO0000 = ifsuper2;
        this.\u00f500000 = super_;
        this.if = c2;
        this.\u00d500000 = object2;
        this.\u00f400000 = g2;
        this.\u00d400000 = b2;
        this.o00000 = thissuper2;
        this.\u00f800000 = d2;
        this.\u00d800000 = e2;
        this.new = ooOO3;
    }
}

