// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package proton

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
)

// WaitUntilComponentDeleted uses the AWS Proton API operation
// GetComponent to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilComponentDeleted(input *GetComponentInput) error {
	return c.WaitUntilComponentDeletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilComponentDeletedWithContext is an extended version of WaitUntilComponentDeleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilComponentDeletedWithContext(ctx aws.Context, input *GetComponentInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilComponentDeleted",
		MaxAttempts: 999,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "component.deploymentStatus",
				Expected: "DELETE_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetComponentInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetComponentRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilComponentDeployed uses the AWS Proton API operation
// GetComponent to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilComponentDeployed(input *GetComponentInput) error {
	return c.WaitUntilComponentDeployedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilComponentDeployedWithContext is an extended version of WaitUntilComponentDeployed.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilComponentDeployedWithContext(ctx aws.Context, input *GetComponentInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilComponentDeployed",
		MaxAttempts: 999,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "component.deploymentStatus",
				Expected: "SUCCEEDED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "component.deploymentStatus",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetComponentInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetComponentRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilEnvironmentDeployed uses the AWS Proton API operation
// GetEnvironment to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilEnvironmentDeployed(input *GetEnvironmentInput) error {
	return c.WaitUntilEnvironmentDeployedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilEnvironmentDeployedWithContext is an extended version of WaitUntilEnvironmentDeployed.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilEnvironmentDeployedWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilEnvironmentDeployed",
		MaxAttempts: 999,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "environment.deploymentStatus",
				Expected: "SUCCEEDED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "environment.deploymentStatus",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetEnvironmentInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEnvironmentRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilEnvironmentTemplateVersionRegistered uses the AWS Proton API operation
// GetEnvironmentTemplateVersion to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilEnvironmentTemplateVersionRegistered(input *GetEnvironmentTemplateVersionInput) error {
	return c.WaitUntilEnvironmentTemplateVersionRegisteredWithContext(aws.BackgroundContext(), input)
}

// WaitUntilEnvironmentTemplateVersionRegisteredWithContext is an extended version of WaitUntilEnvironmentTemplateVersionRegistered.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilEnvironmentTemplateVersionRegisteredWithContext(ctx aws.Context, input *GetEnvironmentTemplateVersionInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilEnvironmentTemplateVersionRegistered",
		MaxAttempts: 150,
		Delay:       request.ConstantWaiterDelay(2 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "environmentTemplateVersion.status",
				Expected: "DRAFT",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "environmentTemplateVersion.status",
				Expected: "PUBLISHED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "environmentTemplateVersion.status",
				Expected: "REGISTRATION_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetEnvironmentTemplateVersionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetEnvironmentTemplateVersionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilServiceCreated uses the AWS Proton API operation
// GetService to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilServiceCreated(input *GetServiceInput) error {
	return c.WaitUntilServiceCreatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilServiceCreatedWithContext is an extended version of WaitUntilServiceCreated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilServiceCreatedWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilServiceCreated",
		MaxAttempts: 999,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "ACTIVE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "CREATE_FAILED_CLEANUP_COMPLETE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "CREATE_FAILED_CLEANUP_FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "CREATE_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetServiceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServiceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilServiceDeleted uses the AWS Proton API operation
// GetService to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilServiceDeleted(input *GetServiceInput) error {
	return c.WaitUntilServiceDeletedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilServiceDeletedWithContext is an extended version of WaitUntilServiceDeleted.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilServiceDeletedWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilServiceDeleted",
		MaxAttempts: 999,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:    request.SuccessWaiterState,
				Matcher:  request.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "DELETE_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetServiceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServiceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilServiceInstanceDeployed uses the AWS Proton API operation
// GetServiceInstance to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilServiceInstanceDeployed(input *GetServiceInstanceInput) error {
	return c.WaitUntilServiceInstanceDeployedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilServiceInstanceDeployedWithContext is an extended version of WaitUntilServiceInstanceDeployed.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilServiceInstanceDeployedWithContext(ctx aws.Context, input *GetServiceInstanceInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilServiceInstanceDeployed",
		MaxAttempts: 999,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "serviceInstance.deploymentStatus",
				Expected: "SUCCEEDED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "serviceInstance.deploymentStatus",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetServiceInstanceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServiceInstanceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilServicePipelineDeployed uses the AWS Proton API operation
// GetService to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilServicePipelineDeployed(input *GetServiceInput) error {
	return c.WaitUntilServicePipelineDeployedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilServicePipelineDeployedWithContext is an extended version of WaitUntilServicePipelineDeployed.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilServicePipelineDeployedWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilServicePipelineDeployed",
		MaxAttempts: 360,
		Delay:       request.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.pipeline.deploymentStatus",
				Expected: "SUCCEEDED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.pipeline.deploymentStatus",
				Expected: "FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetServiceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServiceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilServiceTemplateVersionRegistered uses the AWS Proton API operation
// GetServiceTemplateVersion to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilServiceTemplateVersionRegistered(input *GetServiceTemplateVersionInput) error {
	return c.WaitUntilServiceTemplateVersionRegisteredWithContext(aws.BackgroundContext(), input)
}

// WaitUntilServiceTemplateVersionRegisteredWithContext is an extended version of WaitUntilServiceTemplateVersionRegistered.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilServiceTemplateVersionRegisteredWithContext(ctx aws.Context, input *GetServiceTemplateVersionInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilServiceTemplateVersionRegistered",
		MaxAttempts: 150,
		Delay:       request.ConstantWaiterDelay(2 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "serviceTemplateVersion.status",
				Expected: "DRAFT",
			},
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "serviceTemplateVersion.status",
				Expected: "PUBLISHED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "serviceTemplateVersion.status",
				Expected: "REGISTRATION_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetServiceTemplateVersionInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServiceTemplateVersionRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}

// WaitUntilServiceUpdated uses the AWS Proton API operation
// GetService to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
func (c *Proton) WaitUntilServiceUpdated(input *GetServiceInput) error {
	return c.WaitUntilServiceUpdatedWithContext(aws.BackgroundContext(), input)
}

// WaitUntilServiceUpdatedWithContext is an extended version of WaitUntilServiceUpdated.
// With the support for passing in a context and options to configure the
// Waiter and the underlying request options.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) WaitUntilServiceUpdatedWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.WaiterOption) error {
	w := request.Waiter{
		Name:        "WaitUntilServiceUpdated",
		MaxAttempts: 999,
		Delay:       request.ConstantWaiterDelay(5 * time.Second),
		Acceptors: []request.WaiterAcceptor{
			{
				State:   request.SuccessWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "ACTIVE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "UPDATE_FAILED_CLEANUP_COMPLETE",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "UPDATE_FAILED_CLEANUP_FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "UPDATE_FAILED",
			},
			{
				State:   request.FailureWaiterState,
				Matcher: request.PathWaiterMatch, Argument: "service.status",
				Expected: "UPDATE_COMPLETE_CLEANUP_FAILED",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []request.Option) (*request.Request, error) {
			var inCpy *GetServiceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetServiceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.WaitWithContext(ctx)
}
