/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api;

import com.ubnt.service.site.D;
import com.ubnt.service.trace.M;
import com.ubnt.service.trace.api.DeviceEvent;
import com.ubnt.service.trace.api.Trace;
import com.ubnt.service.trace.api.UUSCommitErrorEvent;
import com.ubnt.service.trace.model.common.TraceMeta;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TraceEventManager {
    private static final String TRACE_CONTROLLER_DEVICE_NAMESPACE = "unifi:network:controller:device";
    private static final String TRACE_UUS_ERROR_EVENT_NAMESPACE = "ubios:udapi-server";
    private final M tracer;
    private final D siteService;

    public TraceEventManager(M m2, D d2) {
        this.tracer = m2;
        this.siteService = d2;
    }

    public void sendDeviceEvent(DeviceEvent deviceEvent) {
        this.siteService.\u00d3O0000(deviceEvent.getDevice().getSiteId()).ifPresent(site -> {
            TraceMeta traceMeta = new TraceMeta(site.getAnonymousId());
            Trace trace = new Trace().setNamespace(TRACE_CONTROLLER_DEVICE_NAMESPACE).setMeta(traceMeta).setType(deviceEvent.getType()).setPayloadData(deviceEvent);
            this.tracer.new(trace);
        });
    }

    public void sendUUSCommitErrorEvent(UUSCommitErrorEvent uUSCommitErrorEvent) {
        this.siteService.\u00d3O0000(uUSCommitErrorEvent.getDevice().getSiteId()).ifPresent(site -> {
            TraceMeta traceMeta = new TraceMeta(site.getAnonymousId());
            Trace trace = new Trace().setNamespace(TRACE_UUS_ERROR_EVENT_NAMESPACE).setMeta(traceMeta).setType(uUSCommitErrorEvent.getType()).setPayloadData(uUSCommitErrorEvent);
            this.tracer.new(trace);
        });
    }
}

