/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.stat;

import java.io.Serializable;
import java.util.IntSummaryStatistics;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

public final class IntSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long _count;
    private final int _min;
    private final int _max;
    private final long _sum;
    private final double _mean;

    private IntSummary(long count, int min, int max, long sum, double mean) {
        this._count = count;
        this._min = min;
        this._max = max;
        this._sum = sum;
        this._mean = mean;
    }

    public long getCount() {
        return this._count;
    }

    public int getMin() {
        return this._min;
    }

    public int getMax() {
        return this._max;
    }

    public long getSum() {
        return this._sum;
    }

    public double getMean() {
        return this._mean;
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((long)hash + (33L * this._count + 37L));
        hash = (int)((long)hash + (33L * this._sum + 37L));
        hash += 33 * this._min + 37;
        hash += 33 * this._max + 37;
        return hash += 33 * Double.hashCode(this._mean) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof IntSummary && this._count == ((IntSummary)obj)._count && this._sum == ((IntSummary)obj)._sum && this._min == ((IntSummary)obj)._min && this._max == ((IntSummary)obj)._max && Double.compare(this._mean, ((IntSummary)obj)._mean) == 0;
    }

    public String toString() {
        return String.format("IntSummary[N=%d, \u2227=%s, \u2228=%s, \u03a3=%s, \u03bc=%s]", this.getCount(), this.getMin(), this.getMax(), this.getSum(), this.getMean());
    }

    public static IntSummary of(long count, int min, int max, long sum, double mean) {
        return new IntSummary(count, min, max, sum, mean);
    }

    public static IntSummary of(IntSummaryStatistics statistics) {
        return new IntSummary(statistics.getCount(), statistics.getMin(), statistics.getMax(), statistics.getSum(), statistics.getAverage());
    }

    public static <T> Collector<T, ?, IntSummary> toIntSummary(ToIntFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        return Collector.of(IntSummaryStatistics::new, (a, b) -> a.accept(mapper.applyAsInt(b)), (a, b) -> {
            a.combine((IntSummaryStatistics)b);
            return a;
        }, IntSummary::of, new Collector.Characteristics[0]);
    }

    public static int min(int[] values) {
        int min = Integer.MAX_VALUE;
        if (values.length > 0) {
            min = values[0];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] >= min) continue;
                min = values[i];
            }
        }
        return min;
    }

    public static int max(int[] values) {
        int max = Integer.MIN_VALUE;
        if (values.length > 0) {
            max = values[0];
            for (int i = 0; i < values.length; ++i) {
                if (values[i] <= max) continue;
                max = values[i];
            }
        }
        return max;
    }

    public static long sum(int[] values) {
        long sum = 0L;
        int i = values.length;
        while (--i >= 0) {
            sum += (long)values[i];
        }
        return sum;
    }

    public static double mean(int[] values) {
        return values.length > 0 ? (double)IntSummary.sum(values) / (double)values.length : Double.NaN;
    }
}

