// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/baremetalsolution/v2/baremetalsolution.proto

package baremetalsolutionpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BareMetalSolution_ListInstances_FullMethodName                   = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListInstances"
	BareMetalSolution_GetInstance_FullMethodName                     = "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetInstance"
	BareMetalSolution_UpdateInstance_FullMethodName                  = "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateInstance"
	BareMetalSolution_RenameInstance_FullMethodName                  = "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameInstance"
	BareMetalSolution_ResetInstance_FullMethodName                   = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ResetInstance"
	BareMetalSolution_StartInstance_FullMethodName                   = "/google.cloud.baremetalsolution.v2.BareMetalSolution/StartInstance"
	BareMetalSolution_StopInstance_FullMethodName                    = "/google.cloud.baremetalsolution.v2.BareMetalSolution/StopInstance"
	BareMetalSolution_EnableInteractiveSerialConsole_FullMethodName  = "/google.cloud.baremetalsolution.v2.BareMetalSolution/EnableInteractiveSerialConsole"
	BareMetalSolution_DisableInteractiveSerialConsole_FullMethodName = "/google.cloud.baremetalsolution.v2.BareMetalSolution/DisableInteractiveSerialConsole"
	BareMetalSolution_DetachLun_FullMethodName                       = "/google.cloud.baremetalsolution.v2.BareMetalSolution/DetachLun"
	BareMetalSolution_ListSSHKeys_FullMethodName                     = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListSSHKeys"
	BareMetalSolution_CreateSSHKey_FullMethodName                    = "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateSSHKey"
	BareMetalSolution_DeleteSSHKey_FullMethodName                    = "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteSSHKey"
	BareMetalSolution_ListVolumes_FullMethodName                     = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumes"
	BareMetalSolution_GetVolume_FullMethodName                       = "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolume"
	BareMetalSolution_UpdateVolume_FullMethodName                    = "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateVolume"
	BareMetalSolution_RenameVolume_FullMethodName                    = "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameVolume"
	BareMetalSolution_EvictVolume_FullMethodName                     = "/google.cloud.baremetalsolution.v2.BareMetalSolution/EvictVolume"
	BareMetalSolution_ResizeVolume_FullMethodName                    = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ResizeVolume"
	BareMetalSolution_ListNetworks_FullMethodName                    = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworks"
	BareMetalSolution_ListNetworkUsage_FullMethodName                = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNetworkUsage"
	BareMetalSolution_GetNetwork_FullMethodName                      = "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetNetwork"
	BareMetalSolution_UpdateNetwork_FullMethodName                   = "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateNetwork"
	BareMetalSolution_CreateVolumeSnapshot_FullMethodName            = "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateVolumeSnapshot"
	BareMetalSolution_RestoreVolumeSnapshot_FullMethodName           = "/google.cloud.baremetalsolution.v2.BareMetalSolution/RestoreVolumeSnapshot"
	BareMetalSolution_DeleteVolumeSnapshot_FullMethodName            = "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteVolumeSnapshot"
	BareMetalSolution_GetVolumeSnapshot_FullMethodName               = "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetVolumeSnapshot"
	BareMetalSolution_ListVolumeSnapshots_FullMethodName             = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListVolumeSnapshots"
	BareMetalSolution_GetLun_FullMethodName                          = "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetLun"
	BareMetalSolution_ListLuns_FullMethodName                        = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListLuns"
	BareMetalSolution_EvictLun_FullMethodName                        = "/google.cloud.baremetalsolution.v2.BareMetalSolution/EvictLun"
	BareMetalSolution_GetNfsShare_FullMethodName                     = "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetNfsShare"
	BareMetalSolution_ListNfsShares_FullMethodName                   = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListNfsShares"
	BareMetalSolution_UpdateNfsShare_FullMethodName                  = "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateNfsShare"
	BareMetalSolution_CreateNfsShare_FullMethodName                  = "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateNfsShare"
	BareMetalSolution_RenameNfsShare_FullMethodName                  = "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameNfsShare"
	BareMetalSolution_DeleteNfsShare_FullMethodName                  = "/google.cloud.baremetalsolution.v2.BareMetalSolution/DeleteNfsShare"
	BareMetalSolution_ListProvisioningQuotas_FullMethodName          = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListProvisioningQuotas"
	BareMetalSolution_SubmitProvisioningConfig_FullMethodName        = "/google.cloud.baremetalsolution.v2.BareMetalSolution/SubmitProvisioningConfig"
	BareMetalSolution_GetProvisioningConfig_FullMethodName           = "/google.cloud.baremetalsolution.v2.BareMetalSolution/GetProvisioningConfig"
	BareMetalSolution_CreateProvisioningConfig_FullMethodName        = "/google.cloud.baremetalsolution.v2.BareMetalSolution/CreateProvisioningConfig"
	BareMetalSolution_UpdateProvisioningConfig_FullMethodName        = "/google.cloud.baremetalsolution.v2.BareMetalSolution/UpdateProvisioningConfig"
	BareMetalSolution_RenameNetwork_FullMethodName                   = "/google.cloud.baremetalsolution.v2.BareMetalSolution/RenameNetwork"
	BareMetalSolution_ListOSImages_FullMethodName                    = "/google.cloud.baremetalsolution.v2.BareMetalSolution/ListOSImages"
)

// BareMetalSolutionClient is the client API for BareMetalSolution service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BareMetalSolutionClient interface {
	// List servers in a given project and location.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Get details about a single server.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Update details of a single server.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// RenameInstance sets a new name for an instance.
	// Use with caution, previous names become immediately invalidated.
	RenameInstance(ctx context.Context, in *RenameInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Perform an ungraceful, hard reset on a server. Equivalent to shutting the
	// power off and then turning it back on.
	ResetInstance(ctx context.Context, in *ResetInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a server that was shutdown.
	StartInstance(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stop a running server.
	StopInstance(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Enable the interactive serial console feature on an instance.
	EnableInteractiveSerialConsole(ctx context.Context, in *EnableInteractiveSerialConsoleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Disable the interactive serial console feature on an instance.
	DisableInteractiveSerialConsole(ctx context.Context, in *DisableInteractiveSerialConsoleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Detach LUN from Instance.
	DetachLun(ctx context.Context, in *DetachLunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the public SSH keys registered for the specified project.
	// These SSH keys are used only for the interactive serial console feature.
	ListSSHKeys(ctx context.Context, in *ListSSHKeysRequest, opts ...grpc.CallOption) (*ListSSHKeysResponse, error)
	// Register a public SSH key in the specified project for use with the
	// interactive serial console feature.
	CreateSSHKey(ctx context.Context, in *CreateSSHKeyRequest, opts ...grpc.CallOption) (*SSHKey, error)
	// Deletes a public SSH key registered in the specified project.
	DeleteSSHKey(ctx context.Context, in *DeleteSSHKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// List storage volumes in a given project and location.
	ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error)
	// Get details of a single storage volume.
	GetVolume(ctx context.Context, in *GetVolumeRequest, opts ...grpc.CallOption) (*Volume, error)
	// Update details of a single storage volume.
	UpdateVolume(ctx context.Context, in *UpdateVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// RenameVolume sets a new name for a volume.
	// Use with caution, previous names become immediately invalidated.
	RenameVolume(ctx context.Context, in *RenameVolumeRequest, opts ...grpc.CallOption) (*Volume, error)
	// Skips volume's cooloff and deletes it now.
	// Volume must be in cooloff state.
	EvictVolume(ctx context.Context, in *EvictVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Emergency Volume resize.
	ResizeVolume(ctx context.Context, in *ResizeVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List network in a given project and location.
	ListNetworks(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error)
	// List all Networks (and used IPs for each Network) in the vendor account
	// associated with the specified project.
	ListNetworkUsage(ctx context.Context, in *ListNetworkUsageRequest, opts ...grpc.CallOption) (*ListNetworkUsageResponse, error)
	// Get details of a single network.
	GetNetwork(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error)
	// Update details of a single network.
	UpdateNetwork(ctx context.Context, in *UpdateNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Takes a snapshot of a boot volume.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	CreateVolumeSnapshot(ctx context.Context, in *CreateVolumeSnapshotRequest, opts ...grpc.CallOption) (*VolumeSnapshot, error)
	// Uses the specified snapshot to restore its parent volume.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	RestoreVolumeSnapshot(ctx context.Context, in *RestoreVolumeSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a volume snapshot.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	DeleteVolumeSnapshot(ctx context.Context, in *DeleteVolumeSnapshotRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the specified snapshot resource.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	GetVolumeSnapshot(ctx context.Context, in *GetVolumeSnapshotRequest, opts ...grpc.CallOption) (*VolumeSnapshot, error)
	// Retrieves the list of snapshots for the specified volume.
	// Returns a response with an empty list of snapshots if called
	// for a non-boot volume.
	ListVolumeSnapshots(ctx context.Context, in *ListVolumeSnapshotsRequest, opts ...grpc.CallOption) (*ListVolumeSnapshotsResponse, error)
	// Get details of a single storage logical unit number(LUN).
	GetLun(ctx context.Context, in *GetLunRequest, opts ...grpc.CallOption) (*Lun, error)
	// List storage volume luns for given storage volume.
	ListLuns(ctx context.Context, in *ListLunsRequest, opts ...grpc.CallOption) (*ListLunsResponse, error)
	// Skips lun's cooloff and deletes it now.
	// Lun must be in cooloff state.
	EvictLun(ctx context.Context, in *EvictLunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get details of a single NFS share.
	GetNfsShare(ctx context.Context, in *GetNfsShareRequest, opts ...grpc.CallOption) (*NfsShare, error)
	// List NFS shares.
	ListNfsShares(ctx context.Context, in *ListNfsSharesRequest, opts ...grpc.CallOption) (*ListNfsSharesResponse, error)
	// Update details of a single NFS share.
	UpdateNfsShare(ctx context.Context, in *UpdateNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create an NFS share.
	CreateNfsShare(ctx context.Context, in *CreateNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// RenameNfsShare sets a new name for an nfsshare.
	// Use with caution, previous names become immediately invalidated.
	RenameNfsShare(ctx context.Context, in *RenameNfsShareRequest, opts ...grpc.CallOption) (*NfsShare, error)
	// Delete an NFS share. The underlying volume is automatically deleted.
	DeleteNfsShare(ctx context.Context, in *DeleteNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List the budget details to provision resources on a given project.
	ListProvisioningQuotas(ctx context.Context, in *ListProvisioningQuotasRequest, opts ...grpc.CallOption) (*ListProvisioningQuotasResponse, error)
	// Submit a provisiong configuration for a given project.
	SubmitProvisioningConfig(ctx context.Context, in *SubmitProvisioningConfigRequest, opts ...grpc.CallOption) (*SubmitProvisioningConfigResponse, error)
	// Get ProvisioningConfig by name.
	GetProvisioningConfig(ctx context.Context, in *GetProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error)
	// Create new ProvisioningConfig.
	CreateProvisioningConfig(ctx context.Context, in *CreateProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error)
	// Update existing ProvisioningConfig.
	UpdateProvisioningConfig(ctx context.Context, in *UpdateProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error)
	// RenameNetwork sets a new name for a network.
	// Use with caution, previous names become immediately invalidated.
	RenameNetwork(ctx context.Context, in *RenameNetworkRequest, opts ...grpc.CallOption) (*Network, error)
	// Retrieves the list of OS images which are currently approved.
	ListOSImages(ctx context.Context, in *ListOSImagesRequest, opts ...grpc.CallOption) (*ListOSImagesResponse, error)
}

type bareMetalSolutionClient struct {
	cc grpc.ClientConnInterface
}

func NewBareMetalSolutionClient(cc grpc.ClientConnInterface) BareMetalSolutionClient {
	return &bareMetalSolutionClient{cc}
}

func (c *bareMetalSolutionClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, BareMetalSolution_GetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_UpdateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RenameInstance(ctx context.Context, in *RenameInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, BareMetalSolution_RenameInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ResetInstance(ctx context.Context, in *ResetInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_ResetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) StartInstance(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_StartInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) StopInstance(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_StopInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) EnableInteractiveSerialConsole(ctx context.Context, in *EnableInteractiveSerialConsoleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_EnableInteractiveSerialConsole_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DisableInteractiveSerialConsole(ctx context.Context, in *DisableInteractiveSerialConsoleRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_DisableInteractiveSerialConsole_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DetachLun(ctx context.Context, in *DetachLunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_DetachLun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListSSHKeys(ctx context.Context, in *ListSSHKeysRequest, opts ...grpc.CallOption) (*ListSSHKeysResponse, error) {
	out := new(ListSSHKeysResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListSSHKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) CreateSSHKey(ctx context.Context, in *CreateSSHKeyRequest, opts ...grpc.CallOption) (*SSHKey, error) {
	out := new(SSHKey)
	err := c.cc.Invoke(ctx, BareMetalSolution_CreateSSHKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DeleteSSHKey(ctx context.Context, in *DeleteSSHKeyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BareMetalSolution_DeleteSSHKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListVolumes(ctx context.Context, in *ListVolumesRequest, opts ...grpc.CallOption) (*ListVolumesResponse, error) {
	out := new(ListVolumesResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListVolumes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetVolume(ctx context.Context, in *GetVolumeRequest, opts ...grpc.CallOption) (*Volume, error) {
	out := new(Volume)
	err := c.cc.Invoke(ctx, BareMetalSolution_GetVolume_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateVolume(ctx context.Context, in *UpdateVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_UpdateVolume_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RenameVolume(ctx context.Context, in *RenameVolumeRequest, opts ...grpc.CallOption) (*Volume, error) {
	out := new(Volume)
	err := c.cc.Invoke(ctx, BareMetalSolution_RenameVolume_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) EvictVolume(ctx context.Context, in *EvictVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_EvictVolume_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ResizeVolume(ctx context.Context, in *ResizeVolumeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_ResizeVolume_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListNetworks(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*ListNetworksResponse, error) {
	out := new(ListNetworksResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListNetworks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListNetworkUsage(ctx context.Context, in *ListNetworkUsageRequest, opts ...grpc.CallOption) (*ListNetworkUsageResponse, error) {
	out := new(ListNetworkUsageResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListNetworkUsage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetNetwork(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error) {
	out := new(Network)
	err := c.cc.Invoke(ctx, BareMetalSolution_GetNetwork_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateNetwork(ctx context.Context, in *UpdateNetworkRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_UpdateNetwork_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) CreateVolumeSnapshot(ctx context.Context, in *CreateVolumeSnapshotRequest, opts ...grpc.CallOption) (*VolumeSnapshot, error) {
	out := new(VolumeSnapshot)
	err := c.cc.Invoke(ctx, BareMetalSolution_CreateVolumeSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RestoreVolumeSnapshot(ctx context.Context, in *RestoreVolumeSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_RestoreVolumeSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DeleteVolumeSnapshot(ctx context.Context, in *DeleteVolumeSnapshotRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BareMetalSolution_DeleteVolumeSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetVolumeSnapshot(ctx context.Context, in *GetVolumeSnapshotRequest, opts ...grpc.CallOption) (*VolumeSnapshot, error) {
	out := new(VolumeSnapshot)
	err := c.cc.Invoke(ctx, BareMetalSolution_GetVolumeSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListVolumeSnapshots(ctx context.Context, in *ListVolumeSnapshotsRequest, opts ...grpc.CallOption) (*ListVolumeSnapshotsResponse, error) {
	out := new(ListVolumeSnapshotsResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListVolumeSnapshots_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetLun(ctx context.Context, in *GetLunRequest, opts ...grpc.CallOption) (*Lun, error) {
	out := new(Lun)
	err := c.cc.Invoke(ctx, BareMetalSolution_GetLun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListLuns(ctx context.Context, in *ListLunsRequest, opts ...grpc.CallOption) (*ListLunsResponse, error) {
	out := new(ListLunsResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListLuns_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) EvictLun(ctx context.Context, in *EvictLunRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_EvictLun_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetNfsShare(ctx context.Context, in *GetNfsShareRequest, opts ...grpc.CallOption) (*NfsShare, error) {
	out := new(NfsShare)
	err := c.cc.Invoke(ctx, BareMetalSolution_GetNfsShare_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListNfsShares(ctx context.Context, in *ListNfsSharesRequest, opts ...grpc.CallOption) (*ListNfsSharesResponse, error) {
	out := new(ListNfsSharesResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListNfsShares_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateNfsShare(ctx context.Context, in *UpdateNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_UpdateNfsShare_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) CreateNfsShare(ctx context.Context, in *CreateNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_CreateNfsShare_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RenameNfsShare(ctx context.Context, in *RenameNfsShareRequest, opts ...grpc.CallOption) (*NfsShare, error) {
	out := new(NfsShare)
	err := c.cc.Invoke(ctx, BareMetalSolution_RenameNfsShare_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) DeleteNfsShare(ctx context.Context, in *DeleteNfsShareRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, BareMetalSolution_DeleteNfsShare_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListProvisioningQuotas(ctx context.Context, in *ListProvisioningQuotasRequest, opts ...grpc.CallOption) (*ListProvisioningQuotasResponse, error) {
	out := new(ListProvisioningQuotasResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListProvisioningQuotas_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) SubmitProvisioningConfig(ctx context.Context, in *SubmitProvisioningConfigRequest, opts ...grpc.CallOption) (*SubmitProvisioningConfigResponse, error) {
	out := new(SubmitProvisioningConfigResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_SubmitProvisioningConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) GetProvisioningConfig(ctx context.Context, in *GetProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error) {
	out := new(ProvisioningConfig)
	err := c.cc.Invoke(ctx, BareMetalSolution_GetProvisioningConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) CreateProvisioningConfig(ctx context.Context, in *CreateProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error) {
	out := new(ProvisioningConfig)
	err := c.cc.Invoke(ctx, BareMetalSolution_CreateProvisioningConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) UpdateProvisioningConfig(ctx context.Context, in *UpdateProvisioningConfigRequest, opts ...grpc.CallOption) (*ProvisioningConfig, error) {
	out := new(ProvisioningConfig)
	err := c.cc.Invoke(ctx, BareMetalSolution_UpdateProvisioningConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) RenameNetwork(ctx context.Context, in *RenameNetworkRequest, opts ...grpc.CallOption) (*Network, error) {
	out := new(Network)
	err := c.cc.Invoke(ctx, BareMetalSolution_RenameNetwork_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bareMetalSolutionClient) ListOSImages(ctx context.Context, in *ListOSImagesRequest, opts ...grpc.CallOption) (*ListOSImagesResponse, error) {
	out := new(ListOSImagesResponse)
	err := c.cc.Invoke(ctx, BareMetalSolution_ListOSImages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BareMetalSolutionServer is the server API for BareMetalSolution service.
// All implementations should embed UnimplementedBareMetalSolutionServer
// for forward compatibility
type BareMetalSolutionServer interface {
	// List servers in a given project and location.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Get details about a single server.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Update details of a single server.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// RenameInstance sets a new name for an instance.
	// Use with caution, previous names become immediately invalidated.
	RenameInstance(context.Context, *RenameInstanceRequest) (*Instance, error)
	// Perform an ungraceful, hard reset on a server. Equivalent to shutting the
	// power off and then turning it back on.
	ResetInstance(context.Context, *ResetInstanceRequest) (*longrunningpb.Operation, error)
	// Starts a server that was shutdown.
	StartInstance(context.Context, *StartInstanceRequest) (*longrunningpb.Operation, error)
	// Stop a running server.
	StopInstance(context.Context, *StopInstanceRequest) (*longrunningpb.Operation, error)
	// Enable the interactive serial console feature on an instance.
	EnableInteractiveSerialConsole(context.Context, *EnableInteractiveSerialConsoleRequest) (*longrunningpb.Operation, error)
	// Disable the interactive serial console feature on an instance.
	DisableInteractiveSerialConsole(context.Context, *DisableInteractiveSerialConsoleRequest) (*longrunningpb.Operation, error)
	// Detach LUN from Instance.
	DetachLun(context.Context, *DetachLunRequest) (*longrunningpb.Operation, error)
	// Lists the public SSH keys registered for the specified project.
	// These SSH keys are used only for the interactive serial console feature.
	ListSSHKeys(context.Context, *ListSSHKeysRequest) (*ListSSHKeysResponse, error)
	// Register a public SSH key in the specified project for use with the
	// interactive serial console feature.
	CreateSSHKey(context.Context, *CreateSSHKeyRequest) (*SSHKey, error)
	// Deletes a public SSH key registered in the specified project.
	DeleteSSHKey(context.Context, *DeleteSSHKeyRequest) (*emptypb.Empty, error)
	// List storage volumes in a given project and location.
	ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error)
	// Get details of a single storage volume.
	GetVolume(context.Context, *GetVolumeRequest) (*Volume, error)
	// Update details of a single storage volume.
	UpdateVolume(context.Context, *UpdateVolumeRequest) (*longrunningpb.Operation, error)
	// RenameVolume sets a new name for a volume.
	// Use with caution, previous names become immediately invalidated.
	RenameVolume(context.Context, *RenameVolumeRequest) (*Volume, error)
	// Skips volume's cooloff and deletes it now.
	// Volume must be in cooloff state.
	EvictVolume(context.Context, *EvictVolumeRequest) (*longrunningpb.Operation, error)
	// Emergency Volume resize.
	ResizeVolume(context.Context, *ResizeVolumeRequest) (*longrunningpb.Operation, error)
	// List network in a given project and location.
	ListNetworks(context.Context, *ListNetworksRequest) (*ListNetworksResponse, error)
	// List all Networks (and used IPs for each Network) in the vendor account
	// associated with the specified project.
	ListNetworkUsage(context.Context, *ListNetworkUsageRequest) (*ListNetworkUsageResponse, error)
	// Get details of a single network.
	GetNetwork(context.Context, *GetNetworkRequest) (*Network, error)
	// Update details of a single network.
	UpdateNetwork(context.Context, *UpdateNetworkRequest) (*longrunningpb.Operation, error)
	// Takes a snapshot of a boot volume.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	CreateVolumeSnapshot(context.Context, *CreateVolumeSnapshotRequest) (*VolumeSnapshot, error)
	// Uses the specified snapshot to restore its parent volume.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	RestoreVolumeSnapshot(context.Context, *RestoreVolumeSnapshotRequest) (*longrunningpb.Operation, error)
	// Deletes a volume snapshot.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	DeleteVolumeSnapshot(context.Context, *DeleteVolumeSnapshotRequest) (*emptypb.Empty, error)
	// Returns the specified snapshot resource.
	// Returns INVALID_ARGUMENT if called for a non-boot volume.
	GetVolumeSnapshot(context.Context, *GetVolumeSnapshotRequest) (*VolumeSnapshot, error)
	// Retrieves the list of snapshots for the specified volume.
	// Returns a response with an empty list of snapshots if called
	// for a non-boot volume.
	ListVolumeSnapshots(context.Context, *ListVolumeSnapshotsRequest) (*ListVolumeSnapshotsResponse, error)
	// Get details of a single storage logical unit number(LUN).
	GetLun(context.Context, *GetLunRequest) (*Lun, error)
	// List storage volume luns for given storage volume.
	ListLuns(context.Context, *ListLunsRequest) (*ListLunsResponse, error)
	// Skips lun's cooloff and deletes it now.
	// Lun must be in cooloff state.
	EvictLun(context.Context, *EvictLunRequest) (*longrunningpb.Operation, error)
	// Get details of a single NFS share.
	GetNfsShare(context.Context, *GetNfsShareRequest) (*NfsShare, error)
	// List NFS shares.
	ListNfsShares(context.Context, *ListNfsSharesRequest) (*ListNfsSharesResponse, error)
	// Update details of a single NFS share.
	UpdateNfsShare(context.Context, *UpdateNfsShareRequest) (*longrunningpb.Operation, error)
	// Create an NFS share.
	CreateNfsShare(context.Context, *CreateNfsShareRequest) (*longrunningpb.Operation, error)
	// RenameNfsShare sets a new name for an nfsshare.
	// Use with caution, previous names become immediately invalidated.
	RenameNfsShare(context.Context, *RenameNfsShareRequest) (*NfsShare, error)
	// Delete an NFS share. The underlying volume is automatically deleted.
	DeleteNfsShare(context.Context, *DeleteNfsShareRequest) (*longrunningpb.Operation, error)
	// List the budget details to provision resources on a given project.
	ListProvisioningQuotas(context.Context, *ListProvisioningQuotasRequest) (*ListProvisioningQuotasResponse, error)
	// Submit a provisiong configuration for a given project.
	SubmitProvisioningConfig(context.Context, *SubmitProvisioningConfigRequest) (*SubmitProvisioningConfigResponse, error)
	// Get ProvisioningConfig by name.
	GetProvisioningConfig(context.Context, *GetProvisioningConfigRequest) (*ProvisioningConfig, error)
	// Create new ProvisioningConfig.
	CreateProvisioningConfig(context.Context, *CreateProvisioningConfigRequest) (*ProvisioningConfig, error)
	// Update existing ProvisioningConfig.
	UpdateProvisioningConfig(context.Context, *UpdateProvisioningConfigRequest) (*ProvisioningConfig, error)
	// RenameNetwork sets a new name for a network.
	// Use with caution, previous names become immediately invalidated.
	RenameNetwork(context.Context, *RenameNetworkRequest) (*Network, error)
	// Retrieves the list of OS images which are currently approved.
	ListOSImages(context.Context, *ListOSImagesRequest) (*ListOSImagesResponse, error)
}

// UnimplementedBareMetalSolutionServer should be embedded to have forward compatible implementations.
type UnimplementedBareMetalSolutionServer struct {
}

func (UnimplementedBareMetalSolutionServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedBareMetalSolutionServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (UnimplementedBareMetalSolutionServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (UnimplementedBareMetalSolutionServer) RenameInstance(context.Context, *RenameInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameInstance not implemented")
}
func (UnimplementedBareMetalSolutionServer) ResetInstance(context.Context, *ResetInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetInstance not implemented")
}
func (UnimplementedBareMetalSolutionServer) StartInstance(context.Context, *StartInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartInstance not implemented")
}
func (UnimplementedBareMetalSolutionServer) StopInstance(context.Context, *StopInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopInstance not implemented")
}
func (UnimplementedBareMetalSolutionServer) EnableInteractiveSerialConsole(context.Context, *EnableInteractiveSerialConsoleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableInteractiveSerialConsole not implemented")
}
func (UnimplementedBareMetalSolutionServer) DisableInteractiveSerialConsole(context.Context, *DisableInteractiveSerialConsoleRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableInteractiveSerialConsole not implemented")
}
func (UnimplementedBareMetalSolutionServer) DetachLun(context.Context, *DetachLunRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachLun not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListSSHKeys(context.Context, *ListSSHKeysRequest) (*ListSSHKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSSHKeys not implemented")
}
func (UnimplementedBareMetalSolutionServer) CreateSSHKey(context.Context, *CreateSSHKeyRequest) (*SSHKey, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSSHKey not implemented")
}
func (UnimplementedBareMetalSolutionServer) DeleteSSHKey(context.Context, *DeleteSSHKeyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSSHKey not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListVolumes(context.Context, *ListVolumesRequest) (*ListVolumesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumes not implemented")
}
func (UnimplementedBareMetalSolutionServer) GetVolume(context.Context, *GetVolumeRequest) (*Volume, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolume not implemented")
}
func (UnimplementedBareMetalSolutionServer) UpdateVolume(context.Context, *UpdateVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVolume not implemented")
}
func (UnimplementedBareMetalSolutionServer) RenameVolume(context.Context, *RenameVolumeRequest) (*Volume, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameVolume not implemented")
}
func (UnimplementedBareMetalSolutionServer) EvictVolume(context.Context, *EvictVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EvictVolume not implemented")
}
func (UnimplementedBareMetalSolutionServer) ResizeVolume(context.Context, *ResizeVolumeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResizeVolume not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListNetworks(context.Context, *ListNetworksRequest) (*ListNetworksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworks not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListNetworkUsage(context.Context, *ListNetworkUsageRequest) (*ListNetworkUsageResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworkUsage not implemented")
}
func (UnimplementedBareMetalSolutionServer) GetNetwork(context.Context, *GetNetworkRequest) (*Network, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNetwork not implemented")
}
func (UnimplementedBareMetalSolutionServer) UpdateNetwork(context.Context, *UpdateNetworkRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNetwork not implemented")
}
func (UnimplementedBareMetalSolutionServer) CreateVolumeSnapshot(context.Context, *CreateVolumeSnapshotRequest) (*VolumeSnapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVolumeSnapshot not implemented")
}
func (UnimplementedBareMetalSolutionServer) RestoreVolumeSnapshot(context.Context, *RestoreVolumeSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreVolumeSnapshot not implemented")
}
func (UnimplementedBareMetalSolutionServer) DeleteVolumeSnapshot(context.Context, *DeleteVolumeSnapshotRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVolumeSnapshot not implemented")
}
func (UnimplementedBareMetalSolutionServer) GetVolumeSnapshot(context.Context, *GetVolumeSnapshotRequest) (*VolumeSnapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVolumeSnapshot not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListVolumeSnapshots(context.Context, *ListVolumeSnapshotsRequest) (*ListVolumeSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVolumeSnapshots not implemented")
}
func (UnimplementedBareMetalSolutionServer) GetLun(context.Context, *GetLunRequest) (*Lun, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLun not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListLuns(context.Context, *ListLunsRequest) (*ListLunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListLuns not implemented")
}
func (UnimplementedBareMetalSolutionServer) EvictLun(context.Context, *EvictLunRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EvictLun not implemented")
}
func (UnimplementedBareMetalSolutionServer) GetNfsShare(context.Context, *GetNfsShareRequest) (*NfsShare, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNfsShare not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListNfsShares(context.Context, *ListNfsSharesRequest) (*ListNfsSharesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNfsShares not implemented")
}
func (UnimplementedBareMetalSolutionServer) UpdateNfsShare(context.Context, *UpdateNfsShareRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNfsShare not implemented")
}
func (UnimplementedBareMetalSolutionServer) CreateNfsShare(context.Context, *CreateNfsShareRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNfsShare not implemented")
}
func (UnimplementedBareMetalSolutionServer) RenameNfsShare(context.Context, *RenameNfsShareRequest) (*NfsShare, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameNfsShare not implemented")
}
func (UnimplementedBareMetalSolutionServer) DeleteNfsShare(context.Context, *DeleteNfsShareRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNfsShare not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListProvisioningQuotas(context.Context, *ListProvisioningQuotasRequest) (*ListProvisioningQuotasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProvisioningQuotas not implemented")
}
func (UnimplementedBareMetalSolutionServer) SubmitProvisioningConfig(context.Context, *SubmitProvisioningConfigRequest) (*SubmitProvisioningConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitProvisioningConfig not implemented")
}
func (UnimplementedBareMetalSolutionServer) GetProvisioningConfig(context.Context, *GetProvisioningConfigRequest) (*ProvisioningConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProvisioningConfig not implemented")
}
func (UnimplementedBareMetalSolutionServer) CreateProvisioningConfig(context.Context, *CreateProvisioningConfigRequest) (*ProvisioningConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateProvisioningConfig not implemented")
}
func (UnimplementedBareMetalSolutionServer) UpdateProvisioningConfig(context.Context, *UpdateProvisioningConfigRequest) (*ProvisioningConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProvisioningConfig not implemented")
}
func (UnimplementedBareMetalSolutionServer) RenameNetwork(context.Context, *RenameNetworkRequest) (*Network, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RenameNetwork not implemented")
}
func (UnimplementedBareMetalSolutionServer) ListOSImages(context.Context, *ListOSImagesRequest) (*ListOSImagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOSImages not implemented")
}

// UnsafeBareMetalSolutionServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BareMetalSolutionServer will
// result in compilation errors.
type UnsafeBareMetalSolutionServer interface {
	mustEmbedUnimplementedBareMetalSolutionServer()
}

func RegisterBareMetalSolutionServer(s grpc.ServiceRegistrar, srv BareMetalSolutionServer) {
	s.RegisterService(&BareMetalSolution_ServiceDesc, srv)
}

func _BareMetalSolution_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_GetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_UpdateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RenameInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RenameInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_RenameInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RenameInstance(ctx, req.(*RenameInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ResetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ResetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ResetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ResetInstance(ctx, req.(*ResetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_StartInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).StartInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_StartInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).StartInstance(ctx, req.(*StartInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_StopInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).StopInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_StopInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).StopInstance(ctx, req.(*StopInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_EnableInteractiveSerialConsole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableInteractiveSerialConsoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).EnableInteractiveSerialConsole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_EnableInteractiveSerialConsole_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).EnableInteractiveSerialConsole(ctx, req.(*EnableInteractiveSerialConsoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DisableInteractiveSerialConsole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableInteractiveSerialConsoleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DisableInteractiveSerialConsole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_DisableInteractiveSerialConsole_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DisableInteractiveSerialConsole(ctx, req.(*DisableInteractiveSerialConsoleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DetachLun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachLunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DetachLun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_DetachLun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DetachLun(ctx, req.(*DetachLunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListSSHKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSSHKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListSSHKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListSSHKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListSSHKeys(ctx, req.(*ListSSHKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_CreateSSHKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSSHKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).CreateSSHKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_CreateSSHKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).CreateSSHKey(ctx, req.(*CreateSSHKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DeleteSSHKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSSHKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DeleteSSHKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_DeleteSSHKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DeleteSSHKey(ctx, req.(*DeleteSSHKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListVolumes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListVolumes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListVolumes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListVolumes(ctx, req.(*ListVolumesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_GetVolume_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetVolume(ctx, req.(*GetVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_UpdateVolume_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateVolume(ctx, req.(*UpdateVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RenameVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RenameVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_RenameVolume_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RenameVolume(ctx, req.(*RenameVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_EvictVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvictVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).EvictVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_EvictVolume_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).EvictVolume(ctx, req.(*EvictVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ResizeVolume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResizeVolumeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ResizeVolume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ResizeVolume_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ResizeVolume(ctx, req.(*ResizeVolumeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListNetworks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListNetworks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListNetworks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListNetworks(ctx, req.(*ListNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListNetworkUsage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkUsageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListNetworkUsage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListNetworkUsage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListNetworkUsage(ctx, req.(*ListNetworkUsageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_GetNetwork_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetNetwork(ctx, req.(*GetNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_UpdateNetwork_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateNetwork(ctx, req.(*UpdateNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_CreateVolumeSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVolumeSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).CreateVolumeSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_CreateVolumeSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).CreateVolumeSnapshot(ctx, req.(*CreateVolumeSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RestoreVolumeSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreVolumeSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RestoreVolumeSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_RestoreVolumeSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RestoreVolumeSnapshot(ctx, req.(*RestoreVolumeSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DeleteVolumeSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVolumeSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DeleteVolumeSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_DeleteVolumeSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DeleteVolumeSnapshot(ctx, req.(*DeleteVolumeSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetVolumeSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVolumeSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetVolumeSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_GetVolumeSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetVolumeSnapshot(ctx, req.(*GetVolumeSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListVolumeSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVolumeSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListVolumeSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListVolumeSnapshots_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListVolumeSnapshots(ctx, req.(*ListVolumeSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetLun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetLun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_GetLun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetLun(ctx, req.(*GetLunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListLuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListLuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListLuns_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListLuns(ctx, req.(*ListLunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_EvictLun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvictLunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).EvictLun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_EvictLun_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).EvictLun(ctx, req.(*EvictLunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_GetNfsShare_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetNfsShare(ctx, req.(*GetNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListNfsShares_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNfsSharesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListNfsShares(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListNfsShares_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListNfsShares(ctx, req.(*ListNfsSharesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_UpdateNfsShare_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateNfsShare(ctx, req.(*UpdateNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_CreateNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).CreateNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_CreateNfsShare_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).CreateNfsShare(ctx, req.(*CreateNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RenameNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RenameNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_RenameNfsShare_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RenameNfsShare(ctx, req.(*RenameNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_DeleteNfsShare_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNfsShareRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).DeleteNfsShare(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_DeleteNfsShare_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).DeleteNfsShare(ctx, req.(*DeleteNfsShareRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListProvisioningQuotas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProvisioningQuotasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListProvisioningQuotas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListProvisioningQuotas_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListProvisioningQuotas(ctx, req.(*ListProvisioningQuotasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_SubmitProvisioningConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitProvisioningConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).SubmitProvisioningConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_SubmitProvisioningConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).SubmitProvisioningConfig(ctx, req.(*SubmitProvisioningConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_GetProvisioningConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProvisioningConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).GetProvisioningConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_GetProvisioningConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).GetProvisioningConfig(ctx, req.(*GetProvisioningConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_CreateProvisioningConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateProvisioningConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).CreateProvisioningConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_CreateProvisioningConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).CreateProvisioningConfig(ctx, req.(*CreateProvisioningConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_UpdateProvisioningConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProvisioningConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).UpdateProvisioningConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_UpdateProvisioningConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).UpdateProvisioningConfig(ctx, req.(*UpdateProvisioningConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_RenameNetwork_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RenameNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).RenameNetwork(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_RenameNetwork_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).RenameNetwork(ctx, req.(*RenameNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BareMetalSolution_ListOSImages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOSImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BareMetalSolutionServer).ListOSImages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BareMetalSolution_ListOSImages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BareMetalSolutionServer).ListOSImages(ctx, req.(*ListOSImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BareMetalSolution_ServiceDesc is the grpc.ServiceDesc for BareMetalSolution service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BareMetalSolution_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.baremetalsolution.v2.BareMetalSolution",
	HandlerType: (*BareMetalSolutionServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _BareMetalSolution_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _BareMetalSolution_GetInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _BareMetalSolution_UpdateInstance_Handler,
		},
		{
			MethodName: "RenameInstance",
			Handler:    _BareMetalSolution_RenameInstance_Handler,
		},
		{
			MethodName: "ResetInstance",
			Handler:    _BareMetalSolution_ResetInstance_Handler,
		},
		{
			MethodName: "StartInstance",
			Handler:    _BareMetalSolution_StartInstance_Handler,
		},
		{
			MethodName: "StopInstance",
			Handler:    _BareMetalSolution_StopInstance_Handler,
		},
		{
			MethodName: "EnableInteractiveSerialConsole",
			Handler:    _BareMetalSolution_EnableInteractiveSerialConsole_Handler,
		},
		{
			MethodName: "DisableInteractiveSerialConsole",
			Handler:    _BareMetalSolution_DisableInteractiveSerialConsole_Handler,
		},
		{
			MethodName: "DetachLun",
			Handler:    _BareMetalSolution_DetachLun_Handler,
		},
		{
			MethodName: "ListSSHKeys",
			Handler:    _BareMetalSolution_ListSSHKeys_Handler,
		},
		{
			MethodName: "CreateSSHKey",
			Handler:    _BareMetalSolution_CreateSSHKey_Handler,
		},
		{
			MethodName: "DeleteSSHKey",
			Handler:    _BareMetalSolution_DeleteSSHKey_Handler,
		},
		{
			MethodName: "ListVolumes",
			Handler:    _BareMetalSolution_ListVolumes_Handler,
		},
		{
			MethodName: "GetVolume",
			Handler:    _BareMetalSolution_GetVolume_Handler,
		},
		{
			MethodName: "UpdateVolume",
			Handler:    _BareMetalSolution_UpdateVolume_Handler,
		},
		{
			MethodName: "RenameVolume",
			Handler:    _BareMetalSolution_RenameVolume_Handler,
		},
		{
			MethodName: "EvictVolume",
			Handler:    _BareMetalSolution_EvictVolume_Handler,
		},
		{
			MethodName: "ResizeVolume",
			Handler:    _BareMetalSolution_ResizeVolume_Handler,
		},
		{
			MethodName: "ListNetworks",
			Handler:    _BareMetalSolution_ListNetworks_Handler,
		},
		{
			MethodName: "ListNetworkUsage",
			Handler:    _BareMetalSolution_ListNetworkUsage_Handler,
		},
		{
			MethodName: "GetNetwork",
			Handler:    _BareMetalSolution_GetNetwork_Handler,
		},
		{
			MethodName: "UpdateNetwork",
			Handler:    _BareMetalSolution_UpdateNetwork_Handler,
		},
		{
			MethodName: "CreateVolumeSnapshot",
			Handler:    _BareMetalSolution_CreateVolumeSnapshot_Handler,
		},
		{
			MethodName: "RestoreVolumeSnapshot",
			Handler:    _BareMetalSolution_RestoreVolumeSnapshot_Handler,
		},
		{
			MethodName: "DeleteVolumeSnapshot",
			Handler:    _BareMetalSolution_DeleteVolumeSnapshot_Handler,
		},
		{
			MethodName: "GetVolumeSnapshot",
			Handler:    _BareMetalSolution_GetVolumeSnapshot_Handler,
		},
		{
			MethodName: "ListVolumeSnapshots",
			Handler:    _BareMetalSolution_ListVolumeSnapshots_Handler,
		},
		{
			MethodName: "GetLun",
			Handler:    _BareMetalSolution_GetLun_Handler,
		},
		{
			MethodName: "ListLuns",
			Handler:    _BareMetalSolution_ListLuns_Handler,
		},
		{
			MethodName: "EvictLun",
			Handler:    _BareMetalSolution_EvictLun_Handler,
		},
		{
			MethodName: "GetNfsShare",
			Handler:    _BareMetalSolution_GetNfsShare_Handler,
		},
		{
			MethodName: "ListNfsShares",
			Handler:    _BareMetalSolution_ListNfsShares_Handler,
		},
		{
			MethodName: "UpdateNfsShare",
			Handler:    _BareMetalSolution_UpdateNfsShare_Handler,
		},
		{
			MethodName: "CreateNfsShare",
			Handler:    _BareMetalSolution_CreateNfsShare_Handler,
		},
		{
			MethodName: "RenameNfsShare",
			Handler:    _BareMetalSolution_RenameNfsShare_Handler,
		},
		{
			MethodName: "DeleteNfsShare",
			Handler:    _BareMetalSolution_DeleteNfsShare_Handler,
		},
		{
			MethodName: "ListProvisioningQuotas",
			Handler:    _BareMetalSolution_ListProvisioningQuotas_Handler,
		},
		{
			MethodName: "SubmitProvisioningConfig",
			Handler:    _BareMetalSolution_SubmitProvisioningConfig_Handler,
		},
		{
			MethodName: "GetProvisioningConfig",
			Handler:    _BareMetalSolution_GetProvisioningConfig_Handler,
		},
		{
			MethodName: "CreateProvisioningConfig",
			Handler:    _BareMetalSolution_CreateProvisioningConfig_Handler,
		},
		{
			MethodName: "UpdateProvisioningConfig",
			Handler:    _BareMetalSolution_UpdateProvisioningConfig_Handler,
		},
		{
			MethodName: "RenameNetwork",
			Handler:    _BareMetalSolution_RenameNetwork_Handler,
		},
		{
			MethodName: "ListOSImages",
			Handler:    _BareMetalSolution_ListOSImages_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/baremetalsolution/v2/baremetalsolution.proto",
}
