// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package plogotlp

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlpcollectorlogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
)

func TestExportPartialSuccess_MoveTo(t *testing.T) {
	ms := generateTestExportPartialSuccess()
	dest := NewExportPartialSuccess()
	ms.MoveTo(dest)
	assert.Equal(t, NewExportPartialSuccess(), ms)
	assert.Equal(t, generateTestExportPartialSuccess(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestExportPartialSuccess(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newExportPartialSuccess(internal.NewOrigExportLogsPartialSuccess(), sharedState)) })
	assert.Panics(t, func() { newExportPartialSuccess(internal.NewOrigExportLogsPartialSuccess(), sharedState).MoveTo(dest) })
}

func TestExportPartialSuccess_CopyTo(t *testing.T) {
	ms := NewExportPartialSuccess()
	orig := NewExportPartialSuccess()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestExportPartialSuccess()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newExportPartialSuccess(internal.NewOrigExportLogsPartialSuccess(), sharedState)) })
}

func TestExportPartialSuccess_RejectedLogRecords(t *testing.T) {
	ms := NewExportPartialSuccess()
	assert.Equal(t, int64(0), ms.RejectedLogRecords())
	ms.SetRejectedLogRecords(int64(13))
	assert.Equal(t, int64(13), ms.RejectedLogRecords())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newExportPartialSuccess(&otlpcollectorlogs.ExportLogsPartialSuccess{}, sharedState).SetRejectedLogRecords(int64(13))
	})
}

func TestExportPartialSuccess_ErrorMessage(t *testing.T) {
	ms := NewExportPartialSuccess()
	assert.Empty(t, ms.ErrorMessage())
	ms.SetErrorMessage("test_errormessage")
	assert.Equal(t, "test_errormessage", ms.ErrorMessage())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() {
		newExportPartialSuccess(&otlpcollectorlogs.ExportLogsPartialSuccess{}, sharedState).SetErrorMessage("test_errormessage")
	})
}

func generateTestExportPartialSuccess() ExportPartialSuccess {
	ms := newExportPartialSuccess(internal.GenTestOrigExportLogsPartialSuccess(), internal.NewState())
	return ms
}
