---
name: Implementation Proposal
about: Propose how you plan to implement a feature or fix before starting work
title: 'IP: '
labels: ''
assignees: ''

---

If you have already started working on this, use `WIP` (Work In Progress) instead of `IP` (Implementation Proposal).

Feel free to change, adapt, or remove any of the following sections as it makes sense to you.

Nothing you write here is set in stone. The purpose of this issue is to help maintainers provide insights to aid contributors. 

Discussion can be moved once you have a PR to iterate on specific implementation details.

**What are you planning to implement?**

Provide a clear and concise description of the feature or fix you want to implement.

Include any relevant context, such as links to issues or discussions related to this change.

**Proposed Approach**

Briefly describe your planned feature approach:

- How will this feature work? For example, describe how the user would interact with jjui using this new feature.

- How will this integrate with or impact existing features?

**Implementation Details**

Does it help to have a checklist to track implementation progress?
- [ ] Step 1: Description
- [ ] Step 2: Description  
- [ ] Step 3: Description

**Testing Strategy**
How do you plan to test this implementation?
- Unit tests needed
- Integration tests
- Manual testing approach

**Alternatives Considered**
What other implementation approaches have you considered? Why did you choose this particular approach?

**Breaking Changes**
Would this implementation introduce any breaking changes? If so, describe them and any migration strategy.

**Questions for Discussion**
What specific aspects of this implementation would you like feedback on?

Are there any areas where you're unsure about the approach?

Do you need any kind of direction or help regarding how or where to find code related to this change?

**Additional Context**
Add any other context, mockups, or references that would help reviewers understand your proposal.

Lastly, be sure to read CONTRIBUTING.md at least once.

Thank you for helping improve jjui.