/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheFactory;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.engine.match.KeyMatcherPatternImpl;
import org.apache.commons.jcs3.engine.match.behavior.IKeyMatcher;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.OptionConverter;
import org.apache.commons.jcs3.utils.config.PropertySetter;

public class CompositeCacheConfigurator {
    private static final Log log = LogManager.getLog(CompositeCacheConfigurator.class);
    protected static final String SYSTEM_PROPERTY_KEY_PREFIX = "jcs";
    protected static final String REGION_PREFIX = "jcs.region.";
    protected static final String SYSTEM_REGION_PREFIX = "jcs.system.";
    protected static final String AUXILIARY_PREFIX = "jcs.auxiliary.";
    protected static final String ATTRIBUTE_PREFIX = ".attributes";
    protected static final String CACHE_ATTRIBUTE_PREFIX = ".cacheattributes";
    protected static final String ELEMENT_ATTRIBUTE_PREFIX = ".elementattributes";
    public static final String KEY_MATCHER_PREFIX = ".keymatcher";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSystemRegions(Properties props, CompositeCacheManager ccm) {
        for (String key : props.stringPropertyNames()) {
            CompositeCache cache;
            if (!key.startsWith(SYSTEM_REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(SYSTEM_REGION_PREFIX.length());
            String auxiliaries = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, ccm, regionName, auxiliaries, null, SYSTEM_REGION_PREFIX);
            }
            ccm.addCache(regionName, cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRegions(Properties props, CompositeCacheManager ccm) {
        ArrayList<String> regionNames = new ArrayList<String>();
        for (String key : props.stringPropertyNames()) {
            CompositeCache cache;
            if (!key.startsWith(REGION_PREFIX) || key.indexOf("attributes") != -1) continue;
            String regionName = key.substring(REGION_PREFIX.length());
            regionNames.add(regionName);
            String auxiliaries = OptionConverter.findAndSubst(key, props);
            String string = regionName;
            synchronized (string) {
                cache = this.parseRegion(props, ccm, regionName, auxiliaries);
            }
            ccm.addCache(regionName, cache);
        }
        log.info("Parsed regions {0}", regionNames);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, CompositeCacheManager ccm, String regName, String auxiliaries) {
        return this.parseRegion(props, ccm, regName, auxiliaries, null, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, CompositeCacheManager ccm, String regName, String auxiliaries, ICompositeCacheAttributes cca) {
        return this.parseRegion(props, ccm, regName, auxiliaries, cca, REGION_PREFIX);
    }

    protected <K, V> CompositeCache<K, V> parseRegion(Properties props, CompositeCacheManager ccm, String regName, String auxiliaries, ICompositeCacheAttributes cca, String regionPrefix) {
        IElementAttributes ea = this.parseElementAttributes(props, regName, ccm.getDefaultElementAttributes(), regionPrefix);
        ICompositeCacheAttributes instantiationCca = cca == null ? this.parseCompositeCacheAttributes(props, regName, ccm.getDefaultCacheAttributes(), regionPrefix) : cca;
        CompositeCache cache = this.newCache(instantiationCca, ea);
        cache.setCompositeCacheManager(ccm);
        cache.setScheduledExecutorService(ccm.getScheduledExecutorService());
        cache.setElementEventQueue(ccm.getElementEventQueue());
        if (auxiliaries != null) {
            ArrayList auxList = new ArrayList();
            log.debug("Parsing region name \"{0}\", value \"{1}\"", regName, auxiliaries);
            String[] auxNames = auxiliaries.split("\\s*,\\s*");
            if (auxNames.length == 0) {
                return null;
            }
            for (String auxName : auxNames) {
                if (auxName.isEmpty()) {
                    log.warn("Skipping empty auxiliary name");
                    continue;
                }
                log.debug("Parsing auxiliary named \"{0}\".", auxName);
                AuxiliaryCache<K, V> auxCache = this.parseAuxiliary(props, ccm, auxName, regName);
                if (auxCache == null) continue;
                if (auxCache instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxCache)).setScheduledExecutorService(ccm.getScheduledExecutorService());
                }
                auxList.add(auxCache);
            }
            cache.setAuxCaches(auxList);
        }
        return cache;
    }

    protected <K, V> CompositeCache<K, V> newCache(ICompositeCacheAttributes cca, IElementAttributes ea) {
        return new CompositeCache(cca, ea);
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName, ICompositeCacheAttributes defaultCCAttr) {
        return this.parseCompositeCacheAttributes(props, regName, defaultCCAttr, REGION_PREFIX);
    }

    protected ICompositeCacheAttributes parseCompositeCacheAttributes(Properties props, String regName, ICompositeCacheAttributes defaultCCAttr, String regionPrefix) {
        String attrName = regionPrefix + regName + CACHE_ATTRIBUTE_PREFIX;
        ICompositeCacheAttributes ccAttr = OptionConverter.instantiateByKey(props, attrName, null);
        if (ccAttr == null) {
            log.info("No special CompositeCacheAttributes class defined for key [{0}], using default class.", attrName);
            ccAttr = defaultCCAttr;
        }
        log.debug("Parsing options for \"{0}\"", attrName);
        PropertySetter.setProperties(ccAttr, props, attrName + ".");
        ccAttr.setCacheName(regName);
        log.debug("End of parsing for \"{0}\"", attrName);
        ccAttr.setCacheName(regName);
        return ccAttr;
    }

    protected IElementAttributes parseElementAttributes(Properties props, String regName, IElementAttributes defaultEAttr, String regionPrefix) {
        String attrName = regionPrefix + regName + ELEMENT_ATTRIBUTE_PREFIX;
        IElementAttributes eAttr = OptionConverter.instantiateByKey(props, attrName, null);
        if (eAttr == null) {
            log.info("No special ElementAttribute class defined for key [{0}], using default class.", attrName);
            eAttr = defaultEAttr;
        }
        log.debug("Parsing options for \"{0}\"", attrName);
        PropertySetter.setProperties(eAttr, props, attrName + ".");
        log.debug("End of parsing for \"{0}\"", attrName);
        return eAttr;
    }

    protected <K, V> AuxiliaryCache<K, V> parseAuxiliary(Properties props, CompositeCacheManager ccm, String auxName, String regName) {
        log.debug("parseAuxiliary {0}", auxName);
        AuxiliaryCache auxCache = ccm.getAuxiliaryCache(auxName, regName);
        if (auxCache == null) {
            AuxiliaryCacheFactory auxFac = ccm.registryFacGet(auxName);
            if (auxFac == null) {
                String prefix = AUXILIARY_PREFIX + auxName;
                auxFac = OptionConverter.instantiateByKey(props, prefix, null);
                if (auxFac == null) {
                    log.error("Could not instantiate auxFactory named \"{0}\"", auxName);
                    return null;
                }
                auxFac.setName(auxName);
                if (auxFac instanceof IRequireScheduler) {
                    ((IRequireScheduler)((Object)auxFac)).setScheduledExecutorService(ccm.getScheduledExecutorService());
                }
                auxFac.initialize();
                ccm.registryFacPut(auxFac);
            }
            AuxiliaryCacheAttributes auxAttr = ccm.registryAttrGet(auxName);
            String attrName = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
            if (auxAttr == null) {
                String prefix = AUXILIARY_PREFIX + auxName + ATTRIBUTE_PREFIX;
                auxAttr = OptionConverter.instantiateByKey(props, prefix, null);
                if (auxAttr == null) {
                    log.error("Could not instantiate auxAttr named \"{0}\"", attrName);
                    return null;
                }
                auxAttr.setName(auxName);
                ccm.registryAttrPut(auxAttr);
            }
            auxAttr = auxAttr.clone();
            log.debug("Parsing options for \"{0}\"", attrName);
            PropertySetter.setProperties(auxAttr, props, attrName + ".");
            auxAttr.setCacheName(regName);
            log.debug("End of parsing for \"{0}\"", attrName);
            auxAttr.setCacheName(regName);
            String auxPrefix = AUXILIARY_PREFIX + auxName;
            ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, auxPrefix);
            IElementSerializer elementSerializer = AuxiliaryCacheConfigurator.parseElementSerializer(props, auxPrefix);
            try {
                auxCache = auxFac.createCache(auxAttr, ccm, cacheEventLogger, elementSerializer);
            }
            catch (Exception e) {
                log.error("Could not instantiate auxiliary cache named \"{0}\"", regName, e);
                return null;
            }
            ccm.addAuxiliaryCache(auxName, regName, auxCache);
        }
        return auxCache;
    }

    protected static void overrideWithSystemProperties(Properties props) {
        Properties sysProps = System.getProperties();
        for (String key : sysProps.stringPropertyNames()) {
            if (!key.startsWith(SYSTEM_PROPERTY_KEY_PREFIX)) continue;
            log.info("Using system property [[{0}] [{1}]]", () -> key, () -> sysProps.getProperty(key));
            props.setProperty(key, sysProps.getProperty(key));
        }
    }

    protected <K> IKeyMatcher<K> parseKeyMatcher(Properties props, String auxPrefix) {
        String keyMatcherClassName = auxPrefix + KEY_MATCHER_PREFIX;
        KeyMatcherPatternImpl keyMatcher = OptionConverter.instantiateByKey(props, keyMatcherClassName, null);
        if (keyMatcher != null) {
            String attributePrefix = auxPrefix + KEY_MATCHER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(keyMatcher, props, attributePrefix + ".");
            log.info("Using custom key matcher [{0}] for auxiliary [{1}]", keyMatcher, auxPrefix);
        } else {
            keyMatcher = new KeyMatcherPatternImpl();
            log.info("Using standard key matcher [{0}] for auxiliary [{1}]", keyMatcher, auxPrefix);
        }
        return keyMatcher;
    }
}

