/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmServerHistoryReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class HistoryLoadTask
extends PleaseWaitRunnable {
    private boolean canceled;
    private Exception lastException;
    private final Set<PrimitiveId> toLoad = new LinkedHashSet<PrimitiveId>();
    private HistoryDataSet loadedData;
    private OsmServerHistoryReader reader;
    private boolean getChangesetData = true;
    private boolean collectMissing;
    private final Set<PrimitiveId> missingPrimitives = new LinkedHashSet<PrimitiveId>();

    public HistoryLoadTask() {
        super(I18n.tr("Load history", new Object[0]), true);
    }

    public HistoryLoadTask(Component parent) {
        super(Objects.requireNonNull(parent, "parent"), I18n.tr("Load history", new Object[0]), true);
    }

    public HistoryLoadTask add(PrimitiveId pid) {
        CheckParameterUtil.ensureThat(pid.getUniqueId() > 0L, "id > 0");
        this.toLoad.add(pid);
        return this;
    }

    public HistoryLoadTask add(HistoryOsmPrimitive primitive) {
        return this.add(primitive.getPrimitiveId());
    }

    public HistoryLoadTask add(History history) {
        return this.add(history.getPrimitiveId());
    }

    public HistoryLoadTask add(OsmPrimitive primitive) {
        CheckParameterUtil.ensureThat(primitive.getOsmId() > 0L, "id > 0");
        return this.add(primitive.getOsmPrimitiveId());
    }

    public HistoryLoadTask addPrimitiveIds(Collection<? extends PrimitiveId> primitives) {
        primitives.forEach(this::add);
        return this;
    }

    public HistoryLoadTask addOsmPrimitives(Collection<? extends OsmPrimitive> primitives) {
        primitives.forEach(this::add);
        return this;
    }

    @Override
    protected void cancel() {
        if (this.reader != null) {
            this.reader.cancel();
        }
        this.canceled = true;
    }

    @Override
    protected void finish() {
        if (this.isCanceled()) {
            return;
        }
        if (this.lastException != null) {
            ExceptionDialogUtil.explainException(this.lastException);
            return;
        }
        HistoryDataSet.getInstance().mergeInto(this.loadedData);
    }

    @Override
    protected void realRun() throws SAXException, IOException, OsmTransferException {
        this.loadedData = new HistoryDataSet();
        int ticks = this.toLoad.size();
        if (this.getChangesetData) {
            ticks *= 2;
        }
        try {
            this.progressMonitor.setTicksCount(ticks);
            for (PrimitiveId pid : this.toLoad) {
                if (!this.canceled) {
                    this.loadHistory(pid);
                    continue;
                }
                break;
            }
        }
        catch (OsmTransferException e) {
            this.lastException = e;
        }
    }

    private void loadHistory(PrimitiveId pid) throws OsmTransferException {
        String msg = HistoryLoadTask.getLoadingMessage(pid);
        this.progressMonitor.indeterminateSubTask(I18n.tr(msg, Long.toString(pid.getUniqueId())));
        this.reader = null;
        HistoryDataSet ds = null;
        try {
            this.reader = new OsmServerHistoryReader(pid.getType(), pid.getUniqueId());
            ds = this.getChangesetData ? HistoryLoadTask.loadHistory(this.reader, this.progressMonitor) : this.reader.parseHistory(this.progressMonitor.createSubTaskMonitor(1, false));
        }
        catch (OsmApiException e) {
            if (this.canceled) {
                return;
            }
            if (e.getResponseCode() == 404 && this.collectMissing) {
                this.missingPrimitives.add(pid);
            }
            throw e;
        }
        catch (OsmTransferException e) {
            if (this.canceled) {
                return;
            }
            throw e;
        }
        if (ds != null) {
            this.loadedData.mergeInto(ds);
        }
    }

    protected static HistoryDataSet loadHistory(OsmServerHistoryReader reader, ProgressMonitor progressMonitor) throws OsmTransferException {
        HistoryDataSet ds = reader.parseHistory(progressMonitor.createSubTaskMonitor(1, false));
        if (ds != null) {
            OsmServerChangesetReader changesetReader = new OsmServerChangesetReader();
            ArrayList<Long> changesetIds = new ArrayList<Long>(ds.getChangesetIds());
            Iterator iter = changesetIds.iterator();
            while (iter.hasNext()) {
                long id = (Long)iter.next();
                Changeset cs = ChangesetCache.getInstance().get((int)id);
                if (cs == null || cs.isOpen()) continue;
                ds.putChangeset(cs);
                iter.remove();
            }
            int n = 100;
            for (int i = 0; i < changesetIds.size(); i += n) {
                ArrayList<Changeset> downloadedCS = new ArrayList<Changeset>(changesetIds.size());
                for (Changeset c : changesetReader.queryChangesets(new ChangesetQuery().forChangesetIds(changesetIds.subList(i, Math.min(i + n, changesetIds.size()))), progressMonitor.createSubTaskMonitor(1, false))) {
                    ds.putChangeset(c);
                    downloadedCS.add(c);
                }
                ChangesetCache.getInstance().update(downloadedCS);
            }
        }
        return ds;
    }

    protected static String getLoadingMessage(PrimitiveId pid) {
        switch (pid.getType()) {
            case NODE: {
                return I18n.marktr("Loading history for node {0}");
            }
            case WAY: {
                return I18n.marktr("Loading history for way {0}");
            }
            case RELATION: {
                return I18n.marktr("Loading history for relation {0}");
            }
        }
        return "";
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void setChangesetDataNeeded(boolean b) {
        this.getChangesetData = b;
    }

    public void setCollectMissing(boolean b) {
        this.collectMissing = b;
    }

    public Set<PrimitiveId> getMissingPrimitives() {
        return this.missingPrimitives;
    }
}

