/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Adjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import org.openstreetmap.josm.gui.util.ChangeNotifier;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class AdjustmentSynchronizer
implements AdjustmentListener {
    private final Set<Adjustable> synchronizedAdjustables = new HashSet<Adjustable>();
    private final Map<Adjustable, Boolean> enabledMap = new HashMap<Adjustable, Boolean>();
    private final ChangeNotifier observable = new ChangeNotifier();

    public void participateInSynchronizedScrolling(Adjustable adjustable) {
        if (adjustable == null) {
            return;
        }
        if (this.synchronizedAdjustables.contains(adjustable)) {
            return;
        }
        this.synchronizedAdjustables.add(adjustable);
        this.setParticipatingInSynchronizedScrolling(adjustable, true);
        adjustable.addAdjustmentListener(this);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (Boolean.FALSE.equals(this.enabledMap.get(e.getAdjustable()))) {
            return;
        }
        for (Adjustable a : this.synchronizedAdjustables) {
            if (a == e.getAdjustable() || !this.isParticipatingInSynchronizedScrolling(a)) continue;
            a.setValue(e.getValue());
        }
    }

    protected void setParticipatingInSynchronizedScrolling(Adjustable adjustable, boolean isParticipating) {
        CheckParameterUtil.ensureParameterNotNull(adjustable, "adjustable");
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            throw new IllegalStateException(I18n.tr("Adjustable {0} not registered yet. Cannot set participation in synchronized adjustment.", adjustable));
        }
        this.enabledMap.put(adjustable, isParticipating);
        this.observable.fireStateChanged();
    }

    protected boolean isParticipatingInSynchronizedScrolling(Adjustable adjustable) {
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            throw new IllegalStateException(I18n.tr("Adjustable {0} not registered yet.", adjustable));
        }
        return this.enabledMap.get(adjustable);
    }

    public void adapt(JCheckBox view, Adjustable adjustable) {
        CheckParameterUtil.ensureParameterNotNull(adjustable, "adjustable");
        CheckParameterUtil.ensureParameterNotNull(view, "view");
        if (!this.synchronizedAdjustables.contains(adjustable)) {
            this.participateInSynchronizedScrolling(adjustable);
        }
        view.addItemListener(e -> {
            switch (e.getStateChange()) {
                case 1: {
                    if (this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                    this.setParticipatingInSynchronizedScrolling(adjustable, true);
                    break;
                }
                case 2: {
                    if (!this.isParticipatingInSynchronizedScrolling(adjustable)) break;
                    this.setParticipatingInSynchronizedScrolling(adjustable, false);
                    break;
                }
            }
        });
        this.observable.addChangeListener(e -> {
            boolean sync = this.isParticipatingInSynchronizedScrolling(adjustable);
            if (view.isSelected() != sync) {
                view.setSelected(sync);
            }
        });
        this.setParticipatingInSynchronizedScrolling(adjustable, true);
        view.setSelected(true);
    }
}

