/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.hints;

import java.util.Objects;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.html.custom.conf.Configuration;
import org.netbeans.modules.html.custom.hints.Bundle;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public final class EditProjectsConfFix
implements HintFix {
    private final Snapshot snapshot;

    public EditProjectsConfFix(Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public String getDescription() {
        return Bundle.editProjectConfiguration();
    }

    public void implement() throws Exception {
        Configuration conf = Configuration.get(this.snapshot.getSource().getFileObject());
        FileObject projectsConfigurationFile = conf.getProjectsConfigurationFile();
        if (projectsConfigurationFile != null) {
            DataObject dobj = DataObject.find((FileObject)projectsConfigurationFile);
            OpenCookie oc = (OpenCookie)dobj.getLookup().lookup(OpenCookie.class);
            oc.open();
        }
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.snapshot);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EditProjectsConfFix other = (EditProjectsConfFix)obj;
        return Objects.equals(this.snapshot, other.snapshot);
    }
}

