/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.java.queries.MultipleRootsUnitTestForSourceQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class GradleTestForSourceImpl
implements MultipleRootsUnitTestForSourceQueryImplementation {
    private static final GradleJavaSourceSet.SourceType[] MAIN_SOURCES = new GradleJavaSourceSet.SourceType[]{GradleJavaSourceSet.SourceType.JAVA, GradleJavaSourceSet.SourceType.GROOVY, GradleJavaSourceSet.SourceType.SCALA, GradleJavaSourceSet.SourceType.KOTLIN};
    private final Project project;

    public GradleTestForSourceImpl(Project project) {
        this.project = project;
    }

    public URL[] findUnitTests(FileObject fo) {
        Map<String, GradleJavaSourceSet> sourceSets = GradleJavaProject.get(this.project).getSourceSets();
        ArrayList<File> retFile = new ArrayList<File>();
        File param = FileUtil.toFile((FileObject)fo);
        for (String name : sourceSets.keySet()) {
            if (!name.contains("test") && !name.contains("Test")) continue;
            GradleJavaSourceSet ss = sourceSets.get(name);
            for (GradleJavaSourceSet.SourceType type : MAIN_SOURCES) {
                for (File src : ss.getSourceDirs(type)) {
                    if (param.equals(src)) {
                        return null;
                    }
                    retFile.add(src);
                }
            }
        }
        if (retFile.isEmpty()) {
            return null;
        }
        ArrayList<URL> ret = new ArrayList<URL>(retFile.size());
        for (File f : retFile) {
            ret.add(GradleTestForSourceImpl.fileToURL(f));
        }
        return ret.toArray(new URL[0]);
    }

    public URL[] findSources(FileObject fo) {
        Map<String, GradleJavaSourceSet> sourceSets = GradleJavaProject.get(this.project).getSourceSets();
        ArrayList<File> retFile = new ArrayList<File>();
        File param = FileUtil.toFile((FileObject)fo);
        for (String name : sourceSets.keySet()) {
            if (name.contains("test") || name.contains("Test")) continue;
            GradleJavaSourceSet ss = sourceSets.get(name);
            for (GradleJavaSourceSet.SourceType type : MAIN_SOURCES) {
                for (File src : ss.getSourceDirs(type)) {
                    if (param.equals(src)) {
                        return null;
                    }
                    retFile.add(src);
                }
            }
        }
        if (retFile.isEmpty()) {
            return null;
        }
        ArrayList<URL> ret = new ArrayList<URL>(retFile.size());
        for (File f : retFile) {
            if (!f.isDirectory()) continue;
            ret.add(GradleTestForSourceImpl.fileToURL(f));
        }
        return ret.toArray(new URL[0]);
    }

    private static URL fileToURL(File f) {
        URL ret = null;
        try {
            URI uri = Utilities.toURI((File)f);
            ret = uri.toURL();
            if (!ret.toExternalForm().endsWith("/")) {
                ret = new URL(ret.toExternalForm() + "/");
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ret;
    }
}

