/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.api.actions;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;

public abstract class AbstractSourceElementAction
extends AbstractAction {
    protected FileObject file;
    private String elementPath;

    public AbstractSourceElementAction(FileObject file, String elementPath) {
        this.file = file;
        this.elementPath = elementPath;
    }

    @Override
    public boolean isEnabled() {
        return this.elementPath != null;
    }

    public FileObject getFileObject() {
        return this.file;
    }

    public SourceElementHandle createSourceElementHandle() throws ParseException {
        final AtomicReference seh_ref = new AtomicReference();
        Source source = Source.create((FileObject)this.file);
        ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator ri = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/html");
                if (ri == null) {
                    return;
                }
                HtmlParserResult result = (HtmlParserResult)ri.getParserResult();
                Snapshot snapshot = result.getSnapshot();
                Node root = result.root();
                OpenTag openTag = ElementUtils.query((Node)root, (String)AbstractSourceElementAction.this.elementPath);
                seh_ref.set(new SourceElementHandle(openTag, snapshot, AbstractSourceElementAction.this.file));
            }
        });
        return (SourceElementHandle)seh_ref.get();
    }

    public class SourceElementHandle {
        private final OpenTag openTag;
        private final Snapshot snapshot;
        private final FileObject file;

        private SourceElementHandle(OpenTag openTag, Snapshot snapshot, FileObject file) {
            this.openTag = openTag;
            this.snapshot = snapshot;
            this.file = file;
        }

        public OpenTag getOpenTag() {
            return this.openTag;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public FileObject getFile() {
            return this.file;
        }

        public boolean isResolved() {
            return this.openTag != null;
        }
    }
}

