/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.configuration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.websvc.design.configuration.WSConfigurationProvider;
import org.openide.util.Lookup;

public class WSConfigurationProviderRegistry {
    static WSConfigurationProviderRegistry registry = new WSConfigurationProviderRegistry();
    private Set<WSConfigurationProvider> providers = new LinkedHashSet<WSConfigurationProvider>();

    private WSConfigurationProviderRegistry() {
    }

    public static WSConfigurationProviderRegistry getDefault() {
        return registry;
    }

    public void register(WSConfigurationProvider provider) {
        this.providers.add(provider);
    }

    public void unregister(WSConfigurationProvider provider) {
        this.providers.remove(provider);
    }

    public Set<WSConfigurationProvider> getWSConfigurationProviders() {
        this.populateRegistry();
        return this.providers;
    }

    private void populateRegistry() {
        if (this.providers.isEmpty()) {
            Lookup.Result results = Lookup.getDefault().lookup(new Lookup.Template(WSConfigurationProvider.class));
            Collection providers = results.allInstances();
            for (WSConfigurationProvider provider : providers) {
                this.register(provider);
            }
        }
    }
}

