/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.win32;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.WString;
import com.sun.jna.win32.StdCallLibrary;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.spi.EncryptionProvider;
import org.netbeans.modules.keyring.utils.Utils;
import org.openide.util.Utilities;

public class Win32Protect
implements EncryptionProvider {
    private static final Logger LOG = Logger.getLogger(Win32Protect.class.getName());

    public boolean enabled() {
        if (!Utilities.isWindows()) {
            LOG.fine("not running on Windows");
            return false;
        }
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            LOG.fine("native keyring integration disabled");
            return false;
        }
        try {
            if (CryptLib.INSTANCE == null) {
                LOG.fine("loadLibrary -> null");
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            LOG.log(Level.FINE, null, t);
            return false;
        }
    }

    public String id() {
        return "win32";
    }

    public byte[] encrypt(char[] cleartext) throws Exception {
        byte[] cleartextB = Utils.chars2Bytes((char[])cleartext);
        CryptIntegerBlob input = new CryptIntegerBlob();
        input.store(cleartextB);
        Arrays.fill(cleartextB, (byte)0);
        CryptIntegerBlob output = new CryptIntegerBlob();
        if (!CryptLib.INSTANCE.CryptProtectData(input, null, null, null, null, 0, output)) {
            throw new Exception("CryptProtectData failed: " + Native.getLastError());
        }
        input.zero();
        return output.load();
    }

    public char[] decrypt(byte[] ciphertext) throws Exception {
        CryptIntegerBlob input = new CryptIntegerBlob();
        input.store(ciphertext);
        CryptIntegerBlob output = new CryptIntegerBlob();
        if (!CryptLib.INSTANCE.CryptUnprotectData(input, null, null, null, null, 0, output)) {
            throw new Exception("CryptUnprotectData failed: " + Native.getLastError());
        }
        byte[] result = output.load();
        char[] cleartext = Utils.bytes2Chars((byte[])result);
        Arrays.fill(result, (byte)0);
        return cleartext;
    }

    public boolean decryptionFailed() {
        return false;
    }

    public void encryptionChangingCallback(Callable<Void> callback) {
    }

    public void encryptionChanged() {
        assert (false);
    }

    public void freshKeyring(boolean fresh) {
    }

    public static interface CryptLib
    extends StdCallLibrary {
        public static final CryptLib INSTANCE = (CryptLib)Native.load((String)"Crypt32", CryptLib.class);

        public boolean CryptProtectData(CryptIntegerBlob var1, WString var2, CryptIntegerBlob var3, Pointer var4, Pointer var5, int var6, CryptIntegerBlob var7);

        public boolean CryptUnprotectData(CryptIntegerBlob var1, WString[] var2, CryptIntegerBlob var3, Pointer var4, Pointer var5, int var6, CryptIntegerBlob var7);
    }

    @Structure.FieldOrder(value={"cbData", "pbData"})
    public static class CryptIntegerBlob
    extends Structure {
        public int cbData;
        public Pointer pbData;

        byte[] load() {
            return this.pbData.getByteArray(0L, this.cbData);
        }

        void store(byte[] data) {
            this.cbData = data.length;
            this.pbData = new Memory((long)data.length);
            this.pbData.write(0L, data, 0, this.cbData);
        }

        void zero() {
            ((Memory)this.pbData).clear();
        }
    }
}

