/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ToolTipSupport;
import org.netbeans.modules.debugger.ui.views.ToolTipView;
import org.netbeans.spi.debugger.ui.EditorPin;
import org.netbeans.spi.debugger.ui.PinWatchUISupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class ToolTipUI {
    private final ToolTipView.ExpandableTooltip et;
    private JEditorPane editorPane;

    ToolTipUI(String toolTipText, Expandable expandable, Pinnable pinnable) {
        this.et = new ToolTipView.ExpandableTooltip(toolTipText, expandable != null, pinnable != null);
        if (expandable != null) {
            this.et.addExpansionListener(new ExpansionListener(expandable));
        }
        if (pinnable != null) {
            this.et.addPinListener(new PinListener(pinnable));
        }
    }

    public ToolTipSupport show(JEditorPane editorPane) {
        EditorUI eui = Utilities.getEditorUI((JTextComponent)editorPane);
        if (eui != null) {
            eui.getToolTipSupport().setToolTip((JComponent)this.et);
            this.editorPane = editorPane;
            return eui.getToolTipSupport();
        }
        return null;
    }

    private class ExpansionListener
    implements ActionListener {
        private final Expandable expandable;

        ExpansionListener(Expandable expandable) {
            this.expandable = expandable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ToolTipUI.this.et.setBorder(BorderFactory.createLineBorder(ToolTipUI.this.et.getForeground()));
            ToolTipUI.this.et.removeAll();
            ToolTipUI.this.et.setWidthCheck(false);
            ToolTipView ttView = ToolTipView.createToolTipView(this.expandable.expression, this.expandable.variable);
            ToolTipUI.this.et.add(ttView);
            ToolTipUI.this.et.revalidate();
            ToolTipUI.this.et.repaint();
            SwingUtilities.invokeLater(() -> {
                EditorUI eui = Utilities.getEditorUI((JTextComponent)ToolTipUI.this.editorPane);
                if (eui == null) {
                    throw new IllegalStateException("Have no EditorUI for " + ToolTipUI.this.editorPane);
                }
                eui.getToolTipSupport().setToolTip((JComponent)ToolTipUI.this.et, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0, 4);
            });
        }
    }

    public static final class Expandable {
        private final String expression;
        private final Object variable;

        public Expandable(String expression, Object variable) {
            this.expression = expression;
            this.variable = variable;
        }
    }

    private class PinListener
    implements ActionListener {
        private final Pinnable pinnable;

        public PinListener(Pinnable pinnable) {
            this.pinnable = pinnable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EditorUI eui = Utilities.getEditorUI((JTextComponent)ToolTipUI.this.editorPane);
            Point location = ToolTipUI.this.et.getLocation();
            location = eui.getStickyWindowSupport().convertPoint(location);
            eui.getToolTipSupport().setToolTipVisible(false);
            DebuggerManager dbMgr = DebuggerManager.getDebuggerManager();
            BaseDocument document = Utilities.getDocument((JTextComponent)ToolTipUI.this.editorPane);
            DataObject dobj = (DataObject)document.getProperty((Object)"stream");
            FileObject fo = dobj.getPrimaryFile();
            EditorPin pin = new EditorPin(fo, this.pinnable.line, location);
            Watch w = dbMgr.createPinnedWatch(this.pinnable.expression, (Watch.Pin)pin);
            SwingUtilities.invokeLater(() -> {
                try {
                    PinWatchUISupport.getDefault().pin(w, this.pinnable.valueProviderId);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            });
        }
    }

    public static final class Pinnable {
        private final String expression;
        private final int line;
        private final String valueProviderId;

        public Pinnable(String expression, int line, String valueProviderId) {
            this.expression = expression;
            this.line = line;
            this.valueProviderId = valueProviderId;
        }
    }
}

