/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner.actions;

import org.netbeans.modules.form.layoutsupport.griddesigner.DesignerContext;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridInfoProvider;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridManager;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.AbstractGridAction;
import org.netbeans.modules.form.layoutsupport.griddesigner.actions.GridBoundsChange;
import org.openide.util.NbBundle;

public class InsertRowAction
extends AbstractGridAction {
    private String name;
    private boolean insertAfter;

    public InsertRowAction(boolean insertAfter) {
        String key = "InsertRow" + (insertAfter ? "After" : "Before") + "Action_Name";
        this.name = NbBundle.getMessage(InsertRowAction.class, (String)key);
        this.insertAfter = insertAfter;
    }

    @Override
    public Object getValue(String key) {
        return key.equals("Name") ? this.name : null;
    }

    @Override
    public boolean isEnabled(DesignerContext context) {
        return context.getFocusedRow() != -1;
    }

    @Override
    public GridBoundsChange performAction(GridManager gridManager, DesignerContext context) {
        GridInfoProvider gridInfo = gridManager.getGridInfo();
        boolean gapSupport = gridInfo.hasGaps();
        int[] originalColumnBounds = gridInfo.getColumnBounds();
        int[] originalRowBounds = gridInfo.getRowBounds();
        GridUtils.removePaddingComponents(gridManager);
        int row = context.getFocusedRow();
        if (this.insertAfter) {
            row += gapSupport ? 2 : 1;
        }
        gridManager.insertRow(row);
        GridUtils.addPaddingComponents(gridManager, originalColumnBounds.length - 1, originalRowBounds.length - 1 + (gapSupport ? 2 : 1));
        GridUtils.revalidateGrid(gridManager);
        int[] newColumnBounds = gridInfo.getColumnBounds();
        int[] newRowBounds = gridInfo.getRowBounds();
        int[] oldRowBounds = new int[originalRowBounds.length + (gapSupport ? 2 : 1)];
        if (gapSupport) {
            if (originalRowBounds.length == row) {
                System.arraycopy(originalRowBounds, 0, oldRowBounds, 0, row);
                oldRowBounds[row] = oldRowBounds[row - 1];
                oldRowBounds[row + 1] = oldRowBounds[row - 1];
            } else {
                System.arraycopy(originalRowBounds, 0, oldRowBounds, 0, row + 1);
                oldRowBounds[row + 1] = oldRowBounds[row];
                oldRowBounds[row + 2] = oldRowBounds[row];
                System.arraycopy(originalRowBounds, row + 1, oldRowBounds, row + 3, originalRowBounds.length - row - 1);
            }
        } else {
            System.arraycopy(originalRowBounds, 0, oldRowBounds, 0, row + 1);
            oldRowBounds[row + 1] = oldRowBounds[row];
            System.arraycopy(originalRowBounds, row + 1, oldRowBounds, row + 2, originalRowBounds.length - row - 1);
        }
        return new GridBoundsChange(originalColumnBounds, oldRowBounds, newColumnBounds, newRowBounds);
    }
}

