/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.identity.model.UserCapabilities;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class User
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="email")
    private final String email;
    @JsonProperty(value="emailVerified")
    private final Boolean emailVerified;
    @JsonProperty(value="dbUserName")
    private final String dbUserName;
    @JsonProperty(value="identityProviderId")
    private final String identityProviderId;
    @JsonProperty(value="externalIdentifier")
    private final String externalIdentifier;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="inactiveStatus")
    private final Long inactiveStatus;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="capabilities")
    private final UserCapabilities capabilities;
    @JsonProperty(value="isMfaActivated")
    private final Boolean isMfaActivated;
    @JsonProperty(value="lastSuccessfulLoginTime")
    private final Date lastSuccessfulLoginTime;
    @JsonProperty(value="previousSuccessfulLoginTime")
    private final Date previousSuccessfulLoginTime;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "name", "description", "email", "emailVerified", "dbUserName", "identityProviderId", "externalIdentifier", "timeCreated", "lifecycleState", "inactiveStatus", "freeformTags", "definedTags", "capabilities", "isMfaActivated", "lastSuccessfulLoginTime", "previousSuccessfulLoginTime"})
    public User(String id, String compartmentId, String name, String description, String email, Boolean emailVerified, String dbUserName, String identityProviderId, String externalIdentifier, Date timeCreated, LifecycleState lifecycleState, Long inactiveStatus, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, UserCapabilities capabilities, Boolean isMfaActivated, Date lastSuccessfulLoginTime, Date previousSuccessfulLoginTime) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.name = name;
        this.description = description;
        this.email = email;
        this.emailVerified = emailVerified;
        this.dbUserName = dbUserName;
        this.identityProviderId = identityProviderId;
        this.externalIdentifier = externalIdentifier;
        this.timeCreated = timeCreated;
        this.lifecycleState = lifecycleState;
        this.inactiveStatus = inactiveStatus;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.capabilities = capabilities;
        this.isMfaActivated = isMfaActivated;
        this.lastSuccessfulLoginTime = lastSuccessfulLoginTime;
        this.previousSuccessfulLoginTime = previousSuccessfulLoginTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEmail() {
        return this.email;
    }

    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public String getIdentityProviderId() {
        return this.identityProviderId;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Long getInactiveStatus() {
        return this.inactiveStatus;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public UserCapabilities getCapabilities() {
        return this.capabilities;
    }

    public Boolean getIsMfaActivated() {
        return this.isMfaActivated;
    }

    public Date getLastSuccessfulLoginTime() {
        return this.lastSuccessfulLoginTime;
    }

    public Date getPreviousSuccessfulLoginTime() {
        return this.previousSuccessfulLoginTime;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("User(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", email=").append(String.valueOf(this.email));
        sb.append(", emailVerified=").append(String.valueOf(this.emailVerified));
        sb.append(", dbUserName=").append(String.valueOf(this.dbUserName));
        sb.append(", identityProviderId=").append(String.valueOf(this.identityProviderId));
        sb.append(", externalIdentifier=").append(String.valueOf(this.externalIdentifier));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", inactiveStatus=").append(String.valueOf(this.inactiveStatus));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", capabilities=").append(String.valueOf((Object)this.capabilities));
        sb.append(", isMfaActivated=").append(String.valueOf(this.isMfaActivated));
        sb.append(", lastSuccessfulLoginTime=").append(String.valueOf(this.lastSuccessfulLoginTime));
        sb.append(", previousSuccessfulLoginTime=").append(String.valueOf(this.previousSuccessfulLoginTime));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.email, other.email) && Objects.equals(this.emailVerified, other.emailVerified) && Objects.equals(this.dbUserName, other.dbUserName) && Objects.equals(this.identityProviderId, other.identityProviderId) && Objects.equals(this.externalIdentifier, other.externalIdentifier) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.inactiveStatus, other.inactiveStatus) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.capabilities, (Object)other.capabilities) && Objects.equals(this.isMfaActivated, other.isMfaActivated) && Objects.equals(this.lastSuccessfulLoginTime, other.lastSuccessfulLoginTime) && Objects.equals(this.previousSuccessfulLoginTime, other.previousSuccessfulLoginTime) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.email == null ? 43 : this.email.hashCode());
        result = result * 59 + (this.emailVerified == null ? 43 : this.emailVerified.hashCode());
        result = result * 59 + (this.dbUserName == null ? 43 : this.dbUserName.hashCode());
        result = result * 59 + (this.identityProviderId == null ? 43 : this.identityProviderId.hashCode());
        result = result * 59 + (this.externalIdentifier == null ? 43 : this.externalIdentifier.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.inactiveStatus == null ? 43 : this.inactiveStatus.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.capabilities == null ? 43 : this.capabilities.hashCode());
        result = result * 59 + (this.isMfaActivated == null ? 43 : this.isMfaActivated.hashCode());
        result = result * 59 + (this.lastSuccessfulLoginTime == null ? 43 : this.lastSuccessfulLoginTime.hashCode());
        result = result * 59 + (this.previousSuccessfulLoginTime == null ? 43 : this.previousSuccessfulLoginTime.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="email")
        private String email;
        @JsonProperty(value="emailVerified")
        private Boolean emailVerified;
        @JsonProperty(value="dbUserName")
        private String dbUserName;
        @JsonProperty(value="identityProviderId")
        private String identityProviderId;
        @JsonProperty(value="externalIdentifier")
        private String externalIdentifier;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="inactiveStatus")
        private Long inactiveStatus;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="capabilities")
        private UserCapabilities capabilities;
        @JsonProperty(value="isMfaActivated")
        private Boolean isMfaActivated;
        @JsonProperty(value="lastSuccessfulLoginTime")
        private Date lastSuccessfulLoginTime;
        @JsonProperty(value="previousSuccessfulLoginTime")
        private Date previousSuccessfulLoginTime;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.__explicitlySet__.add("email");
            return this;
        }

        public Builder emailVerified(Boolean emailVerified) {
            this.emailVerified = emailVerified;
            this.__explicitlySet__.add("emailVerified");
            return this;
        }

        public Builder dbUserName(String dbUserName) {
            this.dbUserName = dbUserName;
            this.__explicitlySet__.add("dbUserName");
            return this;
        }

        public Builder identityProviderId(String identityProviderId) {
            this.identityProviderId = identityProviderId;
            this.__explicitlySet__.add("identityProviderId");
            return this;
        }

        public Builder externalIdentifier(String externalIdentifier) {
            this.externalIdentifier = externalIdentifier;
            this.__explicitlySet__.add("externalIdentifier");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder inactiveStatus(Long inactiveStatus) {
            this.inactiveStatus = inactiveStatus;
            this.__explicitlySet__.add("inactiveStatus");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder capabilities(UserCapabilities capabilities) {
            this.capabilities = capabilities;
            this.__explicitlySet__.add("capabilities");
            return this;
        }

        public Builder isMfaActivated(Boolean isMfaActivated) {
            this.isMfaActivated = isMfaActivated;
            this.__explicitlySet__.add("isMfaActivated");
            return this;
        }

        public Builder lastSuccessfulLoginTime(Date lastSuccessfulLoginTime) {
            this.lastSuccessfulLoginTime = lastSuccessfulLoginTime;
            this.__explicitlySet__.add("lastSuccessfulLoginTime");
            return this;
        }

        public Builder previousSuccessfulLoginTime(Date previousSuccessfulLoginTime) {
            this.previousSuccessfulLoginTime = previousSuccessfulLoginTime;
            this.__explicitlySet__.add("previousSuccessfulLoginTime");
            return this;
        }

        public User build() {
            User model = new User(this.id, this.compartmentId, this.name, this.description, this.email, this.emailVerified, this.dbUserName, this.identityProviderId, this.externalIdentifier, this.timeCreated, this.lifecycleState, this.inactiveStatus, this.freeformTags, this.definedTags, this.capabilities, this.isMfaActivated, this.lastSuccessfulLoginTime, this.previousSuccessfulLoginTime);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(User model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("email")) {
                this.email(model.getEmail());
            }
            if (model.wasPropertyExplicitlySet("emailVerified")) {
                this.emailVerified(model.getEmailVerified());
            }
            if (model.wasPropertyExplicitlySet("dbUserName")) {
                this.dbUserName(model.getDbUserName());
            }
            if (model.wasPropertyExplicitlySet("identityProviderId")) {
                this.identityProviderId(model.getIdentityProviderId());
            }
            if (model.wasPropertyExplicitlySet("externalIdentifier")) {
                this.externalIdentifier(model.getExternalIdentifier());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("inactiveStatus")) {
                this.inactiveStatus(model.getInactiveStatus());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("capabilities")) {
                this.capabilities(model.getCapabilities());
            }
            if (model.wasPropertyExplicitlySet("isMfaActivated")) {
                this.isMfaActivated(model.getIsMfaActivated());
            }
            if (model.wasPropertyExplicitlySet("lastSuccessfulLoginTime")) {
                this.lastSuccessfulLoginTime(model.getLastSuccessfulLoginTime());
            }
            if (model.wasPropertyExplicitlySet("previousSuccessfulLoginTime")) {
                this.previousSuccessfulLoginTime(model.getPreviousSuccessfulLoginTime());
            }
            return this;
        }
    }
}

