/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.latte.embedding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.php.latte.lexer.LatteTopTokenId;

public class LatteHtmlEmbeddingProvider
extends EmbeddingProvider {
    public static final String TARGET_MIME_TYPE = "text/html";
    public static final String GENERATED_CODE = "@@@";

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = TokenHierarchy.create((CharSequence)snapshot.getText(), LatteTopTokenId.language());
        TokenSequence ts = th.tokenSequence(LatteTopTokenId.language());
        if (ts == null) {
            return Collections.emptyList();
        }
        ts.moveStart();
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        int from = -1;
        int length = 0;
        while (ts.moveNext()) {
            Token token = ts.token();
            if (token != null && this.isPureHtmlToken((Token<LatteTopTokenId>)token)) {
                if (from < 0) {
                    from = ts.offset();
                }
                length += token.length();
                continue;
            }
            if (from < 0) continue;
            embeddings.add(snapshot.create(from, length, TARGET_MIME_TYPE));
            embeddings.add(snapshot.create((CharSequence)GENERATED_CODE, TARGET_MIME_TYPE));
            from = -1;
            length = 0;
        }
        if (from >= 0) {
            embeddings.add(snapshot.create(from, length, TARGET_MIME_TYPE));
        }
        if (embeddings.isEmpty()) {
            return Collections.singletonList(snapshot.create((CharSequence)"", TARGET_MIME_TYPE));
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    private boolean isPureHtmlToken(Token<LatteTopTokenId> token) {
        CharSequence tokenText = token.text();
        return token.id() == LatteTopTokenId.T_HTML && (tokenText == null || !tokenText.toString().endsWith("{") && !tokenText.toString().startsWith("}"));
    }

    public int getPriority() {
        return 200;
    }

    public void cancel() {
    }
}

