/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.api;

import com.sun.xml.ws.api.FeatureConstructor;
import com.sun.xml.ws.api.ha.StickyFeature;
import com.sun.xml.ws.rx.rm.api.RmProtocolVersion;
import javax.xml.ws.WebServiceFeature;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
public class ReliableMessagingFeature
extends WebServiceFeature
implements StickyFeature {
    public static final String ID = "http://docs.oasis-open.org/ws-rx/wsrm/";
    public static final long DEFAULT_SEQUENCE_INACTIVITY_TIMEOUT = 600000L;
    public static final long DEFAULT_DESTINATION_BUFFER_QUOTA = 32L;
    public static final long DEFAULT_MESSAGE_RETRANSMISSION_INTERVAL = 2000L;
    public static final long DEFAULT_MAX_MESSAGE_RETRANSMISSION_COUNT = -1L;
    public static final long DEFAULT_MAX_RM_SESSION_CONTROL_MESSAGE_RESEND_ATTEMPTS = 3L;
    public static final long DEFAULT_ACKNOWLEDGEMENT_TRANSMISSION_INTERVAL = -1L;
    public static final long DEFAULT_ACK_REQUEST_TRANSMISSION_INTERVAL = 2000L;
    public static final long DEFAULT_CLOSE_SEQUENCE_OPERATION_TIMEOUT = 3000L;
    public static final long DEFAULT_SEQUENCE_MANAGER_MAINTENANCE_PERIOD = 60000L;
    public static final long DEFAULT_MAX_CONCURRENT_SESSIONS = -1L;
    public static final boolean DEFAULT_OFFER_ELEMENT_GENERATION_DISABLED = false;
    public static final boolean DEFAULT_REJECT_OUT_OF_ORDER_MESSAGES = false;
    public static final boolean DEFAULT_STATE_UPDATE_ON_RECEIVED_ACKREQUESTED_DISABLED = false;
    public static final boolean DEFAULT_XA_TX_FOR_SERVER_RMD = false;
    public static final int DEFAULT_XA_TX_FOR_SERVER_RMD_TIMEOUT_SECONDS = 60;
    private final RmProtocolVersion version;
    private final long sequenceInactivityTimeout;
    private final long destinationBufferQuota;
    private final boolean orderedDelivery;
    private final DeliveryAssurance deliveryAssurance;
    private final SecurityBinding securityBinding;
    private final long messageRetransmissionInterval;
    private final BackoffAlgorithm retransmissionBackoffAlgorithm;
    private final long maxMessageRetransmissionCount;
    private final long maxRmSessionControlMessageResendAttempts;
    private final long acknowledgementTransmissionInterval;
    private final long ackRequestTransmissionInterval;
    private final long closeSequenceOperationTimeout;
    private final boolean persistenceEnabled;
    private final long sequenceManagerMaintenancePeriod;
    private final long maxConcurrentSessions;
    private final boolean offerElementGenerationDisabled;
    private final boolean rejectOutOfOrderMessagesEnabled;

    public ReliableMessagingFeature() {
        this(true);
    }

    public ReliableMessagingFeature(boolean enabled) {
        this(enabled, RmProtocolVersion.getDefault(), 600000L, 32L, false, DeliveryAssurance.getDefault(), SecurityBinding.getDefault(), 2000L, BackoffAlgorithm.getDefault(), -1L, 3L, -1L, 2000L, 3000L, false, 60000L, -1L, false, false);
    }

    @FeatureConstructor(value={"enabled", "version", "sequenceInactivityTimeout", "destinationBufferQuota", "orderedDeliveryEnabled", "deliveryAssurance", "securityBinding", "persistenceEnabled", "sequenceManagerMaintenancePeriod", "maxConcurrentSessions"})
    public ReliableMessagingFeature(boolean enabled, RmProtocolVersion version, long inactivityTimeout, long bufferQuota, boolean orderedDelivery, DeliveryAssurance deliveryAssurance, SecurityBinding securityBinding, boolean persistenceEnabled, long sequenceManagerMaintenancePeriod, long maxConcurrentSessions) {
        this(enabled, version, inactivityTimeout, bufferQuota, orderedDelivery, deliveryAssurance, securityBinding, 2000L, BackoffAlgorithm.getDefault(), -1L, 3L, -1L, 2000L, 3000L, persistenceEnabled, sequenceManagerMaintenancePeriod, maxConcurrentSessions, false, false);
    }

    ReliableMessagingFeature(boolean enabled, RmProtocolVersion version, long inactivityTimeout, long bufferQuota, boolean orderedDelivery, DeliveryAssurance deliveryAssurance, SecurityBinding securityBinding, long messageRetransmissionInterval, BackoffAlgorithm retransmissionBackoffAlgorithm, long maxMessageRetransmissionCount, long maxRmSessionControlMessageResendAttempts, long acknowledgementTransmissionInterval, long ackRequestTransmissionInterval, long closeSequenceOperationTimeout, boolean persistenceEnabled, long sequenceManagerMaintenancePeriod, long maxConcurrentRmSessions, boolean offerElementGenerationDisabled, boolean rejectOutOfOrderMessagesEnabled) {
        this.enabled = enabled;
        this.version = version;
        this.sequenceInactivityTimeout = inactivityTimeout;
        this.destinationBufferQuota = bufferQuota;
        this.orderedDelivery = orderedDelivery;
        this.deliveryAssurance = deliveryAssurance;
        this.securityBinding = securityBinding;
        this.messageRetransmissionInterval = messageRetransmissionInterval;
        this.retransmissionBackoffAlgorithm = retransmissionBackoffAlgorithm;
        this.maxMessageRetransmissionCount = maxMessageRetransmissionCount;
        this.maxRmSessionControlMessageResendAttempts = maxRmSessionControlMessageResendAttempts;
        this.acknowledgementTransmissionInterval = acknowledgementTransmissionInterval;
        this.ackRequestTransmissionInterval = ackRequestTransmissionInterval;
        this.closeSequenceOperationTimeout = closeSequenceOperationTimeout;
        this.persistenceEnabled = persistenceEnabled;
        this.sequenceManagerMaintenancePeriod = sequenceManagerMaintenancePeriod;
        this.maxConcurrentSessions = maxConcurrentRmSessions;
        this.offerElementGenerationDisabled = offerElementGenerationDisabled;
        this.rejectOutOfOrderMessagesEnabled = rejectOutOfOrderMessagesEnabled;
    }

    @Override
    @ManagedAttribute
    public String getID() {
        return ID;
    }

    @ManagedAttribute
    public RmProtocolVersion getProtocolVersion() {
        return this.version;
    }

    @ManagedAttribute
    public long getSequenceInactivityTimeout() {
        return this.sequenceInactivityTimeout;
    }

    @ManagedAttribute
    public SecurityBinding getSecurityBinding() {
        return this.securityBinding;
    }

    @ManagedAttribute
    public DeliveryAssurance getDeliveryAssurance() {
        return this.deliveryAssurance;
    }

    @ManagedAttribute
    public boolean isOrderedDeliveryEnabled() {
        return this.orderedDelivery;
    }

    @ManagedAttribute
    public long getDestinationBufferQuota() {
        return this.destinationBufferQuota;
    }

    @ManagedAttribute
    public long getMessageRetransmissionInterval() {
        return this.messageRetransmissionInterval;
    }

    @ManagedAttribute
    public BackoffAlgorithm getRetransmissionBackoffAlgorithm() {
        return this.retransmissionBackoffAlgorithm;
    }

    @ManagedAttribute
    public long getMaxMessageRetransmissionCount() {
        return this.maxMessageRetransmissionCount;
    }

    public boolean canRetransmitMessage(long nextRetransmissionCount) {
        if (this.maxMessageRetransmissionCount < 0L) {
            return true;
        }
        return nextRetransmissionCount <= this.maxMessageRetransmissionCount;
    }

    @ManagedAttribute
    public long getMaxRmSessionControlMessageResendAttempts() {
        return this.maxRmSessionControlMessageResendAttempts;
    }

    @ManagedAttribute
    public long getAcknowledgementTransmissionInterval() {
        return this.acknowledgementTransmissionInterval;
    }

    @ManagedAttribute
    public long getAckRequestTransmissionInterval() {
        return this.ackRequestTransmissionInterval;
    }

    @ManagedAttribute
    public long getCloseSequenceOperationTimeout() {
        return this.closeSequenceOperationTimeout;
    }

    @ManagedAttribute
    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    @ManagedAttribute
    public long getSequenceManagerMaintenancePeriod() {
        return this.sequenceManagerMaintenancePeriod;
    }

    @ManagedAttribute
    public long getMaxConcurrentSessions() {
        return this.maxConcurrentSessions;
    }

    public boolean isOfferElementGenerationDisabled() {
        return this.offerElementGenerationDisabled;
    }

    public boolean isRejectOutOfOrderMessagesEnabled() {
        return this.rejectOutOfOrderMessagesEnabled;
    }

    public String toString() {
        return "ReliableMessagingFeature{\n\tversion=" + (Object)((Object)this.version) + ",\n\tdeliveryAssurance=" + (Object)((Object)this.deliveryAssurance) + ",\n\torderedDelivery=" + this.orderedDelivery + ",\n\tsecurityBinding=" + (Object)((Object)this.securityBinding) + ",\n\tdestinationBufferQuota=" + this.destinationBufferQuota + ",\n\tpersistenceEnabled=" + this.persistenceEnabled + ",\n\tmessageRetransmissionInterval=" + this.messageRetransmissionInterval + ",\n\tretransmissionBackoffAlgorithm=" + (Object)((Object)this.retransmissionBackoffAlgorithm) + ",\n\tmaxMessageRetransmissionCount=" + this.maxMessageRetransmissionCount + ",\n\tmaxRmSessionControlMessageResendAttempts=" + this.maxRmSessionControlMessageResendAttempts + ",\n\tacknowledgementTransmissionInterval=" + this.acknowledgementTransmissionInterval + ",\n\tackRequestTransmissionInterval=" + this.ackRequestTransmissionInterval + ",\n\tsequenceInactivityTimeout=" + this.sequenceInactivityTimeout + ",\n\tcloseSequenceOperationTimeout=" + this.closeSequenceOperationTimeout + ",\n\tsequenceManagerMaintenancePeriod=" + this.sequenceManagerMaintenancePeriod + ",\n\tmaxConcurrentSessions=" + this.maxConcurrentSessions + ",\n\tofferElementGenerationDisabled=" + this.offerElementGenerationDisabled + ",\n\trejectOutOfOrderMessagesEnabled=" + this.rejectOutOfOrderMessagesEnabled + "\n}";
    }

    public static enum DeliveryAssurance {
        EXACTLY_ONCE,
        AT_LEAST_ONCE,
        AT_MOST_ONCE;


        public static DeliveryAssurance getDefault() {
            return EXACTLY_ONCE;
        }
    }

    public static enum SecurityBinding {
        STR,
        TRANSPORT,
        NONE;


        public static SecurityBinding getDefault() {
            return NONE;
        }
    }

    public static enum BackoffAlgorithm {
        CONSTANT("Constant"){

            @Override
            public long getDelayInMillis(int resendAttemptNumber, long baseRate) {
                return baseRate;
            }
        }
        ,
        EXPONENTIAL("Exponential"){

            @Override
            public long getDelayInMillis(int resendAttemptNumber, long baseRate) {
                return (long)resendAttemptNumber * baseRate;
            }
        };

        private final String name;

        private BackoffAlgorithm(String name) {
            this.name = name;
        }

        public static BackoffAlgorithm parse(String name) {
            for (BackoffAlgorithm value : BackoffAlgorithm.values()) {
                if (!value.name.equals(name)) continue;
                return value;
            }
            return null;
        }

        public static BackoffAlgorithm getDefault() {
            return CONSTANT;
        }

        public abstract long getDelayInMillis(int var1, long var2);
    }
}

