/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.modules.db.mysql.impl.Bundle;
import org.netbeans.modules.db.mysql.impl.Installation;
import org.netbeans.modules.db.mysql.impl.MultiInstallation;
import org.netbeans.modules.db.mysql.installations.BundledInstallation;
import org.netbeans.modules.db.mysql.installations.ui.SelectInstallationPanel;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;

public class InstallationManager {
    private static Logger LOGGER = Logger.getLogger(InstallationManager.class.getName());
    private static ArrayList<Installation> INSTALLATIONS = null;
    private static final String INSTALLATION_PROVIDER_PATH = "Databases/MySQL/Installations";
    private static final String ICON_BASE = "org/netbeans/modules/db/mysql/resources/database.gif";

    public static synchronized List<Installation> getInstallations(Collection loadedInstallations) {
        if (INSTALLATIONS == null) {
            BundledInstallation bundled = BundledInstallation.getDefault();
            if (bundled.isInstalled()) {
                ArrayList<Installation> bundledList = new ArrayList<Installation>();
                bundledList.add(bundled);
                return bundledList;
            }
            ArrayList<Installation> stackInstalls = new ArrayList<Installation>();
            ArrayList<Installation> stdInstalls = new ArrayList<Installation>();
            for (Installation installation : loadedInstallations) {
                if (installation.isStackInstall()) {
                    stackInstalls.add(installation);
                    continue;
                }
                stdInstalls.add(installation);
            }
            INSTALLATIONS = new ArrayList();
            INSTALLATIONS.addAll(stackInstalls);
            INSTALLATIONS.addAll(stdInstalls);
        }
        return INSTALLATIONS;
    }

    public static List<Installation> detectAllInstallations() {
        CopyOnWriteArrayList<Installation> installationCopy = new CopyOnWriteArrayList<Installation>();
        ArrayList<Installation> loadedInstallations = new ArrayList<Installation>(3);
        loadedInstallations.addAll(Lookups.forPath((String)INSTALLATION_PROVIDER_PATH).lookupAll(Installation.class));
        Collection multiInstallations = Lookups.forPath((String)INSTALLATION_PROVIDER_PATH).lookupAll(MultiInstallation.class);
        for (MultiInstallation mi : multiInstallations) {
            loadedInstallations.addAll(mi.getInstallations());
        }
        installationCopy.addAll(InstallationManager.getInstallations(loadedInstallations));
        ArrayList<Installation> validInstallations = new ArrayList<Installation>(3);
        for (Installation installation : installationCopy) {
            LOGGER.log(Level.FINE, "Looking for MySQL installation " + installation.getStartCommand()[0] + installation.getStartCommand()[1]);
            if (!installation.isInstalled()) continue;
            LOGGER.log(Level.FINE, "Installation is installed");
            validInstallations.add(installation);
        }
        return validInstallations;
    }

    public static Installation detectInstallation() {
        List<Installation> allInstallations = InstallationManager.detectAllInstallations();
        if (allInstallations.isEmpty()) {
            return null;
        }
        if (allInstallations.size() > 1) {
            InstallationManager.notifyAboutMultipleInstallations();
        }
        return allInstallations.get(0);
    }

    private static void notifyAboutMultipleInstallations() {
        NotificationDisplayer.getDefault().notify(Bundle.NotifyMultipleInstallations_title(), (Icon)ImageUtilities.loadImageIcon((String)ICON_BASE, (boolean)false), Bundle.NotifyMultipleInstallations_text(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectInstallationPanel.showSelectInstallationDialog();
            }
        }, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.WARNING);
    }
}

