/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.ftp;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.php.project.connections.ftp.FtpPreferences;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class WindowsJdk7WarningPanel
extends JPanel {
    private static final long serialVersionUID = 54654646872L;
    private static final boolean IS_WINDOWS = Utilities.isWindows();
    private static final boolean IS_JDK7 = System.getProperty("java.version").startsWith("1.7.");
    private static volatile Boolean windowsJdk7Warning;
    private JCheckBox doNotShowAgainCheckBox;
    private JLabel infoLabel;
    private JScrollPane infoScrollPane;
    private JTextPane infoTextPane;
    private JLabel issueLinkLabel;

    private WindowsJdk7WarningPanel() {
        this.initComponents();
    }

    public static void warn() {
        if (!WindowsJdk7WarningPanel.showWindowsJdk7Warning()) {
            return;
        }
        WindowsJdk7WarningPanel panel = new WindowsJdk7WarningPanel();
        NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)panel, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (panel.doNotShowAgainCheckBox.isSelected()) {
            WindowsJdk7WarningPanel.hideWindowsJdk7Warning();
        }
    }

    private static boolean showWindowsJdk7Warning() {
        if (windowsJdk7Warning == null) {
            windowsJdk7Warning = IS_WINDOWS && IS_JDK7 && FtpPreferences.getInstance().getWindowsJdk7Warning();
        }
        return windowsJdk7Warning;
    }

    private static void hideWindowsJdk7Warning() {
        windowsJdk7Warning = false;
        FtpPreferences.getInstance().setWindowsJdk7Warning(false);
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.issueLinkLabel = new JLabel();
        this.doNotShowAgainCheckBox = new JCheckBox();
        this.infoScrollPane = new JScrollPane();
        this.infoTextPane = new JTextPane();
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(WindowsJdk7WarningPanel.class, (String)"WindowsJdk7WarningPanel.infoLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.issueLinkLabel, (String)NbBundle.getMessage(WindowsJdk7WarningPanel.class, (String)"WindowsJdk7WarningPanel.issueLinkLabel.text"));
        this.issueLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                WindowsJdk7WarningPanel.this.issueLinkLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                WindowsJdk7WarningPanel.this.issueLinkLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.doNotShowAgainCheckBox, (String)NbBundle.getMessage(WindowsJdk7WarningPanel.class, (String)"WindowsJdk7WarningPanel.doNotShowAgainCheckBox.text"));
        this.infoScrollPane.setBorder(null);
        this.infoTextPane.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.infoTextPane.setBorder(null);
        this.infoTextPane.setEditable(false);
        this.infoTextPane.setText(NbBundle.getMessage(WindowsJdk7WarningPanel.class, (String)"TXT_WinJdk7FtpWarning"));
        this.infoScrollPane.setViewportView(this.infoTextPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoLabel).addComponent(this.doNotShowAgainCheckBox)).addContainerGap(116, Short.MAX_VALUE)).addComponent(this.infoScrollPane, -1, 358, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.issueLinkLabel, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.infoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.issueLinkLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.doNotShowAgainCheckBox)));
    }

    private void issueLinkLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void issueLinkLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=7077696");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

