/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.runconfigs.RunConfigLocal;
import org.netbeans.modules.php.project.runconfigs.validation.RunConfigLocalValidator;
import org.netbeans.modules.php.project.ui.actions.support.AskForUrlPanel;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.actions.support.DebugStarterFactory;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.spi.executable.DebugStarter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

class ConfigActionLocal
extends ConfigAction {
    private final FileObject webRoot;

    protected ConfigActionLocal(PhpProject project) {
        super(project);
        this.webRoot = ProjectPropertiesSupport.getWebRootDirectory(project);
    }

    @Override
    public boolean isProjectValid() {
        return this.isValid(RunConfigLocalValidator.validateConfigAction(RunConfigLocal.forProject(this.project), true) == null);
    }

    @Override
    public boolean isFileValid() {
        return this.isValid(RunConfigLocalValidator.validateConfigAction(RunConfigLocal.forProject(this.project), false) == null);
    }

    protected boolean isValid(boolean valid) {
        if (!valid) {
            this.showCustomizer();
        }
        return valid;
    }

    @Override
    public boolean isRunFileEnabled(Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context, this.webRoot);
        return file != null;
    }

    @Override
    public boolean isDebugFileEnabled(Lookup context) {
        if (DebugStarterFactory.getInstance() == null) {
            return false;
        }
        return this.isRunFileEnabled(context);
    }

    @Override
    public void runProject() {
        try {
            this.showProjectUrl(CommandUtils.urlForProject(this.project));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void debugProject() {
        final URL[] urlToShow = new URL[2];
        try {
            URL urlForProject = this.getUrlToShow(CommandUtils.urlForProject(this.project));
            if (urlForProject != null) {
                urlToShow[0] = CommandUtils.createDebugUrl(urlForProject, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START);
                urlToShow[1] = CommandUtils.createDebugUrl(urlForProject, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_STOP_NO_EXEC);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (StopDebuggingException exc) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (urlToShow[0] != null) {
                    ConfigActionLocal.this.showProjectUrl(urlToShow[0]);
                }
            }
        };
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (urlToShow[1] != null) {
                    ConfigActionLocal.this.showProjectUrl(urlToShow[1]);
                }
                return true;
            }
        };
        DebugStarter dbgStarter = DebugStarterFactory.getInstance();
        if (dbgStarter != null) {
            if (dbgStarter.isAlreadyRunning()) {
                if (CommandUtils.warnNoMoreDebugSession()) {
                    dbgStarter.stop();
                    this.debugProject();
                }
            } else {
                this.startDebugger(dbgStarter, runnable, cancellable, FileUtil.toFileObject((File)RunConfigLocal.forProject(this.project).getIndexFile()));
            }
        }
    }

    @Override
    public void runFile(Lookup context) {
        try {
            URL url = CommandUtils.urlForContext(this.project, context);
            assert (url != null);
            this.preShowUrl(context);
            this.showContextUrl(url, context);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void debugFile(Lookup context) {
        URL urlForStartDebugging = null;
        URL urlForStopDebugging = null;
        try {
            URL urlForContext = this.getUrlToShow(CommandUtils.urlForContext(this.project, context));
            if (urlForContext != null) {
                urlForStartDebugging = CommandUtils.createDebugUrl(urlForContext, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_START);
                urlForStopDebugging = CommandUtils.createDebugUrl(urlForContext, PhpProjectProperties.XDebugUrlArguments.XDEBUG_SESSION_STOP_NO_EXEC);
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        catch (StopDebuggingException exc) {
            return;
        }
        this.preShowUrl(context);
        this.debugFile(CommandUtils.fileForContextOrSelectedNodes(context, this.webRoot), urlForStartDebugging, urlForStopDebugging);
    }

    URL getUrlToShow(URL defaultRunUrl) throws MalformedURLException, StopDebuggingException {
        URL urlToShow = null;
        PhpProjectProperties.DebugUrl debugUrl = ProjectPropertiesSupport.getDebugUrl(this.project);
        switch (debugUrl) {
            case DEFAULT_URL: {
                urlToShow = defaultRunUrl;
                assert (urlToShow != null);
                break;
            }
            case ASK_FOR_URL: {
                AskForUrlPanel askForUrlPanel = new AskForUrlPanel(this.project, defaultRunUrl);
                if (!askForUrlPanel.open()) {
                    throw new StopDebuggingException();
                }
                urlToShow = askForUrlPanel.getUrl();
                assert (urlToShow != null);
                break;
            }
            case DO_NOT_OPEN_BROWSER: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state for debug URL: " + debugUrl);
            }
        }
        return urlToShow;
    }

    void debugFile(final FileObject selectedFile, final URL urlForStartDebugging, final URL urlForStopDebugging) {
        assert (selectedFile != null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (urlForStartDebugging != null) {
                    ConfigActionLocal.this.showFileUrl(urlForStartDebugging, selectedFile);
                }
            }
        };
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                if (urlForStopDebugging != null) {
                    ConfigActionLocal.this.showFileUrl(urlForStopDebugging, selectedFile);
                }
                return true;
            }
        };
        DebugStarter dbgStarter = DebugStarterFactory.getInstance();
        if (dbgStarter != null) {
            if (dbgStarter.isAlreadyRunning()) {
                if (CommandUtils.warnNoMoreDebugSession()) {
                    dbgStarter.stop();
                    this.debugFile(selectedFile, urlForStartDebugging, urlForStopDebugging);
                }
            } else {
                this.startDebugger(dbgStarter, runnable, cancellable, selectedFile);
            }
        }
    }

    protected void preShowUrl(Lookup context) {
    }

    private void startDebugger(DebugStarter dbgStarter, Runnable initDebuggingCode, Cancellable cancellable, FileObject debuggedFile) {
        Callable<Cancellable> initDebuggingCallable = Executors.callable(initDebuggingCode, cancellable);
        DebugStarter.Properties props = new DebugStarter.Properties.Builder().setStartFile(debuggedFile).setCloseSession(false).setPathMapping(ProjectPropertiesSupport.getDebugPathMapping(this.project)).setDebugProxy(ProjectPropertiesSupport.getDebugProxy(this.project)).setEncoding(ProjectPropertiesSupport.getEncoding(this.project)).build();
        dbgStarter.start((Project)this.project, initDebuggingCallable, props);
    }

    void showProjectUrl(URL url) {
        this.showFileUrl(url, CommandUtils.fileForProject(this.project, this.webRoot));
    }

    private void showContextUrl(URL url, Lookup context) {
        FileObject file = CommandUtils.fileForContextOrSelectedNodes(context);
        if (file != null) {
            this.showFileUrl(url, file);
        } else {
            assert (false) : "FO should be found for context";
            this.showProjectUrl(url);
        }
    }

    void showFileUrl(URL url, FileObject file) {
        ((PhpProject.ClientSideDevelopmentSupport)this.project.getLookup().lookup(PhpProject.ClientSideDevelopmentSupport.class)).showFileUrl(url, file);
    }

    private static final class StopDebuggingException
    extends Exception {
        private static final long serialVersionUID = -22807171434417714L;

        private StopDebuggingException() {
        }
    }
}

