/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public abstract class LookupManager {
    private static final Map<Class, Handle> handles = new WeakHashMap<Class, Handle>();
    private Handle handle = null;
    private static final RequestProcessor CHANGES = new RequestProcessor("Lookup changes", 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void register(Class clazz) {
        if (this.handle != null) {
            throw new IllegalStateException();
        }
        Map<Class, Handle> map = handles;
        synchronized (map) {
            this.handle = handles.get(clazz);
            if (this.handle == null) {
                this.handle = new Handle(clazz);
                handles.put(clazz, this.handle);
            }
        }
        this.handle.register(this);
    }

    protected final Collection getResult() {
        return this.handle.getInstances();
    }

    protected abstract void removedFromResult(Collection var1);

    protected abstract void addedToResult(Collection var1);

    private static final class Handle
    implements LookupListener {
        private final Class clazz;
        private Lookup.Result lookupResult = null;
        private Collection lastResult = null;
        private final Set<LookupManager> lms = Collections.newSetFromMap(new WeakHashMap(300));

        private Handle(Class clazz) {
            this.clazz = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(LookupManager lm) {
            Set<LookupManager> set = this.lms;
            synchronized (set) {
                this.lms.add(lm);
            }
        }

        private Lookup.Result getLookupResult() {
            if (this.lookupResult == null) {
                this.lookupResult = Lookup.getDefault().lookup(new Lookup.Template(this.clazz));
                this.lookupResult.addLookupListener((LookupListener)this);
            }
            return this.lookupResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent evt) {
            Handle handle = this;
            synchronized (handle) {
                Collection currentResult = this.getLookupResult().allInstances();
                final HashSet removed = new HashSet(this.lastResult);
                removed.removeAll(currentResult);
                final HashSet added = new HashSet(currentResult);
                added.removeAll(this.lastResult);
                this.lastResult = currentResult;
                CHANGES.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (!removed.isEmpty() || !added.isEmpty()) {
                            Set set = lms;
                            synchronized (set) {
                                for (LookupManager lm : lms) {
                                    if (!removed.isEmpty()) {
                                        lm.removedFromResult(removed);
                                    }
                                    if (added.isEmpty()) continue;
                                    lm.addedToResult(added);
                                }
                            }
                        }
                    }
                });
            }
        }

        public synchronized Collection getInstances() {
            if (this.lastResult == null) {
                this.lastResult = this.getLookupResult().allInstances();
            }
            return this.lastResult;
        }
    }
}

