/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.EditJarSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

class EditJarPanel
extends JPanel {
    private EditJarSupport.Item item;
    private AntProjectHelper helper;
    private JButton btnJavadoc;
    private JButton btnSource;
    private JLabel lblJar;
    private JLabel lblJavadoc;
    private JLabel lblSource;
    private JTextField txtJar;
    private JTextField txtJavadoc;
    private JTextField txtSource;

    private EditJarPanel() {
        this.initComponents();
    }

    EditJarPanel(EditJarSupport.Item item, AntProjectHelper helper) {
        this();
        this.item = item;
        this.helper = helper;
        this.txtJar.setText(EditJarPanel.stripOffVariableMarkup(item.getJarFile()));
        if (item.getSourceFile() != null) {
            this.txtSource.setText(EditJarPanel.stripOffJARContent(EditJarPanel.stripOffVariableMarkup(item.getSourceFile())));
        }
        if (item.getJavadocFile() != null) {
            this.txtJavadoc.setText(EditJarPanel.stripOffJARContent(EditJarPanel.stripOffVariableMarkup(item.getJavadocFile())));
        }
    }

    private static String stripOffVariableMarkup(String v) {
        if (!v.startsWith("${var.")) {
            return v;
        }
        int i = v.replace('\\', '/').indexOf(47);
        if (i == -1) {
            i = v.length();
        }
        return v.substring(6, i - 1) + v.substring(i);
    }

    private static String stripOffJARContent(String v) {
        int i = v.indexOf("!/");
        if (i == -1) {
            return v;
        }
        return v.substring(0, i);
    }

    private static Set<String> getVariableNames() {
        HashSet<String> names = new HashSet<String>();
        for (String v : PropertyUtils.getGlobalProperties().keySet()) {
            if (!v.startsWith("var.")) continue;
            names.add(v.substring(4));
        }
        return names;
    }

    private static String addVariableMarkup(String v) {
        int i = v.replace('\\', '/').indexOf(47);
        if (i == -1) {
            i = v.length();
        }
        String varName = v.substring(0, i);
        if (!EditJarPanel.getVariableNames().contains(varName)) {
            return v;
        }
        return "${var." + varName + "}" + v.substring(i);
    }

    private static String convertPath(AntProjectHelper helper, String path, boolean javadoc) {
        FileObject root;
        Object val = EditJarPanel.addVariableMarkup(path);
        String eval = helper.getStandardPropertyEvaluator().evaluate((String)val);
        if (eval == null) {
            return val;
        }
        FileObject fo = helper.resolveFileObject(eval);
        if (fo == null) {
            return val;
        }
        boolean archiveFile = false;
        if (FileUtil.isArchiveFile((FileObject)fo)) {
            FileObject afo = FileUtil.getArchiveRoot((FileObject)fo);
            if (afo == null) {
                Logger.getLogger(EditJarPanel.class.getName()).warning("Cannot open archive: " + FileUtil.getFileDisplayName((FileObject)fo));
                return val;
            }
            fo = afo;
            archiveFile = true;
        }
        if ((root = javadoc ? JavadocAndSourceRootDetection.findJavadocRoot((FileObject)fo) : JavadocAndSourceRootDetection.findSourceRoot((FileObject)fo)) != null) {
            if (FileUtil.isParentOf((FileObject)fo, (FileObject)root)) {
                if (archiveFile) {
                    val = (String)val + "!/";
                }
                val = (String)val + (((String)val).replace('\\', '/').endsWith("/") ? "" : File.separator);
                Object relPath = FileUtil.getRelativePath((FileObject)fo, (FileObject)root);
                assert (relPath != null) : "fo=" + fo + " root=" + root;
                if (((String)relPath).length() > 0) {
                    relPath = (String)relPath + "/";
                    if (!archiveFile) {
                        relPath = ((String)relPath).replace('/', File.separatorChar);
                    }
                    val = (String)val + (String)relPath;
                }
            } else if (FileUtil.isParentOf((FileObject)root, (FileObject)fo)) {
                File rootFile = FileUtil.toFile((FileObject)root);
                return rootFile != null ? EditJarPanel.addVariableMarkup(rootFile.getAbsolutePath()) : val;
            }
        }
        return val;
    }

    EditJarSupport.Item assignValues() {
        if (this.txtSource.getText() != null && this.txtSource.getText().trim().length() > 0) {
            this.item.setSourceFile(EditJarPanel.convertPath(this.helper, this.txtSource.getText().trim(), false));
        } else {
            this.item.setSourceFile(null);
        }
        if (this.txtJavadoc.getText() != null && this.txtJavadoc.getText().trim().length() > 0) {
            this.item.setJavadocFile(EditJarPanel.convertPath(this.helper, this.txtJavadoc.getText().trim(), true));
        } else {
            this.item.setJavadocFile(null);
        }
        return this.item;
    }

    private void initComponents() {
        this.lblJar = new JLabel();
        this.txtJar = new JTextField();
        this.lblJavadoc = new JLabel();
        this.txtJavadoc = new JTextField();
        this.btnJavadoc = new JButton();
        this.lblSource = new JLabel();
        this.txtSource = new JTextField();
        this.btnSource = new JButton();
        this.lblJar.setLabelFor(this.txtJar);
        Mnemonics.setLocalizedText((JLabel)this.lblJar, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblJar.text"));
        this.txtJar.setEditable(false);
        this.lblJavadoc.setLabelFor(this.txtJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.lblJavadoc, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblJavadoc.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnJavadoc, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.btnJavadoc.text"));
        this.btnJavadoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditJarPanel.this.btnJavadocActionPerformed(evt);
            }
        });
        this.lblSource.setLabelFor(this.txtSource);
        Mnemonics.setLocalizedText((JLabel)this.lblSource, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.lblSource.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSource, (String)NbBundle.getMessage(EditJarPanel.class, (String)"EditJarPanel.btnSource.text"));
        this.btnSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditJarPanel.this.btnSourceActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblJar).addComponent(this.lblJavadoc).addComponent(this.lblSource)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtSource, -1, 330, Short.MAX_VALUE).addComponent(this.txtJavadoc, -1, 330, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnSource).addComponent(this.btnJavadoc))).addComponent(this.txtJar, -1, 438, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJar).addComponent(this.txtJar, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJavadoc).addComponent(this.btnJavadoc).addComponent(this.txtJavadoc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSource).addComponent(this.btnSource).addComponent(this.txtSource, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.lblJar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJar"));
        this.txtJar.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJar"));
        this.lblJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJavadoc"));
        this.txtJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblJavadoc"));
        this.btnJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_btnJavadoc"));
        this.lblSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblSource"));
        this.txtSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_lblSource"));
        this.btnSource.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_btnSource"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditJarPanel.class, (String)"ACSD_EditJarPanel"));
    }

    private void btnJavadocActionPerformed(ActionEvent evt) {
        FileChooser chooser = this.helper.isSharableProject() ? new FileChooser(this.helper, true) : new FileChooser(FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), null);
        chooser.enableVariableBasedSelection(true);
        chooser.setFileHidingEnabled(false);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Bundle.LBL_Edit_Jar_Panel_browse());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter((FileFilter)new SimpleFileFilter("Javadoc Entry (folder, ZIP or JAR file)", new String[]{"ZIP", "JAR"}));
        File curDir = this.helper.resolveFile(this.helper.getStandardPropertyEvaluator().evaluate(this.item.getJarFile()));
        chooser.setCurrentDirectory(curDir);
        int option = chooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this));
        if (option == 0) {
            String[] files;
            try {
                files = chooser.getSelectedPaths();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            this.txtJavadoc.setText(chooser.getSelectedPathVariables() != null ? EditJarPanel.stripOffVariableMarkup(chooser.getSelectedPathVariables()[0]) : files[0]);
        }
    }

    private void btnSourceActionPerformed(ActionEvent evt) {
        FileChooser chooser = this.helper.isSharableProject() ? new FileChooser(this.helper, true) : new FileChooser(FileUtil.toFile((FileObject)this.helper.getProjectDirectory()), null);
        chooser.enableVariableBasedSelection(true);
        chooser.setFileHidingEnabled(false);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Bundle.LBL_Edit_Jar_Panel_browse());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter((FileFilter)new SimpleFileFilter("Source Entry (folder, ZIP or JAR file)", new String[]{"ZIP", "JAR"}));
        File curDir = this.helper.resolveFile(this.helper.getStandardPropertyEvaluator().evaluate(this.item.getJarFile()));
        chooser.setCurrentDirectory(curDir);
        int option = chooser.showOpenDialog((Component)SwingUtilities.getWindowAncestor(this));
        if (option == 0) {
            String[] files;
            try {
                files = chooser.getSelectedPaths();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            this.txtSource.setText(chooser.getSelectedPathVariables() != null ? EditJarPanel.stripOffVariableMarkup(chooser.getSelectedPathVariables()[0]) : files[0]);
        }
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            int index = name.lastIndexOf(46);
            if (index <= 0 || index == name.length() - 1) {
                return false;
            }
            String extension = name.substring(index + 1).toUpperCase();
            return this.extensions.contains(extension);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

