/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.netbeans.modules.bugtracking.commons.Util;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ListValuePicker
extends JPanel {
    private JLabel messageLabel;
    private JScrollPane scrollPane;
    private JLabel valuesLabel;
    private JList valuesList;

    public static String getValues(String title, String label, String message, String valuesString, List<String> knownValues) {
        ArrayList<ListValue> lv = new ArrayList<ListValue>(knownValues.size());
        for (String s : knownValues) {
            lv.add(new ListValue(s, s));
        }
        return ListValuePicker.getValues(title, label, message, valuesString, lv.toArray(new ListValue[0]));
    }

    public static String getValues(String title, String label, String message, String valuesString, ListValue[] knownValues) {
        String[] values = valuesString.split(",");
        if (values == null || values.length == 0) {
            return null;
        }
        ListValuePicker vp = new ListValuePicker(label, message, knownValues, values);
        if (Util.show(vp, title, NbBundle.getMessage(ListValuePicker.class, (String)"LBL_Ok"))) {
            values = vp.getSelectedValues();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                String s = values[i];
                sb.append(s);
                if (i >= values.length - 1) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
        return valuesString;
    }

    private ListValuePicker(String label, String message, ListValue[] knownValues, String[] toSelect) {
        int idx;
        this.initComponents();
        this.messageLabel.setText(message);
        Mnemonics.setLocalizedText((JLabel)this.valuesLabel, (String)label);
        this.valuesList.setCellRenderer(new ListValueRenderer());
        DefaultListModel<ListValue> model = new DefaultListModel<ListValue>();
        for (ListValue lvalue : knownValues) {
            model.addElement(lvalue);
        }
        this.valuesList.setModel(model);
        int[] selection = new int[toSelect.length];
        for (int i = 0; i < toSelect.length; ++i) {
            String s = toSelect[i];
            int idx2 = this.getIndex(model, s = s.trim());
            if (idx2 == -1) {
                idx2 = this.getIndex(model, s.toUpperCase());
            }
            if (idx2 == -1) {
                idx2 = this.getIndex(model, s.toLowerCase());
            }
            selection[i] = idx2;
        }
        this.valuesList.setSelectedIndices(selection);
        int n = idx = selection.length > 0 ? selection[0] : -1;
        if (idx > -1) {
            this.valuesList.scrollRectToVisible(this.valuesList.getCellBounds(idx, idx));
        }
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.valuesList = new JList();
        this.messageLabel = new JLabel();
        this.valuesLabel = new JLabel();
        this.scrollPane.setViewportView(this.valuesList);
        this.valuesList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListValuePicker.class, (String)"ListValuePicker.valuesList.AccessibleContext.accessibleDescription"));
        this.valuesLabel.setLabelFor(this.valuesList);
        this.valuesLabel.setText(NbBundle.getMessage(ListValuePicker.class, (String)"ListValuePicker.valuesLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.valuesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 501, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane).addGroup(layout.createSequentialGroup().addComponent(this.valuesLabel).addGap(0, 0, Short.MAX_VALUE)))));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ListValuePicker.class, (String)"ListValuePicker.AccessibleContext.accessibleDescription"));
    }

    private String[] getSelectedValues() {
        Object[] values = this.valuesList.getSelectedValues();
        String[] ret = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            ret[i] = ((ListValue)values[i]).value;
        }
        return ret;
    }

    private int getIndex(DefaultListModel model, String s) {
        for (int i = 0; i < model.getSize(); ++i) {
            ListValue e = (ListValue)model.getElementAt(i);
            if (!e.value.equals(s)) continue;
            return i;
        }
        return -1;
    }

    public static class ListValue {
        private String displayValue;
        private String value;

        public ListValue(String displayValue, String value) {
            this.displayValue = displayValue;
            this.value = value;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ListValue other = (ListValue)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    private class ListValueRenderer
    extends DefaultListCellRenderer {
        private ListValueRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ListValue) {
                ListValue lv = (ListValue)value;
                return super.getListCellRendererComponent((JList<?>)list, lv.displayValue, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

