/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.texttools;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.texttools.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

@TopComponent.Description(preferredID="TextToolsTopComponent", iconBase="org/netbeans/modules/texttools/accessories-text-editor.png", persistenceType=1)
public final class TextToolsTopComponent
extends TopComponent {
    private static final Logger LOG = Logger.getLogger(TextToolsTopComponent.class.getName());
    private static File lastSelectedDir = null;
    private JPanel buttonPanel;
    private JButton convertButton;
    private JMenuItem convertFromFile;
    private JMenuItem convertFromToFile;
    private JMenuItem convertToFile;
    private JLabel encodingLabel;
    private JComboBox<Charset> encodingSelector;
    private JScrollPane errorScrollPane;
    private JTextArea errorTextPane;
    private JButton fileButton;
    private JPopupMenu fileMenu;
    private JPanel inputPanel;
    private JScrollPane inputScrollPane;
    private JTextArea inputTextPane;
    private JSplitPane jSplitPane1;
    private JLabel lineFeedLabel;
    private JComboBox<String> lineFeedSelector;
    private JPanel outputPanel;
    private JScrollPane outputScrollPane;
    private JTextArea outputTextPane;
    private JLabel pipelineLabel;
    private JComboBox<String> pipelineSelector;
    private JLabel typeLabel;
    private JComboBox<String> typeSelector;

    public TextToolsTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_TextToolsTopComponent());
        this.setToolTipText(Bundle.HINT_TextToolsTopComponent());
        ((CardLayout)this.outputPanel.getLayout()).show(this.outputPanel, "outputScrollPane");
        this.encodingSelector.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Charset) {
                    Charset charset = (Charset)value;
                    return super.getListCellRendererComponent(list, charset.displayName(), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        for (Charset cs : Charset.availableCharsets().values()) {
            this.encodingSelector.addItem(cs);
        }
        this.encodingSelector.setSelectedItem(StandardCharsets.UTF_8);
        this.pipelineSelector.addActionListener(ae -> this.pipeChanged());
        Font currentFont = this.inputTextPane.getFont();
        this.inputTextPane.setFont(new Font("Monospaced", 0, currentFont.getSize()));
        this.outputTextPane.setFont(new Font("Monospaced", 0, currentFont.getSize()));
        this.errorTextPane.setFont(new Font("Monospaced", 0, currentFont.getSize()));
        this.pipeChanged();
    }

    private void pipeChanged() {
        GridBagConstraints gbc = ((GridBagLayout)this.getLayout()).getConstraints(this.buttonPanel);
        this.convertToFile.setVisible(true);
        this.convertFromFile.setVisible(true);
        this.convertFromToFile.setVisible(true);
        this.fileButton.setVisible(true);
        switch (this.pipelineSelector.getSelectedIndex()) {
            case 0: {
                this.encodingLabel.setText("Input-Encoding:");
                this.lineFeedSelector.setVisible(true);
                this.lineFeedLabel.setVisible(true);
                this.typeLabel.setVisible(true);
                this.typeSelector.setVisible(true);
                this.convertToFile.setVisible(false);
                gbc.gridy = 3;
                break;
            }
            case 1: {
                this.encodingLabel.setText("Output-Encoding:");
                this.lineFeedSelector.setVisible(false);
                this.lineFeedLabel.setVisible(false);
                this.typeLabel.setVisible(true);
                this.typeSelector.setVisible(true);
                this.convertFromFile.setVisible(false);
                gbc.gridy = 3;
                break;
            }
            case 2: {
                this.encodingLabel.setText("Encoding:");
                this.lineFeedSelector.setVisible(true);
                this.lineFeedLabel.setVisible(true);
                this.typeLabel.setVisible(false);
                this.typeSelector.setVisible(false);
                this.fileButton.setVisible(false);
                gbc.gridy = 3;
                break;
            }
            case 3: {
                this.encodingLabel.setText("Encoding:");
                this.lineFeedSelector.setVisible(false);
                this.lineFeedLabel.setVisible(false);
                this.typeLabel.setVisible(false);
                this.typeSelector.setVisible(false);
                this.fileButton.setVisible(false);
                gbc.gridy = 2;
                break;
            }
            case 4: {
                this.encodingLabel.setText("Encoding:");
                this.lineFeedSelector.setVisible(true);
                this.lineFeedLabel.setVisible(true);
                this.typeLabel.setVisible(false);
                this.typeSelector.setVisible(false);
                this.fileButton.setVisible(false);
                gbc.gridy = 3;
                break;
            }
            case 5: {
                this.encodingLabel.setText("Encoding:");
                this.lineFeedSelector.setVisible(false);
                this.lineFeedLabel.setVisible(false);
                this.typeLabel.setVisible(false);
                this.typeSelector.setVisible(false);
                this.fileButton.setVisible(false);
                gbc.gridy = 2;
            }
        }
        ((GridBagLayout)this.getLayout()).setConstraints(this.buttonPanel, gbc);
        this.revalidate();
    }

    private void initComponents() {
        this.fileMenu = new JPopupMenu();
        this.convertFromFile = new JMenuItem();
        this.convertToFile = new JMenuItem();
        this.convertFromToFile = new JMenuItem();
        this.pipelineLabel = new JLabel();
        this.pipelineSelector = new JComboBox();
        this.jSplitPane1 = new JSplitPane();
        this.inputPanel = new JPanel();
        this.inputScrollPane = new JScrollPane();
        this.inputTextPane = new JTextArea();
        this.outputPanel = new JPanel();
        this.errorScrollPane = new JScrollPane();
        this.errorTextPane = new JTextArea();
        this.outputScrollPane = new JScrollPane();
        this.outputTextPane = new JTextArea();
        this.encodingLabel = new JLabel();
        this.encodingSelector = new JComboBox();
        this.typeSelector = new JComboBox();
        this.typeLabel = new JLabel();
        this.lineFeedLabel = new JLabel();
        this.lineFeedSelector = new JComboBox();
        this.buttonPanel = new JPanel();
        this.fileButton = new JButton();
        this.convertButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.convertFromFile, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.convertFromFile.text"));
        this.convertFromFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextToolsTopComponent.this.convertFromFileActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.convertFromFile);
        Mnemonics.setLocalizedText((AbstractButton)this.convertToFile, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.convertToFile.text"));
        this.convertToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextToolsTopComponent.this.convertToFileActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.convertToFile);
        Mnemonics.setLocalizedText((AbstractButton)this.convertFromToFile, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.convertFromToFile.text"));
        this.convertFromToFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextToolsTopComponent.this.convertFromToFileActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.convertFromToFile);
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.pipelineLabel, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.pipelineLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.pipelineLabel, gridBagConstraints);
        this.pipelineSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Base64 Encoder", "Base64 Decoder", "URLEncoder", "URLDecoder", "Hex Encoder", "Hex Decoder"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.pipelineSelector, gridBagConstraints);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.jSplitPane1.setPreferredSize(new Dimension(320, 27));
        this.inputPanel.setLayout(new BorderLayout());
        this.inputTextPane.setColumns(20);
        this.inputTextPane.setRows(5);
        this.inputScrollPane.setViewportView(this.inputTextPane);
        this.inputPanel.add((Component)this.inputScrollPane, "Center");
        this.jSplitPane1.setLeftComponent(this.inputPanel);
        this.outputPanel.setLayout(new CardLayout());
        this.errorTextPane.setForeground(new Color(255, 0, 51));
        this.errorTextPane.setLineWrap(true);
        this.errorTextPane.setWrapStyleWord(true);
        this.errorScrollPane.setViewportView(this.errorTextPane);
        this.outputPanel.add((Component)this.errorScrollPane, "errorScrollPane");
        this.outputTextPane.setFont(new Font("Monospaced", 0, 12));
        this.outputTextPane.setLineWrap(true);
        this.outputScrollPane.setViewportView(this.outputTextPane);
        this.outputPanel.add((Component)this.outputScrollPane, "outputScrollPane");
        this.jSplitPane1.setRightComponent(this.outputPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.jSplitPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.encodingLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.encodingLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.encodingSelector, gridBagConstraints);
        this.typeSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Basic", "URL and Filename safe", "MIME"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.typeSelector, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.typeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.typeLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.lineFeedLabel, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.lineFeedLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.add(this.lineFeedLabel, gridBagConstraints);
        this.lineFeedSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Unix, Linux, Android, macOS", "Windows, DOS, OS/2", "Mac OS Classic"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.lineFeedSelector, gridBagConstraints);
        this.buttonPanel.setOpaque(false);
        FlowLayout flowLayout1 = new FlowLayout(4, 5, 0);
        flowLayout1.setAlignOnBaseline(true);
        this.buttonPanel.setLayout(flowLayout1);
        Mnemonics.setLocalizedText((AbstractButton)this.fileButton, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.fileButton.text"));
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextToolsTopComponent.this.fileButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.fileButton);
        Mnemonics.setLocalizedText((AbstractButton)this.convertButton, (String)NbBundle.getMessage(TextToolsTopComponent.class, (String)"TextToolsTopComponent.convertButton.text"));
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextToolsTopComponent.this.convertButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.convertButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        this.add(this.buttonPanel, gridBagConstraints);
    }

    private void convertButtonActionPerformed(ActionEvent evt) {
        this.errorTextPane.setText("");
        this.outputTextPane.setText("");
        ((CardLayout)this.outputPanel.getLayout()).show(this.outputPanel, "outputScrollPane");
        try {
            Charset cs = (Charset)this.encodingSelector.getSelectedItem();
            String outputText = "";
            if (this.pipelineSelector.getSelectedIndex() == 0) {
                String inputText = this.inputTextPane.getText().replace("\n", this.getChosenLineFeed());
                switch (this.typeSelector.getSelectedIndex()) {
                    case 0: {
                        outputText = Base64.getEncoder().encodeToString(inputText.getBytes(cs));
                        break;
                    }
                    case 1: {
                        outputText = Base64.getUrlEncoder().encodeToString(inputText.getBytes(cs));
                        break;
                    }
                    case 2: {
                        outputText = Base64.getMimeEncoder().encodeToString(inputText.getBytes(cs));
                    }
                }
            } else if (this.pipelineSelector.getSelectedIndex() == 1) {
                String inputText = this.inputTextPane.getText();
                switch (this.typeSelector.getSelectedIndex()) {
                    case 0: {
                        outputText = new String(Base64.getDecoder().decode(inputText), cs);
                        break;
                    }
                    case 1: {
                        outputText = new String(Base64.getUrlDecoder().decode(inputText.getBytes(cs)), cs);
                        break;
                    }
                    case 2: {
                        outputText = new String(Base64.getMimeDecoder().decode(inputText.getBytes(cs)), cs);
                    }
                }
            } else if (this.pipelineSelector.getSelectedIndex() == 2) {
                String inputText = this.inputTextPane.getText().replace("\n", this.getChosenLineFeed());
                outputText = URLEncoder.encode(inputText, cs.name());
            } else if (this.pipelineSelector.getSelectedIndex() == 3) {
                String inputText = this.inputTextPane.getText();
                outputText = URLDecoder.decode(inputText, cs.name());
            } else if (this.pipelineSelector.getSelectedIndex() == 4) {
                String inputText = this.inputTextPane.getText().replace("\n", this.getChosenLineFeed());
                byte[] inputData = inputText.getBytes(cs);
                StringBuilder sb = new StringBuilder(inputData.length * 2);
                for (int i = 0; i < inputData.length; ++i) {
                    byte inputByte = inputData[i];
                    sb.append(String.format("%02X", inputByte));
                }
                outputText = sb.toString();
            } else if (this.pipelineSelector.getSelectedIndex() == 5) {
                String inputText = this.inputTextPane.getText();
                if (inputText.length() % 2 != 0) {
                    throw new IllegalArgumentException("Length of input must even");
                }
                byte[] outputData = new byte[inputText.length()];
                for (int i = 0; i < inputText.length(); i += 2) {
                    outputData[i / 2] = (byte)Integer.parseInt(inputText.substring(i, i + 2), 16);
                }
                outputText = new String(outputData, cs);
            }
            this.outputTextPane.setText(outputText);
        }
        catch (UnsupportedEncodingException | RuntimeException ex) {
            this.errorTextPane.setText(ex.getMessage());
            ((CardLayout)this.outputPanel.getLayout()).show(this.outputPanel, "errorScrollPane");
        }
    }

    private void convertFromFileActionPerformed(ActionEvent evt) {
        this.outputTextPane.setText("");
        this.errorTextPane.setText("");
        ((CardLayout)this.outputPanel.getLayout()).show(this.outputPanel, "outputScrollPane");
        File targetFile = this.queryOpenFile();
        if (targetFile != null) {
            try (FileInputStream fos = new FileInputStream(targetFile);){
                int read;
                OutputStream os;
                ByteArrayOutputStream baos = new ByteArrayOutputStream((int)targetFile.length() * 2);
                switch (this.typeSelector.getSelectedIndex()) {
                    default: {
                        if (targetFile.length() > 131072L) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "File is larger than 128kB - please use the 'From/to file' option");
                            return;
                        }
                        os = Base64.getEncoder().wrap(baos);
                        break;
                    }
                    case 1: {
                        if (targetFile.length() > 131072L) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "File is larger than 128kB - please use the 'From/to file' option");
                            return;
                        }
                        os = Base64.getUrlEncoder().wrap(baos);
                        break;
                    }
                    case 2: {
                        if (targetFile.length() > 524288L) {
                            JOptionPane.showMessageDialog((Component)((Object)this), "File is larger than 128kB - please use the 'From/to file' option");
                            return;
                        }
                        os = Base64.getMimeEncoder().wrap(baos);
                    }
                }
                byte[] buffer = new byte[1024];
                while ((read = fos.read(buffer)) >= 0) {
                    os.write(buffer, 0, read);
                }
                this.outputTextPane.setText(baos.toString(StandardCharsets.ISO_8859_1.name()));
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Failed to write file", ex);
                this.errorTextPane.setText(ex.getMessage());
                ((CardLayout)this.outputPanel.getLayout()).show(this.outputPanel, "errorScrollPane");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void convertToFileActionPerformed(ActionEvent evt) {
        this.outputTextPane.setText("");
        this.errorTextPane.setText("");
        ((CardLayout)this.outputPanel.getLayout()).show(this.outputPanel, "outputScrollPane");
        File targetFile = this.querySaveFile();
        if (targetFile == null) return;
        try (FileOutputStream fos = new FileOutputStream(targetFile);){
            String inputText = this.inputTextPane.getText();
            switch (this.typeSelector.getSelectedIndex()) {
                case 0: {
                    fos.write(Base64.getDecoder().decode(inputText));
                    return;
                }
                case 1: {
                    fos.write(Base64.getUrlDecoder().decode(inputText));
                    return;
                }
                case 2: {
                    fos.write(Base64.getMimeDecoder().decode(inputText));
                    return;
                }
            }
            return;
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Failed to write file", ex);
            this.errorTextPane.setText(ex.getMessage());
            ((CardLayout)this.outputPanel.getLayout()).show(this.outputPanel, "errorScrollPane");
        }
    }

    private File querySaveFile() throws HeadlessException {
        JFileChooser jfc = new JFileChooser();
        jfc.setCurrentDirectory(lastSelectedDir);
        int result = jfc.showSaveDialog(jfc);
        if (result == 0) {
            int confirmResult;
            File selectedFile = jfc.getSelectedFile();
            if (selectedFile.exists() && (confirmResult = JOptionPane.showConfirmDialog((Component)((Object)this), "File\n" + selectedFile.getAbsolutePath() + "\nalready exists. Overwrite?", "Overwrite file?", 2)) != 0) {
                return null;
            }
            lastSelectedDir = jfc.getCurrentDirectory();
            return selectedFile;
        }
        return null;
    }

    private File queryOpenFile() throws HeadlessException {
        JFileChooser jfc = new JFileChooser();
        jfc.setCurrentDirectory(lastSelectedDir);
        int result = jfc.showOpenDialog(jfc);
        if (result == 0) {
            File selectedFile = jfc.getSelectedFile();
            lastSelectedDir = jfc.getCurrentDirectory();
            if (!selectedFile.exists()) {
                return null;
            }
            return selectedFile;
        }
        return null;
    }

    private void convertFromToFileActionPerformed(ActionEvent evt) {
        this.outputTextPane.setText("");
        this.errorTextPane.setText("");
        ((CardLayout)this.outputPanel.getLayout()).show(this.outputPanel, "outputScrollPane");
        final File sourceFile = this.queryOpenFile();
        if (sourceFile == null || !sourceFile.exists()) {
            return;
        }
        final File targetFile = this.querySaveFile();
        if (targetFile == null) {
            return;
        }
        final AtomicBoolean canceled = new AtomicBoolean();
        final ProgressHandle handle = ProgressHandle.createHandle((String)"Encoding file", () -> {
            canceled.set(true);
            return true;
        });
        new SwingWorker<Object, long[]>(){

            @Override
            protected Object doInBackground() throws Exception {
                long total = sourceFile.length();
                this.publish((V[])new long[][]{{total, -1L}});
                try (FileInputStream fis = new FileInputStream(sourceFile);
                     FileOutputStream fos = new FileOutputStream(targetFile);){
                    if (TextToolsTopComponent.this.pipelineSelector.getSelectedIndex() == 0) {
                        TextToolsTopComponent.this.transfer(fis, switch (TextToolsTopComponent.this.typeSelector.getSelectedIndex()) {
                            case 0 -> Base64.getEncoder().wrap(fos);
                            case 1 -> Base64.getUrlEncoder().wrap(fos);
                            case 2 -> Base64.getMimeEncoder().wrap(fos);
                            default -> throw new IOException("Invalid conversation: " + TextToolsTopComponent.this.typeSelector.getSelectedIndex() + " / " + TextToolsTopComponent.this.typeSelector.getSelectedItem());
                        }, canceled, i -> this.publish((V[])new long[][]{{total, i}}));
                    } else if (TextToolsTopComponent.this.pipelineSelector.getSelectedIndex() == 1) {
                        TextToolsTopComponent.this.transfer(switch (TextToolsTopComponent.this.typeSelector.getSelectedIndex()) {
                            case 0 -> Base64.getDecoder().wrap(fis);
                            case 1 -> Base64.getUrlDecoder().wrap(fis);
                            case 2 -> Base64.getMimeDecoder().wrap(fis);
                            default -> throw new IOException("Invalid conversation: " + TextToolsTopComponent.this.typeSelector.getSelectedIndex() + " / " + TextToolsTopComponent.this.typeSelector.getSelectedItem());
                        }, fos, canceled, i -> this.publish((V[])new long[][]{{total, i}}));
                    }
                }
                return null;
            }

            @Override
            protected void process(List<long[]> list) {
                int val2;
                int val1;
                long[] lastElement = list.get(list.size() - 1);
                if (Long.compare(lastElement[0], Integer.MAX_VALUE) > 0) {
                    val1 = (int)(lastElement[0] / 1000L);
                    val2 = (int)(lastElement[1] / 1000L);
                } else {
                    val1 = (int)lastElement[0];
                    val2 = (int)lastElement[1];
                }
                handle.switchToDeterminate(val1);
                handle.progress(val2);
            }

            @Override
            protected void done() {
                handle.finish();
                try {
                    this.get();
                }
                catch (InterruptedException | RuntimeException | ExecutionException ex) {
                    LOG.log(Level.WARNING, "Failed to write file", ex);
                    TextToolsTopComponent.this.errorTextPane.setText(ex.getMessage());
                    ((CardLayout)TextToolsTopComponent.this.outputPanel.getLayout()).show(TextToolsTopComponent.this.outputPanel, "errorScrollPane");
                }
            }
        }.execute();
        handle.start();
        handle.switchToIndeterminate();
    }

    private void transfer(InputStream fis, OutputStream os, AtomicBoolean canceled, Consumer<Long> progressListener) throws IOException {
        int read;
        byte[] buffer = new byte[262144];
        long offset = 0L;
        while ((read = fis.read(buffer)) >= 0 && !canceled.get()) {
            os.write(buffer, 0, read);
            offset += (long)read;
            if (progressListener == null) continue;
            progressListener.accept(offset);
        }
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        this.fileMenu.show(this.fileButton, 0, this.fileButton.getHeight());
    }

    private String getChosenLineFeed() {
        switch (this.lineFeedSelector.getSelectedIndex()) {
            default: {
                return "\n";
            }
            case 1: {
                return "\r\n";
            }
            case 2: 
        }
        return "\r";
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        switch (this.pipelineSelector.getSelectedIndex()) {
            case 0: {
                p.setProperty("pipeline", "base64encoder");
                break;
            }
            case 1: {
                p.setProperty("pipeline", "base64decoder");
                break;
            }
            case 2: {
                p.setProperty("pipeline", "urlEncoder");
                break;
            }
            case 3: {
                p.setProperty("pipeline", "urlDecoder");
                break;
            }
            case 4: {
                p.setProperty("pipeline", "hexEncoder");
                break;
            }
            case 5: {
                p.setProperty("pipeline", "hexDecoder");
            }
        }
        p.setProperty("encoding", ((Charset)this.encodingSelector.getSelectedItem()).name());
        switch (this.lineFeedSelector.getSelectedIndex()) {
            case 0: {
                p.setProperty("linefeed", "unix");
                break;
            }
            case 1: {
                p.setProperty("linefeed", "windows");
                break;
            }
            case 2: {
                p.setProperty("linefeed", "mac");
            }
        }
        switch (this.typeSelector.getSelectedIndex()) {
            case 0: {
                p.setProperty("base64Type", "basic");
                break;
            }
            case 1: {
                p.setProperty("base64Type", "url");
                break;
            }
            case 2: {
                p.setProperty("base64Type", "mime");
            }
        }
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        if ("1.0".equals(version)) {
            switch (p.getProperty("pipeline", "")) {
                case "base64encoder": {
                    this.pipelineSelector.setSelectedIndex(0);
                    break;
                }
                case "base64decoder": {
                    this.pipelineSelector.setSelectedIndex(1);
                    break;
                }
                case "urlEncoder": {
                    this.pipelineSelector.setSelectedIndex(2);
                    break;
                }
                case "urlDecoder": {
                    this.pipelineSelector.setSelectedIndex(3);
                    break;
                }
                case "hexEncoder": {
                    this.pipelineSelector.setSelectedIndex(4);
                    break;
                }
                case "hexDecoder": {
                    this.pipelineSelector.setSelectedIndex(5);
                    break;
                }
                default: {
                    this.pipelineSelector.setSelectedIndex(0);
                }
            }
            String encoding = p.getProperty("encoding");
            if (encoding != null && Charset.isSupported(encoding)) {
                this.encodingSelector.setSelectedItem(Charset.forName(encoding));
            }
            switch (p.getProperty("linefeed")) {
                case "unix": {
                    this.lineFeedSelector.setSelectedIndex(0);
                    break;
                }
                case "windows": {
                    this.lineFeedSelector.setSelectedIndex(1);
                    break;
                }
                case "mac": {
                    this.lineFeedSelector.setSelectedIndex(2);
                    break;
                }
                default: {
                    this.lineFeedSelector.setSelectedIndex(0);
                }
            }
            switch (p.getProperty("base64Type")) {
                case "basic": {
                    this.typeSelector.setSelectedIndex(0);
                    break;
                }
                case "url": {
                    this.typeSelector.setSelectedIndex(1);
                    break;
                }
                case "mime": {
                    this.typeSelector.setSelectedIndex(2);
                    break;
                }
                default: {
                    this.typeSelector.setSelectedIndex(0);
                }
            }
        }
    }

    public static class OpenAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent ev) {
            TextToolsTopComponent tttc = new TextToolsTopComponent();
            tttc.open();
            Mode output = WindowManager.getDefault().findMode("output");
            if (output != null) {
                output.dockInto((TopComponent)tttc);
            }
            tttc.requestActive();
        }
    }
}

