/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.Authentication;
import org.netbeans.modules.nativeexecution.support.Logger;

public final class JschSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();

    private JschSupport() {
    }

    public static ChannelStreams startCommand(final ExecutionEnvironment env, final String command, final ChannelParams params) throws IOException, JSchException, InterruptedException {
        JSchWorker<ChannelStreams> worker = new JSchWorker<ChannelStreams>(){

            @Override
            public ChannelStreams call() throws JSchException, IOException, InterruptedException {
                ChannelExec echannel = (ChannelExec)ConnectionManagerAccessor.getDefault().openAndAcquireChannel(env, "exec", true);
                if (echannel == null) {
                    throw new IOException("Cannot open exec channel on " + env + " for " + command);
                }
                echannel.setCommand(command);
                echannel.setXForwarding(params == null ? false : params.x11forward);
                InputStream is = echannel.getInputStream();
                InputStream es = echannel.getErrStream();
                ProtectedOutputStream os = new ProtectedOutputStream(echannel, echannel.getOutputStream());
                Authentication auth = Authentication.getFor(env);
                echannel.connect(auth.getTimeout() * 1000);
                return new ChannelStreams((Channel)echannel, is, es, os);
            }

            public String toString() {
                return command;
            }
        };
        return JschSupport.start(worker, env, 2);
    }

    public static ChannelStreams startLoginShellSession(final ExecutionEnvironment env) throws IOException, JSchException, InterruptedException {
        JSchWorker<ChannelStreams> worker = new JSchWorker<ChannelStreams>(){

            @Override
            public ChannelStreams call() throws InterruptedException, JSchException, IOException {
                ChannelShell shell = (ChannelShell)ConnectionManagerAccessor.getDefault().openAndAcquireChannel(env, "shell", true);
                if (shell == null) {
                    throw new IOException("Cannot open shell channel on " + env);
                }
                shell.setPty(false);
                InputStream is = shell.getInputStream();
                ByteArrayInputStream es = new ByteArrayInputStream(new byte[0]);
                OutputStream os = shell.getOutputStream();
                Authentication auth = Authentication.getFor(env);
                shell.connect(auth.getTimeout() * 1000);
                return new ChannelStreams((Channel)shell, is, es, os);
            }

            public String toString() {
                return "shell session for " + env.getDisplayName();
            }
        };
        return JschSupport.start(worker, env, 2);
    }

    private static synchronized ChannelStreams start(JSchWorker<ChannelStreams> worker, ExecutionEnvironment env, int attempts) throws IOException, JSchException, InterruptedException {
        int retry = attempts;
        while (retry-- > 0) {
            try {
                return worker.call();
            }
            catch (JSchException ex) {
                String message = ex.getMessage();
                Throwable cause = ex.getCause();
                if (cause instanceof NullPointerException) {
                    log.log(Level.INFO, "JSch exception opening channel to " + env + ". Retrying", ex);
                    continue;
                }
                if ("java.io.InterruptedIOException".equals(message)) {
                    log.log(Level.INFO, "JSch exception opening channel to " + env + ". Retrying in 0.5 seconds", ex);
                    try {
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException ex1) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                if ("channel is not opened.".equals(message)) {
                    log.log(Level.INFO, "JSch exception opening channel to " + env + ". Reconnecting and retrying", ex);
                    ConnectionManagerAccessor.getDefault().reconnect(env);
                    continue;
                }
                throw ex;
            }
            catch (NullPointerException npe) {
                log.log(Level.FINE, "Exception from JSch", npe);
            }
        }
        throw new IOException("Failed to execute " + worker.toString());
    }

    public static final class ChannelParams {
        private boolean x11forward = false;

        public void setX11Forwarding(boolean forward) {
            this.x11forward = forward;
        }
    }

    private static interface JSchWorker<T> {
        public T call() throws InterruptedException, IOException, JSchException;
    }

    public static final class ChannelStreams {
        public final InputStream out;
        public final InputStream err;
        public final OutputStream in;
        public final Channel channel;

        public ChannelStreams(Channel channel, InputStream out, InputStream err, OutputStream in) {
            this.channel = channel;
            this.out = out;
            this.err = err;
            this.in = in;
        }
    }

    private static class ProtectedOutputStream
    extends OutputStream {
        private final ChannelExec channel;
        private final OutputStream stream;

        private ProtectedOutputStream(ChannelExec channel, OutputStream stream) {
            this.stream = stream;
            this.channel = channel;
        }

        @Override
        public void write(int b) throws IOException {
            this.checkAlive();
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.checkAlive();
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.checkAlive();
            this.stream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.checkAlive();
            this.stream.flush();
        }

        @Override
        public void close() throws IOException {
            if (!this.channel.isConnected()) {
                return;
            }
            this.stream.close();
        }

        private void checkAlive() throws IOException {
            if (!this.channel.isConnected()) {
                throw new IOException("Channel is already closed");
            }
        }
    }
}

