/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.SessionMethodController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class EjbMethodController {
    public static EjbMethodController createFromClass(FileObject ejbClassFO, final String className) {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)ejbClassFO);
        if (ejbModule == null) {
            return null;
        }
        AbstractMethodController controller = null;
        try {
            MetadataModel model = ejbModule.getMetadataModel();
            EjbType ejbType = (EjbType)((Object)model.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, EjbType>(){

                public EjbType run(EjbJarMetadata metadata) throws Exception {
                    Ejb ejb = metadata.findByEjbClass(className);
                    if (ejb == null) {
                        return EjbType.ERROR;
                    }
                    if (ejb instanceof Session) {
                        return EjbType.SESSION;
                    }
                    if (ejb instanceof Entity) {
                        return EjbType.ENTITY;
                    }
                    return EjbType.ERROR;
                }
            }));
            if (ejbType == EjbType.SESSION) {
                boolean allowsNoInterface = false;
                Project project = FileOwnerQuery.getOwner((FileObject)ejbClassFO);
                if (project != null) {
                    J2eeProjectCapabilities projectCap = J2eeProjectCapabilities.forProject((Project)project);
                    boolean bl = allowsNoInterface = projectCap != null && (projectCap.isEjb31LiteSupported() || projectCap.isEjb40LiteSupported());
                }
                if (!((controller = new SessionMethodController(className, (MetadataModel<EjbJarMetadata>)model, allowsNoInterface)).allowsNoInterface() || ((EjbMethodController)controller).hasLocal() || ((EjbMethodController)controller).hasRemote())) {
                    controller = null;
                }
            } else if (ejbType == EjbType.ENTITY) {
                controller = new EntityMethodController(className, (MetadataModel<EjbJarMetadata>)model);
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return controller;
    }

    public abstract List getImplementation(MethodModel var1);

    public abstract MethodModel getPrimaryImplementation(MethodModel var1);

    public abstract boolean hasJavaImplementation(MethodModel var1);

    public abstract boolean hasJavaImplementation(MethodType var1);

    public abstract ClassMethodPair getInterface(MethodModel var1, boolean var2);

    public abstract boolean hasMethodInInterface(MethodModel var1, MethodType var2, boolean var3);

    public abstract MethodType getMethodTypeFromInterface(MethodModel var1);

    public abstract MethodType getMethodTypeFromImpl(MethodModel var1);

    public abstract String getBeanClass();

    public abstract String getLocal();

    public abstract String getRemote();

    public abstract Collection<String> getLocalInterfaces();

    public abstract Collection<String> getRemoteInterfaces();

    public abstract boolean hasLocal();

    public abstract boolean hasRemote();

    public boolean allowsNoInterface() {
        return false;
    }

    public void addEjbQl(MethodModel clientView, String ejbql, FileObject ddFileObject) throws IOException {
        assert (false) : "ejbql not supported for this bean type";
    }

    public String createDefaultQL(MethodModel methodModel) {
        return null;
    }

    public abstract void createAndAddInterface(MethodModel var1, boolean var2);

    public abstract void createAndAddImpl(MethodModel var1);

    public abstract void delete(MethodModel var1);

    public abstract void delete(MethodModel var1, boolean var2);

    public abstract boolean supportsMethodType(MethodType.Kind var1);

    public abstract MethodModel createAndAdd(MethodModel var1, boolean var2, boolean var3);

    private static enum EjbType {
        SESSION,
        ENTITY,
        ERROR;

    }

    protected static final class ClassMethodPair {
        private final String className;
        private final MethodModel methodModel;

        public ClassMethodPair(String className, MethodModel methodModel) {
            this.className = className;
            this.methodModel = methodModel;
        }

        public String getClassName() {
            return this.className;
        }

        public MethodModel getMethodModel() {
            return this.methodModel;
        }
    }
}

