/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.ReformatTask;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;

public class Formatter
implements ReformatTask {
    private static final Logger LOG = Logger.getLogger(Formatter.class.getName());
    private final Context ctx;
    private final LSPBindings server;
    private final ReformatKind kind;

    public Formatter(Context ctx, LSPBindings server, ReformatKind kind) {
        this.ctx = ctx;
        this.server = server;
        this.kind = kind;
    }

    public void reformat() throws BadLocationException {
        FileObject file = NbEditorUtilities.getFileObject((Document)this.ctx.document());
        if (file != null) {
            switch (this.kind) {
                case RANGE: {
                    this.rangeFormat(file, this.server);
                    break;
                }
                case DOCUMENT: {
                    this.documentFormat(file, this.server);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown kind: " + this.kind);
                }
            }
        }
    }

    private void rangeFormat(FileObject fo, LSPBindings bindings) throws BadLocationException {
        DocumentRangeFormattingParams drfp = new DocumentRangeFormattingParams();
        drfp.setTextDocument(new TextDocumentIdentifier(Utils.toURI(fo)));
        drfp.setOptions(new FormattingOptions(IndentUtils.indentLevelSize((Document)this.ctx.document()), IndentUtils.isExpandTabs((Document)this.ctx.document())));
        drfp.setRange(new Range(Utils.createPosition(this.ctx.document(), this.ctx.startOffset()), Utils.createPosition(this.ctx.document(), this.ctx.endOffset())));
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        try {
            edits = new ArrayList(bindings.getTextDocumentService().rangeFormatting(drfp).get());
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.INFO, String.format("LSP document rangeFormat failed for {0}", fo), ex);
        }
        this.applyTextEdits(edits);
    }

    private void documentFormat(FileObject fo, LSPBindings bindings) throws BadLocationException {
        DocumentFormattingParams dfp = new DocumentFormattingParams();
        dfp.setTextDocument(new TextDocumentIdentifier(Utils.toURI(fo)));
        dfp.setOptions(new FormattingOptions(IndentUtils.indentLevelSize((Document)this.ctx.document()), IndentUtils.isExpandTabs((Document)this.ctx.document())));
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        try {
            edits.addAll((Collection)bindings.getTextDocumentService().formatting(dfp).get());
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.log(Level.INFO, String.format("LSP document format failed for {0}", fo), ex);
        }
        this.applyTextEdits(edits);
    }

    private void applyTextEdits(List<TextEdit> edits) {
        if (this.ctx.document() instanceof StyledDocument) {
            NbDocument.runAtomic((StyledDocument)((StyledDocument)this.ctx.document()), () -> Utils.applyEditsNoLock(this.ctx.document(), edits, this.ctx.startOffset(), this.ctx.endOffset()));
        } else {
            Utils.applyEditsNoLock(this.ctx.document(), edits, this.ctx.startOffset(), this.ctx.endOffset());
        }
    }

    public ExtraLock reformatLock() {
        return null;
    }

    private static enum ReformatKind {
        RANGE,
        DOCUMENT;

    }

    public static class Factory
    implements ReformatTask.Factory {
        public ReformatTask createTask(Context context) {
            FileObject file = NbEditorUtilities.getFileObject((Document)context.document());
            if (file != null) {
                List<LSPBindings> servers = LSPBindings.getBindings(file);
                for (LSPBindings server : servers) {
                    boolean rangeFormatting = Utils.isEnabled(server.getInitResult().getCapabilities().getDocumentRangeFormattingProvider());
                    if (rangeFormatting) {
                        return new Formatter(context, server, ReformatKind.RANGE);
                    }
                    boolean documentFormatting = Utils.isEnabled(server.getInitResult().getCapabilities().getDocumentFormattingProvider());
                    if (!documentFormatting) continue;
                    return new Formatter(context, server, ReformatKind.DOCUMENT);
                }
            }
            return null;
        }
    }
}

