/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MultipathDevice
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ipv4")
    private final String ipv4;
    @JsonProperty(value="iqn")
    private final String iqn;
    @JsonProperty(value="port")
    private final Integer port;

    @Deprecated
    @ConstructorProperties(value={"ipv4", "iqn", "port"})
    public MultipathDevice(String ipv4, String iqn, Integer port) {
        this.ipv4 = ipv4;
        this.iqn = iqn;
        this.port = port;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getIpv4() {
        return this.ipv4;
    }

    public String getIqn() {
        return this.iqn;
    }

    public Integer getPort() {
        return this.port;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MultipathDevice(");
        sb.append("super=").append(super.toString());
        sb.append("ipv4=").append(String.valueOf(this.ipv4));
        sb.append(", iqn=").append(String.valueOf(this.iqn));
        sb.append(", port=").append(String.valueOf(this.port));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultipathDevice)) {
            return false;
        }
        MultipathDevice other = (MultipathDevice)((Object)o);
        return Objects.equals(this.ipv4, other.ipv4) && Objects.equals(this.iqn, other.iqn) && Objects.equals(this.port, other.port) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ipv4 == null ? 43 : this.ipv4.hashCode());
        result = result * 59 + (this.iqn == null ? 43 : this.iqn.hashCode());
        result = result * 59 + (this.port == null ? 43 : this.port.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ipv4")
        private String ipv4;
        @JsonProperty(value="iqn")
        private String iqn;
        @JsonProperty(value="port")
        private Integer port;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ipv4(String ipv4) {
            this.ipv4 = ipv4;
            this.__explicitlySet__.add("ipv4");
            return this;
        }

        public Builder iqn(String iqn) {
            this.iqn = iqn;
            this.__explicitlySet__.add("iqn");
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            this.__explicitlySet__.add("port");
            return this;
        }

        public MultipathDevice build() {
            MultipathDevice model = new MultipathDevice(this.ipv4, this.iqn, this.port);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MultipathDevice model) {
            if (model.wasPropertyExplicitlySet("ipv4")) {
                this.ipv4(model.getIpv4());
            }
            if (model.wasPropertyExplicitlySet("iqn")) {
                this.iqn(model.getIqn());
            }
            if (model.wasPropertyExplicitlySet("port")) {
                this.port(model.getPort());
            }
            return this;
        }
    }
}

