/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.i18n.I18nUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;

public class I18nOptions {
    private static final I18nOptions INSTANCE = new I18nOptions();
    public static final String PROP_INIT_JAVA_CODE = "initJavaCode";
    public static final String PROP_REPLACE_JAVA_CODE = "replaceJavaCode";
    public static final String PROP_REGULAR_EXPRESSION = "regularExpression";
    public static final String PROP_I18N_REGULAR_EXPRESSION = "i18nRegularExpression";
    public static final String PROP_REPLACE_RESOURCE_VALUE = "replaceResourceValue";
    public static final String PROP_LAST_RESOURCE2 = "lastResource2";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.i18n.I18nOptions");

    private I18nOptions() {
    }

    public static I18nOptions getDefault() {
        return INSTANCE;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(I18nOptions.class);
    }

    public String getInitJavaCode() {
        return I18nOptions.getPreferences().get(PROP_INIT_JAVA_CODE, I18nUtil.getInitFormatItems().get(0));
    }

    public void setInitJavaCode(String initJavaCode) {
        I18nOptions.getPreferences().put(PROP_INIT_JAVA_CODE, initJavaCode);
    }

    public String getReplaceJavaCode() {
        return I18nOptions.getPreferences().get(PROP_REPLACE_JAVA_CODE, I18nUtil.getDefaultReplaceFormat(false));
    }

    public void setReplaceJavaCode(String replaceJavaCode) {
        I18nOptions.getPreferences().put(PROP_REPLACE_JAVA_CODE, replaceJavaCode);
    }

    public String getRegularExpression() {
        return I18nOptions.getPreferences().get(PROP_REGULAR_EXPRESSION, I18nUtil.getRegExpItems().get(0));
    }

    public void setRegularExpression(String regExp) {
        I18nOptions.getPreferences().put(PROP_REGULAR_EXPRESSION, regExp);
    }

    public String getI18nRegularExpression() {
        return I18nOptions.getPreferences().get(PROP_I18N_REGULAR_EXPRESSION, I18nUtil.getI18nRegExpItems().get(0));
    }

    public void setI18nRegularExpression(String regExp) {
        I18nOptions.getPreferences().put(PROP_I18N_REGULAR_EXPRESSION, regExp);
    }

    public boolean isReplaceResourceValue() {
        return I18nOptions.getPreferences().getBoolean(PROP_REPLACE_RESOURCE_VALUE, false);
    }

    public void setReplaceResourceValue(boolean replaceResourceValue) {
        I18nOptions.getPreferences().putBoolean(PROP_REPLACE_RESOURCE_VALUE, replaceResourceValue);
    }

    @Deprecated
    public DataObject getLastResource2() {
        return this.getLastResource2(null);
    }

    public DataObject getLastResource2(DataObject srcDataObject) {
        FileObject f;
        String path = I18nOptions.getPreferences().get(PROP_LAST_RESOURCE2, null);
        if (path == null) {
            return null;
        }
        FileObject fileObject = f = srcDataObject != null ? I18nOptions.findFileObject(srcDataObject, path) : I18nOptions.findFileObject(path);
        if (f != null && !f.isFolder() && f.isValid()) {
            try {
                return DataObject.find((FileObject)f);
            }
            catch (DataObjectNotFoundException e) {
                I18nOptions.getPreferences().remove(PROP_LAST_RESOURCE2);
            }
        }
        return null;
    }

    public void setLastResource2(DataObject lastResource) {
        if (lastResource == null) {
            return;
        }
        I18nOptions.getPreferences().put(PROP_LAST_RESOURCE2, lastResource.getPrimaryFile().getPath());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(I18nOptions.class);
    }

    private static FileSystem[] getFileSystems() {
        ArrayList<FileSystem> retval = new ArrayList<FileSystem>();
        for (File file : File.listRoots()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (fo == null) continue;
            try {
                retval.add(fo.getFileSystem());
            }
            catch (FileStateInvalidException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        return retval.toArray(new FileSystem[0]);
    }

    @Deprecated
    private static FileObject findFileObject(String path) {
        for (FileSystem fileSystem : I18nOptions.getFileSystems()) {
            FileObject retval = fileSystem.findResource(path);
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    private static FileObject findFileObject(DataObject srcDataObject, String path) {
        FileObject pfo = srcDataObject.getPrimaryFile();
        ClassPath cp = ClassPath.getClassPath((FileObject)pfo, (String)"classpath/execute");
        if (cp == null) {
            LOG.info("Unable to find FileObject due to ClassPath is null");
            return null;
        }
        for (FileObject fo : I18nOptions.getRoots(cp)) {
            try {
                FileObject retval;
                FileSystem fs = fo.getFileSystem();
                if (fs == null || (retval = fs.findResource(path)) == null) continue;
                return retval;
            }
            catch (FileStateInvalidException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
        return null;
    }

    private static List<FileObject> getRoots(ClassPath cp) {
        assert (cp != null);
        ArrayList<FileObject> l = new ArrayList<FileObject>(cp.entries().size());
        for (ClassPath.Entry e : cp.entries()) {
            URL url = e.getURL();
            SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)url);
            FileObject[] fos = r.getRoots();
            if (fos.length > 0) {
                for (FileObject fo : fos) {
                    l.add(fo);
                }
                continue;
            }
            if (e.getRoot() == null) continue;
            l.add(e.getRoot());
        }
        return l;
    }
}

