/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.eecommon.api.config;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.payara.eecommon.api.config.PayaraConfiguration;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class FolderListener
implements FileChangeListener {
    private final File configKey;
    private final String[] targets;

    public static FileChangeListener createListener(File key, FileObject folder, J2eeModule.Type type) {
        return new FolderListener(key, folder, type);
    }

    private FolderListener(File key, FileObject folder, J2eeModule.Type type) {
        this.configKey = key;
        if (type == J2eeModule.Type.WAR) {
            this.targets = new String[]{"web.xml", "webservices.xml"};
        } else if (type == J2eeModule.Type.EJB) {
            this.targets = new String[]{"ejb-jar.xml", "webservices.xml"};
        } else if (type == J2eeModule.Type.EAR) {
            this.targets = new String[]{"application.xml"};
        } else if (type == J2eeModule.Type.CAR) {
            this.targets = new String[]{"application-client.xml"};
        } else {
            Logger.getLogger("payara-eecommon").log(Level.WARNING, "Unsupported module type: " + type);
            this.targets = new String[0];
        }
        folder.addFileChangeListener((FileChangeListener)this);
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        for (String target : this.targets) {
            PayaraConfiguration config;
            if (!target.equals(fo.getNameExt()) || (config = PayaraConfiguration.getConfiguration(this.configKey)) == null) continue;
            config.addDescriptorListener(fo);
        }
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }
}

