/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.resource;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.resource.DefaultResourceResolverChain;
import org.springframework.web.reactive.resource.DefaultResourceTransformerChain;
import org.springframework.web.reactive.resource.HttpResource;
import org.springframework.web.reactive.resource.PathResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolver;
import org.springframework.web.reactive.resource.ResourceResolverChain;
import org.springframework.web.reactive.resource.ResourceTransformer;
import org.springframework.web.reactive.resource.ResourceTransformerChain;
import org.springframework.web.server.MethodNotAllowedException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;

public class ResourceWebHandler
implements WebHandler,
InitializingBean {
    private static final Set<HttpMethod> SUPPORTED_METHODS = EnumSet.of(HttpMethod.GET, HttpMethod.HEAD);
    private static final Log logger = LogFactory.getLog(ResourceWebHandler.class);
    @Nullable
    private ResourceLoader resourceLoader;
    private final List<String> locationValues = new ArrayList<String>(4);
    private final List<Resource> locationResources = new ArrayList<Resource>(4);
    private final List<Resource> locationsToUse = new ArrayList<Resource>(4);
    private final List<ResourceResolver> resourceResolvers = new ArrayList<ResourceResolver>(4);
    private final List<ResourceTransformer> resourceTransformers = new ArrayList<ResourceTransformer>(4);
    @Nullable
    private ResourceResolverChain resolverChain;
    @Nullable
    private ResourceTransformerChain transformerChain;
    @Nullable
    private CacheControl cacheControl;
    @Nullable
    private ResourceHttpMessageWriter resourceHttpMessageWriter;
    @Nullable
    private Map<String, MediaType> mediaTypes;
    private boolean useLastModified = true;
    private boolean optimizeLocations = false;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setLocationValues(List<String> locationValues) {
        Assert.notNull(locationValues, (String)"Location values list must not be null");
        this.locationValues.clear();
        this.locationValues.addAll(locationValues);
    }

    public List<String> getLocationValues() {
        return this.locationValues;
    }

    public void setLocations(@Nullable List<Resource> locations) {
        this.locationResources.clear();
        if (locations != null) {
            this.locationResources.addAll(locations);
        }
    }

    public List<Resource> getLocations() {
        if (this.locationsToUse.isEmpty()) {
            return this.locationResources;
        }
        return this.locationsToUse;
    }

    public void setResourceResolvers(@Nullable List<ResourceResolver> resourceResolvers) {
        this.resourceResolvers.clear();
        if (resourceResolvers != null) {
            this.resourceResolvers.addAll(resourceResolvers);
        }
    }

    public List<ResourceResolver> getResourceResolvers() {
        return this.resourceResolvers;
    }

    public void setResourceTransformers(@Nullable List<ResourceTransformer> resourceTransformers) {
        this.resourceTransformers.clear();
        if (resourceTransformers != null) {
            this.resourceTransformers.addAll(resourceTransformers);
        }
    }

    public List<ResourceTransformer> getResourceTransformers() {
        return this.resourceTransformers;
    }

    public void setResourceHttpMessageWriter(@Nullable ResourceHttpMessageWriter httpMessageWriter) {
        this.resourceHttpMessageWriter = httpMessageWriter;
    }

    @Nullable
    public ResourceHttpMessageWriter getResourceHttpMessageWriter() {
        return this.resourceHttpMessageWriter;
    }

    public void setCacheControl(@Nullable CacheControl cacheControl) {
        this.cacheControl = cacheControl;
    }

    @Nullable
    public CacheControl getCacheControl() {
        return this.cacheControl;
    }

    public void setUseLastModified(boolean useLastModified) {
        this.useLastModified = useLastModified;
    }

    public boolean isUseLastModified() {
        return this.useLastModified;
    }

    public void setOptimizeLocations(boolean optimizeLocations) {
        this.optimizeLocations = optimizeLocations;
    }

    public boolean isOptimizeLocations() {
        return this.optimizeLocations;
    }

    public void setMediaTypes(Map<String, MediaType> mediaTypes) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new HashMap<String, MediaType>(mediaTypes.size());
        }
        mediaTypes.forEach((ext, type) -> this.mediaTypes.put(ext.toLowerCase(Locale.ENGLISH), (MediaType)type));
    }

    public Map<String, MediaType> getMediaTypes() {
        return this.mediaTypes != null ? this.mediaTypes : Collections.emptyMap();
    }

    public void afterPropertiesSet() throws Exception {
        this.resolveResourceLocations();
        if (this.resourceResolvers.isEmpty()) {
            this.resourceResolvers.add(new PathResourceResolver());
        }
        this.initAllowedLocations();
        if (this.getResourceHttpMessageWriter() == null) {
            this.resourceHttpMessageWriter = new ResourceHttpMessageWriter();
        }
        this.resolverChain = new DefaultResourceResolverChain(this.resourceResolvers);
        this.transformerChain = new DefaultResourceTransformerChain(this.resolverChain, this.resourceTransformers);
    }

    private void resolveResourceLocations() {
        List<Object> result = new ArrayList<Resource>(this.locationResources);
        if (!this.locationValues.isEmpty()) {
            Assert.notNull((Object)this.resourceLoader, (String)"ResourceLoader is required when \"locationValues\" are configured.");
            Assert.isTrue((boolean)CollectionUtils.isEmpty(this.locationResources), (String)"Please set either Resource-based \"locations\" or String-based \"locationValues\", but not both.");
            for (String location : this.locationValues) {
                result.add(this.resourceLoader.getResource(location));
            }
        }
        if (this.isOptimizeLocations()) {
            result = result.stream().filter(Resource::exists).collect(Collectors.toList());
        }
        this.locationsToUse.clear();
        this.locationsToUse.addAll(result);
    }

    protected void initAllowedLocations() {
        if (CollectionUtils.isEmpty(this.getLocations())) {
            return;
        }
        for (int i2 = this.getResourceResolvers().size() - 1; i2 >= 0; --i2) {
            if (!(this.getResourceResolvers().get(i2) instanceof PathResourceResolver)) continue;
            PathResourceResolver resolver = (PathResourceResolver)this.getResourceResolvers().get(i2);
            if (!ObjectUtils.isEmpty((Object[])resolver.getAllowedLocations())) break;
            resolver.setAllowedLocations(this.getLocations().toArray(new Resource[0]));
            break;
        }
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        return this.getResource(exchange).switchIfEmpty(Mono.defer(() -> {
            logger.debug((Object)(exchange.getLogPrefix() + "Resource not found"));
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
        })).flatMap(resource -> {
            try {
                if (HttpMethod.OPTIONS.matches(exchange.getRequest().getMethodValue())) {
                    exchange.getResponse().getHeaders().add("Allow", "GET,HEAD,OPTIONS");
                    return Mono.empty();
                }
                HttpMethod httpMethod = exchange.getRequest().getMethod();
                if (!SUPPORTED_METHODS.contains(httpMethod)) {
                    return Mono.error((Throwable)new MethodNotAllowedException(exchange.getRequest().getMethodValue(), SUPPORTED_METHODS));
                }
                if (this.isUseLastModified() && exchange.checkNotModified(Instant.ofEpochMilli(resource.lastModified()))) {
                    logger.trace((Object)(exchange.getLogPrefix() + "Resource not modified"));
                    return Mono.empty();
                }
                CacheControl cacheControl = this.getCacheControl();
                if (cacheControl != null) {
                    exchange.getResponse().getHeaders().setCacheControl(cacheControl);
                }
                MediaType mediaType = this.getMediaType((Resource)resource);
                this.setHeaders(exchange, (Resource)resource, mediaType);
                ResourceHttpMessageWriter writer = this.getResourceHttpMessageWriter();
                Assert.state((writer != null ? 1 : 0) != 0, (String)"No ResourceHttpMessageWriter");
                return writer.write((Publisher)Mono.just((Object)resource), null, ResolvableType.forClass(Resource.class), mediaType, exchange.getRequest(), exchange.getResponse(), Hints.from((String)Hints.LOG_PREFIX_HINT, (Object)exchange.getLogPrefix()));
            }
            catch (IOException ex) {
                return Mono.error((Throwable)ex);
            }
        });
    }

    protected Mono<Resource> getResource(ServerWebExchange exchange) {
        String name = HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE;
        PathContainer pathWithinHandler = (PathContainer)exchange.getRequiredAttribute(name);
        String path2 = this.processPath(pathWithinHandler.value());
        if (!StringUtils.hasText((String)path2) || this.isInvalidPath(path2)) {
            return Mono.empty();
        }
        if (this.isInvalidEncodedPath(path2)) {
            return Mono.empty();
        }
        Assert.state((this.resolverChain != null ? 1 : 0) != 0, (String)"ResourceResolverChain not initialized");
        Assert.state((this.transformerChain != null ? 1 : 0) != 0, (String)"ResourceTransformerChain not initialized");
        return this.resolverChain.resolveResource(exchange, path2, this.getLocations()).flatMap(resource -> this.transformerChain.transform(exchange, (Resource)resource));
    }

    protected String processPath(String path2) {
        path2 = StringUtils.replace((String)path2, (String)"\\", (String)"/");
        path2 = this.cleanDuplicateSlashes(path2);
        return this.cleanLeadingSlash(path2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cleanDuplicateSlashes(String path2) {
        StringBuilder sb = null;
        char prev = '\u0000';
        for (int i2 = 0; i2 < path2.length(); ++i2) {
            char curr = path2.charAt(i2);
            try {
                if (curr == '/' && prev == '/') {
                    if (sb != null) continue;
                    sb = new StringBuilder(path2.substring(0, i2));
                    continue;
                }
                if (sb == null) continue;
                sb.append(path2.charAt(i2));
                continue;
            }
            finally {
                prev = curr;
            }
        }
        return sb != null ? sb.toString() : path2;
    }

    private String cleanLeadingSlash(String path2) {
        boolean slash = false;
        for (int i2 = 0; i2 < path2.length(); ++i2) {
            if (path2.charAt(i2) == '/') {
                slash = true;
                continue;
            }
            if (path2.charAt(i2) <= ' ' || path2.charAt(i2) == '\u007f') continue;
            if (i2 == 0 || i2 == 1 && slash) {
                return path2;
            }
            return slash ? "/" + path2.substring(i2) : path2.substring(i2);
        }
        return slash ? "/" : "";
    }

    private boolean isInvalidEncodedPath(String path2) {
        if (path2.contains("%")) {
            try {
                String decodedPath = URLDecoder.decode(path2, "UTF-8");
                if (this.isInvalidPath(decodedPath)) {
                    return true;
                }
                if (this.isInvalidPath(decodedPath = this.processPath(decodedPath))) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean isInvalidPath(String path2) {
        if (path2.contains("WEB-INF") || path2.contains("META-INF")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)LogFormatUtils.formatValue((Object)("Path with \"WEB-INF\" or \"META-INF\": [" + path2 + "]"), (int)-1, (boolean)true));
            }
            return true;
        }
        if (path2.contains(":/")) {
            String relativePath;
            String string = relativePath = path2.charAt(0) == '/' ? path2.substring(1) : path2;
            if (ResourceUtils.isUrl((String)relativePath) || relativePath.startsWith("url:")) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)LogFormatUtils.formatValue((Object)("Path represents URL or has \"url:\" prefix: [" + path2 + "]"), (int)-1, (boolean)true));
                }
                return true;
            }
        }
        if (path2.contains("..") && StringUtils.cleanPath((String)path2).contains("../")) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)LogFormatUtils.formatValue((Object)("Path contains \"../\" after call to StringUtils#cleanPath: [" + path2 + "]"), (int)-1, (boolean)true));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private MediaType getMediaType(Resource resource) {
        List mediaTypes;
        String ext;
        MediaType mediaType = null;
        String filename = resource.getFilename();
        if (!CollectionUtils.isEmpty(this.mediaTypes) && (ext = StringUtils.getFilenameExtension((String)filename)) != null) {
            mediaType = this.mediaTypes.get(ext.toLowerCase(Locale.ENGLISH));
        }
        if (mediaType == null && !CollectionUtils.isEmpty((Collection)(mediaTypes = MediaTypeFactory.getMediaTypes((String)filename)))) {
            mediaType = (MediaType)mediaTypes.get(0);
        }
        return mediaType;
    }

    protected void setHeaders(ServerWebExchange exchange, Resource resource, @Nullable MediaType mediaType) throws IOException {
        HttpHeaders headers2 = exchange.getResponse().getHeaders();
        long length = resource.contentLength();
        headers2.setContentLength(length);
        if (mediaType != null) {
            headers2.setContentType(mediaType);
        }
        if (resource instanceof HttpResource) {
            HttpHeaders resourceHeaders = ((HttpResource)resource).getResponseHeaders();
            exchange.getResponse().getHeaders().putAll((Map)resourceHeaders);
        }
    }

    public String toString() {
        return "ResourceWebHandler " + this.locationToString(this.getLocations());
    }

    private String locationToString(List<Resource> locations) {
        return locations.toString().replaceAll("class path resource", "classpath").replaceAll("ServletContext resource", "ServletContext");
    }
}

