/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trafficflow.mq.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.ubnt.net.Dto;
import com.ubnt.service.systemlog.trigger.voidsuper;
import com.ubnt.service.trafficflow.O0oo;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;

public enum TrafficFlowMessageType implements Dto
{
    AD_BLOCKING("dnsAdBlock"),
    DNS_BLOCK("dnsBlock"),
    CONTENT_FILTERING_BLOCK("contentFilteringBlock"),
    FLOW_POLICY("FLOW_POLICY"),
    FIREWALL_POLICY("FIREWALL_POLICY"),
    GEO_POLICY("GEO_POLICY"),
    HONEYPOT("HoneypotEvent"),
    IPS("SuricataEvent"),
    SIMPLE_APP_BLOCK("SIMPLE_APP_BLOCK"),
    FIREWALL_RULE("FIREWALL_RULE"),
    TRAFFIC_RULE("TRAFFIC_RULE"),
    TRAFFIC_ROUTE("TRAFFIC_ROUTE"),
    GENERATED_ALLOW_FIREWALL_POLICY("GENERATED_ALLOW_FIREWALL_POLICY"),
    GENERATED_BLOCK_FIREWALL_POLICY("GENERATED_BLOCK_FIREWALL_POLICY"),
    GENERATED_REJECT_FIREWALL_POLICY("GENERATED_REJECT_FIREWALL_POLICY"),
    GENERATED_POLICY_BASED_ROUTING("GENERATED_POLICY_BASED_ROUTING"),
    UNKNOWN("");

    private final String firmwareValue;

    public O0oo toTrafficFlowType(boolean bl) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AD_BLOCKING -> {
                if (bl) {
                    yield O0oo.\u00d4Oo000;
                }
                yield O0oo.\u00f4\u00f8O000;
            }
            case DNS_BLOCK -> O0oo.o0o000;
            case CONTENT_FILTERING_BLOCK -> O0oo.dointerface;
            case GEO_POLICY -> O0oo.\u00d50o000;
            case HONEYPOT -> O0oo.OOo000;
            case FIREWALL_POLICY -> O0oo.\u00d4\u00f8O000;
            case FIREWALL_RULE -> O0oo.publicprivate;
            case SIMPLE_APP_BLOCK -> O0oo.\u00f5Oo000;
            case TRAFFIC_RULE -> O0oo.\u00d6Oo000;
            case TRAFFIC_ROUTE -> O0oo.\u00d6\u00f8O000;
            case FLOW_POLICY -> O0oo.\u00d60o000;
            case IPS -> O0oo.\u00d2Oo000;
            case GENERATED_REJECT_FIREWALL_POLICY -> O0oo.superinterface;
            case GENERATED_BLOCK_FIREWALL_POLICY -> O0oo.\u00f50o000;
            case GENERATED_ALLOW_FIREWALL_POLICY -> O0oo.\u00f5\u00f6O000;
            case GENERATED_POLICY_BASED_ROUTING -> O0oo.\u00d5\u00f8O000;
            case UNKNOWN -> O0oo.intinterface;
        };
    }

    public Optional<voidsuper> toTriggerType() {
        return Optional.ofNullable(switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case FIREWALL_POLICY -> voidsuper.\u00d300000;
            case GENERATED_REJECT_FIREWALL_POLICY -> voidsuper.\u00f400000;
            case GENERATED_BLOCK_FIREWALL_POLICY -> voidsuper.o00000;
            case GENERATED_ALLOW_FIREWALL_POLICY -> voidsuper.while;
            case GENERATED_POLICY_BASED_ROUTING -> voidsuper.\u00f800000;
            case FIREWALL_RULE -> voidsuper.new;
            case SIMPLE_APP_BLOCK -> voidsuper.\u00d500000;
            case TRAFFIC_RULE -> voidsuper.OO0000;
            case TRAFFIC_ROUTE -> voidsuper.if;
            case AD_BLOCKING, DNS_BLOCK, CONTENT_FILTERING_BLOCK, GEO_POLICY, HONEYPOT, FLOW_POLICY, IPS, UNKNOWN -> null;
        });
    }

    public boolean isTriggerType() {
        return this.toTriggerType().isPresent();
    }

    public boolean isFirewallMessage() {
        return this == FIREWALL_POLICY || this == TRAFFIC_RULE || this == FIREWALL_RULE || this == SIMPLE_APP_BLOCK || this == TRAFFIC_ROUTE;
    }

    @JsonCreator
    public static TrafficFlowMessageType fromFirmwareValue(String string) {
        for (TrafficFlowMessageType trafficFlowMessageType : TrafficFlowMessageType.values()) {
            if (!trafficFlowMessageType.firmwareValue.equals(string)) continue;
            return trafficFlowMessageType;
        }
        return UNKNOWN;
    }

    @ConstructorProperties(value={"firmwareValue"})
    @Generated
    private TrafficFlowMessageType(String string2) {
        this.firmwareValue = string2;
    }

    static class _o {
        static final String \u00d300000 = "HoneypotEvent";
        static final String new = "SuricataEvent";
        static final String o00000 = "contentFilteringBlock";

        private _o() {
        }
    }
}

