package profiler

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"github.com/chromedp/cdproto/debugger"
)

// EventConsoleProfileFinished [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Profiler#event-consoleProfileFinished
type EventConsoleProfileFinished struct {
	ID       string             `json:"id"`
	Location *debugger.Location `json:"location"` // Location of console.profileEnd().
	Profile  *Profile           `json:"profile"`
	Title    string             `json:"title,omitempty,omitzero"` // Profile title passed as an argument to console.profile().
}

// EventConsoleProfileStarted sent when new profile recording is started
// using console.profile() call.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Profiler#event-consoleProfileStarted
type EventConsoleProfileStarted struct {
	ID       string             `json:"id"`
	Location *debugger.Location `json:"location"`                 // Location of console.profile().
	Title    string             `json:"title,omitempty,omitzero"` // Profile title passed as an argument to console.profile().
}

// EventPreciseCoverageDeltaUpdate reports coverage delta since the last poll
// (either from an event like this, or from takePreciseCoverage for the current
// isolate. May only be sent if precise code coverage has been started. This
// event can be trigged by the embedder to, for example, trigger collection of
// coverage data immediately at a certain point in time.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Profiler#event-preciseCoverageDeltaUpdate
type EventPreciseCoverageDeltaUpdate struct {
	Timestamp float64           `json:"timestamp"` // Monotonically increasing time (in seconds) when the coverage update was taken in the backend.
	Occasion  string            `json:"occasion"`  // Identifier for distinguishing coverage events.
	Result    []*ScriptCoverage `json:"result"`    // Coverage data for the current isolate.
}
