// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"context"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"github.com/oracle/oci-go-sdk/v65/common/auth"
	"net/http"
)

// VulnerabilityScanningClient a client for VulnerabilityScanning
type VulnerabilityScanningClient struct {
	common.BaseClient
	config *common.ConfigurationProvider
}

// NewVulnerabilityScanningClientWithConfigurationProvider Creates a new default VulnerabilityScanning client with the given configuration provider.
// the configuration provider will be used for the default signer as well as reading the region
func NewVulnerabilityScanningClientWithConfigurationProvider(configProvider common.ConfigurationProvider) (client VulnerabilityScanningClient, err error) {
	if enabled := common.CheckForEnabledServices("vulnerabilityscanning"); !enabled {
		return client, fmt.Errorf("the Developer Tool configuration disabled this service, this behavior is controlled by OciSdkEnabledServicesMap variables. Please check if your local developer-tool-configuration.json file configured the service you're targeting or contact the cloud provider on the availability of this service")
	}
	provider, err := auth.GetGenericConfigurationProvider(configProvider)
	if err != nil {
		return client, err
	}
	baseClient, e := common.NewClientWithConfig(provider)
	if e != nil {
		return client, e
	}
	return newVulnerabilityScanningClientFromBaseClient(baseClient, provider)
}

// NewVulnerabilityScanningClientWithOboToken Creates a new default VulnerabilityScanning client with the given configuration provider.
// The obotoken will be added to default headers and signed; the configuration provider will be used for the signer
//
//	as well as reading the region
func NewVulnerabilityScanningClientWithOboToken(configProvider common.ConfigurationProvider, oboToken string) (client VulnerabilityScanningClient, err error) {
	baseClient, err := common.NewClientWithOboToken(configProvider, oboToken)
	if err != nil {
		return client, err
	}

	return newVulnerabilityScanningClientFromBaseClient(baseClient, configProvider)
}

func newVulnerabilityScanningClientFromBaseClient(baseClient common.BaseClient, configProvider common.ConfigurationProvider) (client VulnerabilityScanningClient, err error) {
	// VulnerabilityScanning service default circuit breaker is enabled
	baseClient.Configuration.CircuitBreaker = common.NewCircuitBreaker(common.DefaultCircuitBreakerSettingWithServiceName("VulnerabilityScanning"))
	common.ConfigCircuitBreakerFromEnvVar(&baseClient)
	common.ConfigCircuitBreakerFromGlobalVar(&baseClient)

	client = VulnerabilityScanningClient{BaseClient: baseClient}
	client.BasePath = "20210215"
	err = client.setConfigurationProvider(configProvider)
	return
}

// SetRegion overrides the region of this client.
func (client *VulnerabilityScanningClient) SetRegion(region string) {
	client.Host = common.StringToRegion(region).EndpointForTemplate("vulnerabilityscanning", "https://vss-cp-api.{region}.oci.{secondLevelDomain}")
}

// SetConfigurationProvider sets the configuration provider including the region, returns an error if is not valid
func (client *VulnerabilityScanningClient) setConfigurationProvider(configProvider common.ConfigurationProvider) error {
	if ok, err := common.IsConfigurationProviderValid(configProvider); !ok {
		return err
	}

	// Error has been checked already
	region, _ := configProvider.Region()
	client.SetRegion(region)
	if client.Host == "" {
		return fmt.Errorf("invalid region or Host. Endpoint cannot be constructed without endpointServiceName or serviceEndpointTemplate for a dotted region")
	}
	client.config = &configProvider
	return nil
}

// ConfigurationProvider the ConfigurationProvider used in this client, or null if none set
func (client *VulnerabilityScanningClient) ConfigurationProvider() *common.ConfigurationProvider {
	return client.config
}

// ChangeContainerScanRecipeCompartment Moves a ContainerScanRecipe into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeContainerScanRecipeCompartment.go.html to see an example of how to use ChangeContainerScanRecipeCompartment API.
func (client VulnerabilityScanningClient) ChangeContainerScanRecipeCompartment(ctx context.Context, request ChangeContainerScanRecipeCompartmentRequest) (response ChangeContainerScanRecipeCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeContainerScanRecipeCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeContainerScanRecipeCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeContainerScanRecipeCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeContainerScanRecipeCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeContainerScanRecipeCompartmentResponse")
	}
	return
}

// changeContainerScanRecipeCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeContainerScanRecipeCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/containerScanRecipes/{containerScanRecipeId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeContainerScanRecipeCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/ChangeContainerScanRecipeCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeContainerScanRecipeCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ChangeContainerScanResultCompartment Moves a ContainerScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeContainerScanResultCompartment.go.html to see an example of how to use ChangeContainerScanResultCompartment API.
func (client VulnerabilityScanningClient) ChangeContainerScanResultCompartment(ctx context.Context, request ChangeContainerScanResultCompartmentRequest) (response ChangeContainerScanResultCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeContainerScanResultCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeContainerScanResultCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeContainerScanResultCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeContainerScanResultCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeContainerScanResultCompartmentResponse")
	}
	return
}

// changeContainerScanResultCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeContainerScanResultCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/containerScanResults/{containerScanResultId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeContainerScanResultCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanResult/ChangeContainerScanResultCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeContainerScanResultCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ChangeContainerScanTargetCompartment Moves a ContainerScanTarget into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeContainerScanTargetCompartment.go.html to see an example of how to use ChangeContainerScanTargetCompartment API.
func (client VulnerabilityScanningClient) ChangeContainerScanTargetCompartment(ctx context.Context, request ChangeContainerScanTargetCompartmentRequest) (response ChangeContainerScanTargetCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeContainerScanTargetCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeContainerScanTargetCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeContainerScanTargetCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeContainerScanTargetCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeContainerScanTargetCompartmentResponse")
	}
	return
}

// changeContainerScanTargetCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeContainerScanTargetCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/containerScanTargets/{containerScanTargetId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeContainerScanTargetCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/ChangeContainerScanTargetCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeContainerScanTargetCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ChangeHostAgentScanResultCompartment Moves a HostAgentScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeHostAgentScanResultCompartment.go.html to see an example of how to use ChangeHostAgentScanResultCompartment API.
func (client VulnerabilityScanningClient) ChangeHostAgentScanResultCompartment(ctx context.Context, request ChangeHostAgentScanResultCompartmentRequest) (response ChangeHostAgentScanResultCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeHostAgentScanResultCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeHostAgentScanResultCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeHostAgentScanResultCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeHostAgentScanResultCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeHostAgentScanResultCompartmentResponse")
	}
	return
}

// changeHostAgentScanResultCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeHostAgentScanResultCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostAgentScanResults/{hostAgentScanResultId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeHostAgentScanResultCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/ChangeHostAgentScanResultCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeHostAgentScanResultCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ChangeHostCisBenchmarkScanResultCompartment Moves a HostCisBenchmarkScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeHostCisBenchmarkScanResultCompartment.go.html to see an example of how to use ChangeHostCisBenchmarkScanResultCompartment API.
func (client VulnerabilityScanningClient) ChangeHostCisBenchmarkScanResultCompartment(ctx context.Context, request ChangeHostCisBenchmarkScanResultCompartmentRequest) (response ChangeHostCisBenchmarkScanResultCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeHostCisBenchmarkScanResultCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeHostCisBenchmarkScanResultCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeHostCisBenchmarkScanResultCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeHostCisBenchmarkScanResultCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeHostCisBenchmarkScanResultCompartmentResponse")
	}
	return
}

// changeHostCisBenchmarkScanResultCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeHostCisBenchmarkScanResultCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostCisBenchmarkScanResults/{hostCisBenchmarkScanResultId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeHostCisBenchmarkScanResultCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostCisBenchmarkScanResult/ChangeHostCisBenchmarkScanResultCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeHostCisBenchmarkScanResultCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ChangeHostEndpointProtectionScanResultCompartment Moves a HostEndpointProtectionScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeHostEndpointProtectionScanResultCompartment.go.html to see an example of how to use ChangeHostEndpointProtectionScanResultCompartment API.
func (client VulnerabilityScanningClient) ChangeHostEndpointProtectionScanResultCompartment(ctx context.Context, request ChangeHostEndpointProtectionScanResultCompartmentRequest) (response ChangeHostEndpointProtectionScanResultCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeHostEndpointProtectionScanResultCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeHostEndpointProtectionScanResultCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeHostEndpointProtectionScanResultCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeHostEndpointProtectionScanResultCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeHostEndpointProtectionScanResultCompartmentResponse")
	}
	return
}

// changeHostEndpointProtectionScanResultCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeHostEndpointProtectionScanResultCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostEndpointProtectionScanResults/{hostEndpointProtectionScanResultId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeHostEndpointProtectionScanResultCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostEndpointProtectionScanResult/ChangeHostEndpointProtectionScanResultCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeHostEndpointProtectionScanResultCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ChangeHostPortScanResultCompartment Moves a HostPortScanResult into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeHostPortScanResultCompartment.go.html to see an example of how to use ChangeHostPortScanResultCompartment API.
func (client VulnerabilityScanningClient) ChangeHostPortScanResultCompartment(ctx context.Context, request ChangeHostPortScanResultCompartmentRequest) (response ChangeHostPortScanResultCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeHostPortScanResultCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeHostPortScanResultCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeHostPortScanResultCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeHostPortScanResultCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeHostPortScanResultCompartmentResponse")
	}
	return
}

// changeHostPortScanResultCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeHostPortScanResultCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostPortScanResults/{hostPortScanResultId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeHostPortScanResultCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostPortScanResult/ChangeHostPortScanResultCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeHostPortScanResultCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ChangeHostScanRecipeCompartment Moves a HostScanRecipe into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeHostScanRecipeCompartment.go.html to see an example of how to use ChangeHostScanRecipeCompartment API.
func (client VulnerabilityScanningClient) ChangeHostScanRecipeCompartment(ctx context.Context, request ChangeHostScanRecipeCompartmentRequest) (response ChangeHostScanRecipeCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeHostScanRecipeCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeHostScanRecipeCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeHostScanRecipeCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeHostScanRecipeCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeHostScanRecipeCompartmentResponse")
	}
	return
}

// changeHostScanRecipeCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeHostScanRecipeCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostScanRecipes/{hostScanRecipeId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeHostScanRecipeCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/ChangeHostScanRecipeCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeHostScanRecipeCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ChangeHostScanTargetCompartment Moves a HostScanTarget into a different compartment. When provided, If-Match is checked against ETag values of the resource.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ChangeHostScanTargetCompartment.go.html to see an example of how to use ChangeHostScanTargetCompartment API.
func (client VulnerabilityScanningClient) ChangeHostScanTargetCompartment(ctx context.Context, request ChangeHostScanTargetCompartmentRequest) (response ChangeHostScanTargetCompartmentResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.changeHostScanTargetCompartment, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ChangeHostScanTargetCompartmentResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ChangeHostScanTargetCompartmentResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ChangeHostScanTargetCompartmentResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ChangeHostScanTargetCompartmentResponse")
	}
	return
}

// changeHostScanTargetCompartment implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) changeHostScanTargetCompartment(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostScanTargets/{hostScanTargetId}/actions/changeCompartment", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ChangeHostScanTargetCompartmentResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/ChangeHostScanTargetCompartment"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ChangeHostScanTargetCompartment", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// CreateContainerScanRecipe Creates a new ContainerScanRecipe. A recipe determines the types of security issues that you want scanned.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/CreateContainerScanRecipe.go.html to see an example of how to use CreateContainerScanRecipe API.
func (client VulnerabilityScanningClient) CreateContainerScanRecipe(ctx context.Context, request CreateContainerScanRecipeRequest) (response CreateContainerScanRecipeResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.createContainerScanRecipe, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = CreateContainerScanRecipeResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = CreateContainerScanRecipeResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(CreateContainerScanRecipeResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into CreateContainerScanRecipeResponse")
	}
	return
}

// createContainerScanRecipe implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) createContainerScanRecipe(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/containerScanRecipes", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response CreateContainerScanRecipeResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/CreateContainerScanRecipe"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "CreateContainerScanRecipe", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// CreateContainerScanTarget Creates a new ContainerScanTarget. A container scan target specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/CreateContainerScanTarget.go.html to see an example of how to use CreateContainerScanTarget API.
func (client VulnerabilityScanningClient) CreateContainerScanTarget(ctx context.Context, request CreateContainerScanTargetRequest) (response CreateContainerScanTargetResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.createContainerScanTarget, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = CreateContainerScanTargetResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = CreateContainerScanTargetResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(CreateContainerScanTargetResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into CreateContainerScanTargetResponse")
	}
	return
}

// createContainerScanTarget implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) createContainerScanTarget(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/containerScanTargets", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response CreateContainerScanTargetResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/CreateContainerScanTarget"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "CreateContainerScanTarget", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// CreateHostScanRecipe Creates a new HostScanRecipe. A recipe determines the types of security issues that you want scanned, and how often to scan.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/CreateHostScanRecipe.go.html to see an example of how to use CreateHostScanRecipe API.
func (client VulnerabilityScanningClient) CreateHostScanRecipe(ctx context.Context, request CreateHostScanRecipeRequest) (response CreateHostScanRecipeResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.createHostScanRecipe, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = CreateHostScanRecipeResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = CreateHostScanRecipeResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(CreateHostScanRecipeResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into CreateHostScanRecipeResponse")
	}
	return
}

// createHostScanRecipe implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) createHostScanRecipe(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostScanRecipes", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response CreateHostScanRecipeResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/CreateHostScanRecipe"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "CreateHostScanRecipe", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// CreateHostScanTarget Creates a new HostScanTarget. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/CreateHostScanTarget.go.html to see an example of how to use CreateHostScanTarget API.
func (client VulnerabilityScanningClient) CreateHostScanTarget(ctx context.Context, request CreateHostScanTargetRequest) (response CreateHostScanTargetResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}

	if !(request.OpcRetryToken != nil && *request.OpcRetryToken != "") {
		request.OpcRetryToken = common.String(common.RetryToken())
	}

	ociResponse, err = common.Retry(ctx, request, client.createHostScanTarget, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = CreateHostScanTargetResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = CreateHostScanTargetResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(CreateHostScanTargetResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into CreateHostScanTargetResponse")
	}
	return
}

// createHostScanTarget implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) createHostScanTarget(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostScanTargets", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response CreateHostScanTargetResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/CreateHostScanTarget"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "CreateHostScanTarget", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteContainerScanRecipe Deletes the ContainerScanRecipe identified by the recipe ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteContainerScanRecipe.go.html to see an example of how to use DeleteContainerScanRecipe API.
func (client VulnerabilityScanningClient) DeleteContainerScanRecipe(ctx context.Context, request DeleteContainerScanRecipeRequest) (response DeleteContainerScanRecipeResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteContainerScanRecipe, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteContainerScanRecipeResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteContainerScanRecipeResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteContainerScanRecipeResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteContainerScanRecipeResponse")
	}
	return
}

// deleteContainerScanRecipe implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteContainerScanRecipe(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/containerScanRecipes/{containerScanRecipeId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteContainerScanRecipeResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/DeleteContainerScanRecipe"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteContainerScanRecipe", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteContainerScanResult Deletes the ContainerScanResult identified by the container scan ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteContainerScanResult.go.html to see an example of how to use DeleteContainerScanResult API.
func (client VulnerabilityScanningClient) DeleteContainerScanResult(ctx context.Context, request DeleteContainerScanResultRequest) (response DeleteContainerScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteContainerScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteContainerScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteContainerScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteContainerScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteContainerScanResultResponse")
	}
	return
}

// deleteContainerScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteContainerScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/containerScanResults/{containerScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteContainerScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanResult/DeleteContainerScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteContainerScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteContainerScanTarget Deletes the ContainerScanTarget identified by the target ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteContainerScanTarget.go.html to see an example of how to use DeleteContainerScanTarget API.
func (client VulnerabilityScanningClient) DeleteContainerScanTarget(ctx context.Context, request DeleteContainerScanTargetRequest) (response DeleteContainerScanTargetResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteContainerScanTarget, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteContainerScanTargetResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteContainerScanTargetResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteContainerScanTargetResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteContainerScanTargetResponse")
	}
	return
}

// deleteContainerScanTarget implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteContainerScanTarget(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/containerScanTargets/{containerScanTargetId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteContainerScanTargetResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/DeleteContainerScanTarget"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteContainerScanTarget", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteHostAgentScanResult Deletes the HostAgentScanResult identified by the host agent scan ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteHostAgentScanResult.go.html to see an example of how to use DeleteHostAgentScanResult API.
func (client VulnerabilityScanningClient) DeleteHostAgentScanResult(ctx context.Context, request DeleteHostAgentScanResultRequest) (response DeleteHostAgentScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteHostAgentScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteHostAgentScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteHostAgentScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteHostAgentScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteHostAgentScanResultResponse")
	}
	return
}

// deleteHostAgentScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteHostAgentScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/hostAgentScanResults/{hostAgentScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteHostAgentScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/DeleteHostAgentScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteHostAgentScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteHostCisBenchmarkScanResult Deletes the HostCisBenchmarkScanResult identified by the benchmark scan result ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteHostCisBenchmarkScanResult.go.html to see an example of how to use DeleteHostCisBenchmarkScanResult API.
func (client VulnerabilityScanningClient) DeleteHostCisBenchmarkScanResult(ctx context.Context, request DeleteHostCisBenchmarkScanResultRequest) (response DeleteHostCisBenchmarkScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteHostCisBenchmarkScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteHostCisBenchmarkScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteHostCisBenchmarkScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteHostCisBenchmarkScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteHostCisBenchmarkScanResultResponse")
	}
	return
}

// deleteHostCisBenchmarkScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteHostCisBenchmarkScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/hostCisBenchmarkScanResults/{hostCisBenchmarkScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteHostCisBenchmarkScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostCisBenchmarkScanResult/DeleteHostCisBenchmarkScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteHostCisBenchmarkScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteHostEndpointProtectionScanResult Deletes the HostEndpointProtectionScanResult identified by the id
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteHostEndpointProtectionScanResult.go.html to see an example of how to use DeleteHostEndpointProtectionScanResult API.
func (client VulnerabilityScanningClient) DeleteHostEndpointProtectionScanResult(ctx context.Context, request DeleteHostEndpointProtectionScanResultRequest) (response DeleteHostEndpointProtectionScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteHostEndpointProtectionScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteHostEndpointProtectionScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteHostEndpointProtectionScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteHostEndpointProtectionScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteHostEndpointProtectionScanResultResponse")
	}
	return
}

// deleteHostEndpointProtectionScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteHostEndpointProtectionScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/hostEndpointProtectionScanResults/{hostEndpointProtectionScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteHostEndpointProtectionScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostEndpointProtectionScanResult/DeleteHostEndpointProtectionScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteHostEndpointProtectionScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteHostPortScanResult Deletes the HostPortScanResult identified by the host port scan ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteHostPortScanResult.go.html to see an example of how to use DeleteHostPortScanResult API.
func (client VulnerabilityScanningClient) DeleteHostPortScanResult(ctx context.Context, request DeleteHostPortScanResultRequest) (response DeleteHostPortScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteHostPortScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteHostPortScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteHostPortScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteHostPortScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteHostPortScanResultResponse")
	}
	return
}

// deleteHostPortScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteHostPortScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/hostPortScanResults/{hostPortScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteHostPortScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostPortScanResult/DeleteHostPortScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteHostPortScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteHostScanRecipe Deletes the HostScanRecipe identified by the recipe ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteHostScanRecipe.go.html to see an example of how to use DeleteHostScanRecipe API.
func (client VulnerabilityScanningClient) DeleteHostScanRecipe(ctx context.Context, request DeleteHostScanRecipeRequest) (response DeleteHostScanRecipeResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteHostScanRecipe, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteHostScanRecipeResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteHostScanRecipeResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteHostScanRecipeResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteHostScanRecipeResponse")
	}
	return
}

// deleteHostScanRecipe implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteHostScanRecipe(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/hostScanRecipes/{hostScanRecipeId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteHostScanRecipeResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/DeleteHostScanRecipe"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteHostScanRecipe", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// DeleteHostScanTarget Deletes the HostScanTarget identified by the target ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/DeleteHostScanTarget.go.html to see an example of how to use DeleteHostScanTarget API.
func (client VulnerabilityScanningClient) DeleteHostScanTarget(ctx context.Context, request DeleteHostScanTargetRequest) (response DeleteHostScanTargetResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.deleteHostScanTarget, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = DeleteHostScanTargetResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = DeleteHostScanTargetResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(DeleteHostScanTargetResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into DeleteHostScanTargetResponse")
	}
	return
}

// deleteHostScanTarget implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) deleteHostScanTarget(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodDelete, "/hostScanTargets/{hostScanTargetId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response DeleteHostScanTargetResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/DeleteHostScanTarget"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "DeleteHostScanTarget", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ExportHostAgentScanResultCsv Exports a list of HostAgentScanResultSummary objects within a compartment and during a specified time range in CSV format. You can filter the results by problem severity.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ExportHostAgentScanResultCsv.go.html to see an example of how to use ExportHostAgentScanResultCsv API.
func (client VulnerabilityScanningClient) ExportHostAgentScanResultCsv(ctx context.Context, request ExportHostAgentScanResultCsvRequest) (response ExportHostAgentScanResultCsvResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.exportHostAgentScanResultCsv, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ExportHostAgentScanResultCsvResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ExportHostAgentScanResultCsvResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ExportHostAgentScanResultCsvResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ExportHostAgentScanResultCsvResponse")
	}
	return
}

// exportHostAgentScanResultCsv implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) exportHostAgentScanResultCsv(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostAgentScanResults/actions/exportCsv", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ExportHostAgentScanResultCsvResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/ExportHostAgentScanResultCsv"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ExportHostAgentScanResultCsv", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ExportHostVulnerabilityCsv Exports a list of HostVulnerabilitySummary objects in a compartment in CSV format.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ExportHostVulnerabilityCsv.go.html to see an example of how to use ExportHostVulnerabilityCsv API.
func (client VulnerabilityScanningClient) ExportHostVulnerabilityCsv(ctx context.Context, request ExportHostVulnerabilityCsvRequest) (response ExportHostVulnerabilityCsvResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.exportHostVulnerabilityCsv, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ExportHostVulnerabilityCsvResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ExportHostVulnerabilityCsvResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ExportHostVulnerabilityCsvResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ExportHostVulnerabilityCsvResponse")
	}
	return
}

// exportHostVulnerabilityCsv implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) exportHostVulnerabilityCsv(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPost, "/hostVulnerabilities/actions/exportCsv", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ExportHostVulnerabilityCsvResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostVulnerability/ExportHostVulnerabilityCsv"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ExportHostVulnerabilityCsv", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetContainerScanRecipe Retrieves a ContainerScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetContainerScanRecipe.go.html to see an example of how to use GetContainerScanRecipe API.
func (client VulnerabilityScanningClient) GetContainerScanRecipe(ctx context.Context, request GetContainerScanRecipeRequest) (response GetContainerScanRecipeResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getContainerScanRecipe, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetContainerScanRecipeResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetContainerScanRecipeResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetContainerScanRecipeResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetContainerScanRecipeResponse")
	}
	return
}

// getContainerScanRecipe implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getContainerScanRecipe(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/containerScanRecipes/{containerScanRecipeId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetContainerScanRecipeResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/GetContainerScanRecipe"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetContainerScanRecipe", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetContainerScanResult Retrieves a ContainerScanResult identified by the container scan ID. The result includes a list of problems found in a specific image in a Docker repository.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetContainerScanResult.go.html to see an example of how to use GetContainerScanResult API.
func (client VulnerabilityScanningClient) GetContainerScanResult(ctx context.Context, request GetContainerScanResultRequest) (response GetContainerScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getContainerScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetContainerScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetContainerScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetContainerScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetContainerScanResultResponse")
	}
	return
}

// getContainerScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getContainerScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/containerScanResults/{containerScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetContainerScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanResult/GetContainerScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetContainerScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetContainerScanTarget Gets a ContainerScanTarget identified by the target ID. A container scan target specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetContainerScanTarget.go.html to see an example of how to use GetContainerScanTarget API.
func (client VulnerabilityScanningClient) GetContainerScanTarget(ctx context.Context, request GetContainerScanTargetRequest) (response GetContainerScanTargetResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getContainerScanTarget, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetContainerScanTargetResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetContainerScanTargetResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetContainerScanTargetResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetContainerScanTargetResponse")
	}
	return
}

// getContainerScanTarget implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getContainerScanTarget(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/containerScanTargets/{containerScanTargetId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetContainerScanTargetResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/GetContainerScanTarget"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetContainerScanTarget", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetHostAgentScanResult Retrieves a HostAgentScanResult identified by the host agent scan ID. The result includes a list of CVEs detected in a specific compute instance.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetHostAgentScanResult.go.html to see an example of how to use GetHostAgentScanResult API.
func (client VulnerabilityScanningClient) GetHostAgentScanResult(ctx context.Context, request GetHostAgentScanResultRequest) (response GetHostAgentScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getHostAgentScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetHostAgentScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetHostAgentScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetHostAgentScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetHostAgentScanResultResponse")
	}
	return
}

// getHostAgentScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getHostAgentScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostAgentScanResults/{hostAgentScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetHostAgentScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/GetHostAgentScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetHostAgentScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetHostCisBenchmarkScanResult Retrieves a HostCisBenchmarkScanResult identified by the benchmark scan result ID. A CIS (Center for Internet Security) benchmark scan result includes a list of benchmarks that were tested on a specific compute instance, and whether each test passed or failed.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetHostCisBenchmarkScanResult.go.html to see an example of how to use GetHostCisBenchmarkScanResult API.
func (client VulnerabilityScanningClient) GetHostCisBenchmarkScanResult(ctx context.Context, request GetHostCisBenchmarkScanResultRequest) (response GetHostCisBenchmarkScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getHostCisBenchmarkScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetHostCisBenchmarkScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetHostCisBenchmarkScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetHostCisBenchmarkScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetHostCisBenchmarkScanResultResponse")
	}
	return
}

// getHostCisBenchmarkScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getHostCisBenchmarkScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostCisBenchmarkScanResults/{hostCisBenchmarkScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetHostCisBenchmarkScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostCisBenchmarkScanResult/GetHostCisBenchmarkScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetHostCisBenchmarkScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetHostEndpointProtectionScanResult Returns HostEndpointProtectionScanResults for the given host endpoint protection scan result ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetHostEndpointProtectionScanResult.go.html to see an example of how to use GetHostEndpointProtectionScanResult API.
func (client VulnerabilityScanningClient) GetHostEndpointProtectionScanResult(ctx context.Context, request GetHostEndpointProtectionScanResultRequest) (response GetHostEndpointProtectionScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getHostEndpointProtectionScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetHostEndpointProtectionScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetHostEndpointProtectionScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetHostEndpointProtectionScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetHostEndpointProtectionScanResultResponse")
	}
	return
}

// getHostEndpointProtectionScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getHostEndpointProtectionScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostEndpointProtectionScanResults/{hostEndpointProtectionScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetHostEndpointProtectionScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostEndpointProtectionScanResult/GetHostEndpointProtectionScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetHostEndpointProtectionScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetHostPortScanResult Retrieves a HostPortScanResult identified by the host port scan ID. The result includes a list of open ports that were detected in a specific compute instance.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetHostPortScanResult.go.html to see an example of how to use GetHostPortScanResult API.
func (client VulnerabilityScanningClient) GetHostPortScanResult(ctx context.Context, request GetHostPortScanResultRequest) (response GetHostPortScanResultResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getHostPortScanResult, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetHostPortScanResultResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetHostPortScanResultResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetHostPortScanResultResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetHostPortScanResultResponse")
	}
	return
}

// getHostPortScanResult implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getHostPortScanResult(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostPortScanResults/{hostPortScanResultId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetHostPortScanResultResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostPortScanResult/GetHostPortScanResult"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetHostPortScanResult", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetHostScanRecipe Retrieves a HostScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned, and how often to scan.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetHostScanRecipe.go.html to see an example of how to use GetHostScanRecipe API.
func (client VulnerabilityScanningClient) GetHostScanRecipe(ctx context.Context, request GetHostScanRecipeRequest) (response GetHostScanRecipeResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getHostScanRecipe, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetHostScanRecipeResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetHostScanRecipeResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetHostScanRecipeResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetHostScanRecipeResponse")
	}
	return
}

// getHostScanRecipe implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getHostScanRecipe(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostScanRecipes/{hostScanRecipeId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetHostScanRecipeResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/GetHostScanRecipe"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetHostScanRecipe", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetHostScanTarget Retrieves a HostScanTarget identified by the target ID. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetHostScanTarget.go.html to see an example of how to use GetHostScanTarget API.
func (client VulnerabilityScanningClient) GetHostScanTarget(ctx context.Context, request GetHostScanTargetRequest) (response GetHostScanTargetResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getHostScanTarget, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetHostScanTargetResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetHostScanTargetResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetHostScanTargetResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetHostScanTargetResponse")
	}
	return
}

// getHostScanTarget implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getHostScanTarget(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostScanTargets/{hostScanTargetId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetHostScanTargetResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/GetHostScanTarget"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetHostScanTarget", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetHostVulnerability Retrieves a HostVulnerability identified by the host vulnerability ID. A host vulnerability describes a security issue that was detected in scans of one or more compute instances. Common Vulnerabilities and Exposures (CVE) numbers identify security vulnerabilities for operating systems and other software, including Critical Patch Updates and Security Alert advisories.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetHostVulnerability.go.html to see an example of how to use GetHostVulnerability API.
func (client VulnerabilityScanningClient) GetHostVulnerability(ctx context.Context, request GetHostVulnerabilityRequest) (response GetHostVulnerabilityResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getHostVulnerability, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetHostVulnerabilityResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetHostVulnerabilityResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetHostVulnerabilityResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetHostVulnerabilityResponse")
	}
	return
}

// getHostVulnerability implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getHostVulnerability(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostVulnerabilities/{hostVulnerabilityId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetHostVulnerabilityResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostVulnerability/GetHostVulnerability"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetHostVulnerability", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetVulnerability Retrieves a Vulnerability identified by the vulnerability ID. A vulnerability describes a security issue that was detected in scans of one or more compute instances, container scan repositories. Common Vulnerabilities and Exposures (CVE) numbers identify security vulnerabilities for operating systems and other software, including Critical Patch Updates and Security Alert advisories.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetVulnerability.go.html to see an example of how to use GetVulnerability API.
func (client VulnerabilityScanningClient) GetVulnerability(ctx context.Context, request GetVulnerabilityRequest) (response GetVulnerabilityResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getVulnerability, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetVulnerabilityResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetVulnerabilityResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetVulnerabilityResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetVulnerabilityResponse")
	}
	return
}

// getVulnerability implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getVulnerability(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/vulnerabilities/{vulnerabilityId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetVulnerabilityResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/Vulnerability/GetVulnerability"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetVulnerability", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// GetWorkRequest Gets the status of the work request with the given ID.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/GetWorkRequest.go.html to see an example of how to use GetWorkRequest API.
func (client VulnerabilityScanningClient) GetWorkRequest(ctx context.Context, request GetWorkRequestRequest) (response GetWorkRequestResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.getWorkRequest, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = GetWorkRequestResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = GetWorkRequestResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(GetWorkRequestResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into GetWorkRequestResponse")
	}
	return
}

// getWorkRequest implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) getWorkRequest(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/workRequests/{workRequestId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response GetWorkRequestResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/WorkRequest/GetWorkRequest"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "GetWorkRequest", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListContainerScanRecipes Retrieves a list of ContainerScanRecipeSummary objects in a compartment. A recipe determines the types of security issues that you want scanned.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListContainerScanRecipes.go.html to see an example of how to use ListContainerScanRecipes API.
func (client VulnerabilityScanningClient) ListContainerScanRecipes(ctx context.Context, request ListContainerScanRecipesRequest) (response ListContainerScanRecipesResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listContainerScanRecipes, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListContainerScanRecipesResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListContainerScanRecipesResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListContainerScanRecipesResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListContainerScanRecipesResponse")
	}
	return
}

// listContainerScanRecipes implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listContainerScanRecipes(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/containerScanRecipes", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListContainerScanRecipesResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/ListContainerScanRecipes"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListContainerScanRecipes", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListContainerScanResults Retrieves a list of ContainerScanResultSummary objects in a compartment. You can filter and sort the results by problem severity and time. A container scan result includes a list of problems detected in a specific image in a Docker repository.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListContainerScanResults.go.html to see an example of how to use ListContainerScanResults API.
func (client VulnerabilityScanningClient) ListContainerScanResults(ctx context.Context, request ListContainerScanResultsRequest) (response ListContainerScanResultsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listContainerScanResults, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListContainerScanResultsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListContainerScanResultsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListContainerScanResultsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListContainerScanResultsResponse")
	}
	return
}

// listContainerScanResults implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listContainerScanResults(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/containerScanResults", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListContainerScanResultsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanResult/ListContainerScanResults"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListContainerScanResults", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListContainerScanTargets Retrieves a list of ContainerScanTargetSummary objects in a compartment. A container scan target specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListContainerScanTargets.go.html to see an example of how to use ListContainerScanTargets API.
func (client VulnerabilityScanningClient) ListContainerScanTargets(ctx context.Context, request ListContainerScanTargetsRequest) (response ListContainerScanTargetsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listContainerScanTargets, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListContainerScanTargetsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListContainerScanTargetsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListContainerScanTargetsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListContainerScanTargetsResponse")
	}
	return
}

// listContainerScanTargets implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listContainerScanTargets(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/containerScanTargets", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListContainerScanTargetsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/ListContainerScanTargets"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListContainerScanTargets", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostAgentScanResults Retrieves a list of HostAgentScanResultSummary objects in a compartment. You can filter and sort the results by problem severity and time. An agent scan result includes a list of CVEs detected in a specific compute instance.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostAgentScanResults.go.html to see an example of how to use ListHostAgentScanResults API.
func (client VulnerabilityScanningClient) ListHostAgentScanResults(ctx context.Context, request ListHostAgentScanResultsRequest) (response ListHostAgentScanResultsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostAgentScanResults, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostAgentScanResultsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostAgentScanResultsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostAgentScanResultsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostAgentScanResultsResponse")
	}
	return
}

// listHostAgentScanResults implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostAgentScanResults(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostAgentScanResults", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostAgentScanResultsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostAgentScanResult/ListHostAgentScanResults"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostAgentScanResults", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostCisBenchmarkScanResults Retrieves a list of HostCisBenchmarkScanResultSummary objects in a compartment. You can filter and sort the results by problem severity and time. A CIS (Center for Internet Security) benchmark scan result includes the number of failed benchmark tests on a specific compute instance.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostCisBenchmarkScanResults.go.html to see an example of how to use ListHostCisBenchmarkScanResults API.
func (client VulnerabilityScanningClient) ListHostCisBenchmarkScanResults(ctx context.Context, request ListHostCisBenchmarkScanResultsRequest) (response ListHostCisBenchmarkScanResultsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostCisBenchmarkScanResults, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostCisBenchmarkScanResultsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostCisBenchmarkScanResultsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostCisBenchmarkScanResultsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostCisBenchmarkScanResultsResponse")
	}
	return
}

// listHostCisBenchmarkScanResults implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostCisBenchmarkScanResults(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostCisBenchmarkScanResults", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostCisBenchmarkScanResultsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostCisBenchmarkScanResult/ListHostCisBenchmarkScanResults"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostCisBenchmarkScanResults", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostEndpointProtectionScanResults Returns a collection of HostEndpointProtectionScanResultSummary objects
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostEndpointProtectionScanResults.go.html to see an example of how to use ListHostEndpointProtectionScanResults API.
func (client VulnerabilityScanningClient) ListHostEndpointProtectionScanResults(ctx context.Context, request ListHostEndpointProtectionScanResultsRequest) (response ListHostEndpointProtectionScanResultsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostEndpointProtectionScanResults, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostEndpointProtectionScanResultsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostEndpointProtectionScanResultsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostEndpointProtectionScanResultsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostEndpointProtectionScanResultsResponse")
	}
	return
}

// listHostEndpointProtectionScanResults implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostEndpointProtectionScanResults(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostEndpointProtectionScanResults", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostEndpointProtectionScanResultsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostEndpointProtectionScanResult/ListHostEndpointProtectionScanResults"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostEndpointProtectionScanResults", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostPortScanResults Retrieves a list of HostPortScanResultSummary objects in a compartment. You can filter and sort the results by problem severity and time. A port scan result includes a list of open ports that were detected in a specific compute instance.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostPortScanResults.go.html to see an example of how to use ListHostPortScanResults API.
func (client VulnerabilityScanningClient) ListHostPortScanResults(ctx context.Context, request ListHostPortScanResultsRequest) (response ListHostPortScanResultsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostPortScanResults, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostPortScanResultsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostPortScanResultsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostPortScanResultsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostPortScanResultsResponse")
	}
	return
}

// listHostPortScanResults implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostPortScanResults(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostPortScanResults", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostPortScanResultsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostPortScanResult/ListHostPortScanResults"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostPortScanResults", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostScanRecipes Retrieves a list of HostScanRecipeSummary objects in a compartment. A recipe determines the types of security issues that you want scanned, and how often to scan.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostScanRecipes.go.html to see an example of how to use ListHostScanRecipes API.
func (client VulnerabilityScanningClient) ListHostScanRecipes(ctx context.Context, request ListHostScanRecipesRequest) (response ListHostScanRecipesResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostScanRecipes, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostScanRecipesResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostScanRecipesResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostScanRecipesResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostScanRecipesResponse")
	}
	return
}

// listHostScanRecipes implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostScanRecipes(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostScanRecipes", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostScanRecipesResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/ListHostScanRecipes"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostScanRecipes", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostScanTargetErrors Retrieves list of errors during scanning on instances associated with HostScanTarget identified by the target ID. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostScanTargetErrors.go.html to see an example of how to use ListHostScanTargetErrors API.
func (client VulnerabilityScanningClient) ListHostScanTargetErrors(ctx context.Context, request ListHostScanTargetErrorsRequest) (response ListHostScanTargetErrorsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostScanTargetErrors, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostScanTargetErrorsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostScanTargetErrorsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostScanTargetErrorsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostScanTargetErrorsResponse")
	}
	return
}

// listHostScanTargetErrors implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostScanTargetErrors(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostScanTargets/{hostScanTargetId}/errors", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostScanTargetErrorsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTargetErrorSummaryCollection/ListHostScanTargetErrors"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostScanTargetErrors", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostScanTargets Retrieves a list of HostScanTargetSummary objects in a compartment. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostScanTargets.go.html to see an example of how to use ListHostScanTargets API.
func (client VulnerabilityScanningClient) ListHostScanTargets(ctx context.Context, request ListHostScanTargetsRequest) (response ListHostScanTargetsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostScanTargets, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostScanTargetsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostScanTargetsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostScanTargetsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostScanTargetsResponse")
	}
	return
}

// listHostScanTargets implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostScanTargets(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostScanTargets", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostScanTargetsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/ListHostScanTargets"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostScanTargets", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostVulnerabilities Retrieves a list of HostVulnerabilitySummary objects in a compartment. You can filter and sort the vulnerabilities by problem severity and time. A host vulnerability describes a security issue that was detected in scans of one or more compute instances.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostVulnerabilities.go.html to see an example of how to use ListHostVulnerabilities API.
func (client VulnerabilityScanningClient) ListHostVulnerabilities(ctx context.Context, request ListHostVulnerabilitiesRequest) (response ListHostVulnerabilitiesResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostVulnerabilities, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostVulnerabilitiesResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostVulnerabilitiesResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostVulnerabilitiesResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostVulnerabilitiesResponse")
	}
	return
}

// listHostVulnerabilities implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostVulnerabilities(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostVulnerabilities", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostVulnerabilitiesResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostVulnerability/ListHostVulnerabilities"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostVulnerabilities", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListHostVulnerabilityImpactedHosts Retrieves a list of HostVulnerabilityImpactedHostSummary objects for a specific host vulnerability ID. An impacted host summary identifies a compute instance on which the specified vulnerability was detected.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostVulnerabilityImpactedHosts.go.html to see an example of how to use ListHostVulnerabilityImpactedHosts API.
func (client VulnerabilityScanningClient) ListHostVulnerabilityImpactedHosts(ctx context.Context, request ListHostVulnerabilityImpactedHostsRequest) (response ListHostVulnerabilityImpactedHostsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listHostVulnerabilityImpactedHosts, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListHostVulnerabilityImpactedHostsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListHostVulnerabilityImpactedHostsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListHostVulnerabilityImpactedHostsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListHostVulnerabilityImpactedHostsResponse")
	}
	return
}

// listHostVulnerabilityImpactedHosts implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listHostVulnerabilityImpactedHosts(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/hostVulnerabilities/{hostVulnerabilityId}/impactedHosts", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListHostVulnerabilityImpactedHostsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostVulnerability/ListHostVulnerabilityImpactedHosts"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListHostVulnerabilityImpactedHosts", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListVulnerabilities Retrieves a list of VulnerabilitySummary objects in a compartment. You can filter and sort the vulnerabilities by problem severity and time and type. A vulnerability describes a security issue that was detected in scans of one or more compute instances, container images.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListVulnerabilities.go.html to see an example of how to use ListVulnerabilities API.
func (client VulnerabilityScanningClient) ListVulnerabilities(ctx context.Context, request ListVulnerabilitiesRequest) (response ListVulnerabilitiesResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listVulnerabilities, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListVulnerabilitiesResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListVulnerabilitiesResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListVulnerabilitiesResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListVulnerabilitiesResponse")
	}
	return
}

// listVulnerabilities implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listVulnerabilities(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/vulnerabilities", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListVulnerabilitiesResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/Vulnerability/ListVulnerabilities"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListVulnerabilities", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListVulnerabilityImpactedContainers Retrieves a list of VulnerabilityImpactedContainerSummary objects for a specific vulnerability ID. An impacted container image summary identifies container images on which the specified vulnerability was detected.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListVulnerabilityImpactedContainers.go.html to see an example of how to use ListVulnerabilityImpactedContainers API.
func (client VulnerabilityScanningClient) ListVulnerabilityImpactedContainers(ctx context.Context, request ListVulnerabilityImpactedContainersRequest) (response ListVulnerabilityImpactedContainersResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listVulnerabilityImpactedContainers, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListVulnerabilityImpactedContainersResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListVulnerabilityImpactedContainersResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListVulnerabilityImpactedContainersResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListVulnerabilityImpactedContainersResponse")
	}
	return
}

// listVulnerabilityImpactedContainers implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listVulnerabilityImpactedContainers(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/vulnerabilities/{vulnerabilityId}/impactedContainers", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListVulnerabilityImpactedContainersResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/Vulnerability/ListVulnerabilityImpactedContainers"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListVulnerabilityImpactedContainers", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListVulnerabilityImpactedHosts Retrieves a list of VulnerabilityImpactedHostSummary objects for a specific host vulnerability ID. An impacted host summary identifies a compute instance on which the specified vulnerability was detected.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListVulnerabilityImpactedHosts.go.html to see an example of how to use ListVulnerabilityImpactedHosts API.
func (client VulnerabilityScanningClient) ListVulnerabilityImpactedHosts(ctx context.Context, request ListVulnerabilityImpactedHostsRequest) (response ListVulnerabilityImpactedHostsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listVulnerabilityImpactedHosts, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListVulnerabilityImpactedHostsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListVulnerabilityImpactedHostsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListVulnerabilityImpactedHostsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListVulnerabilityImpactedHostsResponse")
	}
	return
}

// listVulnerabilityImpactedHosts implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listVulnerabilityImpactedHosts(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/vulnerabilities/{vulnerabilityId}/impactedHosts", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListVulnerabilityImpactedHostsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/Vulnerability/ListVulnerabilityImpactedHosts"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListVulnerabilityImpactedHosts", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListWorkRequestErrors Return a (paginated) list of errors for a given work request.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListWorkRequestErrors.go.html to see an example of how to use ListWorkRequestErrors API.
func (client VulnerabilityScanningClient) ListWorkRequestErrors(ctx context.Context, request ListWorkRequestErrorsRequest) (response ListWorkRequestErrorsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listWorkRequestErrors, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListWorkRequestErrorsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListWorkRequestErrorsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListWorkRequestErrorsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListWorkRequestErrorsResponse")
	}
	return
}

// listWorkRequestErrors implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listWorkRequestErrors(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/workRequests/{workRequestId}/errors", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListWorkRequestErrorsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/WorkRequestError/ListWorkRequestErrors"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListWorkRequestErrors", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListWorkRequestLogs Return a (paginated) list of logs for a given work request.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListWorkRequestLogs.go.html to see an example of how to use ListWorkRequestLogs API.
func (client VulnerabilityScanningClient) ListWorkRequestLogs(ctx context.Context, request ListWorkRequestLogsRequest) (response ListWorkRequestLogsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listWorkRequestLogs, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListWorkRequestLogsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListWorkRequestLogsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListWorkRequestLogsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListWorkRequestLogsResponse")
	}
	return
}

// listWorkRequestLogs implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listWorkRequestLogs(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/workRequests/{workRequestId}/logs", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListWorkRequestLogsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/WorkRequestLogEntry/ListWorkRequestLogs"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListWorkRequestLogs", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// ListWorkRequests Lists the work requests in a compartment.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListWorkRequests.go.html to see an example of how to use ListWorkRequests API.
func (client VulnerabilityScanningClient) ListWorkRequests(ctx context.Context, request ListWorkRequestsRequest) (response ListWorkRequestsResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.listWorkRequests, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = ListWorkRequestsResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = ListWorkRequestsResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(ListWorkRequestsResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into ListWorkRequestsResponse")
	}
	return
}

// listWorkRequests implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) listWorkRequests(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodGet, "/workRequests", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response ListWorkRequestsResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/WorkRequest/ListWorkRequests"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "ListWorkRequests", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// UpdateContainerScanRecipe Updates the ContainerScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/UpdateContainerScanRecipe.go.html to see an example of how to use UpdateContainerScanRecipe API.
func (client VulnerabilityScanningClient) UpdateContainerScanRecipe(ctx context.Context, request UpdateContainerScanRecipeRequest) (response UpdateContainerScanRecipeResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.updateContainerScanRecipe, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = UpdateContainerScanRecipeResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = UpdateContainerScanRecipeResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(UpdateContainerScanRecipeResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into UpdateContainerScanRecipeResponse")
	}
	return
}

// updateContainerScanRecipe implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) updateContainerScanRecipe(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPut, "/containerScanRecipes/{containerScanRecipeId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response UpdateContainerScanRecipeResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanRecipe/UpdateContainerScanRecipe"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "UpdateContainerScanRecipe", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// UpdateContainerScanTarget Updates the ContainerScanTarget identified by the target ID. A container scan target specifies a group of one or more Docker image repositories in Oracle Cloud Infrastructure Registry (OCIR) that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/UpdateContainerScanTarget.go.html to see an example of how to use UpdateContainerScanTarget API.
func (client VulnerabilityScanningClient) UpdateContainerScanTarget(ctx context.Context, request UpdateContainerScanTargetRequest) (response UpdateContainerScanTargetResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.updateContainerScanTarget, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = UpdateContainerScanTargetResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = UpdateContainerScanTargetResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(UpdateContainerScanTargetResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into UpdateContainerScanTargetResponse")
	}
	return
}

// updateContainerScanTarget implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) updateContainerScanTarget(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPut, "/containerScanTargets/{containerScanTargetId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response UpdateContainerScanTargetResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/ContainerScanTarget/UpdateContainerScanTarget"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "UpdateContainerScanTarget", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// UpdateHostScanRecipe Updates the HostScanRecipe identified by the recipe ID. A recipe determines the types of security issues that you want scanned, and how often to scan.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/UpdateHostScanRecipe.go.html to see an example of how to use UpdateHostScanRecipe API.
func (client VulnerabilityScanningClient) UpdateHostScanRecipe(ctx context.Context, request UpdateHostScanRecipeRequest) (response UpdateHostScanRecipeResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.updateHostScanRecipe, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = UpdateHostScanRecipeResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = UpdateHostScanRecipeResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(UpdateHostScanRecipeResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into UpdateHostScanRecipeResponse")
	}
	return
}

// updateHostScanRecipe implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) updateHostScanRecipe(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPut, "/hostScanRecipes/{hostScanRecipeId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response UpdateHostScanRecipeResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanRecipe/UpdateHostScanRecipe"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "UpdateHostScanRecipe", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}

// UpdateHostScanTarget Updates the HostScanTarget identified by the target ID. A host scan target is a collection of compute instances that you want routinely scanned for security vulnerabilities.
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/UpdateHostScanTarget.go.html to see an example of how to use UpdateHostScanTarget API.
func (client VulnerabilityScanningClient) UpdateHostScanTarget(ctx context.Context, request UpdateHostScanTargetRequest) (response UpdateHostScanTargetResponse, err error) {
	var ociResponse common.OCIResponse
	policy := common.NoRetryPolicy()
	if client.RetryPolicy() != nil {
		policy = *client.RetryPolicy()
	}
	if request.RetryPolicy() != nil {
		policy = *request.RetryPolicy()
	}
	ociResponse, err = common.Retry(ctx, request, client.updateHostScanTarget, policy)
	if err != nil {
		if ociResponse != nil {
			if httpResponse := ociResponse.HTTPResponse(); httpResponse != nil {
				opcRequestId := httpResponse.Header.Get("opc-request-id")
				response = UpdateHostScanTargetResponse{RawResponse: httpResponse, OpcRequestId: &opcRequestId}
			} else {
				response = UpdateHostScanTargetResponse{}
			}
		}
		return
	}
	if convertedResponse, ok := ociResponse.(UpdateHostScanTargetResponse); ok {
		response = convertedResponse
	} else {
		err = fmt.Errorf("failed to convert OCIResponse into UpdateHostScanTargetResponse")
	}
	return
}

// updateHostScanTarget implements the OCIOperation interface (enables retrying operations)
func (client VulnerabilityScanningClient) updateHostScanTarget(ctx context.Context, request common.OCIRequest, binaryReqBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (common.OCIResponse, error) {

	httpRequest, err := request.HTTPRequest(http.MethodPut, "/hostScanTargets/{hostScanTargetId}", binaryReqBody, extraHeaders)
	if err != nil {
		return nil, err
	}

	var response UpdateHostScanTargetResponse
	var httpResponse *http.Response
	httpResponse, err = client.Call(ctx, &httpRequest)
	defer common.CloseBodyIfValid(httpResponse)
	response.RawResponse = httpResponse
	if err != nil {
		apiReferenceLink := "https://docs.oracle.com/iaas/api/#/en/scanning/20210215/HostScanTarget/UpdateHostScanTarget"
		err = common.PostProcessServiceError(err, "VulnerabilityScanning", "UpdateHostScanTarget", apiReferenceLink)
		return response, err
	}

	err = common.UnmarshalResponse(httpResponse, &response)
	return response, err
}
