# Testcontainers issue bounty policy

## General

We want to use issue bounties to encourage contributions in areas that are important to our sponsors, or tricky to solve.
This includes bug fixes and new features.
We hope that this will provide incentives to tackle issues, and gives sponsors a way to influence where development time is expended.
We also want to reward our contributors, some of whom make huge efforts to improve Testcontainers and help their fellow developers!

!!! note
    It's early days for our use of sponsorship, so we expect to evolve this policy over time, possibly without notice. In the event of any ambiguity or dispute, the [Testcontainers org core maintainers](#organisation-core-maintainers) have the final say.

    If you'd like to suggest an improvement to this policy, we'd be grateful for your input - please raise a pull request!

## For Sponsors

Sponsors will be able to create a number of 'bounties' per month, varying according to sponsorship tier.

As a sponsor, the process for creating a bounty is as follows:

* Raise an issue, or find an existing issue that describes the bug or feature.
* Start a discussion with the [Testcontainers org core maintainers](#organisation-core-maintainers) to agree that the issue is suitable for a bounty, and how much the reward amount should be.
* Once agreed, we will assign a label to the issue so that interested developers can find it.

Sponsors can create up to 1 or 3 bounties (according to tier) _per calendar month_ - i.e. the counter resets on the 1st of each month. 
If a sponsor does not use their full quota of bounty credits in a calendar month, they cannot be rolled over to the next month.

Bounties will expire 90 days after creation - after this time, if they have not been resolved we will close them.

## For Contributors

As a contributor, the process for working on an issue with a bounty attached is:

* Find an issue with a bounty attached to it and no assignee, clarify the requirements if necessary, and consider how you would approach working on it.
* Start a discussion with the [Testcontainers org core maintainers](#organisation-core-maintainers) and the bounty owner. To avoid unpleasant surprises at review time, we'll try to confirm that we're happy with your proposed solution.
* If we're happy with your proposed solution, we will assign the ticket to you.
* Once work is complete, we will go through the PR process as usual and merge the work when finished.
* To receive the bounty reward, [raise an invoice](https://opencollective.com/testcontainers/expenses/new) on Open Collective, following the expenses policy on that page.

Note that a 20% cut of the bounty amount will normally be assigned to project maintainers for PR review work.
We believe this reflects that PR review can often be a significant amount of work for some issues - and also gives maintainers an incentive to complete the review and unlock the bounty reward!
Some pull requests are so well done that very little review is necessary. If that happens, the maintainers may choose not to take a cut of the bounty, and instead release the full amount to the contributor.

## Organisation core maintainers

The organisation core maintainers are:

* Richard North (@rnorth)
* Sergei Egorov (@bsideup)
* Kevin Wittek (@kiview)
