/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.lcm;

import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Client {
    private final String hostname;
    private final String ip;
    private boolean isWired;
    private boolean isGuest;
    private final long satisfaction;
    private final long latestAssocTime;
    private final Long deviceModel;

    private Client(Builder builder) {
        this.hostname = builder.hostname;
        this.ip = builder.ip;
        this.isWired = builder.isWired;
        this.isGuest = builder.isGuest;
        this.satisfaction = builder.satisfaction;
        this.latestAssocTime = builder.latestAssocTime;
        this.deviceModel = builder.deviceModel;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getIp() {
        return this.ip;
    }

    public boolean getIsWired() {
        return this.isWired;
    }

    public boolean getIsGuest() {
        return this.isGuest;
    }

    public long getSatisfaction() {
        return this.satisfaction;
    }

    public long getLatestAssocTime() {
        return this.latestAssocTime;
    }

    public Long getDeviceModel() {
        return this.deviceModel;
    }

    public static class Builder {
        private String hostname;
        private String ip;
        private boolean isWired;
        private boolean isGuest;
        private long satisfaction;
        private long latestAssocTime;
        private Long deviceModel;

        public Builder setHostname(String string) {
            this.hostname = string;
            return this;
        }

        public Builder setIp(String string) {
            this.ip = string;
            return this;
        }

        public Builder setIsWired(boolean bl) {
            this.isWired = bl;
            return this;
        }

        public Builder setIsGuest(boolean bl) {
            this.isGuest = bl;
            return this;
        }

        public Builder setSatisfaction(long l2) {
            this.satisfaction = l2;
            return this;
        }

        public Builder setLatestAssocTime(long l2) {
            this.latestAssocTime = l2;
            return this;
        }

        public Builder setDeviceModel(long l2) {
            this.deviceModel = l2 > 0L ? Long.valueOf(l2) : null;
            return this;
        }

        public Client build() {
            return new Client(this);
        }
    }
}

