/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.acl.dto.endpoint;

import com.ubnt.net.integration.api.acl.dto.endpoint.IntegrationMacAclRuleEndpointFilterDto;
import com.ubnt.net.v2.validation.constraints.MacAddress;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

public final class IntegrationMacAclRuleMacAddressEndpointFilterDto
implements IntegrationMacAclRuleEndpointFilterDto {
    @NotEmpty
    @Schema(description="Source/destination MAC addresses this ACL rule will apply to.")
    @ArraySchema(minItems=1)
    private final @NotEmpty List<@NotNull @MacAddress String> macAddresses;
    @Nullable
    @Min(value=1L)
    @Max(value=48L)
    @Schema(description="MAC address prefix length. When null, full MAC address(-es) will be used.")
    private final @Min(value=1L) @Max(value=48L) Integer prefixLength;

    @ConstructorProperties(value={"macAddresses", "prefixLength"})
    @Generated
    IntegrationMacAclRuleMacAddressEndpointFilterDto(List<@NotNull @MacAddress String> list, @Nullable Integer n2) {
        this.macAddresses = list;
        this.prefixLength = n2;
    }

    @Generated
    public static IntegrationMacAclRuleMacAddressEndpointFilterDtoBuilder builder() {
        return new IntegrationMacAclRuleMacAddressEndpointFilterDtoBuilder();
    }

    @Generated
    public List<@NotNull @MacAddress String> getMacAddresses() {
        return this.macAddresses;
    }

    @Nullable
    @Generated
    public Integer getPrefixLength() {
        return this.prefixLength;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationMacAclRuleMacAddressEndpointFilterDto)) {
            return false;
        }
        IntegrationMacAclRuleMacAddressEndpointFilterDto integrationMacAclRuleMacAddressEndpointFilterDto = (IntegrationMacAclRuleMacAddressEndpointFilterDto)object;
        Integer n2 = this.getPrefixLength();
        Integer n3 = integrationMacAclRuleMacAddressEndpointFilterDto.getPrefixLength();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        List<String> list = this.getMacAddresses();
        List<String> list2 = integrationMacAclRuleMacAddressEndpointFilterDto.getMacAddresses();
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        Integer n3 = this.getPrefixLength();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        List<String> list = this.getMacAddresses();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        return n2;
    }

    @Generated
    public String toString() {
        return "IntegrationMacAclRuleMacAddressEndpointFilterDto(macAddresses=" + String.valueOf(this.getMacAddresses()) + ", prefixLength=" + this.getPrefixLength() + ")";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Generated
    public static class IntegrationMacAclRuleMacAddressEndpointFilterDtoBuilder {
        @Generated
        private List<@NotNull @MacAddress String> \u00d200000;
        @Generated
        private Integer super;

        @Generated
        IntegrationMacAclRuleMacAddressEndpointFilterDtoBuilder() {
        }

        @Generated
        public IntegrationMacAclRuleMacAddressEndpointFilterDtoBuilder macAddresses(List<@NotNull @MacAddress String> list) {
            this.\u00d200000 = list;
            return this;
        }

        @Generated
        public IntegrationMacAclRuleMacAddressEndpointFilterDtoBuilder prefixLength(@Nullable Integer n2) {
            this.super = n2;
            return this;
        }

        @Generated
        public IntegrationMacAclRuleMacAddressEndpointFilterDto build() {
            return new IntegrationMacAclRuleMacAddressEndpointFilterDto(this.\u00d200000, this.super);
        }

        @Generated
        public String toString() {
            return "IntegrationMacAclRuleMacAddressEndpointFilterDto.IntegrationMacAclRuleMacAddressEndpointFilterDtoBuilder(macAddresses=" + String.valueOf(this.\u00d200000) + ", prefixLength=" + this.super + ")";
        }
    }
}

