/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.integration.api.network.dto.details;

import com.ubnt.net.Dto;
import com.ubnt.net.integration.api.network.dto.details.A;
import com.ubnt.net.v2.validation.constraints.Ip;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class IntegrationNetworkIpv4DhcpServerConfigurationDto
implements Dto {
    @NotNull
    @Valid
    private final A ipAddressRange;
    @Nullable
    @Ip
    @Schema(description="Gateway IP address provided to DHCP clients. If null, the default gateway will be assigned.")
    private final String gatewayIpAddressOverride;
    @Nullable
    @Size(min=1, max=4)
    @Schema(description="List of DNS servers assigned to client devices by the DHCP server. If none are specified, they will be selected automatically.")
    @ArraySchema(minItems=1, maxItems=4)
    private final @Size(min=1, max=4) List<@NotNull @Ip String> dnsServerIpAddressesOverride;
    @NotNull
    @Min(value=0L)
    @Max(value=31536000L)
    @Schema(description="The lease time in seconds for addresses in this range.")
    private final @NotNull @Min(value=0L) @Max(value=31536000L) Integer leaseTimeSeconds;
    @Nullable
    @Schema(description="Domain name that can be used to access network in the browser.")
    private final String domainName;

    @Generated
    protected IntegrationNetworkIpv4DhcpServerConfigurationDto(IntegrationNetworkIpv4DhcpServerConfigurationDtoBuilder<?, ?> integrationNetworkIpv4DhcpServerConfigurationDtoBuilder) {
        this.ipAddressRange = integrationNetworkIpv4DhcpServerConfigurationDtoBuilder.\u00d500000;
        this.gatewayIpAddressOverride = integrationNetworkIpv4DhcpServerConfigurationDtoBuilder.\u00d400000;
        this.dnsServerIpAddressesOverride = integrationNetworkIpv4DhcpServerConfigurationDtoBuilder.new;
        this.leaseTimeSeconds = integrationNetworkIpv4DhcpServerConfigurationDtoBuilder.o00000;
        this.domainName = integrationNetworkIpv4DhcpServerConfigurationDtoBuilder.\u00d300000;
    }

    @Generated
    public A getIpAddressRange() {
        return this.ipAddressRange;
    }

    @Nullable
    @Generated
    public String getGatewayIpAddressOverride() {
        return this.gatewayIpAddressOverride;
    }

    @Nullable
    @Generated
    public List<@NotNull @Ip String> getDnsServerIpAddressesOverride() {
        return this.dnsServerIpAddressesOverride;
    }

    @Generated
    public Integer getLeaseTimeSeconds() {
        return this.leaseTimeSeconds;
    }

    @Nullable
    @Generated
    public String getDomainName() {
        return this.domainName;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntegrationNetworkIpv4DhcpServerConfigurationDto)) {
            return false;
        }
        IntegrationNetworkIpv4DhcpServerConfigurationDto integrationNetworkIpv4DhcpServerConfigurationDto = (IntegrationNetworkIpv4DhcpServerConfigurationDto)object;
        if (!integrationNetworkIpv4DhcpServerConfigurationDto.canEqual(this)) {
            return false;
        }
        Integer n2 = this.getLeaseTimeSeconds();
        Integer n3 = integrationNetworkIpv4DhcpServerConfigurationDto.getLeaseTimeSeconds();
        if (n2 == null ? n3 != null : !((Object)n2).equals(n3)) {
            return false;
        }
        A a2 = this.getIpAddressRange();
        A a3 = integrationNetworkIpv4DhcpServerConfigurationDto.getIpAddressRange();
        if (a2 == null ? a3 != null : !((Object)a2).equals(a3)) {
            return false;
        }
        String string = this.getGatewayIpAddressOverride();
        String string2 = integrationNetworkIpv4DhcpServerConfigurationDto.getGatewayIpAddressOverride();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        List<String> list = this.getDnsServerIpAddressesOverride();
        List<String> list2 = integrationNetworkIpv4DhcpServerConfigurationDto.getDnsServerIpAddressesOverride();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        String string3 = this.getDomainName();
        String string4 = integrationNetworkIpv4DhcpServerConfigurationDto.getDomainName();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof IntegrationNetworkIpv4DhcpServerConfigurationDto;
    }

    @Generated
    public int hashCode() {
        int n2 = 1;
        Integer n3 = this.getLeaseTimeSeconds();
        n2 = n2 * 59 + (n3 == null ? 43 : ((Object)n3).hashCode());
        A a2 = this.getIpAddressRange();
        n2 = n2 * 59 + (a2 == null ? 43 : ((Object)a2).hashCode());
        String string = this.getGatewayIpAddressOverride();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        List<String> list = this.getDnsServerIpAddressesOverride();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        String string2 = this.getDomainName();
        n2 = n2 * 59 + (string2 == null ? 43 : string2.hashCode());
        return n2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Generated
    public static abstract class IntegrationNetworkIpv4DhcpServerConfigurationDtoBuilder<C extends IntegrationNetworkIpv4DhcpServerConfigurationDto, B extends IntegrationNetworkIpv4DhcpServerConfigurationDtoBuilder<C, B>> {
        @Generated
        private A \u00d500000;
        @Generated
        private String \u00d400000;
        @Generated
        private List<@NotNull @Ip String> new;
        @Generated
        private Integer o00000;
        @Generated
        private String \u00d300000;

        @Generated
        public B ipAddressRange(A a2) {
            this.\u00d500000 = a2;
            return this.o00000();
        }

        @Generated
        public B gatewayIpAddressOverride(@Nullable String string) {
            this.\u00d400000 = string;
            return this.o00000();
        }

        @Generated
        public B dnsServerIpAddressesOverride(@Nullable List<@NotNull @Ip String> list) {
            this.new = list;
            return this.o00000();
        }

        @Generated
        public B leaseTimeSeconds(Integer n2) {
            this.o00000 = n2;
            return this.o00000();
        }

        @Generated
        public B domainName(@Nullable String string) {
            this.\u00d300000 = string;
            return this.o00000();
        }

        @Generated
        protected abstract B o00000();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "IntegrationNetworkIpv4DhcpServerConfigurationDto.IntegrationNetworkIpv4DhcpServerConfigurationDtoBuilder(ipAddressRange=" + String.valueOf(this.\u00d500000) + ", gatewayIpAddressOverride=" + this.\u00d400000 + ", dnsServerIpAddressesOverride=" + String.valueOf(this.new) + ", leaseTimeSeconds=" + this.o00000 + ", domainName=" + this.\u00d300000 + ")";
        }
    }
}

