/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wan;

import com.ubnt.data.Site;
import com.ubnt.model.api.wan.loadbalancing.WanLoadBalancingConfigurationDto;
import com.ubnt.model.api.wan.loadbalancing.WanLoadBalancingStatusDto;
import com.ubnt.net.v2.V2RestController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="WAN Load Balancing")
public class WanLoadBalancingController {
    private final com.ubnt.service.wan.loadbalancing.Object super;

    public WanLoadBalancingController(com.ubnt.service.wan.loadbalancing.Object object) {
        this.super = object;
    }

    @Operation(summary="Get WAN load balancing configuration", description="Since 7.1.36")
    @GetMapping(value={"/api/site/{siteName}/wan/load-balancing/configuration"})
    public WanLoadBalancingConfigurationDto getWanLoadBalancingConfiguration(@PathVariable(value="siteName") Site site) {
        return WanLoadBalancingConfigurationDto.of(this.super.o00000(site.getId()));
    }

    @Operation(summary="Update WAN load balancing configuration", description="Since 7.1.36")
    @PutMapping(value={"/api/site/{siteName}/wan/load-balancing/configuration"})
    public WanLoadBalancingConfigurationDto updateWanLoadBalancingConfiguration(@PathVariable(value="siteName") Site site, @Valid @RequestBody WanLoadBalancingConfigurationDto wanLoadBalancingConfigurationDto) {
        return WanLoadBalancingConfigurationDto.of(this.super.\u00d400000(wanLoadBalancingConfigurationDto.toWanLoadBalancingConfiguration(site.getId())));
    }

    @Operation(summary="Get WAN load balancing status", description="Since 7.1.36")
    @GetMapping(value={"/api/site/{siteName}/wan/load-balancing/status"})
    public WanLoadBalancingStatusDto getWanLoadBalancingStatus(@PathVariable(value="siteName") Site site) {
        return WanLoadBalancingStatusDto.of(this.super.\u00d6O0000(site.getId()));
    }
}

