/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.wifi;

import com.ubnt.data.WlanConf;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.model.WifiTemplate;
import com.ubnt.service.orchestration.template.TemplateConfigurationConstructor;
import com.ubnt.service.orchestration.template.TemplateProvisioningHandler;
import com.ubnt.service.orchestration.template.TemplateProvisioningValidationIssue;
import com.ubnt.service.orchestration.template.TemplateType;
import com.ubnt.service.orchestration.template.wifi.WifiConfigsProvisionService;
import com.ubnt.service.orchestration.template.wifi.validator.WifiOrchestrationError;
import com.ubnt.service.system.jA;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class WifiTemplateTypeProvisioningHandler
implements TemplateProvisioningHandler<WifiTemplate> {
    private static final Logger LOGGER = jA.ifnew;
    private final TemplateConfigurationConstructor<WifiTemplate, WlanConf> templateConfigurationConstructor;
    private final WifiConfigsProvisionService wlanConfManagementService;

    @Override
    public Map<TemplateProvisioningValidationIssue, List<IssueDetailReportDto>> handle(String string, WifiTemplate wifiTemplate) {
        try {
            WlanConf wlanConf = this.templateConfigurationConstructor.construct(string, wifiTemplate);
            if (wlanConf == null) {
                LOGGER.warn("Can't construct WLAN configuration for siteId '{}' and orchestrationId '{}'", (Object)string, (Object)wifiTemplate.getMetaData().orchestrationId());
                return Map.of(TemplateProvisioningValidationIssue.ERROR, List.of(IssueDetailReportDto.builder().code(WifiOrchestrationError.PROVISIONING_ERROR).issueDetail("Can't construct WLAN configuration from template").build()));
            }
            return this.wlanConfManagementService.validateAndProvision(List.of(wlanConf));
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to apply WLAN configuration: {}", (Object)exception.getMessage(), (Object)exception);
            return Map.of(TemplateProvisioningValidationIssue.ERROR, List.of(IssueDetailReportDto.builder().code(WifiOrchestrationError.PROVISIONING_ERROR).issueDetail("Failed to apply WLAN configuration").build()));
        }
    }

    @Override
    public TemplateType getType() {
        return TemplateType.WIFI;
    }

    @Override
    public Class<WifiTemplate> handledType() {
        return WifiTemplate.class;
    }

    @ConstructorProperties(value={"templateConfigurationConstructor", "wlanConfManagementService"})
    @Generated
    public WifiTemplateTypeProvisioningHandler(TemplateConfigurationConstructor<WifiTemplate, WlanConf> templateConfigurationConstructor, WifiConfigsProvisionService wifiConfigsProvisionService) {
        this.templateConfigurationConstructor = templateConfigurationConstructor;
        this.wlanConfManagementService = wifiConfigsProvisionService;
    }
}

