// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/iam/v3beta/policy_binding_resources.proto

package iampb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	expr "google.golang.org/genproto/googleapis/type/expr"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Different policy kinds supported in this binding.
type PolicyBinding_PolicyKind int32

const (
	// Unspecified policy kind; Not a valid state
	PolicyBinding_POLICY_KIND_UNSPECIFIED PolicyBinding_PolicyKind = 0
	// Principal access boundary policy kind
	PolicyBinding_PRINCIPAL_ACCESS_BOUNDARY PolicyBinding_PolicyKind = 1
)

// Enum value maps for PolicyBinding_PolicyKind.
var (
	PolicyBinding_PolicyKind_name = map[int32]string{
		0: "POLICY_KIND_UNSPECIFIED",
		1: "PRINCIPAL_ACCESS_BOUNDARY",
	}
	PolicyBinding_PolicyKind_value = map[string]int32{
		"POLICY_KIND_UNSPECIFIED":   0,
		"PRINCIPAL_ACCESS_BOUNDARY": 1,
	}
)

func (x PolicyBinding_PolicyKind) Enum() *PolicyBinding_PolicyKind {
	p := new(PolicyBinding_PolicyKind)
	*p = x
	return p
}

func (x PolicyBinding_PolicyKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PolicyBinding_PolicyKind) Descriptor() protoreflect.EnumDescriptor {
	return file_google_iam_v3beta_policy_binding_resources_proto_enumTypes[0].Descriptor()
}

func (PolicyBinding_PolicyKind) Type() protoreflect.EnumType {
	return &file_google_iam_v3beta_policy_binding_resources_proto_enumTypes[0]
}

func (x PolicyBinding_PolicyKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PolicyBinding_PolicyKind.Descriptor instead.
func (PolicyBinding_PolicyKind) EnumDescriptor() ([]byte, []int) {
	return file_google_iam_v3beta_policy_binding_resources_proto_rawDescGZIP(), []int{0, 0}
}

// IAM policy binding resource.
type PolicyBinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the policy binding, in the format
	// `{binding_parent/locations/{location}/policyBindings/{policy_binding_id}`.
	// The binding parent is the closest Resource Manager resource (project,
	// folder, or organization) to the binding target.
	//
	// Format:
	//
	// * `projects/{project_id}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `projects/{project_number}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `folders/{folder_id}/locations/{location}/policyBindings/{policy_binding_id}`
	// * `organizations/{organization_id}/locations/{location}/policyBindings/{policy_binding_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The globally unique ID of the policy binding. Assigned when
	// the policy binding is created.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Optional. The etag for the policy binding.
	// If this is provided on update, it must match the server's etag.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. The description of the policy binding. Must be less than or equal
	// to 63 characters.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined annotations. See
	// https://google.aip.dev/148#annotations for more details such as format and
	// size limitations
	Annotations map[string]string `protobuf:"bytes,5,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Immutable. Target is the full resource name of the resource to
	// which the policy will be bound. Immutable once set.
	Target *PolicyBinding_Target `protobuf:"bytes,6,opt,name=target,proto3" json:"target,omitempty"`
	// Immutable. The kind of the policy to attach in this binding. This field
	// must be one of the following:
	//
	// - Left empty (will be automatically set to the policy kind)
	// - The input policy kind
	PolicyKind PolicyBinding_PolicyKind `protobuf:"varint,11,opt,name=policy_kind,json=policyKind,proto3,enum=google.iam.v3beta.PolicyBinding_PolicyKind" json:"policy_kind,omitempty"`
	// Required. Immutable. The resource name of the policy to be bound. The
	// binding parent and policy must belong to the same organization.
	Policy string `protobuf:"bytes,7,opt,name=policy,proto3" json:"policy,omitempty"`
	// Output only. The globally unique ID of the policy to be bound.
	PolicyUid string `protobuf:"bytes,12,opt,name=policy_uid,json=policyUid,proto3" json:"policy_uid,omitempty"`
	// Optional. The condition to apply to the policy binding. When set, the
	// `expression` field in the `Expr` must include from 1 to 10 subexpressions,
	// joined by the
	// "||"(Logical OR), "&&"(Logical AND) or "!"(Logical NOT) operators and
	// cannot contain more than 250 characters.
	//
	// The condition is currently only supported when bound to policies of kind
	// principal access boundary.
	//
	// When the bound policy is a principal access boundary policy, the only
	// supported attributes in any subexpression are `principal.type` and
	// `principal.subject`. An example expression is: "principal.type ==
	// 'iam.googleapis.com/ServiceAccount'" or "principal.subject ==
	// 'bob@example.com'".
	//
	// Allowed operations for `principal.subject`:
	//
	// - `principal.subject == <principal subject string>`
	// - `principal.subject != <principal subject string>`
	// - `principal.subject in [<list of principal subjects>]`
	// - `principal.subject.startsWith(<string>)`
	// - `principal.subject.endsWith(<string>)`
	//
	// Allowed operations for `principal.type`:
	//
	// - `principal.type == <principal type string>`
	// - `principal.type != <principal type string>`
	// - `principal.type in [<list of principal types>]`
	//
	// Supported principal types are Workspace, Workforce Pool, Workload Pool and
	// Service Account. Allowed string must be one of:
	//
	// - iam.googleapis.com/WorkspaceIdentity
	// - iam.googleapis.com/WorkforcePoolIdentity
	// - iam.googleapis.com/WorkloadPoolIdentity
	// - iam.googleapis.com/ServiceAccount
	Condition *expr.Expr `protobuf:"bytes,8,opt,name=condition,proto3" json:"condition,omitempty"`
	// Output only. The time when the policy binding was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the policy binding was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *PolicyBinding) Reset() {
	*x = PolicyBinding{}
	mi := &file_google_iam_v3beta_policy_binding_resources_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyBinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyBinding) ProtoMessage() {}

func (x *PolicyBinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3beta_policy_binding_resources_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyBinding.ProtoReflect.Descriptor instead.
func (*PolicyBinding) Descriptor() ([]byte, []int) {
	return file_google_iam_v3beta_policy_binding_resources_proto_rawDescGZIP(), []int{0}
}

func (x *PolicyBinding) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PolicyBinding) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *PolicyBinding) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PolicyBinding) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PolicyBinding) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

func (x *PolicyBinding) GetTarget() *PolicyBinding_Target {
	if x != nil {
		return x.Target
	}
	return nil
}

func (x *PolicyBinding) GetPolicyKind() PolicyBinding_PolicyKind {
	if x != nil {
		return x.PolicyKind
	}
	return PolicyBinding_POLICY_KIND_UNSPECIFIED
}

func (x *PolicyBinding) GetPolicy() string {
	if x != nil {
		return x.Policy
	}
	return ""
}

func (x *PolicyBinding) GetPolicyUid() string {
	if x != nil {
		return x.PolicyUid
	}
	return ""
}

func (x *PolicyBinding) GetCondition() *expr.Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *PolicyBinding) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *PolicyBinding) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Target is the full resource name of the resource to which the policy will
// be bound. Immutable once set.
type PolicyBinding_Target struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The different types of targets that can be bound to a policy.
	//
	// Types that are assignable to Target:
	//
	//	*PolicyBinding_Target_PrincipalSet
	Target isPolicyBinding_Target_Target `protobuf_oneof:"target"`
}

func (x *PolicyBinding_Target) Reset() {
	*x = PolicyBinding_Target{}
	mi := &file_google_iam_v3beta_policy_binding_resources_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PolicyBinding_Target) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PolicyBinding_Target) ProtoMessage() {}

func (x *PolicyBinding_Target) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3beta_policy_binding_resources_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PolicyBinding_Target.ProtoReflect.Descriptor instead.
func (*PolicyBinding_Target) Descriptor() ([]byte, []int) {
	return file_google_iam_v3beta_policy_binding_resources_proto_rawDescGZIP(), []int{0, 0}
}

func (m *PolicyBinding_Target) GetTarget() isPolicyBinding_Target_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (x *PolicyBinding_Target) GetPrincipalSet() string {
	if x, ok := x.GetTarget().(*PolicyBinding_Target_PrincipalSet); ok {
		return x.PrincipalSet
	}
	return ""
}

type isPolicyBinding_Target_Target interface {
	isPolicyBinding_Target_Target()
}

type PolicyBinding_Target_PrincipalSet struct {
	// Immutable. Full Resource Name used for principal access boundary policy
	// bindings. The principal set must be directly parented by the policy
	// binding's parent or same as the parent if the target is a
	// project/folder/organization.
	//
	// Examples:
	// * For binding's parented by an organization:
	//   - Organization:
	//     `//cloudresourcemanager.googleapis.com/organizations/ORGANIZATION_ID`
	//   - Workforce Identity:
	//     `//iam.googleapis.com/locations/global/workforcePools/WORKFORCE_POOL_ID`
	//   - Workspace Identity:
	//     `//iam.googleapis.com/locations/global/workspace/WORKSPACE_ID`
	//
	// * For binding's parented by a folder:
	//   - Folder:
	//     `//cloudresourcemanager.googleapis.com/folders/FOLDER_ID`
	//
	// * For binding's parented by a project:
	//   - Project:
	//   - `//cloudresourcemanager.googleapis.com/projects/PROJECT_NUMBER`
	//   - `//cloudresourcemanager.googleapis.com/projects/PROJECT_ID`
	//   - Workload Identity Pool:
	//     `//iam.googleapis.com/projects/PROJECT_NUMBER/locations/LOCATION/workloadIdentityPools/WORKLOAD_POOL_ID`
	PrincipalSet string `protobuf:"bytes,1,opt,name=principal_set,json=principalSet,proto3,oneof"`
}

func (*PolicyBinding_Target_PrincipalSet) isPolicyBinding_Target_Target() {}

var File_google_iam_v3beta_policy_binding_resources_proto protoreflect.FileDescriptor

var file_google_iam_v3beta_policy_binding_resources_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x65, 0x78, 0x70,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf1, 0x08, 0x0a, 0x0d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x51, 0x0a, 0x0b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x6b, 0x69, 0x6e, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x4b, 0x69, 0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x1e, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x55, 0x69, 0x64, 0x12, 0x34, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78,
	0x70, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x3e, 0x0a, 0x06, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x12, 0x2a, 0x0a, 0x0d, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x73, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x0c,
	0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x42, 0x08, 0x0a, 0x06,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x48, 0x0a, 0x0a, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x4b, 0x69, 0x6e, 0x64, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4b,
	0x49, 0x4e, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x52, 0x49, 0x4e, 0x43, 0x49, 0x50, 0x41, 0x4c, 0x5f, 0x41,
	0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x10, 0x01,
	0x3a, 0xa8, 0x02, 0xea, 0x41, 0xa4, 0x02, 0x0a, 0x20, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x51, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x12, 0x45, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x7d, 0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x7d, 0x2a, 0x0e, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x32, 0x0d, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x99, 0x01, 0x0a, 0x15,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x42, 0x1b, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x69, 0x61, 0x6d, 0x70, 0x62, 0x3b, 0x69, 0x61,
	0x6d, 0x70, 0x62, 0xaa, 0x02, 0x17, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x49, 0x61, 0x6d, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x17,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x49, 0x61, 0x6d,
	0x5c, 0x56, 0x33, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_iam_v3beta_policy_binding_resources_proto_rawDescOnce sync.Once
	file_google_iam_v3beta_policy_binding_resources_proto_rawDescData = file_google_iam_v3beta_policy_binding_resources_proto_rawDesc
)

func file_google_iam_v3beta_policy_binding_resources_proto_rawDescGZIP() []byte {
	file_google_iam_v3beta_policy_binding_resources_proto_rawDescOnce.Do(func() {
		file_google_iam_v3beta_policy_binding_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_iam_v3beta_policy_binding_resources_proto_rawDescData)
	})
	return file_google_iam_v3beta_policy_binding_resources_proto_rawDescData
}

var file_google_iam_v3beta_policy_binding_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_iam_v3beta_policy_binding_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_iam_v3beta_policy_binding_resources_proto_goTypes = []any{
	(PolicyBinding_PolicyKind)(0), // 0: google.iam.v3beta.PolicyBinding.PolicyKind
	(*PolicyBinding)(nil),         // 1: google.iam.v3beta.PolicyBinding
	(*PolicyBinding_Target)(nil),  // 2: google.iam.v3beta.PolicyBinding.Target
	nil,                           // 3: google.iam.v3beta.PolicyBinding.AnnotationsEntry
	(*expr.Expr)(nil),             // 4: google.type.Expr
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
}
var file_google_iam_v3beta_policy_binding_resources_proto_depIdxs = []int32{
	3, // 0: google.iam.v3beta.PolicyBinding.annotations:type_name -> google.iam.v3beta.PolicyBinding.AnnotationsEntry
	2, // 1: google.iam.v3beta.PolicyBinding.target:type_name -> google.iam.v3beta.PolicyBinding.Target
	0, // 2: google.iam.v3beta.PolicyBinding.policy_kind:type_name -> google.iam.v3beta.PolicyBinding.PolicyKind
	4, // 3: google.iam.v3beta.PolicyBinding.condition:type_name -> google.type.Expr
	5, // 4: google.iam.v3beta.PolicyBinding.create_time:type_name -> google.protobuf.Timestamp
	5, // 5: google.iam.v3beta.PolicyBinding.update_time:type_name -> google.protobuf.Timestamp
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_iam_v3beta_policy_binding_resources_proto_init() }
func file_google_iam_v3beta_policy_binding_resources_proto_init() {
	if File_google_iam_v3beta_policy_binding_resources_proto != nil {
		return
	}
	file_google_iam_v3beta_policy_binding_resources_proto_msgTypes[1].OneofWrappers = []any{
		(*PolicyBinding_Target_PrincipalSet)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_iam_v3beta_policy_binding_resources_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_iam_v3beta_policy_binding_resources_proto_goTypes,
		DependencyIndexes: file_google_iam_v3beta_policy_binding_resources_proto_depIdxs,
		EnumInfos:         file_google_iam_v3beta_policy_binding_resources_proto_enumTypes,
		MessageInfos:      file_google_iam_v3beta_policy_binding_resources_proto_msgTypes,
	}.Build()
	File_google_iam_v3beta_policy_binding_resources_proto = out.File
	file_google_iam_v3beta_policy_binding_resources_proto_rawDesc = nil
	file_google_iam_v3beta_policy_binding_resources_proto_goTypes = nil
	file_google_iam_v3beta_policy_binding_resources_proto_depIdxs = nil
}
