// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: yandex/cloud/storage/v1/bucket_service.proto

package storage

import (
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud"
	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	_ "github.com/yandex-cloud/go-genproto/yandex/cloud/api"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type GetBucketRequest_View int32

const (
	GetBucketRequest_VIEW_UNSPECIFIED GetBucketRequest_View = 0
	// Returns basic information about a bucket.
	//
	// The following fields will _not_ be returned: [Bucket.acl], [Bucket.cors], [Bucket.website_settings],
	// [Bucket.lifecycle_rules], [Bucket.tags].
	GetBucketRequest_VIEW_BASIC GetBucketRequest_View = 1
	// Returns basic information and access control list (ACL) for the bucket.
	//
	// The following fields will _not_ be returned: [Bucket.cors], [Bucket.website_settings], [Bucket.lifecycle_rules],
	// [Bucket.tags].
	GetBucketRequest_VIEW_ACL GetBucketRequest_View = 2
	// Returns full information about a bucket.
	GetBucketRequest_VIEW_FULL GetBucketRequest_View = 3
)

// Enum value maps for GetBucketRequest_View.
var (
	GetBucketRequest_View_name = map[int32]string{
		0: "VIEW_UNSPECIFIED",
		1: "VIEW_BASIC",
		2: "VIEW_ACL",
		3: "VIEW_FULL",
	}
	GetBucketRequest_View_value = map[string]int32{
		"VIEW_UNSPECIFIED": 0,
		"VIEW_BASIC":       1,
		"VIEW_ACL":         2,
		"VIEW_FULL":        3,
	}
)

func (x GetBucketRequest_View) Enum() *GetBucketRequest_View {
	p := new(GetBucketRequest_View)
	*p = x
	return p
}

func (x GetBucketRequest_View) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GetBucketRequest_View) Descriptor() protoreflect.EnumDescriptor {
	return file_yandex_cloud_storage_v1_bucket_service_proto_enumTypes[0].Descriptor()
}

func (GetBucketRequest_View) Type() protoreflect.EnumType {
	return &file_yandex_cloud_storage_v1_bucket_service_proto_enumTypes[0]
}

func (x GetBucketRequest_View) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GetBucketRequest_View.Descriptor instead.
func (GetBucketRequest_View) EnumDescriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{0, 0}
}

type GetBucketRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket to return.
	//
	// To get the bucket name, make a [BucketService.List] request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Scope of information about the bucket to return.
	//
	// Access to scopes is managed via [Identity and Access Management roles](/docs/storage/security),
	// bucket [ACL](/docs/storage/concepts/acl) and [policies](/docs/storage/concepts/policy).
	View          GetBucketRequest_View `protobuf:"varint,2,opt,name=view,proto3,enum=yandex.cloud.storage.v1.GetBucketRequest_View" json:"view,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetBucketRequest) Reset() {
	*x = GetBucketRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBucketRequest) ProtoMessage() {}

func (x *GetBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBucketRequest.ProtoReflect.Descriptor instead.
func (*GetBucketRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetBucketRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetBucketRequest) GetView() GetBucketRequest_View {
	if x != nil {
		return x.View
	}
	return GetBucketRequest_VIEW_UNSPECIFIED
}

type ListBucketsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the folder to list buckets in.
	//
	// To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId      string `protobuf:"bytes,1,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListBucketsRequest) Reset() {
	*x = ListBucketsRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBucketsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBucketsRequest) ProtoMessage() {}

func (x *ListBucketsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBucketsRequest.ProtoReflect.Descriptor instead.
func (*ListBucketsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListBucketsRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

type ListBucketsResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of buckets in the specified folder.
	Buckets       []*Bucket `protobuf:"bytes,1,rep,name=buckets,proto3" json:"buckets,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListBucketsResponse) Reset() {
	*x = ListBucketsResponse{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListBucketsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBucketsResponse) ProtoMessage() {}

func (x *ListBucketsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBucketsResponse.ProtoReflect.Descriptor instead.
func (*ListBucketsResponse) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListBucketsResponse) GetBuckets() []*Bucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

type CreateBucketRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket.
	//
	// The name must be unique within the platform. For naming limitations and rules, see
	// [documentation](/docs/storage/concepts/bucket#naming).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// ID of the folder to create a bucket in.
	//
	// To get the folder ID, make a [yandex.cloud.resourcemanager.v1.FolderService.List] request.
	FolderId string `protobuf:"bytes,2,opt,name=folder_id,json=folderId,proto3" json:"folder_id,omitempty"`
	// Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
	// (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	DefaultStorageClass string `protobuf:"bytes,4,opt,name=default_storage_class,json=defaultStorageClass,proto3" json:"default_storage_class,omitempty"`
	// Maximum size of the bucket.
	// For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
	MaxSize int64 `protobuf:"varint,5,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// Flags for configuring public (anonymous) access to the bucket's content and settings.
	// For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
	AnonymousAccessFlags *AnonymousAccessFlags `protobuf:"bytes,6,opt,name=anonymous_access_flags,json=anonymousAccessFlags,proto3" json:"anonymous_access_flags,omitempty"`
	// Access control list (ACL) of the bucket.
	// For details, see [documentation](/docs/storage/concepts/acl).
	Acl *ACL `protobuf:"bytes,7,opt,name=acl,proto3" json:"acl,omitempty"`
	// List of tags for the bucket.
	// For details, see [documentation](/docs/resource-manager/concepts/labels).
	Tags []*Tag `protobuf:"bytes,8,rep,name=tags,proto3" json:"tags,omitempty"`
	// Configuration for bucket's encryption.
	// For details, see [documentation](/docs/storage/concepts/encryption).
	Encryption *Encryption `protobuf:"bytes,9,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// Bucket versioning status.
	// For details, see [documentation](/docs/storage/concepts/versioning).
	Versioning Versioning `protobuf:"varint,10,opt,name=versioning,proto3,enum=yandex.cloud.storage.v1.Versioning" json:"versioning,omitempty"`
	// Configuration for bucket's allowed private endpoints.
	// requires permission s3:PutBucketAllowedPrivateEndpoints
	AllowedPrivateEndpoints *BucketAllowedPrivateEndpoints `protobuf:"bytes,11,opt,name=allowed_private_endpoints,json=allowedPrivateEndpoints,proto3" json:"allowed_private_endpoints,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *CreateBucketRequest) Reset() {
	*x = CreateBucketRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBucketRequest) ProtoMessage() {}

func (x *CreateBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBucketRequest.ProtoReflect.Descriptor instead.
func (*CreateBucketRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{3}
}

func (x *CreateBucketRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateBucketRequest) GetFolderId() string {
	if x != nil {
		return x.FolderId
	}
	return ""
}

func (x *CreateBucketRequest) GetDefaultStorageClass() string {
	if x != nil {
		return x.DefaultStorageClass
	}
	return ""
}

func (x *CreateBucketRequest) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

func (x *CreateBucketRequest) GetAnonymousAccessFlags() *AnonymousAccessFlags {
	if x != nil {
		return x.AnonymousAccessFlags
	}
	return nil
}

func (x *CreateBucketRequest) GetAcl() *ACL {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *CreateBucketRequest) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *CreateBucketRequest) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *CreateBucketRequest) GetVersioning() Versioning {
	if x != nil {
		return x.Versioning
	}
	return Versioning_VERSIONING_UNSPECIFIED
}

func (x *CreateBucketRequest) GetAllowedPrivateEndpoints() *BucketAllowedPrivateEndpoints {
	if x != nil {
		return x.AllowedPrivateEndpoints
	}
	return nil
}

type CreateBucketMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket that is being created.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateBucketMetadata) Reset() {
	*x = CreateBucketMetadata{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateBucketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBucketMetadata) ProtoMessage() {}

func (x *CreateBucketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBucketMetadata.ProtoReflect.Descriptor instead.
func (*CreateBucketMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateBucketMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type UpdateBucketRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket to update.
	//
	// The name cannot be updated.
	//
	// To get the bucket name, make a [BucketService.List] request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Update mask that specifies which attributes of the bucket should be updated.
	// Use * for full update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Flags for configuring public (anonymous) access to the bucket's content and settings.
	// For details, see [documentation](/docs/storage/concepts/bucket#bucket-access).
	AnonymousAccessFlags *AnonymousAccessFlags `protobuf:"bytes,3,opt,name=anonymous_access_flags,json=anonymousAccessFlags,proto3" json:"anonymous_access_flags,omitempty"`
	// Default storage class for objects in the bucket. Supported classes are standard storage (`STANDARD`), cold storage
	// (`COLD`, `STANDARD_IA`, `NEARLINE` all synonyms), and ice storage (`ICE` and `GLACIER` are synonyms).
	// For details, see [documentation](/docs/storage/concepts/storage-class).
	DefaultStorageClass string `protobuf:"bytes,4,opt,name=default_storage_class,json=defaultStorageClass,proto3" json:"default_storage_class,omitempty"`
	// Maximum size of the bucket, in bytes.
	// For details, see [documentation](/docs/storage/operations/buckets/limit-max-volume).
	MaxSize int64 `protobuf:"varint,5,opt,name=max_size,json=maxSize,proto3" json:"max_size,omitempty"`
	// List of rules for cross-domain requests to objects in the bucket (cross-origin resource sharing, CORS).
	// For details, see [documentation](/docs/storage/concepts/cors).
	Cors []*CorsRule `protobuf:"bytes,6,rep,name=cors,proto3" json:"cors,omitempty"`
	// Configuration for hosting a static website in the bucket.
	// For details, see [documentation](/docs/storage/concepts/hosting).
	WebsiteSettings *WebsiteSettings `protobuf:"bytes,7,opt,name=website_settings,json=websiteSettings,proto3" json:"website_settings,omitempty"`
	// Bucket versioning status.
	// For details, see [documentation](/docs/storage/concepts/versioning).
	Versioning Versioning `protobuf:"varint,8,opt,name=versioning,proto3,enum=yandex.cloud.storage.v1.Versioning" json:"versioning,omitempty"`
	// List of object lifecycle rules for the bucket.
	// For details, see [documentation](/docs/storage/concepts/lifecycles).
	LifecycleRules []*LifecycleRule `protobuf:"bytes,9,rep,name=lifecycle_rules,json=lifecycleRules,proto3" json:"lifecycle_rules,omitempty"`
	// Bucket policies that set permissions for actions with the bucket, its objects, and groups of objects.
	// For details, see [documentation](/docs/storage/concepts/policy).
	Policy *structpb.Struct `protobuf:"bytes,10,opt,name=policy,proto3" json:"policy,omitempty"`
	// Access control list (ACL) of the bucket.
	// For details, see [documentation](/docs/storage/concepts/acl).
	Acl *ACL `protobuf:"bytes,11,opt,name=acl,proto3" json:"acl,omitempty"`
	// List of tags for the bucket.
	// For details, see [documentation](/docs/resource-manager/concepts/labels).
	Tags []*Tag `protobuf:"bytes,12,rep,name=tags,proto3" json:"tags,omitempty"`
	// Configuration for object lock on the bucket.
	// For details about the concept, see [documentation](/docs/storage/concepts/object-lock).
	ObjectLock *ObjectLock `protobuf:"bytes,13,opt,name=object_lock,json=objectLock,proto3" json:"object_lock,omitempty"`
	// Configuration for bucket's encryption.
	// For details, see [documentation](/docs/storage/concepts/encryption)
	Encryption *Encryption `protobuf:"bytes,14,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// requires permission s3:PutBucketAllowedPrivateEndpoints
	AllowedPrivateEndpoints *BucketAllowedPrivateEndpoints `protobuf:"bytes,15,opt,name=allowed_private_endpoints,json=allowedPrivateEndpoints,proto3" json:"allowed_private_endpoints,omitempty"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *UpdateBucketRequest) Reset() {
	*x = UpdateBucketRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBucketRequest) ProtoMessage() {}

func (x *UpdateBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBucketRequest.ProtoReflect.Descriptor instead.
func (*UpdateBucketRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateBucketRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateBucketRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateBucketRequest) GetAnonymousAccessFlags() *AnonymousAccessFlags {
	if x != nil {
		return x.AnonymousAccessFlags
	}
	return nil
}

func (x *UpdateBucketRequest) GetDefaultStorageClass() string {
	if x != nil {
		return x.DefaultStorageClass
	}
	return ""
}

func (x *UpdateBucketRequest) GetMaxSize() int64 {
	if x != nil {
		return x.MaxSize
	}
	return 0
}

func (x *UpdateBucketRequest) GetCors() []*CorsRule {
	if x != nil {
		return x.Cors
	}
	return nil
}

func (x *UpdateBucketRequest) GetWebsiteSettings() *WebsiteSettings {
	if x != nil {
		return x.WebsiteSettings
	}
	return nil
}

func (x *UpdateBucketRequest) GetVersioning() Versioning {
	if x != nil {
		return x.Versioning
	}
	return Versioning_VERSIONING_UNSPECIFIED
}

func (x *UpdateBucketRequest) GetLifecycleRules() []*LifecycleRule {
	if x != nil {
		return x.LifecycleRules
	}
	return nil
}

func (x *UpdateBucketRequest) GetPolicy() *structpb.Struct {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *UpdateBucketRequest) GetAcl() *ACL {
	if x != nil {
		return x.Acl
	}
	return nil
}

func (x *UpdateBucketRequest) GetTags() []*Tag {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *UpdateBucketRequest) GetObjectLock() *ObjectLock {
	if x != nil {
		return x.ObjectLock
	}
	return nil
}

func (x *UpdateBucketRequest) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *UpdateBucketRequest) GetAllowedPrivateEndpoints() *BucketAllowedPrivateEndpoints {
	if x != nil {
		return x.AllowedPrivateEndpoints
	}
	return nil
}

type UpdateBucketMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket that is being updated.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UpdateBucketMetadata) Reset() {
	*x = UpdateBucketMetadata{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateBucketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBucketMetadata) ProtoMessage() {}

func (x *UpdateBucketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBucketMetadata.ProtoReflect.Descriptor instead.
func (*UpdateBucketMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateBucketMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// DeleteBucketRequest deletes requested bucket from the Cloud.
type DeleteBucketRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket to update.
	//
	// To get the bucket name, make a [BucketService.List] request.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteBucketRequest) Reset() {
	*x = DeleteBucketRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBucketRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketRequest) ProtoMessage() {}

func (x *DeleteBucketRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketRequest.ProtoReflect.Descriptor instead.
func (*DeleteBucketRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteBucketRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DeleteBucketMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket that is being deleted.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteBucketMetadata) Reset() {
	*x = DeleteBucketMetadata{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBucketMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketMetadata) ProtoMessage() {}

func (x *DeleteBucketMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketMetadata.ProtoReflect.Descriptor instead.
func (*DeleteBucketMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteBucketMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetBucketStatsRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket to return the statistics for.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetBucketStatsRequest) Reset() {
	*x = GetBucketStatsRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBucketStatsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBucketStatsRequest) ProtoMessage() {}

func (x *GetBucketStatsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBucketStatsRequest.ProtoReflect.Descriptor instead.
func (*GetBucketStatsRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{9}
}

func (x *GetBucketStatsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type GetBucketHTTPSConfigRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket to return the HTTPS configuration for.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GetBucketHTTPSConfigRequest) Reset() {
	*x = GetBucketHTTPSConfigRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetBucketHTTPSConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBucketHTTPSConfigRequest) ProtoMessage() {}

func (x *GetBucketHTTPSConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBucketHTTPSConfigRequest.ProtoReflect.Descriptor instead.
func (*GetBucketHTTPSConfigRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{10}
}

func (x *GetBucketHTTPSConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type SelfManagedHTTPSConfigParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// [PEM](https://en.wikipedia.org/wiki/Privacy-Enhanced_Mail)-encoded certificate.
	CertificatePem string `protobuf:"bytes,1,opt,name=certificate_pem,json=certificatePem,proto3" json:"certificate_pem,omitempty"`
	// [PEM](https://en.wikipedia.org/wiki/Privacy-Enhanced_Mail)-encoded private key for the certificate.
	PrivateKeyPem string `protobuf:"bytes,2,opt,name=private_key_pem,json=privateKeyPem,proto3" json:"private_key_pem,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SelfManagedHTTPSConfigParams) Reset() {
	*x = SelfManagedHTTPSConfigParams{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SelfManagedHTTPSConfigParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SelfManagedHTTPSConfigParams) ProtoMessage() {}

func (x *SelfManagedHTTPSConfigParams) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SelfManagedHTTPSConfigParams.ProtoReflect.Descriptor instead.
func (*SelfManagedHTTPSConfigParams) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{11}
}

func (x *SelfManagedHTTPSConfigParams) GetCertificatePem() string {
	if x != nil {
		return x.CertificatePem
	}
	return ""
}

func (x *SelfManagedHTTPSConfigParams) GetPrivateKeyPem() string {
	if x != nil {
		return x.PrivateKeyPem
	}
	return ""
}

// A resource for a TLS certificate from Certificate Manager.
type CertificateManagerHTTPSConfigParams struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// ID of the certificate.
	//
	// To get the list of all available certificates, make a [yandex.cloud.certificatemanager.v1.CertificateService.List]
	// request.
	CertificateId string `protobuf:"bytes,1,opt,name=certificate_id,json=certificateId,proto3" json:"certificate_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CertificateManagerHTTPSConfigParams) Reset() {
	*x = CertificateManagerHTTPSConfigParams{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CertificateManagerHTTPSConfigParams) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateManagerHTTPSConfigParams) ProtoMessage() {}

func (x *CertificateManagerHTTPSConfigParams) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateManagerHTTPSConfigParams.ProtoReflect.Descriptor instead.
func (*CertificateManagerHTTPSConfigParams) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{12}
}

func (x *CertificateManagerHTTPSConfigParams) GetCertificateId() string {
	if x != nil {
		return x.CertificateId
	}
	return ""
}

type SetBucketHTTPSConfigRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket to update the HTTPS configuration for.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// HTTPS configuration parameters.
	//
	// Types that are valid to be assigned to Params:
	//
	//	*SetBucketHTTPSConfigRequest_SelfManaged
	//	*SetBucketHTTPSConfigRequest_CertificateManager
	Params        isSetBucketHTTPSConfigRequest_Params `protobuf_oneof:"params"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetBucketHTTPSConfigRequest) Reset() {
	*x = SetBucketHTTPSConfigRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetBucketHTTPSConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBucketHTTPSConfigRequest) ProtoMessage() {}

func (x *SetBucketHTTPSConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBucketHTTPSConfigRequest.ProtoReflect.Descriptor instead.
func (*SetBucketHTTPSConfigRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{13}
}

func (x *SetBucketHTTPSConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SetBucketHTTPSConfigRequest) GetParams() isSetBucketHTTPSConfigRequest_Params {
	if x != nil {
		return x.Params
	}
	return nil
}

func (x *SetBucketHTTPSConfigRequest) GetSelfManaged() *SelfManagedHTTPSConfigParams {
	if x != nil {
		if x, ok := x.Params.(*SetBucketHTTPSConfigRequest_SelfManaged); ok {
			return x.SelfManaged
		}
	}
	return nil
}

func (x *SetBucketHTTPSConfigRequest) GetCertificateManager() *CertificateManagerHTTPSConfigParams {
	if x != nil {
		if x, ok := x.Params.(*SetBucketHTTPSConfigRequest_CertificateManager); ok {
			return x.CertificateManager
		}
	}
	return nil
}

type isSetBucketHTTPSConfigRequest_Params interface {
	isSetBucketHTTPSConfigRequest_Params()
}

type SetBucketHTTPSConfigRequest_SelfManaged struct {
	// Your TLS certificate, uploaded directly.
	//
	// Object Storage only supports [PEM](https://en.wikipedia.org/wiki/Privacy-Enhanced_Mail)-encoded certificates.
	SelfManaged *SelfManagedHTTPSConfigParams `protobuf:"bytes,2,opt,name=self_managed,json=selfManaged,proto3,oneof"`
}

type SetBucketHTTPSConfigRequest_CertificateManager struct {
	// TLS certificate from Certificate Manager.
	//
	// To create a certificate in Certificate Manager, make a
	// [yandex.cloud.certificatemanager.v1.CertificateService.Create] request.
	CertificateManager *CertificateManagerHTTPSConfigParams `protobuf:"bytes,3,opt,name=certificate_manager,json=certificateManager,proto3,oneof"`
}

func (*SetBucketHTTPSConfigRequest_SelfManaged) isSetBucketHTTPSConfigRequest_Params() {}

func (*SetBucketHTTPSConfigRequest_CertificateManager) isSetBucketHTTPSConfigRequest_Params() {}

type SetBucketHTTPSConfigMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket the HTTPS configuration is being updated for.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SetBucketHTTPSConfigMetadata) Reset() {
	*x = SetBucketHTTPSConfigMetadata{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SetBucketHTTPSConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBucketHTTPSConfigMetadata) ProtoMessage() {}

func (x *SetBucketHTTPSConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBucketHTTPSConfigMetadata.ProtoReflect.Descriptor instead.
func (*SetBucketHTTPSConfigMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{14}
}

func (x *SetBucketHTTPSConfigMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DeleteBucketHTTPSConfigRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket to delete the HTTPS configuration for.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteBucketHTTPSConfigRequest) Reset() {
	*x = DeleteBucketHTTPSConfigRequest{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBucketHTTPSConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketHTTPSConfigRequest) ProtoMessage() {}

func (x *DeleteBucketHTTPSConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketHTTPSConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteBucketHTTPSConfigRequest) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteBucketHTTPSConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type DeleteBucketHTTPSConfigMetadata struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the bucket the HTTPS configuration is being deleted for.
	Name          string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeleteBucketHTTPSConfigMetadata) Reset() {
	*x = DeleteBucketHTTPSConfigMetadata{}
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteBucketHTTPSConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBucketHTTPSConfigMetadata) ProtoMessage() {}

func (x *DeleteBucketHTTPSConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBucketHTTPSConfigMetadata.ProtoReflect.Descriptor instead.
func (*DeleteBucketHTTPSConfigMetadata) Descriptor() ([]byte, []int) {
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP(), []int{16}
}

func (x *DeleteBucketHTTPSConfigMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_yandex_cloud_storage_v1_bucket_service_proto protoreflect.FileDescriptor

const file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc = "" +
	"\n" +
	",yandex/cloud/storage/v1/bucket_service.proto\x12\x17yandex.cloud.storage.v1\x1a\x1cgoogle/api/annotations.proto\x1a google/protobuf/field_mask.proto\x1a\x1cgoogle/protobuf/struct.proto\x1a yandex/cloud/access/access.proto\x1a yandex/cloud/api/operation.proto\x1a&yandex/cloud/operation/operation.proto\x1a$yandex/cloud/storage/v1/bucket.proto\x1a\x1dyandex/cloud/validation.proto\"\xbb\x01\n" +
	"\x10GetBucketRequest\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\x12B\n" +
	"\x04view\x18\x02 \x01(\x0e2..yandex.cloud.storage.v1.GetBucketRequest.ViewR\x04view\"I\n" +
	"\x04View\x12\x14\n" +
	"\x10VIEW_UNSPECIFIED\x10\x00\x12\x0e\n" +
	"\n" +
	"VIEW_BASIC\x10\x01\x12\f\n" +
	"\bVIEW_ACL\x10\x02\x12\r\n" +
	"\tVIEW_FULL\x10\x03\"?\n" +
	"\x12ListBucketsRequest\x12)\n" +
	"\tfolder_id\x18\x01 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\"P\n" +
	"\x13ListBucketsResponse\x129\n" +
	"\abuckets\x18\x01 \x03(\v2\x1f.yandex.cloud.storage.v1.BucketR\abuckets\"\xf4\x04\n" +
	"\x13CreateBucketRequest\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\x12)\n" +
	"\tfolder_id\x18\x02 \x01(\tB\f\xe8\xc71\x01\x8a\xc81\x04<=50R\bfolderId\x122\n" +
	"\x15default_storage_class\x18\x04 \x01(\tR\x13defaultStorageClass\x12\x19\n" +
	"\bmax_size\x18\x05 \x01(\x03R\amaxSize\x12c\n" +
	"\x16anonymous_access_flags\x18\x06 \x01(\v2-.yandex.cloud.storage.v1.AnonymousAccessFlagsR\x14anonymousAccessFlags\x12.\n" +
	"\x03acl\x18\a \x01(\v2\x1c.yandex.cloud.storage.v1.ACLR\x03acl\x120\n" +
	"\x04tags\x18\b \x03(\v2\x1c.yandex.cloud.storage.v1.TagR\x04tags\x12C\n" +
	"\n" +
	"encryption\x18\t \x01(\v2#.yandex.cloud.storage.v1.EncryptionR\n" +
	"encryption\x12C\n" +
	"\n" +
	"versioning\x18\n" +
	" \x01(\x0e2#.yandex.cloud.storage.v1.VersioningR\n" +
	"versioning\x12r\n" +
	"\x19allowed_private_endpoints\x18\v \x01(\v26.yandex.cloud.storage.v1.BucketAllowedPrivateEndpointsR\x17allowedPrivateEndpointsJ\x04\b\x03\x10\x04\"*\n" +
	"\x14CreateBucketMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"\xda\a\n" +
	"\x13UpdateBucketRequest\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\x12A\n" +
	"\vupdate_mask\x18\x02 \x01(\v2\x1a.google.protobuf.FieldMaskB\x04\xe8\xc71\x01R\n" +
	"updateMask\x12c\n" +
	"\x16anonymous_access_flags\x18\x03 \x01(\v2-.yandex.cloud.storage.v1.AnonymousAccessFlagsR\x14anonymousAccessFlags\x122\n" +
	"\x15default_storage_class\x18\x04 \x01(\tR\x13defaultStorageClass\x12\x19\n" +
	"\bmax_size\x18\x05 \x01(\x03R\amaxSize\x125\n" +
	"\x04cors\x18\x06 \x03(\v2!.yandex.cloud.storage.v1.CorsRuleR\x04cors\x12S\n" +
	"\x10website_settings\x18\a \x01(\v2(.yandex.cloud.storage.v1.WebsiteSettingsR\x0fwebsiteSettings\x12C\n" +
	"\n" +
	"versioning\x18\b \x01(\x0e2#.yandex.cloud.storage.v1.VersioningR\n" +
	"versioning\x12O\n" +
	"\x0flifecycle_rules\x18\t \x03(\v2&.yandex.cloud.storage.v1.LifecycleRuleR\x0elifecycleRules\x12/\n" +
	"\x06policy\x18\n" +
	" \x01(\v2\x17.google.protobuf.StructR\x06policy\x12.\n" +
	"\x03acl\x18\v \x01(\v2\x1c.yandex.cloud.storage.v1.ACLR\x03acl\x120\n" +
	"\x04tags\x18\f \x03(\v2\x1c.yandex.cloud.storage.v1.TagR\x04tags\x12D\n" +
	"\vobject_lock\x18\r \x01(\v2#.yandex.cloud.storage.v1.ObjectLockR\n" +
	"objectLock\x12C\n" +
	"\n" +
	"encryption\x18\x0e \x01(\v2#.yandex.cloud.storage.v1.EncryptionR\n" +
	"encryption\x12r\n" +
	"\x19allowed_private_endpoints\x18\x0f \x01(\v26.yandex.cloud.storage.v1.BucketAllowedPrivateEndpointsR\x17allowedPrivateEndpoints\"*\n" +
	"\x14UpdateBucketMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"/\n" +
	"\x13DeleteBucketRequest\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\"*\n" +
	"\x14DeleteBucketMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\"1\n" +
	"\x15GetBucketStatsRequest\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\"7\n" +
	"\x1bGetBucketHTTPSConfigRequest\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\"\x8d\x01\n" +
	"\x1cSelfManagedHTTPSConfigParams\x126\n" +
	"\x0fcertificate_pem\x18\x01 \x01(\tB\r\x8a\xc81\t<=3145728R\x0ecertificatePem\x125\n" +
	"\x0fprivate_key_pem\x18\x02 \x01(\tB\r\x8a\xc81\t<=3145728R\rprivateKeyPem\"L\n" +
	"#CertificateManagerHTTPSConfigParams\x12%\n" +
	"\x0ecertificate_id\x18\x01 \x01(\tR\rcertificateId\"\x94\x02\n" +
	"\x1bSetBucketHTTPSConfigRequest\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\x12Z\n" +
	"\fself_managed\x18\x02 \x01(\v25.yandex.cloud.storage.v1.SelfManagedHTTPSConfigParamsH\x00R\vselfManaged\x12o\n" +
	"\x13certificate_manager\x18\x03 \x01(\v2<.yandex.cloud.storage.v1.CertificateManagerHTTPSConfigParamsH\x00R\x12certificateManagerB\x0e\n" +
	"\x06params\x12\x04\xc0\xc11\x01\"2\n" +
	"\x1cSetBucketHTTPSConfigMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\":\n" +
	"\x1eDeleteBucketHTTPSConfigRequest\x12\x18\n" +
	"\x04name\x18\x01 \x01(\tB\x04\xe8\xc71\x01R\x04name\"5\n" +
	"\x1fDeleteBucketHTTPSConfigMetadata\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name2\xee\x10\n" +
	"\rBucketService\x12~\n" +
	"\x04List\x12+.yandex.cloud.storage.v1.ListBucketsRequest\x1a,.yandex.cloud.storage.v1.ListBucketsResponse\"\x1b\x82\xd3\xe4\x93\x02\x15\x12\x13/storage/v1/buckets\x12u\n" +
	"\x03Get\x12).yandex.cloud.storage.v1.GetBucketRequest\x1a\x1f.yandex.cloud.storage.v1.Bucket\"\"\x82\xd3\xe4\x93\x02\x1c\x12\x1a/storage/v1/buckets/{name}\x12\x9b\x01\n" +
	"\x06Create\x12,.yandex.cloud.storage.v1.CreateBucketRequest\x1a!.yandex.cloud.operation.Operation\"@\xb2\xd2*\x1e\n" +
	"\x14CreateBucketMetadata\x12\x06Bucket\x82\xd3\xe4\x93\x02\x18:\x01*\"\x13/storage/v1/buckets\x12\xa2\x01\n" +
	"\x06Update\x12,.yandex.cloud.storage.v1.UpdateBucketRequest\x1a!.yandex.cloud.operation.Operation\"G\xb2\xd2*\x1e\n" +
	"\x14UpdateBucketMetadata\x12\x06Bucket\x82\xd3\xe4\x93\x02\x1f:\x01*2\x1a/storage/v1/buckets/{name}\x12\xae\x01\n" +
	"\x06Delete\x12,.yandex.cloud.storage.v1.DeleteBucketRequest\x1a!.yandex.cloud.operation.Operation\"S\xb2\xd2*-\n" +
	"\x14DeleteBucketMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02\x1c*\x1a/storage/v1/buckets/{name}\x12\x8d\x01\n" +
	"\bGetStats\x12..yandex.cloud.storage.v1.GetBucketStatsRequest\x1a$.yandex.cloud.storage.v1.BucketStats\"+\x82\xd3\xe4\x93\x02%\x12#/storage/v1/buckets/{name}:getStats\x12\x9f\x01\n" +
	"\x0eGetHTTPSConfig\x124.yandex.cloud.storage.v1.GetBucketHTTPSConfigRequest\x1a$.yandex.cloud.storage.v1.HTTPSConfig\"1\x82\xd3\xe4\x93\x02+\x12)/storage/v1/buckets/{name}:getHttpsConfig\x12\xce\x01\n" +
	"\x0eSetHTTPSConfig\x124.yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest\x1a!.yandex.cloud.operation.Operation\"c\xb2\xd2*+\n" +
	"\x1cSetBucketHTTPSConfigMetadata\x12\vHTTPSConfig\x82\xd3\xe4\x93\x02.:\x01*\")/storage/v1/buckets/{name}:setHttpsConfig\x12\xe1\x01\n" +
	"\x11DeleteHTTPSConfig\x127.yandex.cloud.storage.v1.DeleteBucketHTTPSConfigRequest\x1a!.yandex.cloud.operation.Operation\"p\xb2\xd2*8\n" +
	"\x1fDeleteBucketHTTPSConfigMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02.\",/storage/v1/buckets/{name}:deleteHttpsConfig\x12\xe2\x01\n" +
	"\x11SetAccessBindings\x12-.yandex.cloud.access.SetAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"{\xb2\xd2*9\n" +
	" access.SetAccessBindingsMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x028:\x01*\"3/storage/v1/buckets/{resource_id}:setAccessBindings\x12\xef\x01\n" +
	"\x14UpdateAccessBindings\x120.yandex.cloud.access.UpdateAccessBindingsRequest\x1a!.yandex.cloud.operation.Operation\"\x81\x01\xb2\xd2*<\n" +
	"#access.UpdateAccessBindingsMetadata\x12\x15google.protobuf.Empty\x82\xd3\xe4\x93\x02;:\x01*26/storage/v1/buckets/{resource_id}:updateAccessBindings\x12\xb3\x01\n" +
	"\x12ListAccessBindings\x12..yandex.cloud.access.ListAccessBindingsRequest\x1a/.yandex.cloud.access.ListAccessBindingsResponse\"<\x82\xd3\xe4\x93\x026\x124/storage/v1/buckets/{resource_id}:listAccessBindingsBb\n" +
	"\x1byandex.cloud.api.storage.v1ZCgithub.com/yandex-cloud/go-genproto/yandex/cloud/storage/v1;storageb\x06proto3"

var (
	file_yandex_cloud_storage_v1_bucket_service_proto_rawDescOnce sync.Once
	file_yandex_cloud_storage_v1_bucket_service_proto_rawDescData []byte
)

func file_yandex_cloud_storage_v1_bucket_service_proto_rawDescGZIP() []byte {
	file_yandex_cloud_storage_v1_bucket_service_proto_rawDescOnce.Do(func() {
		file_yandex_cloud_storage_v1_bucket_service_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc), len(file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc)))
	})
	return file_yandex_cloud_storage_v1_bucket_service_proto_rawDescData
}

var file_yandex_cloud_storage_v1_bucket_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_yandex_cloud_storage_v1_bucket_service_proto_goTypes = []any{
	(GetBucketRequest_View)(0),                  // 0: yandex.cloud.storage.v1.GetBucketRequest.View
	(*GetBucketRequest)(nil),                    // 1: yandex.cloud.storage.v1.GetBucketRequest
	(*ListBucketsRequest)(nil),                  // 2: yandex.cloud.storage.v1.ListBucketsRequest
	(*ListBucketsResponse)(nil),                 // 3: yandex.cloud.storage.v1.ListBucketsResponse
	(*CreateBucketRequest)(nil),                 // 4: yandex.cloud.storage.v1.CreateBucketRequest
	(*CreateBucketMetadata)(nil),                // 5: yandex.cloud.storage.v1.CreateBucketMetadata
	(*UpdateBucketRequest)(nil),                 // 6: yandex.cloud.storage.v1.UpdateBucketRequest
	(*UpdateBucketMetadata)(nil),                // 7: yandex.cloud.storage.v1.UpdateBucketMetadata
	(*DeleteBucketRequest)(nil),                 // 8: yandex.cloud.storage.v1.DeleteBucketRequest
	(*DeleteBucketMetadata)(nil),                // 9: yandex.cloud.storage.v1.DeleteBucketMetadata
	(*GetBucketStatsRequest)(nil),               // 10: yandex.cloud.storage.v1.GetBucketStatsRequest
	(*GetBucketHTTPSConfigRequest)(nil),         // 11: yandex.cloud.storage.v1.GetBucketHTTPSConfigRequest
	(*SelfManagedHTTPSConfigParams)(nil),        // 12: yandex.cloud.storage.v1.SelfManagedHTTPSConfigParams
	(*CertificateManagerHTTPSConfigParams)(nil), // 13: yandex.cloud.storage.v1.CertificateManagerHTTPSConfigParams
	(*SetBucketHTTPSConfigRequest)(nil),         // 14: yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest
	(*SetBucketHTTPSConfigMetadata)(nil),        // 15: yandex.cloud.storage.v1.SetBucketHTTPSConfigMetadata
	(*DeleteBucketHTTPSConfigRequest)(nil),      // 16: yandex.cloud.storage.v1.DeleteBucketHTTPSConfigRequest
	(*DeleteBucketHTTPSConfigMetadata)(nil),     // 17: yandex.cloud.storage.v1.DeleteBucketHTTPSConfigMetadata
	(*Bucket)(nil),                              // 18: yandex.cloud.storage.v1.Bucket
	(*AnonymousAccessFlags)(nil),                // 19: yandex.cloud.storage.v1.AnonymousAccessFlags
	(*ACL)(nil),                                 // 20: yandex.cloud.storage.v1.ACL
	(*Tag)(nil),                                 // 21: yandex.cloud.storage.v1.Tag
	(*Encryption)(nil),                          // 22: yandex.cloud.storage.v1.Encryption
	(Versioning)(0),                             // 23: yandex.cloud.storage.v1.Versioning
	(*BucketAllowedPrivateEndpoints)(nil),       // 24: yandex.cloud.storage.v1.BucketAllowedPrivateEndpoints
	(*fieldmaskpb.FieldMask)(nil),               // 25: google.protobuf.FieldMask
	(*CorsRule)(nil),                            // 26: yandex.cloud.storage.v1.CorsRule
	(*WebsiteSettings)(nil),                     // 27: yandex.cloud.storage.v1.WebsiteSettings
	(*LifecycleRule)(nil),                       // 28: yandex.cloud.storage.v1.LifecycleRule
	(*structpb.Struct)(nil),                     // 29: google.protobuf.Struct
	(*ObjectLock)(nil),                          // 30: yandex.cloud.storage.v1.ObjectLock
	(*access.SetAccessBindingsRequest)(nil),     // 31: yandex.cloud.access.SetAccessBindingsRequest
	(*access.UpdateAccessBindingsRequest)(nil),  // 32: yandex.cloud.access.UpdateAccessBindingsRequest
	(*access.ListAccessBindingsRequest)(nil),    // 33: yandex.cloud.access.ListAccessBindingsRequest
	(*operation.Operation)(nil),                 // 34: yandex.cloud.operation.Operation
	(*BucketStats)(nil),                         // 35: yandex.cloud.storage.v1.BucketStats
	(*HTTPSConfig)(nil),                         // 36: yandex.cloud.storage.v1.HTTPSConfig
	(*access.ListAccessBindingsResponse)(nil),   // 37: yandex.cloud.access.ListAccessBindingsResponse
}
var file_yandex_cloud_storage_v1_bucket_service_proto_depIdxs = []int32{
	0,  // 0: yandex.cloud.storage.v1.GetBucketRequest.view:type_name -> yandex.cloud.storage.v1.GetBucketRequest.View
	18, // 1: yandex.cloud.storage.v1.ListBucketsResponse.buckets:type_name -> yandex.cloud.storage.v1.Bucket
	19, // 2: yandex.cloud.storage.v1.CreateBucketRequest.anonymous_access_flags:type_name -> yandex.cloud.storage.v1.AnonymousAccessFlags
	20, // 3: yandex.cloud.storage.v1.CreateBucketRequest.acl:type_name -> yandex.cloud.storage.v1.ACL
	21, // 4: yandex.cloud.storage.v1.CreateBucketRequest.tags:type_name -> yandex.cloud.storage.v1.Tag
	22, // 5: yandex.cloud.storage.v1.CreateBucketRequest.encryption:type_name -> yandex.cloud.storage.v1.Encryption
	23, // 6: yandex.cloud.storage.v1.CreateBucketRequest.versioning:type_name -> yandex.cloud.storage.v1.Versioning
	24, // 7: yandex.cloud.storage.v1.CreateBucketRequest.allowed_private_endpoints:type_name -> yandex.cloud.storage.v1.BucketAllowedPrivateEndpoints
	25, // 8: yandex.cloud.storage.v1.UpdateBucketRequest.update_mask:type_name -> google.protobuf.FieldMask
	19, // 9: yandex.cloud.storage.v1.UpdateBucketRequest.anonymous_access_flags:type_name -> yandex.cloud.storage.v1.AnonymousAccessFlags
	26, // 10: yandex.cloud.storage.v1.UpdateBucketRequest.cors:type_name -> yandex.cloud.storage.v1.CorsRule
	27, // 11: yandex.cloud.storage.v1.UpdateBucketRequest.website_settings:type_name -> yandex.cloud.storage.v1.WebsiteSettings
	23, // 12: yandex.cloud.storage.v1.UpdateBucketRequest.versioning:type_name -> yandex.cloud.storage.v1.Versioning
	28, // 13: yandex.cloud.storage.v1.UpdateBucketRequest.lifecycle_rules:type_name -> yandex.cloud.storage.v1.LifecycleRule
	29, // 14: yandex.cloud.storage.v1.UpdateBucketRequest.policy:type_name -> google.protobuf.Struct
	20, // 15: yandex.cloud.storage.v1.UpdateBucketRequest.acl:type_name -> yandex.cloud.storage.v1.ACL
	21, // 16: yandex.cloud.storage.v1.UpdateBucketRequest.tags:type_name -> yandex.cloud.storage.v1.Tag
	30, // 17: yandex.cloud.storage.v1.UpdateBucketRequest.object_lock:type_name -> yandex.cloud.storage.v1.ObjectLock
	22, // 18: yandex.cloud.storage.v1.UpdateBucketRequest.encryption:type_name -> yandex.cloud.storage.v1.Encryption
	24, // 19: yandex.cloud.storage.v1.UpdateBucketRequest.allowed_private_endpoints:type_name -> yandex.cloud.storage.v1.BucketAllowedPrivateEndpoints
	12, // 20: yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest.self_managed:type_name -> yandex.cloud.storage.v1.SelfManagedHTTPSConfigParams
	13, // 21: yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest.certificate_manager:type_name -> yandex.cloud.storage.v1.CertificateManagerHTTPSConfigParams
	2,  // 22: yandex.cloud.storage.v1.BucketService.List:input_type -> yandex.cloud.storage.v1.ListBucketsRequest
	1,  // 23: yandex.cloud.storage.v1.BucketService.Get:input_type -> yandex.cloud.storage.v1.GetBucketRequest
	4,  // 24: yandex.cloud.storage.v1.BucketService.Create:input_type -> yandex.cloud.storage.v1.CreateBucketRequest
	6,  // 25: yandex.cloud.storage.v1.BucketService.Update:input_type -> yandex.cloud.storage.v1.UpdateBucketRequest
	8,  // 26: yandex.cloud.storage.v1.BucketService.Delete:input_type -> yandex.cloud.storage.v1.DeleteBucketRequest
	10, // 27: yandex.cloud.storage.v1.BucketService.GetStats:input_type -> yandex.cloud.storage.v1.GetBucketStatsRequest
	11, // 28: yandex.cloud.storage.v1.BucketService.GetHTTPSConfig:input_type -> yandex.cloud.storage.v1.GetBucketHTTPSConfigRequest
	14, // 29: yandex.cloud.storage.v1.BucketService.SetHTTPSConfig:input_type -> yandex.cloud.storage.v1.SetBucketHTTPSConfigRequest
	16, // 30: yandex.cloud.storage.v1.BucketService.DeleteHTTPSConfig:input_type -> yandex.cloud.storage.v1.DeleteBucketHTTPSConfigRequest
	31, // 31: yandex.cloud.storage.v1.BucketService.SetAccessBindings:input_type -> yandex.cloud.access.SetAccessBindingsRequest
	32, // 32: yandex.cloud.storage.v1.BucketService.UpdateAccessBindings:input_type -> yandex.cloud.access.UpdateAccessBindingsRequest
	33, // 33: yandex.cloud.storage.v1.BucketService.ListAccessBindings:input_type -> yandex.cloud.access.ListAccessBindingsRequest
	3,  // 34: yandex.cloud.storage.v1.BucketService.List:output_type -> yandex.cloud.storage.v1.ListBucketsResponse
	18, // 35: yandex.cloud.storage.v1.BucketService.Get:output_type -> yandex.cloud.storage.v1.Bucket
	34, // 36: yandex.cloud.storage.v1.BucketService.Create:output_type -> yandex.cloud.operation.Operation
	34, // 37: yandex.cloud.storage.v1.BucketService.Update:output_type -> yandex.cloud.operation.Operation
	34, // 38: yandex.cloud.storage.v1.BucketService.Delete:output_type -> yandex.cloud.operation.Operation
	35, // 39: yandex.cloud.storage.v1.BucketService.GetStats:output_type -> yandex.cloud.storage.v1.BucketStats
	36, // 40: yandex.cloud.storage.v1.BucketService.GetHTTPSConfig:output_type -> yandex.cloud.storage.v1.HTTPSConfig
	34, // 41: yandex.cloud.storage.v1.BucketService.SetHTTPSConfig:output_type -> yandex.cloud.operation.Operation
	34, // 42: yandex.cloud.storage.v1.BucketService.DeleteHTTPSConfig:output_type -> yandex.cloud.operation.Operation
	34, // 43: yandex.cloud.storage.v1.BucketService.SetAccessBindings:output_type -> yandex.cloud.operation.Operation
	34, // 44: yandex.cloud.storage.v1.BucketService.UpdateAccessBindings:output_type -> yandex.cloud.operation.Operation
	37, // 45: yandex.cloud.storage.v1.BucketService.ListAccessBindings:output_type -> yandex.cloud.access.ListAccessBindingsResponse
	34, // [34:46] is the sub-list for method output_type
	22, // [22:34] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_yandex_cloud_storage_v1_bucket_service_proto_init() }
func file_yandex_cloud_storage_v1_bucket_service_proto_init() {
	if File_yandex_cloud_storage_v1_bucket_service_proto != nil {
		return
	}
	file_yandex_cloud_storage_v1_bucket_proto_init()
	file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes[13].OneofWrappers = []any{
		(*SetBucketHTTPSConfigRequest_SelfManaged)(nil),
		(*SetBucketHTTPSConfigRequest_CertificateManager)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc), len(file_yandex_cloud_storage_v1_bucket_service_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_yandex_cloud_storage_v1_bucket_service_proto_goTypes,
		DependencyIndexes: file_yandex_cloud_storage_v1_bucket_service_proto_depIdxs,
		EnumInfos:         file_yandex_cloud_storage_v1_bucket_service_proto_enumTypes,
		MessageInfos:      file_yandex_cloud_storage_v1_bucket_service_proto_msgTypes,
	}.Build()
	File_yandex_cloud_storage_v1_bucket_service_proto = out.File
	file_yandex_cloud_storage_v1_bucket_service_proto_goTypes = nil
	file_yandex_cloud_storage_v1_bucket_service_proto_depIdxs = nil
}
