// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package connectors provides access to the Connectors API.
//
// For product documentation, see: https://cloud.google.com/apigee/docs/api-platform/connectors/about-connectors
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/connectors/v2"
//	...
//	ctx := context.Background()
//	connectorsService, err := connectors.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	connectorsService, err := connectors.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	connectorsService, err := connectors.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package connectors // import "google.golang.org/api/connectors/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "connectors:v2"
const apiName = "connectors"
const apiVersion = "v2"
const basePath = "https://connectors.googleapis.com/"
const basePathTemplate = "https://connectors.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://connectors.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Connections = NewProjectsLocationsConnectionsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Connections *ProjectsLocationsConnectionsService
}

func NewProjectsLocationsConnectionsService(s *Service) *ProjectsLocationsConnectionsService {
	rs := &ProjectsLocationsConnectionsService{s: s}
	rs.Actions = NewProjectsLocationsConnectionsActionsService(s)
	rs.EntityTypes = NewProjectsLocationsConnectionsEntityTypesService(s)
	rs.Resources = NewProjectsLocationsConnectionsResourcesService(s)
	rs.Tools = NewProjectsLocationsConnectionsToolsService(s)
	return rs
}

type ProjectsLocationsConnectionsService struct {
	s *Service

	Actions *ProjectsLocationsConnectionsActionsService

	EntityTypes *ProjectsLocationsConnectionsEntityTypesService

	Resources *ProjectsLocationsConnectionsResourcesService

	Tools *ProjectsLocationsConnectionsToolsService
}

func NewProjectsLocationsConnectionsActionsService(s *Service) *ProjectsLocationsConnectionsActionsService {
	rs := &ProjectsLocationsConnectionsActionsService{s: s}
	return rs
}

type ProjectsLocationsConnectionsActionsService struct {
	s *Service
}

func NewProjectsLocationsConnectionsEntityTypesService(s *Service) *ProjectsLocationsConnectionsEntityTypesService {
	rs := &ProjectsLocationsConnectionsEntityTypesService{s: s}
	rs.Entities = NewProjectsLocationsConnectionsEntityTypesEntitiesService(s)
	return rs
}

type ProjectsLocationsConnectionsEntityTypesService struct {
	s *Service

	Entities *ProjectsLocationsConnectionsEntityTypesEntitiesService
}

func NewProjectsLocationsConnectionsEntityTypesEntitiesService(s *Service) *ProjectsLocationsConnectionsEntityTypesEntitiesService {
	rs := &ProjectsLocationsConnectionsEntityTypesEntitiesService{s: s}
	return rs
}

type ProjectsLocationsConnectionsEntityTypesEntitiesService struct {
	s *Service
}

func NewProjectsLocationsConnectionsResourcesService(s *Service) *ProjectsLocationsConnectionsResourcesService {
	rs := &ProjectsLocationsConnectionsResourcesService{s: s}
	return rs
}

type ProjectsLocationsConnectionsResourcesService struct {
	s *Service
}

func NewProjectsLocationsConnectionsToolsService(s *Service) *ProjectsLocationsConnectionsToolsService {
	rs := &ProjectsLocationsConnectionsToolsService{s: s}
	return rs
}

type ProjectsLocationsConnectionsToolsService struct {
	s *Service
}

// AccessCredentials: AccessCredentials includes the OAuth access token, and
// the other fields returned along with it.
type AccessCredentials struct {
	// AccessToken: OAuth access token.
	AccessToken string `json:"accessToken,omitempty"`
	// ExpiresIn: Duration till the access token expires.
	ExpiresIn string `json:"expiresIn,omitempty"`
	// RefreshToken: OAuth refresh token.
	RefreshToken string `json:"refreshToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessCredentials) MarshalJSON() ([]byte, error) {
	type NoMethod AccessCredentials
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Action: Action message contains metadata information about a single action
// present in the external system.
type Action struct {
	// Description: Brief Description of action
	Description string `json:"description,omitempty"`
	// DisplayName: Display Name of action to be shown on client side
	DisplayName string `json:"displayName,omitempty"`
	// InputJsonSchema: JsonSchema representation of this actions's input schema
	InputJsonSchema *JsonSchema `json:"inputJsonSchema,omitempty"`
	// InputParameters: List containing input parameter metadata.
	InputParameters []*InputParameter `json:"inputParameters,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Name of the action.
	Name string `json:"name,omitempty"`
	// ResultJsonSchema: JsonSchema representation of this actions's result schema
	ResultJsonSchema *JsonSchema `json:"resultJsonSchema,omitempty"`
	// ResultMetadata: List containing the metadata of result fields.
	ResultMetadata []*ResultMetadata `json:"resultMetadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Action) MarshalJSON() ([]byte, error) {
	type NoMethod Action
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthCodeData: AuthCodeData contains the data the runtime plane will give the
// connector backend in exchange for access and refresh tokens.
type AuthCodeData struct {
	// AuthCode: OAuth authorization code.
	AuthCode string `json:"authCode,omitempty"`
	// PkceVerifier: OAuth PKCE verifier, needed if PKCE is enabled for this
	// particular connection.
	PkceVerifier string `json:"pkceVerifier,omitempty"`
	// RedirectUri: OAuth redirect URI passed in during the auth code flow,
	// required by some OAuth backends.
	RedirectUri string `json:"redirectUri,omitempty"`
	// Scopes: Scopes the connection will request when the user performs the auth
	// code flow.
	Scopes []string `json:"scopes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthCodeData) MarshalJSON() ([]byte, error) {
	type NoMethod AuthCodeData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckReadinessResponse: Response containing status of the connector for
// readiness prober.
type CheckReadinessResponse struct {
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Status") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckReadinessResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckReadinessResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CheckStatusResponse: The status of the connector.
type CheckStatusResponse struct {
	// Description: When the connector is not in ACTIVE state, the description must
	// be populated to specify the reason why it's not in ACTIVE state.
	Description string `json:"description,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// State: State of the connector.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "ACTIVE" - The connector is active and ready to process runtime requests.
	// This can also mean that from the connector's perspective, the connector is
	// not in an error state and should be able to process runtime requests
	// successfully.
	//   "ERROR" - The connector is in an error state and cannot process runtime
	// requests. An example reason would be that the connection container has some
	// network issues that prevent outbound requests from being sent.
	//   "AUTH_ERROR" - This is a more specific error state that the developers can
	// opt to use when the connector is facing auth-related errors caused by auth
	// configuration not present, invalid auth credentials, etc.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CheckStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckStatusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DailyCycle: Time window specified for daily operations.
type DailyCycle struct {
	// Duration: Output only. Duration of the time window, set by service producer.
	Duration string `json:"duration,omitempty"`
	// StartTime: Time within the day to start the operations.
	StartTime *TimeOfDay `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Duration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DailyCycle) MarshalJSON() ([]byte, error) {
	type NoMethod DailyCycle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DenyMaintenancePeriod: DenyMaintenancePeriod definition. Maintenance is
// forbidden within the deny period. The start_date must be less than the
// end_date.
type DenyMaintenancePeriod struct {
	// EndDate: Deny period end date. This can be: * A full date, with non-zero
	// year, month and day values. * A month and day value, with a zero year.
	// Allows recurring deny periods each year. Date matching this period will have
	// to be before the end.
	EndDate *Date `json:"endDate,omitempty"`
	// StartDate: Deny period start date. This can be: * A full date, with non-zero
	// year, month and day values. * A month and day value, with a zero year.
	// Allows recurring deny periods each year. Date matching this period will have
	// to be the same or after the start.
	StartDate *Date `json:"startDate,omitempty"`
	// Time: Time in UTC when the Blackout period starts on start_date and ends on
	// end_date. This can be: * Full time. * All zeros for 00:00:00 UTC
	Time *TimeOfDay `json:"time,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndDate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DenyMaintenancePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod DenyMaintenancePeriod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// Entity: 'Entity row'/ 'Entity' refers to a single row of an entity type.
type Entity struct {
	// Fields: Fields of the entity. The key is name of the field and the value
	// contains the applicable `google.protobuf.Value` entry for this field.
	Fields googleapi.RawMessage `json:"fields,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Output only. Resource name of the Entity. Format:
	// projects/{project}/locations/{location}/connections/{connection}/entityTypes/
	// {type}/entities/{id}
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Fields") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Entity) MarshalJSON() ([]byte, error) {
	type NoMethod Entity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EntityType: EntityType message contains metadata information about a single
// entity type present in the external system.
type EntityType struct {
	DefaultSortBy string `json:"defaultSortBy,omitempty"`
	// Fields: List containing metadata information about each field of the entity
	// type.
	Fields []*Field `json:"fields,omitempty"`
	// JsonSchema: JsonSchema representation of this entity's schema
	JsonSchema *JsonSchema `json:"jsonSchema,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The name of the entity type.
	Name string `json:"name,omitempty"`
	// Possible values:
	//   "OPERATION_UNSPECIFIED" - Operation unspecified.
	//   "LIST" - This operation means entity type supports LIST method.
	//   "GET" - This operation means entity type supports GET method.
	//   "CREATE" - This operation means entity type supports CREATE method.
	//   "UPDATE" - This operation means entity type supports UPDATE method.
	//   "DELETE" - This operation means entity type supports DELETE method.
	Operations []string `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DefaultSortBy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultSortBy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EntityType) MarshalJSON() ([]byte, error) {
	type NoMethod EntityType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExchangeAuthCodeRequest: ExchangeAuthCodeRequest currently includes the auth
// code data.
type ExchangeAuthCodeRequest struct {
	// AuthCodeData: Optional. AuthCodeData contains the data the runtime requires
	// to exchange for access and refresh tokens. If the data is not provided, the
	// runtime will read the data from the secret manager.
	AuthCodeData *AuthCodeData `json:"authCodeData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthCodeData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthCodeData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExchangeAuthCodeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangeAuthCodeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExchangeAuthCodeResponse: ExchangeAuthCodeResponse includes the returned
// access token and its associated credentials.
type ExchangeAuthCodeResponse struct {
	AccessCredentials *AccessCredentials `json:"accessCredentials,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessCredentials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessCredentials") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExchangeAuthCodeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExchangeAuthCodeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecuteActionRequest: Request message for ActionService.ExecuteAction
type ExecuteActionRequest struct {
	// Parameters: Parameters for executing the action. The parameters can be
	// key/value pairs or nested structs.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteActionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteActionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecuteActionResponse: Response message for ActionService.ExecuteAction
type ExecuteActionResponse struct {
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// Results: In the case of successful invocation of the specified action, the
	// results Struct contains values based on the response of the action invoked.
	// 1. If the action execution produces any entities as a result, they are
	// returned as an array of Structs with the 'key' being the field name and the
	// 'value' being the value of that field in each result row. { 'results':
	// [{'key': 'value'}, ...] }
	Results []googleapi.RawMessage `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteActionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteActionResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecuteSqlQueryRequest: An execute sql query request containing the query
// and the connection to execute it on.
type ExecuteSqlQueryRequest struct {
	// Query: Required. SQL statement passed by clients like Integration Platform,
	// the query is passed as-is to the driver used for interfacing with external
	// systems.
	Query *Query `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Query") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteSqlQueryRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteSqlQueryRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecuteSqlQueryResponse: A response returned by the connection after
// executing the sql query.
type ExecuteSqlQueryResponse struct {
	// Results: In the case of successful execution of the query the response
	// contains results returned by the external system. For example, the result
	// rows of the query are contained in the 'results' Struct list - "results": [
	// { "field1": "val1", "field2": "val2",.. },.. ] Each Struct row can contain
	// fields any type of like nested Structs or lists.
	Results []googleapi.RawMessage `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Results") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Results") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteSqlQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteSqlQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecuteToolRequest: Request message for ConnectorAgentService.ExecuteTool
type ExecuteToolRequest struct {
	// Parameters: Input parameters for the tool.
	Parameters googleapi.RawMessage `json:"parameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteToolRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteToolRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecuteToolResponse: Response message for ConnectorAgentService.ExecuteTool
type ExecuteToolResponse struct {
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// Result: Output from the tool execution.
	Result googleapi.RawMessage `json:"result,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteToolResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteToolResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Field: Message contains EntityType's Field metadata.
type Field struct {
	// AdditionalDetails: The following map contains fields that are not explicitly
	// mentioned above,this give connectors the flexibility to add new metadata
	// fields.
	AdditionalDetails googleapi.RawMessage `json:"additionalDetails,omitempty"`
	// DataType: The data type of the Field.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	DataType string `json:"dataType,omitempty"`
	// DefaultValue: The following field specifies the default value of the Field
	// provided by the external system if a value is not provided.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// Description: A brief description of the Field.
	Description string `json:"description,omitempty"`
	// JsonSchema: JsonSchema of the field, applicable only if field is of type
	// `STRUCT`
	JsonSchema *JsonSchema `json:"jsonSchema,omitempty"`
	// Key: The following boolean field specifies if the current Field acts as a
	// primary key or id if the parent is of type entity.
	Key bool `json:"key,omitempty"`
	// Name: Name of the Field.
	Name string `json:"name,omitempty"`
	// Nullable: Specifies whether a null value is allowed.
	Nullable bool `json:"nullable,omitempty"`
	// Reference: Reference captures the association between two different entity
	// types. Value links to the reference of another entity type.
	Reference *Reference `json:"reference,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Field) MarshalJSON() ([]byte, error) {
	type NoMethod Field
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type GetResourceResponse struct {
	// Data: The content of the resource.
	Data string `json:"data,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// MimeType: The MIME type of the resource.
	MimeType string `json:"mimeType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Data") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Data") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetResourceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetResourceResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputParameter: Input Parameter message contains metadata about the
// parameters required for executing an Action.
type InputParameter struct {
	// AdditionalDetails: The following map contains fields that are not explicitly
	// mentioned above,this give connectors the flexibility to add new metadata
	// fields.
	AdditionalDetails googleapi.RawMessage `json:"additionalDetails,omitempty"`
	// DataType: The data type of the Parameter
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	DataType string `json:"dataType,omitempty"`
	// DefaultValue: The following field specifies the default value of the
	// Parameter provided by the external system if a value is not provided.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// Description: A brief description of the Parameter.
	Description string `json:"description,omitempty"`
	// JsonSchema: JsonSchema of the parameter, applicable only if parameter is of
	// type `STRUCT`
	JsonSchema *JsonSchema `json:"jsonSchema,omitempty"`
	// Name: Name of the Parameter.
	Name string `json:"name,omitempty"`
	// Nullable: Specifies whether a null value is allowed.
	Nullable bool `json:"nullable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputParameter) MarshalJSON() ([]byte, error) {
	type NoMethod InputParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Instance: Instance represents the interface for SLM services to actuate the
// state of control plane resources. Example Instance in JSON, where
// consumer-project-number=123456, producer-project-id=cloud-sql: ```json
// Instance: { "name":
// "projects/123456/locations/us-east1/instances/prod-instance", "create_time":
// { "seconds": 1526406431, }, "labels": { "env": "prod", "foo": "bar" },
// "state": READY, "software_versions": { "software_update":
// "cloud-sql-09-28-2018", }, "maintenance_policy_names": { "UpdatePolicy":
// "projects/123456/locations/us-east1/maintenancePolicies/prod-update-policy",
// } "tenant_project_id": "cloud-sql-test-tenant", "producer_metadata": {
// "cloud-sql-tier": "basic", "cloud-sql-instance-size": "1G", },
// "provisioned_resources": [ { "resource-type": "compute-instance",
// "resource-url":
// "https://www.googleapis.com/compute/v1/projects/cloud-sql/zones/us-east1-b/in
// stances/vm-1", } ], "maintenance_schedules": { "csa_rollout": {
// "start_time": { "seconds": 1526406431, }, "end_time": { "seconds":
// 1535406431, }, }, "ncsa_rollout": { "start_time": { "seconds": 1526406431,
// }, "end_time": { "seconds": 1535406431, }, } }, "consumer_defined_name":
// "my-sql-instance1", } ``` LINT.IfChange
type Instance struct {
	// ConsumerDefinedName: consumer_defined_name is the name of the instance set
	// by the service consumers. Generally this is different from the `name` field
	// which reperesents the system-assigned id of the instance which the service
	// consumers do not recognize. This is a required field for tenants onboarding
	// to Maintenance Window notifications
	// (go/slm-rollout-maintenance-policies#prerequisites).
	ConsumerDefinedName string `json:"consumerDefinedName,omitempty"`
	// ConsumerProjectNumber: Optional. The consumer_project_number associated with
	// this Apigee instance. This field is added specifically to support Apigee
	// integration with SLM Rollout and UMM. It represents the numerical project ID
	// of the GCP project that consumes this Apigee instance. It is used for SLM
	// rollout notifications and UMM integration, enabling proper mapping to
	// customer projects and log delivery for Apigee instances. This field
	// complements consumer_project_id and may be used for specific Apigee
	// scenarios where the numerical ID is required.
	ConsumerProjectNumber string `json:"consumerProjectNumber,omitempty"`
	// CreateTime: Output only. Timestamp when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// InstanceType: Optional. The instance_type of this instance of format:
	// projects/{project_number}/locations/{location_id}/instanceTypes/{instance_typ
	// e_id}. Instance Type represents a high-level tier or SKU of the service that
	// this instance belong to. When enabled(eg: Maintenance Rollout), Rollout uses
	// 'instance_type' along with 'software_versions' to determine whether instance
	// needs an update or not.
	InstanceType string `json:"instanceType,omitempty"`
	// Labels: Optional. Resource labels to represent user provided metadata. Each
	// label is a key-value pair, where both the key and the value are arbitrary
	// strings provided by the user.
	Labels map[string]string `json:"labels,omitempty"`
	// MaintenancePolicyNames: Optional. The MaintenancePolicies that have been
	// attached to the instance. The key must be of the type name of the oneof
	// policy name defined in MaintenancePolicy, and the referenced policy must
	// define the same policy type. For details, please refer to go/mr-user-guide.
	// Should not be set if maintenance_settings.maintenance_policies is set.
	MaintenancePolicyNames map[string]string `json:"maintenancePolicyNames,omitempty"`
	// MaintenanceSchedules: The MaintenanceSchedule contains the scheduling
	// information of published maintenance schedule with same key as
	// software_versions.
	MaintenanceSchedules map[string]MaintenanceSchedule `json:"maintenanceSchedules,omitempty"`
	// MaintenanceSettings: Optional. The MaintenanceSettings associated with
	// instance.
	MaintenanceSettings *MaintenanceSettings `json:"maintenanceSettings,omitempty"`
	// Name: Unique name of the resource. It uses the form:
	// `projects/{project_number}/locations/{location_id}/instances/{instance_id}`
	// Note: This name is passed, stored and logged across the rollout system. So
	// use of consumer project_id or any other consumer PII in the name is strongly
	// discouraged for wipeout (go/wipeout) compliance. See
	// go/elysium/project_ids#storage-guidance for more details.
	Name string `json:"name,omitempty"`
	// NotificationParameters: Optional. notification_parameter are information
	// that service producers may like to include that is not relevant to Rollout.
	// This parameter will only be passed to Gamma and Cloud Logging for
	// notification/logging purpose.
	NotificationParameters map[string]NotificationParameter `json:"notificationParameters,omitempty"`
	// ProducerMetadata: Output only. Custom string attributes used primarily to
	// expose producer-specific information in monitoring dashboards. See
	// go/get-instance-metadata.
	ProducerMetadata map[string]string `json:"producerMetadata,omitempty"`
	// ProvisionedResources: Output only. The list of data plane resources
	// provisioned for this instance, e.g. compute VMs. See
	// go/get-instance-metadata.
	ProvisionedResources []*ProvisionedResource `json:"provisionedResources,omitempty"`
	// SlmInstanceTemplate: Link to the SLM instance template. Only populated when
	// updating SLM instances via SSA's Actuation service adaptor. Service
	// producers with custom control plane (e.g. Cloud SQL) doesn't need to
	// populate this field. Instead they should use software_versions.
	SlmInstanceTemplate string `json:"slmInstanceTemplate,omitempty"`
	// SloMetadata: Output only. SLO metadata for instance classification in the
	// Standardized dataplane SLO platform. See go/cloud-ssa-standard-slo for
	// feature description.
	SloMetadata *SloMetadata `json:"sloMetadata,omitempty"`
	// SoftwareVersions: Software versions that are used to deploy this instance.
	// This can be mutated by rollout services.
	SoftwareVersions map[string]string `json:"softwareVersions,omitempty"`
	// State: Output only. Current lifecycle state of the resource (e.g. if it's
	// being created or ready to use).
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "CREATING" - Instance is being created.
	//   "READY" - Instance has been created and is ready to use.
	//   "UPDATING" - Instance is being updated.
	//   "REPAIRING" - Instance is unheathy and under repair.
	//   "DELETING" - Instance is being deleted.
	//   "ERROR" - Instance encountered an error and is in indeterministic state.
	State string `json:"state,omitempty"`
	// TenantProjectId: Output only. ID of the associated GCP tenant project. See
	// go/get-instance-metadata.
	TenantProjectId string `json:"tenantProjectId,omitempty"`
	// UpdateTime: Output only. Timestamp when the resource was last modified.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsumerDefinedName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsumerDefinedName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Instance) MarshalJSON() ([]byte, error) {
	type NoMethod Instance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JsonSchema: JsonSchema representation of schema metadata
type JsonSchema struct {
	// AdditionalDetails: Additional details apart from standard json schema
	// fields, this gives flexibility to store metadata about the schema
	AdditionalDetails googleapi.RawMessage `json:"additionalDetails,omitempty"`
	// Default: The default value of the field or object described by this schema.
	Default interface{} `json:"default,omitempty"`
	// Description: A description of this schema.
	Description string `json:"description,omitempty"`
	// Enum: Possible values for an enumeration. This works in conjunction with
	// `type` to represent types with a fixed set of legal values
	Enum []interface{} `json:"enum,omitempty"`
	// Format: Format of the value as per
	// https://json-schema.org/understanding-json-schema/reference/string.html#format
	Format string `json:"format,omitempty"`
	// Items: Schema that applies to array values, applicable only if this is of
	// type `array`.
	Items *JsonSchema `json:"items,omitempty"`
	// JdbcType: JDBC datatype of the field.
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	JdbcType string `json:"jdbcType,omitempty"`
	// Properties: The child schemas, applicable only if this is of type `object`.
	// The key is the name of the property and the value is the json schema that
	// describes that property
	Properties map[string]JsonSchema `json:"properties,omitempty"`
	// Required: Whether this property is required.
	Required []string `json:"required,omitempty"`
	// Type: JSON Schema Validation: A Vocabulary for Structural Validation of JSON
	Type []string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdditionalDetails") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdditionalDetails") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JsonSchema) MarshalJSON() ([]byte, error) {
	type NoMethod JsonSchema
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListActionsResponse: Response message for ActionService.ListActions
type ListActionsResponse struct {
	// Actions: List of action metadata.
	Actions []*Action `json:"actions,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// NextPageToken: Next page token if more actions available.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// UnsupportedActionNames: List of actions which contain unsupported Datatypes.
	// Check datatype.proto for more information.
	UnsupportedActionNames []string `json:"unsupportedActionNames,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Actions") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Actions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListActionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListActionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListEntitiesResponse: Response message for EntityService.ListEntities
type ListEntitiesResponse struct {
	// Entities: List containing entity rows.
	Entities []*Entity `json:"entities,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// NextPageToken: Next page token if more records are available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Entities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListEntitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEntitiesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListEntityTypesResponse: Response message for EntityService.ListEntityTypes
type ListEntityTypesResponse struct {
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// NextPageToken: Next page token if more entity types available.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Types: List of metadata related to all entity types.
	Types []*EntityType `json:"types,omitempty"`
	// UnsupportedTypeNames: List of entity type names which contain unsupported
	// Datatypes. Check datatype.proto for more information.
	UnsupportedTypeNames []string `json:"unsupportedTypeNames,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListEntityTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListEntityTypesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ListResourcesResponse struct {
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// NextPageToken: Next page token if more resources available.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Resources: List of available resources.
	Resources []*Resource `json:"resources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListResourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListToolsResponse: Response message for ConnectorAgentService.ListTools
type ListToolsResponse struct {
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// NextPageToken: Next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Tools: List of available tools.
	Tools []*Tool `json:"tools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListToolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListToolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenancePolicy: Defines policies to service maintenance events.
type MaintenancePolicy struct {
	// CreateTime: Output only. The time when the resource was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Optional. Description of what this policy is for. Create/Update
	// methods return INVALID_ARGUMENT if the length is greater than 512.
	Description string `json:"description,omitempty"`
	// Labels: Optional. Resource labels to represent user provided metadata. Each
	// label is a key-value pair, where both the key and the value are arbitrary
	// strings provided by the user.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Required. MaintenancePolicy name using the form:
	// `projects/{project_id}/locations/{location_id}/maintenancePolicies/{maintenan
	// ce_policy_id}` where {project_id} refers to a GCP consumer project ID,
	// {location_id} refers to a GCP region/zone, {maintenance_policy_id} must be
	// 1-63 characters long and match the regular expression
	// `[a-z0-9]([-a-z0-9]*[a-z0-9])?`.
	Name string `json:"name,omitempty"`
	// State: Optional. The state of the policy.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified state.
	//   "READY" - Resource is ready to be used.
	//   "DELETING" - Resource is being deleted. It can no longer be attached to
	// instances.
	State string `json:"state,omitempty"`
	// UpdatePolicy: Maintenance policy applicable to instance update.
	UpdatePolicy *UpdatePolicy `json:"updatePolicy,omitempty"`
	// UpdateTime: Output only. The time when the resource was updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenancePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenancePolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenanceSchedule: Maintenance schedule which is exposed to customer and
// potentially end user, indicating published upcoming future maintenance
// schedule
type MaintenanceSchedule struct {
	// CanReschedule: This field is deprecated, and will be always set to true
	// since reschedule can happen multiple times now. This field should not be
	// removed until all service producers remove this for their customers.
	CanReschedule bool `json:"canReschedule,omitempty"`
	// EndTime: The scheduled end time for the maintenance.
	EndTime string `json:"endTime,omitempty"`
	// RolloutManagementPolicy: The rollout management policy this maintenance
	// schedule is associated with. When doing reschedule update request, the
	// reschedule should be against this given policy.
	RolloutManagementPolicy string `json:"rolloutManagementPolicy,omitempty"`
	// ScheduleDeadlineTime: schedule_deadline_time is the time deadline any
	// schedule start time cannot go beyond, including reschedule. It's normally
	// the initial schedule start time plus maintenance window length (1 day or 1
	// week). Maintenance cannot be scheduled to start beyond this deadline.
	ScheduleDeadlineTime string `json:"scheduleDeadlineTime,omitempty"`
	// StartTime: The scheduled start time for the maintenance.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanReschedule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanReschedule") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenanceSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceSchedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenanceSettings: Maintenance settings associated with instance. Allows
// service producers and end users to assign settings that controls maintenance
// on this instance.
type MaintenanceSettings struct {
	// Exclude: Optional. Exclude instance from maintenance. When true, rollout
	// service will not attempt maintenance on the instance. Rollout service will
	// include the instance in reported rollout progress as not attempted.
	Exclude bool `json:"exclude,omitempty"`
	// IsRollback: Optional. If the update call is triggered from rollback, set the
	// value as true.
	IsRollback bool `json:"isRollback,omitempty"`
	// MaintenancePolicies: Optional. The MaintenancePolicies that have been
	// attached to the instance. The key must be of the type name of the oneof
	// policy name defined in MaintenancePolicy, and the embedded policy must
	// define the same policy type. For details, please refer to go/mr-user-guide.
	// Should not be set if maintenance_policy_names is set. If only the name is
	// needed, then only populate MaintenancePolicy.name.
	MaintenancePolicies map[string]MaintenancePolicy `json:"maintenancePolicies,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Exclude") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Exclude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenanceSettings) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenanceWindow: MaintenanceWindow definition.
type MaintenanceWindow struct {
	// DailyCycle: Daily cycle.
	DailyCycle *DailyCycle `json:"dailyCycle,omitempty"`
	// WeeklyCycle: Weekly cycle.
	WeeklyCycle *WeeklyCycle `json:"weeklyCycle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DailyCycle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DailyCycle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenanceWindow) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceWindow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeSloMetadata: Node information for custom per-node SLO implementations.
// SSA does not support per-node SLO, but producers can populate per-node
// information in SloMetadata for custom precomputations. SSA Eligibility
// Exporter will emit per-node metric based on this information.
type NodeSloMetadata struct {
	// Location: The location of the node, if different from instance location.
	Location string `json:"location,omitempty"`
	// NodeId: The id of the node. This should be equal to
	// SaasInstanceNode.node_id.
	NodeId string `json:"nodeId,omitempty"`
	// PerSliEligibility: If present, this will override eligibility for the node
	// coming from instance or exclusions for specified SLIs.
	PerSliEligibility *PerSliSloEligibility `json:"perSliEligibility,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeSloMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod NodeSloMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NotificationParameter: Contains notification related data.
type NotificationParameter struct {
	// Values: Optional. Array of string values. e.g. instance's replica
	// information.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NotificationParameter) MarshalJSON() ([]byte, error) {
	type NoMethod NotificationParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PerSliSloEligibility: PerSliSloEligibility is a mapping from an SLI name to
// eligibility.
type PerSliSloEligibility struct {
	// Eligibilities: An entry in the eligibilities map specifies an eligibility
	// for a particular SLI for the given instance. The SLI key in the name must be
	// a valid SLI name specified in the Eligibility Exporter binary flags
	// otherwise an error will be emitted by Eligibility Exporter and the oncaller
	// will be alerted. If an SLI has been defined in the binary flags but the
	// eligibilities map does not contain it, the corresponding SLI time series
	// will not be emitted by the Eligibility Exporter. This ensures a smooth
	// rollout and compatibility between the data produced by different versions of
	// the Eligibility Exporters. If eligibilities map contains a key for an SLI
	// which has not been declared in the binary flags, there will be an error
	// message emitted in the Eligibility Exporter log and the metric for the SLI
	// in question will not be emitted.
	Eligibilities map[string]SloEligibility `json:"eligibilities,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Eligibilities") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Eligibilities") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PerSliSloEligibility) MarshalJSON() ([]byte, error) {
	type NoMethod PerSliSloEligibility
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProvisionedResource: Describes provisioned dataplane resources.
type ProvisionedResource struct {
	// ResourceType: Type of the resource. This can be either a GCP resource or a
	// custom one (e.g. another cloud provider's VM). For GCP compute resources use
	// singular form of the names listed in GCP compute API documentation
	// (https://cloud.google.com/compute/docs/reference/rest/v1/), prefixed with
	// 'compute-', for example: 'compute-instance', 'compute-disk',
	// 'compute-autoscaler'.
	ResourceType string `json:"resourceType,omitempty"`
	// ResourceUrl: URL identifying the resource, e.g.
	// "https://www.googleapis.com/compute/v1/projects/...)".
	ResourceUrl string `json:"resourceUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ResourceType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ResourceType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProvisionedResource) MarshalJSON() ([]byte, error) {
	type NoMethod ProvisionedResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Query: A wrapper around the SQL query statement. This is needed so that the
// JSON representation of ExecuteSqlQueryRequest has the following format:
// `{"query":"select *"}`.
type Query struct {
	// MaxRows: Sets the limit for the maximum number of rows returned after the
	// query execution.
	MaxRows int64 `json:"maxRows,omitempty,string"`
	// Query: Required. Sql query to execute.
	Query string `json:"query,omitempty"`
	// QueryParameters: In the struct, the value corresponds to the value of query
	// parameter and date type corresponds to the date type of the query parameter.
	QueryParameters []*QueryParameter `json:"queryParameters,omitempty"`
	// Timeout: Sets the number of seconds the driver will wait for a query to
	// execute.
	Timeout int64 `json:"timeout,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "MaxRows") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxRows") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Query) MarshalJSON() ([]byte, error) {
	type NoMethod Query
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryParameter: Query parameter definition
type QueryParameter struct {
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	DataType string      `json:"dataType,omitempty"`
	Value    interface{} `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryParameter) MarshalJSON() ([]byte, error) {
	type NoMethod QueryParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Reference struct {
	// Name: Name of the reference field.
	Name string `json:"name,omitempty"`
	// Type: Name of reference entity type.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Reference) MarshalJSON() ([]byte, error) {
	type NoMethod Reference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RefreshAccessTokenRequest: RefreshAccessTokenRequest includes the refresh
// token.
type RefreshAccessTokenRequest struct {
	// RefreshToken: Optional. Refresh Token String. If the Refresh Token is not
	// provided, the runtime will read the data from the secret manager.
	RefreshToken string `json:"refreshToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RefreshToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RefreshToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RefreshAccessTokenRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RefreshAccessTokenRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RefreshAccessTokenResponse: RefreshAccessTokenResponse includes the returned
// access token and its associated credentials.
type RefreshAccessTokenResponse struct {
	AccessCredentials *AccessCredentials `json:"accessCredentials,omitempty"`
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessCredentials") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessCredentials") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RefreshAccessTokenResponse) MarshalJSON() ([]byte, error) {
	type NoMethod RefreshAccessTokenResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Resource struct {
	// Description: A description of what this resource represents.
	Description string `json:"description,omitempty"`
	// MimeType: The MIME type of this resource, if known.
	MimeType string `json:"mimeType,omitempty"`
	// Name: A human-readable name for this resource.
	Name string `json:"name,omitempty"`
	// Size: The size of the raw resource content, in bytes, if known.
	Size int64 `json:"size,omitempty,string"`
	// Uri: The URI of this resource.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Resource) MarshalJSON() ([]byte, error) {
	type NoMethod Resource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResultMetadata: Result Metadata message contains metadata about the result
// returned after executing an Action.
type ResultMetadata struct {
	// DataType: The data type of the metadata field
	//
	// Possible values:
	//   "DATA_TYPE_UNSPECIFIED" - Datatype unspecified.
	//   "INT" - Deprecated Int type, use INTEGER type instead.
	//   "SMALLINT" - Small int type.
	//   "DOUBLE" - Double type.
	//   "DATE" - Date type.
	//   "DATETIME" - Deprecated Datetime type.
	//   "TIME" - Time type.
	//   "STRING" - Deprecated string type, use VARCHAR type instead.
	//   "LONG" - Deprecated Long type, use BIGINT type instead.
	//   "BOOLEAN" - Boolean type.
	//   "DECIMAL" - Decimal type.
	//   "UUID" - Deprecated UUID type, use VARCHAR instead.
	//   "BLOB" - Blob type.
	//   "BIT" - Bit type.
	//   "TINYINT" - Tiny int type.
	//   "INTEGER" - Integer type.
	//   "BIGINT" - Big int type.
	//   "FLOAT" - Float type.
	//   "REAL" - Real type.
	//   "NUMERIC" - Numeric type.
	//   "CHAR" - Char type.
	//   "VARCHAR" - Varchar type.
	//   "LONGVARCHAR" - Long varchar type.
	//   "TIMESTAMP" - Timestamp type.
	//   "NCHAR" - Nchar type.
	//   "NVARCHAR" - Nvarchar type.
	//   "LONGNVARCHAR" - Long Nvarchar type.
	//   "NULL" - Null type.
	//   "OTHER" - Other type.
	//   "JAVA_OBJECT" - Java object type.
	//   "DISTINCT" - Distinct type keyword.
	//   "STRUCT" - Struct type.
	//   "ARRAY" - Array type.
	//   "CLOB" - Clob type.
	//   "REF" - Ref type.
	//   "DATALINK" - Datalink type.
	//   "ROWID" - Row ID type.
	//   "BINARY" - Binary type.
	//   "VARBINARY" - Varbinary type.
	//   "LONGVARBINARY" - Long Varbinary type.
	//   "NCLOB" - Nclob type.
	//   "SQLXML" - SQLXML type.
	//   "REF_CURSOR" - Ref_cursor type.
	//   "TIME_WITH_TIMEZONE" - Time with timezone type.
	//   "TIMESTAMP_WITH_TIMEZONE" - Timestamp with timezone type.
	DataType string `json:"dataType,omitempty"`
	// DefaultValue: The following field specifies the default value of the
	// Parameter provided by the external system if a value is not provided.
	DefaultValue interface{} `json:"defaultValue,omitempty"`
	// Description: A brief description of the metadata field.
	Description string `json:"description,omitempty"`
	// JsonSchema: JsonSchema of the result, applicable only if parameter is of
	// type `STRUCT`
	JsonSchema *JsonSchema `json:"jsonSchema,omitempty"`
	// Name: Name of the metadata field.
	Name string `json:"name,omitempty"`
	// Nullable: Specifies whether a null value is allowed.
	Nullable bool `json:"nullable,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResultMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ResultMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Schedule: Configure the schedule.
type Schedule struct {
	// Day: Allows to define schedule that runs specified day of the week.
	//
	// Possible values:
	//   "DAY_OF_WEEK_UNSPECIFIED" - The day of the week is unspecified.
	//   "MONDAY" - Monday
	//   "TUESDAY" - Tuesday
	//   "WEDNESDAY" - Wednesday
	//   "THURSDAY" - Thursday
	//   "FRIDAY" - Friday
	//   "SATURDAY" - Saturday
	//   "SUNDAY" - Sunday
	Day string `json:"day,omitempty"`
	// Duration: Output only. Duration of the time window, set by service producer.
	Duration string `json:"duration,omitempty"`
	// StartTime: Time within the window to start the operations.
	StartTime *TimeOfDay `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Schedule) MarshalJSON() ([]byte, error) {
	type NoMethod Schedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SloEligibility: SloEligibility is a tuple containing eligibility value: true
// if an instance is eligible for SLO calculation or false if it should be
// excluded from all SLO-related calculations along with a user-defined reason.
type SloEligibility struct {
	// Eligible: Whether an instance is eligible or ineligible.
	Eligible bool `json:"eligible,omitempty"`
	// Reason: User-defined reason for the current value of instance eligibility.
	// Usually, this can be directly mapped to the internal state. An empty reason
	// is allowed.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Eligible") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Eligible") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SloEligibility) MarshalJSON() ([]byte, error) {
	type NoMethod SloEligibility
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SloMetadata: SloMetadata contains resources required for proper SLO
// classification of the instance.
type SloMetadata struct {
	// Nodes: Optional. List of nodes. Some producers need to use per-node metadata
	// to calculate SLO. This field allows such producers to publish per-node SLO
	// meta data, which will be consumed by SSA Eligibility Exporter and published
	// in the form of per node metric to Monarch.
	Nodes []*NodeSloMetadata `json:"nodes,omitempty"`
	// PerSliEligibility: Optional. Multiple per-instance SLI eligibilities which
	// apply for individual SLIs.
	PerSliEligibility *PerSliSloEligibility `json:"perSliEligibility,omitempty"`
	// Tier: Name of the SLO tier the Instance belongs to. This name will be
	// expected to match the tiers specified in the service SLO configuration.
	// Field is mandatory and must not be empty.
	Tier string `json:"tier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Nodes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Nodes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SloMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod SloMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TimeOfDay: Represents a time of day. The date and time zone are either not
// significant or are specified elsewhere. An API may choose to allow leap
// seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
type TimeOfDay struct {
	// Hours: Hours of a day in 24 hour format. Must be greater than or equal to 0
	// and typically must be less than or equal to 23. An API may choose to allow
	// the value "24:00:00" for scenarios like business closing time.
	Hours int64 `json:"hours,omitempty"`
	// Minutes: Minutes of an hour. Must be greater than or equal to 0 and less
	// than or equal to 59.
	Minutes int64 `json:"minutes,omitempty"`
	// Nanos: Fractions of seconds, in nanoseconds. Must be greater than or equal
	// to 0 and less than or equal to 999,999,999.
	Nanos int64 `json:"nanos,omitempty"`
	// Seconds: Seconds of a minute. Must be greater than or equal to 0 and
	// typically must be less than or equal to 59. An API may allow the value 60 if
	// it allows leap-seconds.
	Seconds int64 `json:"seconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Hours") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Hours") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TimeOfDay) MarshalJSON() ([]byte, error) {
	type NoMethod TimeOfDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Tool: Message representing a single tool.
type Tool struct {
	// Annotations: Annotations for the tool.
	Annotations *ToolAnnotations `json:"annotations,omitempty"`
	// DependsOn: List of tool names that this tool depends on.
	DependsOn []string `json:"dependsOn,omitempty"`
	// Description: Description of the tool.
	Description string `json:"description,omitempty"`
	// InputSchema: JSON schema for the input parameters of the tool.
	InputSchema *JsonSchema `json:"inputSchema,omitempty"`
	// Name: Name of the tool.
	Name string `json:"name,omitempty"`
	// OutputSchema: JSON schema for the output of the tool.
	OutputSchema *JsonSchema `json:"outputSchema,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Tool) MarshalJSON() ([]byte, error) {
	type NoMethod Tool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ToolAnnotations: ToolAnnotations holds annotations for a tool.
type ToolAnnotations struct {
	// DestructiveHint: If true, the tool may perform destructive updates to its
	// environment. If false, the tool performs only additive updates. (This
	// property is meaningful only when `read_only_hint == false`)
	DestructiveHint bool `json:"destructiveHint,omitempty"`
	// IdempotentHint: If true, calling the tool repeatedly with the same arguments
	// will have no additional effect on the environment. (This property is
	// meaningful only when `read_only_hint == false`)
	IdempotentHint bool `json:"idempotentHint,omitempty"`
	// OpenWorldHint: If true, this tool may interact with an "open world" of
	// external entities. If false, the tool's domain of interaction is closed. For
	// example, the world of a web search tool is open, whereas that of a memory
	// tool is not.
	OpenWorldHint bool `json:"openWorldHint,omitempty"`
	// ReadOnlyHint: If true, the tool does not modify its environment.
	ReadOnlyHint bool `json:"readOnlyHint,omitempty"`
	// Title: A human-readable title for the tool.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestructiveHint") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestructiveHint") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ToolAnnotations) MarshalJSON() ([]byte, error) {
	type NoMethod ToolAnnotations
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdateEntitiesWithConditionsResponse: Response message for
// EntityService.UpdateEntitiesWithConditions
type UpdateEntitiesWithConditionsResponse struct {
	// Metadata: Metadata like service latency, etc.
	Metadata map[string]googleapi.RawMessage `json:"metadata,omitempty"`
	// Response: Response returned by the external system.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdateEntitiesWithConditionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateEntitiesWithConditionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UpdatePolicy: Maintenance policy applicable to instance updates.
type UpdatePolicy struct {
	// Channel: Optional. Relative scheduling channel applied to resource.
	//
	// Possible values:
	//   "UPDATE_CHANNEL_UNSPECIFIED" - Unspecified channel.
	//   "EARLIER" - Early channel within a customer project.
	//   "LATER" - Later channel within a customer project.
	//   "WEEK1" - ! ! The follow channels can ONLY be used if you adopt the new MW
	// system! ! ! NOTE: all WEEK channels are assumed to be under a weekly window.
	// ! There is currently no dedicated channel definitions for Daily windows. !
	// If you use Daily window, the system will assume a 1d (24Hours) advanced !
	// notification period b/w EARLY and LATER. ! We may consider support more
	// flexible daily channel specifications in ! the future. WEEK1 == EARLIER with
	// minimum 7d advanced notification. {7d, 14d} The system will treat them
	// equally and will use WEEK1 whenever it can. New customers are encouraged to
	// use this channel annotation.
	//   "WEEK2" - WEEK2 == LATER with minimum 14d advanced notification {14d,
	// 21d}.
	//   "WEEK5" - WEEK5 == 40d support. minimum 35d advanced notification {35d,
	// 42d}.
	Channel string `json:"channel,omitempty"`
	// DenyMaintenancePeriods: Deny Maintenance Period that is applied to resource
	// to indicate when maintenance is forbidden. The protocol supports
	// zero-to-many such periods, but the current SLM Rollout implementation only
	// supports zero-to-one.
	DenyMaintenancePeriods []*DenyMaintenancePeriod `json:"denyMaintenancePeriods,omitempty"`
	// Window: Optional. Maintenance window that is applied to resources covered by
	// this policy.
	Window *MaintenanceWindow `json:"window,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Channel") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Channel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UpdatePolicy) MarshalJSON() ([]byte, error) {
	type NoMethod UpdatePolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WeeklyCycle: Time window specified for weekly operations.
type WeeklyCycle struct {
	// Schedule: User can specify multiple windows in a week. Minimum of 1 window.
	Schedule []*Schedule `json:"schedule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Schedule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Schedule") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WeeklyCycle) MarshalJSON() ([]byte, error) {
	type NoMethod WeeklyCycle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsConnectionsCheckReadinessCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CheckReadiness: Reports readiness status of the connector. Similar logic to
// GetStatus but modified for kubernetes health check to understand.
//
// - name: .
func (r *ProjectsLocationsConnectionsService) CheckReadiness(name string) *ProjectsLocationsConnectionsCheckReadinessCall {
	c := &ProjectsLocationsConnectionsCheckReadinessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsCheckReadinessCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsCheckReadinessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsCheckReadinessCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsCheckReadinessCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsCheckReadinessCall) Context(ctx context.Context) *ProjectsLocationsConnectionsCheckReadinessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsCheckReadinessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsCheckReadinessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:checkReadiness")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.checkReadiness", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.checkReadiness" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckReadinessResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsCheckReadinessCall) Do(opts ...googleapi.CallOption) (*CheckReadinessResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckReadinessResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.checkReadiness", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsCheckStatusCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CheckStatus: Reports the status of the connection. Note that when the
// connection is in a state that is not ACTIVE, the implementation of this RPC
// method must return a Status with the corresponding State instead of
// returning a gRPC status code that is not "OK", which indicates that
// ConnectionStatus itself, not the connection, failed.
//
// - name: .
func (r *ProjectsLocationsConnectionsService) CheckStatus(name string) *ProjectsLocationsConnectionsCheckStatusCall {
	c := &ProjectsLocationsConnectionsCheckStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsCheckStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsCheckStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsCheckStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsCheckStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsCheckStatusCall) Context(ctx context.Context) *ProjectsLocationsConnectionsCheckStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsCheckStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsCheckStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:checkStatus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.checkStatus", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.checkStatus" call.
// Any non-2xx status code is an error. Response headers are in either
// *CheckStatusResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsCheckStatusCall) Do(opts ...googleapi.CallOption) (*CheckStatusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &CheckStatusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.checkStatus", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsExchangeAuthCodeCall struct {
	s                       *Service
	name                    string
	exchangeauthcoderequest *ExchangeAuthCodeRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// ExchangeAuthCode: ExchangeAuthCode exchanges the OAuth authorization code
// (and other necessary data) for an access token (and associated credentials).
//
// - name: .
func (r *ProjectsLocationsConnectionsService) ExchangeAuthCode(name string, exchangeauthcoderequest *ExchangeAuthCodeRequest) *ProjectsLocationsConnectionsExchangeAuthCodeCall {
	c := &ProjectsLocationsConnectionsExchangeAuthCodeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.exchangeauthcoderequest = exchangeauthcoderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsExchangeAuthCodeCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsExchangeAuthCodeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsExchangeAuthCodeCall) Context(ctx context.Context) *ProjectsLocationsConnectionsExchangeAuthCodeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsExchangeAuthCodeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsExchangeAuthCodeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.exchangeauthcoderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:exchangeAuthCode")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.exchangeAuthCode", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.exchangeAuthCode" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExchangeAuthCodeResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsExchangeAuthCodeCall) Do(opts ...googleapi.CallOption) (*ExchangeAuthCodeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExchangeAuthCodeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.exchangeAuthCode", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsExecuteSqlQueryCall struct {
	s                      *Service
	connection             string
	executesqlqueryrequest *ExecuteSqlQueryRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// ExecuteSqlQuery: Executes a SQL statement specified in the body of the
// request. An example of this SQL statement in the case of Salesforce
// connector would be 'select * from Account a, Order o where a.Id =
// o.AccountId'.
//
//   - connection: Resource name of the Connection. Format:
//     projects/{project}/locations/{location}/connections/{connection}.
func (r *ProjectsLocationsConnectionsService) ExecuteSqlQuery(connection string, executesqlqueryrequest *ExecuteSqlQueryRequest) *ProjectsLocationsConnectionsExecuteSqlQueryCall {
	c := &ProjectsLocationsConnectionsExecuteSqlQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.connection = connection
	c.executesqlqueryrequest = executesqlqueryrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsExecuteSqlQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) Context(ctx context.Context) *ProjectsLocationsConnectionsExecuteSqlQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.executesqlqueryrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+connection}:executeSqlQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"connection": c.connection,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.executeSqlQuery", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.executeSqlQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExecuteSqlQueryResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsExecuteSqlQueryCall) Do(opts ...googleapi.CallOption) (*ExecuteSqlQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExecuteSqlQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.executeSqlQuery", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsRefreshAccessTokenCall struct {
	s                         *Service
	name                      string
	refreshaccesstokenrequest *RefreshAccessTokenRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// RefreshAccessToken: RefreshAccessToken exchanges the OAuth refresh token
// (and other necessary data) for a new access token (and new associated
// credentials).
//
// - name: .
func (r *ProjectsLocationsConnectionsService) RefreshAccessToken(name string, refreshaccesstokenrequest *RefreshAccessTokenRequest) *ProjectsLocationsConnectionsRefreshAccessTokenCall {
	c := &ProjectsLocationsConnectionsRefreshAccessTokenCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.refreshaccesstokenrequest = refreshaccesstokenrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsRefreshAccessTokenCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsRefreshAccessTokenCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsRefreshAccessTokenCall) Context(ctx context.Context) *ProjectsLocationsConnectionsRefreshAccessTokenCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsRefreshAccessTokenCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsRefreshAccessTokenCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.refreshaccesstokenrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:refreshAccessToken")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.refreshAccessToken", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.refreshAccessToken" call.
// Any non-2xx status code is an error. Response headers are in either
// *RefreshAccessTokenResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsRefreshAccessTokenCall) Do(opts ...googleapi.CallOption) (*RefreshAccessTokenResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &RefreshAccessTokenResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.refreshAccessToken", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsActionsExecuteCall struct {
	s                    *Service
	name                 string
	executeactionrequest *ExecuteActionRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Execute: Executes an action with the name specified in the request. The
// input parameters for executing the action are passed through the body of the
// ExecuteAction request.
//
//   - name: Resource name of the Action. Format:
//     projects/{project}/locations/{location}/connections/{connection}/actions/{a
//     ction}.
func (r *ProjectsLocationsConnectionsActionsService) Execute(name string, executeactionrequest *ExecuteActionRequest) *ProjectsLocationsConnectionsActionsExecuteCall {
	c := &ProjectsLocationsConnectionsActionsExecuteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.executeactionrequest = executeactionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsActionsExecuteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsActionsExecuteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsActionsExecuteCall) Context(ctx context.Context) *ProjectsLocationsConnectionsActionsExecuteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsActionsExecuteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsActionsExecuteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.executeactionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:execute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.actions.execute", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.actions.execute" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExecuteActionResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsActionsExecuteCall) Do(opts ...googleapi.CallOption) (*ExecuteActionResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExecuteActionResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.actions.execute", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsActionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the schema of the given action.
//
//   - name: Resource name of the Action. Format:
//     projects/{project}/locations/{location}/connections/{connection}/actions/{a
//     ction}.
func (r *ProjectsLocationsConnectionsActionsService) Get(name string) *ProjectsLocationsConnectionsActionsGetCall {
	c := &ProjectsLocationsConnectionsActionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Specified view of the action
// schema.
//
// Possible values:
//
//	"ACTION_SCHEMA_VIEW_UNSPECIFIED" - VIEW_UNSPECIFIED. The unset value.
//
// Defaults to BASIC View.
//
//	"ACTION_SCHEMA_VIEW_BASIC" - Return basic action schema.
//	"ACTION_SCHEMA_VIEW_ENRICHED" - Return enriched action schema.
func (c *ProjectsLocationsConnectionsActionsGetCall) View(view string) *ProjectsLocationsConnectionsActionsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsActionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsActionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsActionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsActionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsActionsGetCall) Context(ctx context.Context) *ProjectsLocationsConnectionsActionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsActionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsActionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.actions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.actions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Action.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsActionsGetCall) Do(opts ...googleapi.CallOption) (*Action, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Action{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.actions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsActionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Gets the schema of all the actions supported by the connector.
//
//   - parent: Parent resource name of the Action. Format:
//     projects/{project}/locations/{location}/connections/{connection}.
func (r *ProjectsLocationsConnectionsActionsService) List(parent string) *ProjectsLocationsConnectionsActionsListCall {
	c := &ProjectsLocationsConnectionsActionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Number of Actions to
// return. Defaults to 25.
func (c *ProjectsLocationsConnectionsActionsListCall) PageSize(pageSize int64) *ProjectsLocationsConnectionsActionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, return from a
// previous ListActions call, that can be used retrieve the next page of
// content. If unspecified, the request returns the first page of actions.
func (c *ProjectsLocationsConnectionsActionsListCall) PageToken(pageToken string) *ProjectsLocationsConnectionsActionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Specifies which fields of the
// Action are returned in the response.
//
// Possible values:
//
//	"ACTION_VIEW_UNSPECIFIED" - VIEW_UNSPECIFIED. The unset value Defaults to
//
// FULL View.
//
//	"ACTION_VIEW_BASIC" - Return only action names.
//	"ACTION_VIEW_FULL" - Return actions with schema.
func (c *ProjectsLocationsConnectionsActionsListCall) View(view string) *ProjectsLocationsConnectionsActionsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsActionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsActionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsActionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsActionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsActionsListCall) Context(ctx context.Context) *ProjectsLocationsConnectionsActionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsActionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsActionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/actions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.actions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.actions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListActionsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsActionsListCall) Do(opts ...googleapi.CallOption) (*ListActionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListActionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.actions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConnectionsActionsListCall) Pages(ctx context.Context, f func(*ListActionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConnectionsEntityTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets metadata of given entity type
//
//   - name: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/entityType
//     s/{entityType}.
func (r *ProjectsLocationsConnectionsEntityTypesService) Get(name string) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c := &ProjectsLocationsConnectionsEntityTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ContextMetadata sets the optional parameter "contextMetadata": Context
// metadata for request could be used to fetch customization of entity type
// schema.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) ContextMetadata(contextMetadata string) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c.urlParams_.Set("contextMetadata", contextMetadata)
	return c
}

// View sets the optional parameter "view": Specifies view for entity type
// schema.
//
// Possible values:
//
//	"ENTITY_TYPE_SCHEMA_VIEW_UNSPECIFIED" - VIEW_UNSPECIFIED. The unset value.
//
// Defaults to BASIC View.
//
//	"ENTITY_TYPE_SCHEMA_VIEW_BASIC" - Return basic entity type schema.
//	"ENTITY_TYPE_SCHEMA_VIEW_ENRICHED" - Return enriched entity types schema.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) View(view string) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *EntityType.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesGetCall) Do(opts ...googleapi.CallOption) (*EntityType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &EntityType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsEntityTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists metadata related to all entity types present in the external
// system.
//
//   - parent: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}.
func (r *ProjectsLocationsConnectionsEntityTypesService) List(parent string) *ProjectsLocationsConnectionsEntityTypesListCall {
	c := &ProjectsLocationsConnectionsEntityTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Number of entity types to
// return. Defaults to 25.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) PageSize(pageSize int64) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token, return from a
// previous ListEntityTypes call, that can be used retrieve the next page of
// content. If unspecified, the request returns the first page of entity types.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) PageToken(pageToken string) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": Specifies which fields of the
// Entity Type are returned in the response.
//
// Possible values:
//
//	"ENTITY_TYPE_VIEW_UNSPECIFIED" - VIEW_UNSPECIFIED. The unset value.
//
// Defaults to FULL View.
//
//	"ENTITY_TYPE_VIEW_BASIC" - Return only entity type names.
//	"ENTITY_TYPE_VIEW_FULL" - Return entity types with schema
func (c *ProjectsLocationsConnectionsEntityTypesListCall) View(view string) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entityTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListEntityTypesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Do(opts ...googleapi.CallOption) (*ListEntityTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEntityTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConnectionsEntityTypesListCall) Pages(ctx context.Context, f func(*ListEntityTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall struct {
	s          *Service
	parent     string
	entity     *Entity
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new entity row of the specified entity type in the
// external system. The field values for creating the row are contained in the
// body of the request. The response message contains a `Entity` message object
// returned as a response by the external system.
//
//   - parent: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/entityType
//     s/{type}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) Create(parent string, entity *Entity) *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.entity = entity
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.entity)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entities")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Entity.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesCreateCall) Do(opts ...googleapi.CallOption) (*Entity, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Entity{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an existing entity row matching the entity type and entity
// id specified in the request.
//
//   - name: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/entityType
//     s/{type}/entities/{id}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) Delete(name string) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall struct {
	s          *Service
	entityType string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// DeleteEntitiesWithConditions: Deletes entities based on conditions specified
// in the request and not on entity id.
//
//   - entityType: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/entityType
//     s/{type}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) DeleteEntitiesWithConditions(entityType string) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entityType = entityType
	return c
}

// Conditions sets the optional parameter "conditions": Required. Conditions to
// be used when deleting entities. From a proto standpoint, There are no
// restrictions on what can be passed using this field. The connector
// documentation should have information about what format of
// filters/conditions are supported. Note: If this conditions field is left
// empty, an exception is thrown. We don't want to consider 'empty conditions'
// to be a match-all case. Connector developers can determine and document what
// a match-all case constraint would be.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Conditions(conditions string) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall {
	c.urlParams_.Set("conditions", conditions)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+entityType}/entities:deleteEntitiesWithConditions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entityType": c.entityType,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.deleteEntitiesWithConditions", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.deleteEntitiesWithConditions" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesDeleteEntitiesWithConditionsCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.deleteEntitiesWithConditions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsEntityTypesEntitiesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single entity row matching the entity type and entity id
// specified in the request.
//
//   - name: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/entityType
//     s/{type}/entities/{id}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) Get(name string) *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Entity.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesGetCall) Do(opts ...googleapi.CallOption) (*Entity, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Entity{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsEntityTypesEntitiesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists entity rows of a particular entity type contained in the
// request. Note: 1. Currently, only max of one 'sort_by' column is supported.
// 2. If no 'sort_by' column is provided, the primary key of the table is used.
// If zero or more than one primary key is available, we default to the
// unpaginated list entities logic which only returns the first page. 3. The
// values of the 'sort_by' columns must uniquely identify an entity row,
// otherwise undefined behaviors may be observed during pagination. 4. Since
// transactions are not supported, any updates, inserts or deletes during
// pagination can lead to stale data being returned or other unexpected
// behaviors.
//
//   - parent: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/entityType
//     s/{type}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) List(parent string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Conditions sets the optional parameter "conditions": Conditions to be used
// when listing entities. From a proto standpoint, There are no restrictions on
// what can be passed using this field. The connector documentation should have
// information about what format of filters/conditions are supported.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Conditions(conditions string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.Set("conditions", conditions)
	return c
}

// PageSize sets the optional parameter "pageSize": Number of entity rows to
// return. Defaults page size = 25. Max page size = 200.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) PageSize(pageSize int64) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token value if
// available from a previous request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) PageToken(pageToken string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// SortBy sets the optional parameter "sortBy": List of 'sort_by' columns to
// use when returning the results.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) SortBy(sortBy ...string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.SetMulti("sortBy", append([]string{}, sortBy...))
	return c
}

// SortOrder sets the optional parameter "sortOrder": List of 'sort_order'
// columns to use when returning the results.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) SortOrder(sortOrder ...string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.SetMulti("sortOrder", append([]string{}, sortOrder...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/entities")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListEntitiesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Do(opts ...googleapi.CallOption) (*ListEntitiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListEntitiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesListCall) Pages(ctx context.Context, f func(*ListEntitiesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall struct {
	s          *Service
	name       string
	entity     *Entity
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates an existing entity row matching the entity type and entity id
// specified in the request. The fields in the entity row that need to be
// modified are contained in the body of the request. All unspecified fields
// are left unchanged. The response message contains a `Entity` message object
// returned as a response by the external system.
//
//   - name: Output only. Resource name of the Entity. Format:
//     projects/{project}/locations/{location}/connections/{connection}/entityType
//     s/{type}/entities/{id}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) Patch(name string, entity *Entity) *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.entity = entity
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.entity)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Entity.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesPatchCall) Do(opts ...googleapi.CallOption) (*Entity, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Entity{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall struct {
	s          *Service
	entityType string
	entity     *Entity
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateEntitiesWithConditions: Updates entities based on conditions specified
// in the request and not on entity id.
//
//   - entityType: Resource name of the Entity Type. Format:
//     projects/{project}/locations/{location}/connections/{connection}/entityType
//     s/{type}.
func (r *ProjectsLocationsConnectionsEntityTypesEntitiesService) UpdateEntitiesWithConditions(entityType string, entity *Entity) *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall {
	c := &ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.entityType = entityType
	c.entity = entity
	return c
}

// Conditions sets the optional parameter "conditions": Required. Conditions to
// be used when updating entities. From a proto standpoint, There are no
// restrictions on what can be passed using this field. The connector
// documentation should have information about what format of
// filters/conditions are supported. Note: If this conditions field is left
// empty, an exception is thrown. We don't want to consider 'empty conditions'
// to be a match-all case. Connector developers can determine and document what
// a match-all case constraint would be.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Conditions(conditions string) *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall {
	c.urlParams_.Set("conditions", conditions)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Context(ctx context.Context) *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.entity)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+entityType}/entities:updateEntitiesWithConditions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"entityType": c.entityType,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.updateEntitiesWithConditions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.entityTypes.entities.updateEntitiesWithConditions" call.
// Any non-2xx status code is an error. Response headers are in either
// *UpdateEntitiesWithConditionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConnectionsEntityTypesEntitiesUpdateEntitiesWithConditionsCall) Do(opts ...googleapi.CallOption) (*UpdateEntitiesWithConditionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UpdateEntitiesWithConditionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.entityTypes.entities.updateEntitiesWithConditions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsResourcesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a specific resource.
//
//   - name: Resource name of the Resource. Format:
//     projects/{project}/locations/{location}/connections/{connection}/resources/
//     {resource}.
func (r *ProjectsLocationsConnectionsResourcesService) Get(name string) *ProjectsLocationsConnectionsResourcesGetCall {
	c := &ProjectsLocationsConnectionsResourcesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsResourcesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsResourcesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsResourcesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsResourcesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsResourcesGetCall) Context(ctx context.Context) *ProjectsLocationsConnectionsResourcesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsResourcesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsResourcesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.resources.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.resources.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GetResourceResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsResourcesGetCall) Do(opts ...googleapi.CallOption) (*GetResourceResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GetResourceResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.resources.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsResourcesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all available resources.
//
//   - parent: Resource name of the connection. Format:
//     projects/{project}/locations/{location}/connections/{connection}.
func (r *ProjectsLocationsConnectionsResourcesService) List(parent string) *ProjectsLocationsConnectionsResourcesListCall {
	c := &ProjectsLocationsConnectionsResourcesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Page size for the request.
func (c *ProjectsLocationsConnectionsResourcesListCall) PageSize(pageSize int64) *ProjectsLocationsConnectionsResourcesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token for the
// request.
func (c *ProjectsLocationsConnectionsResourcesListCall) PageToken(pageToken string) *ProjectsLocationsConnectionsResourcesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsResourcesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsResourcesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsResourcesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsResourcesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsResourcesListCall) Context(ctx context.Context) *ProjectsLocationsConnectionsResourcesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsResourcesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsResourcesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/resources")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.resources.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.resources.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListResourcesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsResourcesListCall) Do(opts ...googleapi.CallOption) (*ListResourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListResourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.resources.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConnectionsResourcesListCall) Pages(ctx context.Context, f func(*ListResourcesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConnectionsToolsExecuteCall struct {
	s                  *Service
	name               string
	executetoolrequest *ExecuteToolRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Execute: Executes a specific tool.
//
//   - name: Resource name of the Tool. Format:
//     projects/{project}/locations/{location}/connections/{connection}/tools/{too
//     l}.
func (r *ProjectsLocationsConnectionsToolsService) Execute(name string, executetoolrequest *ExecuteToolRequest) *ProjectsLocationsConnectionsToolsExecuteCall {
	c := &ProjectsLocationsConnectionsToolsExecuteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.executetoolrequest = executetoolrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsToolsExecuteCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsToolsExecuteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsToolsExecuteCall) Context(ctx context.Context) *ProjectsLocationsConnectionsToolsExecuteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsToolsExecuteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsToolsExecuteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.executetoolrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:execute")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.tools.execute", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.tools.execute" call.
// Any non-2xx status code is an error. Response headers are in either
// *ExecuteToolResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsToolsExecuteCall) Do(opts ...googleapi.CallOption) (*ExecuteToolResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ExecuteToolResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.tools.execute", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConnectionsToolsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all available tools.
//
//   - parent: Resource name of the Connection. Format:
//     projects/{project}/locations/{location}/connections/{connection}.
func (r *ProjectsLocationsConnectionsToolsService) List(parent string) *ProjectsLocationsConnectionsToolsListCall {
	c := &ProjectsLocationsConnectionsToolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Page size.
func (c *ProjectsLocationsConnectionsToolsListCall) PageSize(pageSize int64) *ProjectsLocationsConnectionsToolsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token.
func (c *ProjectsLocationsConnectionsToolsListCall) PageToken(pageToken string) *ProjectsLocationsConnectionsToolsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConnectionsToolsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConnectionsToolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConnectionsToolsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConnectionsToolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConnectionsToolsListCall) Context(ctx context.Context) *ProjectsLocationsConnectionsToolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConnectionsToolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConnectionsToolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/tools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.tools.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "connectors.projects.locations.connections.tools.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListToolsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsConnectionsToolsListCall) Do(opts ...googleapi.CallOption) (*ListToolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListToolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "connectors.projects.locations.connections.tools.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsConnectionsToolsListCall) Pages(ctx context.Context, f func(*ListToolsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
