# Go API client for edgeservices

Azion Services

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/oauth2
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```golang
import sw "./edgeservices"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```golang
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `sw.ContextServerIndex` of type `int`.

```golang
ctx := context.WithValue(context.Background(), sw.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `sw.ContextServerVariables` of type `map[string]string`.

```golang
ctx := context.WithValue(context.Background(), sw.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `sw.ContextOperationServerIndices` and `sw.ContextOperationServerVariables` context maps.

```
ctx := context.WithValue(context.Background(), sw.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), sw.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:3002*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**DeleteResource**](docs/DefaultApi.md#deleteresource) | **Delete** /edge_services/{serviceId}/resources/{resourceId} | Delete Service Resource by ID
*DefaultApi* | [**DeleteService**](docs/DefaultApi.md#deleteservice) | **Delete** /edge_services/{id} | Delete Service by ID
*DefaultApi* | [**GetResource**](docs/DefaultApi.md#getresource) | **Get** /edge_services/{serviceId}/resources/{resourceId} | Return Service Resource by ID
*DefaultApi* | [**GetResources**](docs/DefaultApi.md#getresources) | **Get** /edge_services/{serviceId}/resources | Return Service Resources by page
*DefaultApi* | [**GetService**](docs/DefaultApi.md#getservice) | **Get** /edge_services/{id} | Return Service by ID
*DefaultApi* | [**GetServices**](docs/DefaultApi.md#getservices) | **Get** /edge_services/ | Return Services by page
*DefaultApi* | [**NewService**](docs/DefaultApi.md#newservice) | **Post** /edge_services/ | Create Service
*DefaultApi* | [**PatchService**](docs/DefaultApi.md#patchservice) | **Patch** /edge_services/{id} | Update Service by ID
*DefaultApi* | [**PatchServiceResource**](docs/DefaultApi.md#patchserviceresource) | **Patch** /edge_services/{serviceId}/resources/{resourceId} | Update Service Resource by ID
*DefaultApi* | [**PostResource**](docs/DefaultApi.md#postresource) | **Post** /edge_services/{serviceId}/resources | Create Service Resource


## Documentation For Models

 - [CreateResourceRequest](docs/CreateResourceRequest.md)
 - [CreateServiceRequest](docs/CreateServiceRequest.md)
 - [ResourceDetail](docs/ResourceDetail.md)
 - [ResourceResponse](docs/ResourceResponse.md)
 - [ResourceResponseWithTotal](docs/ResourceResponseWithTotal.md)
 - [ServiceResponse](docs/ServiceResponse.md)
 - [ServiceResponseWithTotals](docs/ServiceResponseWithTotals.md)
 - [UpdateResourceRequest](docs/UpdateResourceRequest.md)
 - [UpdateServiceRequest](docs/UpdateServiceRequest.md)
 - [Variable](docs/Variable.md)


## Documentation For Authorization



### bearerAuth

- **Type**: HTTP Bearer token authentication

Example

```golang
auth := context.WithValue(context.Background(), sw.ContextAccessToken, "BEARERTOKENSTRING")
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



