// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/retail/v2alpha/project_service.proto

package retailpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ProjectService_GetProject_FullMethodName            = "/google.cloud.retail.v2alpha.ProjectService/GetProject"
	ProjectService_AcceptTerms_FullMethodName           = "/google.cloud.retail.v2alpha.ProjectService/AcceptTerms"
	ProjectService_EnrollSolution_FullMethodName        = "/google.cloud.retail.v2alpha.ProjectService/EnrollSolution"
	ProjectService_ListEnrolledSolutions_FullMethodName = "/google.cloud.retail.v2alpha.ProjectService/ListEnrolledSolutions"
	ProjectService_GetLoggingConfig_FullMethodName      = "/google.cloud.retail.v2alpha.ProjectService/GetLoggingConfig"
	ProjectService_UpdateLoggingConfig_FullMethodName   = "/google.cloud.retail.v2alpha.ProjectService/UpdateLoggingConfig"
	ProjectService_GetAlertConfig_FullMethodName        = "/google.cloud.retail.v2alpha.ProjectService/GetAlertConfig"
	ProjectService_UpdateAlertConfig_FullMethodName     = "/google.cloud.retail.v2alpha.ProjectService/UpdateAlertConfig"
)

// ProjectServiceClient is the client API for ProjectService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ProjectServiceClient interface {
	// Gets the project.
	//
	// Throws `NOT_FOUND` if the project wasn't initialized for the Retail API
	// service.
	GetProject(ctx context.Context, in *GetProjectRequest, opts ...grpc.CallOption) (*Project, error)
	// Accepts service terms for this project.
	// By making requests to this API, you agree to the terms of service linked
	// below.
	// https://cloud.google.com/retail/data-use-terms
	AcceptTerms(ctx context.Context, in *AcceptTermsRequest, opts ...grpc.CallOption) (*Project, error)
	// The method enrolls a solution of type [Retail
	// Search][google.cloud.retail.v2alpha.SolutionType.SOLUTION_TYPE_SEARCH]
	// into a project.
	//
	// The [Recommendations AI solution
	// type][google.cloud.retail.v2alpha.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
	// is enrolled by default when your project enables Retail API, so you don't
	// need to call the enrollSolution method for recommendations.
	EnrollSolution(ctx context.Context, in *EnrollSolutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all the retail API solutions the project has enrolled.
	ListEnrolledSolutions(ctx context.Context, in *ListEnrolledSolutionsRequest, opts ...grpc.CallOption) (*ListEnrolledSolutionsResponse, error)
	// Gets the [LoggingConfig][google.cloud.retail.v2alpha.LoggingConfig] of the
	// requested project.
	GetLoggingConfig(ctx context.Context, in *GetLoggingConfigRequest, opts ...grpc.CallOption) (*LoggingConfig, error)
	// Updates the [LoggingConfig][google.cloud.retail.v2alpha.LoggingConfig] of
	// the requested project.
	UpdateLoggingConfig(ctx context.Context, in *UpdateLoggingConfigRequest, opts ...grpc.CallOption) (*LoggingConfig, error)
	// Get the [AlertConfig][google.cloud.retail.v2alpha.AlertConfig] of the
	// requested project.
	GetAlertConfig(ctx context.Context, in *GetAlertConfigRequest, opts ...grpc.CallOption) (*AlertConfig, error)
	// Update the alert config of the requested project.
	UpdateAlertConfig(ctx context.Context, in *UpdateAlertConfigRequest, opts ...grpc.CallOption) (*AlertConfig, error)
}

type projectServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewProjectServiceClient(cc grpc.ClientConnInterface) ProjectServiceClient {
	return &projectServiceClient{cc}
}

func (c *projectServiceClient) GetProject(ctx context.Context, in *GetProjectRequest, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, ProjectService_GetProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectServiceClient) AcceptTerms(ctx context.Context, in *AcceptTermsRequest, opts ...grpc.CallOption) (*Project, error) {
	out := new(Project)
	err := c.cc.Invoke(ctx, ProjectService_AcceptTerms_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectServiceClient) EnrollSolution(ctx context.Context, in *EnrollSolutionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ProjectService_EnrollSolution_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectServiceClient) ListEnrolledSolutions(ctx context.Context, in *ListEnrolledSolutionsRequest, opts ...grpc.CallOption) (*ListEnrolledSolutionsResponse, error) {
	out := new(ListEnrolledSolutionsResponse)
	err := c.cc.Invoke(ctx, ProjectService_ListEnrolledSolutions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectServiceClient) GetLoggingConfig(ctx context.Context, in *GetLoggingConfigRequest, opts ...grpc.CallOption) (*LoggingConfig, error) {
	out := new(LoggingConfig)
	err := c.cc.Invoke(ctx, ProjectService_GetLoggingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectServiceClient) UpdateLoggingConfig(ctx context.Context, in *UpdateLoggingConfigRequest, opts ...grpc.CallOption) (*LoggingConfig, error) {
	out := new(LoggingConfig)
	err := c.cc.Invoke(ctx, ProjectService_UpdateLoggingConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectServiceClient) GetAlertConfig(ctx context.Context, in *GetAlertConfigRequest, opts ...grpc.CallOption) (*AlertConfig, error) {
	out := new(AlertConfig)
	err := c.cc.Invoke(ctx, ProjectService_GetAlertConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *projectServiceClient) UpdateAlertConfig(ctx context.Context, in *UpdateAlertConfigRequest, opts ...grpc.CallOption) (*AlertConfig, error) {
	out := new(AlertConfig)
	err := c.cc.Invoke(ctx, ProjectService_UpdateAlertConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ProjectServiceServer is the server API for ProjectService service.
// All implementations should embed UnimplementedProjectServiceServer
// for forward compatibility
type ProjectServiceServer interface {
	// Gets the project.
	//
	// Throws `NOT_FOUND` if the project wasn't initialized for the Retail API
	// service.
	GetProject(context.Context, *GetProjectRequest) (*Project, error)
	// Accepts service terms for this project.
	// By making requests to this API, you agree to the terms of service linked
	// below.
	// https://cloud.google.com/retail/data-use-terms
	AcceptTerms(context.Context, *AcceptTermsRequest) (*Project, error)
	// The method enrolls a solution of type [Retail
	// Search][google.cloud.retail.v2alpha.SolutionType.SOLUTION_TYPE_SEARCH]
	// into a project.
	//
	// The [Recommendations AI solution
	// type][google.cloud.retail.v2alpha.SolutionType.SOLUTION_TYPE_RECOMMENDATION]
	// is enrolled by default when your project enables Retail API, so you don't
	// need to call the enrollSolution method for recommendations.
	EnrollSolution(context.Context, *EnrollSolutionRequest) (*longrunningpb.Operation, error)
	// Lists all the retail API solutions the project has enrolled.
	ListEnrolledSolutions(context.Context, *ListEnrolledSolutionsRequest) (*ListEnrolledSolutionsResponse, error)
	// Gets the [LoggingConfig][google.cloud.retail.v2alpha.LoggingConfig] of the
	// requested project.
	GetLoggingConfig(context.Context, *GetLoggingConfigRequest) (*LoggingConfig, error)
	// Updates the [LoggingConfig][google.cloud.retail.v2alpha.LoggingConfig] of
	// the requested project.
	UpdateLoggingConfig(context.Context, *UpdateLoggingConfigRequest) (*LoggingConfig, error)
	// Get the [AlertConfig][google.cloud.retail.v2alpha.AlertConfig] of the
	// requested project.
	GetAlertConfig(context.Context, *GetAlertConfigRequest) (*AlertConfig, error)
	// Update the alert config of the requested project.
	UpdateAlertConfig(context.Context, *UpdateAlertConfigRequest) (*AlertConfig, error)
}

// UnimplementedProjectServiceServer should be embedded to have forward compatible implementations.
type UnimplementedProjectServiceServer struct {
}

func (UnimplementedProjectServiceServer) GetProject(context.Context, *GetProjectRequest) (*Project, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProject not implemented")
}
func (UnimplementedProjectServiceServer) AcceptTerms(context.Context, *AcceptTermsRequest) (*Project, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcceptTerms not implemented")
}
func (UnimplementedProjectServiceServer) EnrollSolution(context.Context, *EnrollSolutionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnrollSolution not implemented")
}
func (UnimplementedProjectServiceServer) ListEnrolledSolutions(context.Context, *ListEnrolledSolutionsRequest) (*ListEnrolledSolutionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnrolledSolutions not implemented")
}
func (UnimplementedProjectServiceServer) GetLoggingConfig(context.Context, *GetLoggingConfigRequest) (*LoggingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetLoggingConfig not implemented")
}
func (UnimplementedProjectServiceServer) UpdateLoggingConfig(context.Context, *UpdateLoggingConfigRequest) (*LoggingConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateLoggingConfig not implemented")
}
func (UnimplementedProjectServiceServer) GetAlertConfig(context.Context, *GetAlertConfigRequest) (*AlertConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAlertConfig not implemented")
}
func (UnimplementedProjectServiceServer) UpdateAlertConfig(context.Context, *UpdateAlertConfigRequest) (*AlertConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAlertConfig not implemented")
}

// UnsafeProjectServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ProjectServiceServer will
// result in compilation errors.
type UnsafeProjectServiceServer interface {
	mustEmbedUnimplementedProjectServiceServer()
}

func RegisterProjectServiceServer(s grpc.ServiceRegistrar, srv ProjectServiceServer) {
	s.RegisterService(&ProjectService_ServiceDesc, srv)
}

func _ProjectService_GetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectServiceServer).GetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProjectService_GetProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectServiceServer).GetProject(ctx, req.(*GetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectService_AcceptTerms_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcceptTermsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectServiceServer).AcceptTerms(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProjectService_AcceptTerms_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectServiceServer).AcceptTerms(ctx, req.(*AcceptTermsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectService_EnrollSolution_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnrollSolutionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectServiceServer).EnrollSolution(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProjectService_EnrollSolution_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectServiceServer).EnrollSolution(ctx, req.(*EnrollSolutionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectService_ListEnrolledSolutions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnrolledSolutionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectServiceServer).ListEnrolledSolutions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProjectService_ListEnrolledSolutions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectServiceServer).ListEnrolledSolutions(ctx, req.(*ListEnrolledSolutionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectService_GetLoggingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLoggingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectServiceServer).GetLoggingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProjectService_GetLoggingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectServiceServer).GetLoggingConfig(ctx, req.(*GetLoggingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectService_UpdateLoggingConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLoggingConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectServiceServer).UpdateLoggingConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProjectService_UpdateLoggingConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectServiceServer).UpdateLoggingConfig(ctx, req.(*UpdateLoggingConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectService_GetAlertConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAlertConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectServiceServer).GetAlertConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProjectService_GetAlertConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectServiceServer).GetAlertConfig(ctx, req.(*GetAlertConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ProjectService_UpdateAlertConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAlertConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ProjectServiceServer).UpdateAlertConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ProjectService_UpdateAlertConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ProjectServiceServer).UpdateAlertConfig(ctx, req.(*UpdateAlertConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ProjectService_ServiceDesc is the grpc.ServiceDesc for ProjectService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ProjectService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.retail.v2alpha.ProjectService",
	HandlerType: (*ProjectServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProject",
			Handler:    _ProjectService_GetProject_Handler,
		},
		{
			MethodName: "AcceptTerms",
			Handler:    _ProjectService_AcceptTerms_Handler,
		},
		{
			MethodName: "EnrollSolution",
			Handler:    _ProjectService_EnrollSolution_Handler,
		},
		{
			MethodName: "ListEnrolledSolutions",
			Handler:    _ProjectService_ListEnrolledSolutions_Handler,
		},
		{
			MethodName: "GetLoggingConfig",
			Handler:    _ProjectService_GetLoggingConfig_Handler,
		},
		{
			MethodName: "UpdateLoggingConfig",
			Handler:    _ProjectService_UpdateLoggingConfig_Handler,
		},
		{
			MethodName: "GetAlertConfig",
			Handler:    _ProjectService_GetAlertConfig_Handler,
		},
		{
			MethodName: "UpdateAlertConfig",
			Handler:    _ProjectService_UpdateAlertConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/retail/v2alpha/project_service.proto",
}
